/*
 * halTimer.c
 *
 *  Created on: 2015 okt. 21
 *      Author: Sandor
 */

#include <inttypes.h>
#include <math.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

#include "driverlib/cpu.h"
#include "driverlib/fpu.h"
#include "driverlib/pin_map.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/timer.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/udma.h"

#include "inc/hw_gpio.h"
#include "inc/hw_memmap.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "inc/hw_timer.h"
#include "inc/hw_ints.h"

#include "utils/ustdlib.h"

#include "halTimer.h"
#include "halExtInt.h"
#include "halPWM.h"

extern uint32_t measuredValues[MAX_CHANNEL];
extern uint8_t extIntState;
extern uint32_t runValues[MAX_CHANNEL];

void halTimer0Init(){
	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER0);
	ROM_TimerConfigure(TIMER0_BASE, TIMER_CFG_PERIODIC_UP);
	ROM_TimerLoadSet(TIMER0_BASE, TIMER_A, SysCtlClockGet() / TIMER_RESOLUTION * (PERIODTIME));
	ROM_IntEnable(INT_TIMER0A);
	ROM_TimerIntEnable(TIMER0_BASE, TIMER_TIMA_TIMEOUT);

	ROM_TimerEnable(TIMER0_BASE, TIMER_A);
}

void Timer0IntHandler(void){
	switch(extIntState){
		case 0:
			if(runValues[0] == 1){				// count enable
				measuredValues[0]++;
			}
			break;
		case 1:
			if(runValues[1] == 1){
				measuredValues[1]++;
			}
			break;
		case 2:
			if(runValues[2] == 1){
				measuredValues[2]++;
			}
			break;
		case 3:
			if(runValues[3] == 1){
				measuredValues[3]++;
			}
			break;
		case 4:
			if(runValues[4] == 1){
				measuredValues[4]++;
			}
			break;
		case 5:
			if(runValues[5] == 1){
				measuredValues[5]++;
			}
			break;
		case 6:
			if(runValues[6] == 1){
				measuredValues[6]++;
			}
			break;
		case 7:
			if(runValues[7] == 1){
				measuredValues[7]++;
			}
			break;
	}

	ROM_TimerIntClear(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
}
