/*
 * halUART.c
 *
 *  Created on: 2015 szept. 16
 *      Author: Sandor
 */


#include <inttypes.h>
#include <math.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>
#include <string.h>

#include "inc/hw_types.h"
#include "inc/hw_gpio.h"
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_udma.h"
#include "inc/hw_uart.h"

#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/rom.h"
#include "driverlib/sysctl.h"
#include "driverlib/pin_map.h"
#include "driverlib/uart.h"

#include "halUART.h"
#include "fifo.h"

extern _FIFOu8* InputFIFO;
extern _FIFOu8* OutputFIFO;

void UARTInit()
{
  SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

  IntMasterEnable();

  GPIOPinConfigure(GPIO_PA0_U0RX);
  GPIOPinConfigure(GPIO_PA1_U0TX);

  GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

  //UARTClockSourceSet(UART0_BASE, UART_CLOCK_PIOSC);

  UARTConfigSetExpClk(UART0_BASE, 50000000, 115200,
                        (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE |
                         UART_CONFIG_PAR_NONE));
  IntEnable(INT_UART0);
  UARTIntEnable(UART0_BASE, UART_INT_RX | UART_INT_RT );
  UARTFIFOLevelSet(UART0_BASE, UART_FIFO_TX1_8, UART_FIFO_RX1_8);

  UARTEnable(UART0_BASE);
}

void UARTPutByte(uint8_t data){
	UARTCharPut(UART0_BASE,(uint32_t)data);
}


void UARTPrintString(char *string)
{
  while(*string)
  {
	UARTPutByte(*string);
    string++;
  }
}

void UARTSendNumber(uint16_t number) {
	uint8_t data[5], i = 0;

	data[0] = '0' + (number / 10000) % 10;
	data[1] = '0' + (number / 1000) % 10;
	data[1] = '0' + (number / 100) % 10;
	data[1] = '0' + (number / 10) % 10;
	data[1] = '0' + (number % 10);

	for(i = 0; i < 5; i++){
		UARTCharPut(UART0_BASE,(uint32_t)(data[i]));
	}
}

void UARTPutNumber(int32_t number)
{
  char t[20];
  sprintf(t,"%d",number);
  UARTPrintString(t);
}

void UARTPutStrNum(char *string, int32_t number)
{
  UARTPrintString(string);
  UARTPutNumber(number);
}

// Doesn't work yet!!
void UARTPutFloatNumber(float number)
{
  char t[15];
  sprintf(t,"%f",number);
  UARTPrintString(t);
}


void UART0IntHandler()
{
  static uint8_t rx_data;
  unsigned long ulStatus;

  rx_data = UARTCharGet(UART0_BASE);

  /* Push the received data to the FIFO */
  FIFO_Push(InputFIFO,rx_data);


  ulStatus = ROM_UARTIntStatus(UART0_BASE, true);
  ROM_UARTIntClear(UART0_BASE, ulStatus);
}
