/*
 * mpu.h
 *
 *  Created on: 2016 jan. 21
 *      Author: Sandor
 */

#ifndef MPU_H_
#define MPU_H_

#include "sensorlib/i2cm_drv.h"

typedef enum eMPUInstState {
	MPU_STATE_IDLE = 0,
	MPU_STATE_RUN,
	MPU_STATE_WAIT_RESET,
	MPU_STATE_WAIT_INIT,
	MPU_STATE_CALIBRATION,
	MPU_STATE_RAW_MAG_OUTPUT,
	MPU_STATE_DISABLED
} tMPUInstState;


typedef struct sMPUInst {
    tMPUInstState ui8State;
    bool bDataReady;
    int16_t i16ax, i16ay, i16az, i16gx, i16gy, i16gz, i16mx, i16my, i16mz;
    int16_t i16mxOffset, i16myOffset, i16mzOffset;
	uint16_t ui16FIFOCount[1];
    float faScaleFactor, fgScaleFactor;
    uint8_t ui8AxisArrangement;
    uint32_t ui32SysTick;
	uint8_t ui8ResetCount;
	tI2CMInstance *psI2CInst;
    bool *pbI2CBusy;
    uint8_t ui8Addr;
    uint16_t pui16Data[9];
    union {
    	uint8_t	pui8Buffer[2];
    	tI2CMRead16BE sI2CRead16BE;
    	tI2CMWrite16BE sI2CWrite16BE;
    } uCommand;
    tSensorCallback *pfnCallback;
    void *pvCallbackData;
} tMPUInst;

typedef struct sMPUBiasInst {
	int32_t i32ax, i32ay, i32az;
	int32_t i32gx, i32gy, i32gz;
	int16_t i16ax_reg, i16ay_reg, i16az_reg;
	int16_t i16gx_reg, i16gy_reg, i16gz_reg;
} tMPUBiasInst;

//==============================================================================
//======== 					Function declarations						========
//==============================================================================
void MPU_init(tMPUInst *psInst, tI2CMInstance *psI2CInst, bool *pbI2CBusy, uint_fast8_t ui8I2CAddr, tSensorCallback *pfnCallback, void *pvCallbackData);
void MPU_poll(tMPUInst *psInst);
void MPU_callback(void *pvCallbackData, uint_fast8_t ui8Status);
void MPU_I2CRead(tMPUInst *psInst, uint8_t ui8Reg, uint8_t *pui8Value, uint16_t ui16Count);
void MPU_I2CWrite(tMPUInst *psInst, uint8_t ui8Reg, uint8_t ui8Value);
void MPU_I2CRead16(tMPUInst *psInst, uint8_t ui8Reg, uint16_t *pui16Value, uint16_t ui16Count);
void MPU_I2CWrite16(tMPUInst *psInst, uint8_t ui8Reg, uint16_t *pui16Value, uint16_t ui16Count);
void MPU_default_config(tMPUInst* psInst);

//==============================================================================
//======== 					MPU specific defines 						========
//==============================================================================
#define TO_RAD					0.017453293	// conversion factor deg->rad
#define TO_DEG					57.295780	// conversion factor rad->deg

#define MPU_AXIS_ARR_1			1

#define MPU_INIT_TIME	     	100

#define MPU_CALIB_SOURCE		0x04
#define MPU_CALIB_LOAD_EEPROM	0x00
#define MPU_CALIB_RUN			0x04

#define MPU_ADDRESS_AD0_LOW     0x68 // address pin low (GND), default for InvenSense evaluation board
#define MPU_ADDRESS_AD0_HIGH    0x69 // address pin high (VCC)
#define MPU_ADDRESS				MPU_ADDRESS_AD0_LOW

#define MPU_RA_XG_OFFS_TC       0x00 //[7] PWR_MODE, [6:1] XG_OFFS_TC, [0] OTP_BNK_VLD
#define MPU_RA_YG_OFFS_TC       0x01 //[7] PWR_MODE, [6:1] YG_OFFS_TC, [0] OTP_BNK_VLD
#define MPU_RA_ZG_OFFS_TC       0x02 //[7] PWR_MODE, [6:1] ZG_OFFS_TC, [0] OTP_BNK_VLD
#define MPU_RA_X_FINE_GAIN      0x03 //[7:0] X_FINE_GAIN
#define MPU_RA_Y_FINE_GAIN      0x04 //[7:0] Y_FINE_GAIN
#define MPU_RA_Z_FINE_GAIN      0x05 //[7:0] Z_FINE_GAIN
#define MPU_RA_XA_OFFS_H        0x06 //[15:0] XA_OFFS
#define MPU_RA_XA_OFFS_L_TC     0x07
#define MPU_RA_YA_OFFS_H        0x08 //[15:0] YA_OFFS
#define MPU_RA_YA_OFFS_L_TC     0x09
#define MPU_RA_ZA_OFFS_H        0x0A //[15:0] ZA_OFFS
#define MPU_RA_ZA_OFFS_L_TC     0x0B

#define MPU_RA_ACCEL_PROD_SH1   0x0D
#define MPU_RA_ACCEL_PROD_SH2   0x0E
#define MPU_RA_ACCEL_PROD_SH3   0x0F
#define MPU_RA_ACCEL_PROD_SH4   0x10

#define MPU_RA_XG_OFFS_USRH     0x13 //[15:0] XG_OFFS_USR
#define MPU_RA_XG_OFFS_USRL     0x14
#define MPU_RA_YG_OFFS_USRH     0x15 //[15:0] YG_OFFS_USR
#define MPU_RA_YG_OFFS_USRL     0x16
#define MPU_RA_ZG_OFFS_USRH     0x17 //[15:0] ZG_OFFS_USR
#define MPU_RA_ZG_OFFS_USRL     0x18
#define MPU_RA_SMPLRT_DIV       0x19
#define MPU_RA_CONFIG           0x1A
#define MPU_RA_GYRO_CONFIG      0x1B
#define MPU_RA_ACCEL_CONFIG     0x1C
#define MPU_RA_FF_THR           0x1D
#define MPU_RA_FF_DUR           0x1E
#define MPU_RA_MOT_THR          0x1F
#define MPU_RA_MOT_DUR          0x20
#define MPU_RA_ZRMOT_THR        0x21
#define MPU_RA_ZRMOT_DUR        0x22
#define MPU_RA_FIFO_EN          0x23
#define MPU_RA_I2C_MST_CTRL     0x24
#define MPU_RA_I2C_SLV0_ADDR    0x25
#define MPU_RA_I2C_SLV0_REG     0x26
#define MPU_RA_I2C_SLV0_CTRL    0x27
#define MPU_RA_I2C_SLV1_ADDR    0x28
#define MPU_RA_I2C_SLV1_REG     0x29
#define MPU_RA_I2C_SLV1_CTRL    0x2A
#define MPU_RA_I2C_SLV2_ADDR    0x2B
#define MPU_RA_I2C_SLV2_REG     0x2C
#define MPU_RA_I2C_SLV2_CTRL    0x2D
#define MPU_RA_I2C_SLV3_ADDR    0x2E
#define MPU_RA_I2C_SLV3_REG     0x2F
#define MPU_RA_I2C_SLV3_CTRL    0x30
#define MPU_RA_I2C_SLV4_ADDR    0x31
#define MPU_RA_I2C_SLV4_REG     0x32
#define MPU_RA_I2C_SLV4_DO      0x33
#define MPU_RA_I2C_SLV4_CTRL    0x34
#define MPU_RA_I2C_SLV4_DI      0x35
#define MPU_RA_I2C_MST_STATUS   0x36
#define MPU_RA_INT_PIN_CFG      0x37
#define MPU_RA_INT_ENABLE       0x38
#define MPU_RA_DMP_INT_STATUS   0x39
#define MPU_RA_INT_STATUS       0x3A
#define MPU_RA_ACCEL_XOUT_H     0x3B
#define MPU_RA_ACCEL_XOUT_L     0x3C
#define MPU_RA_ACCEL_YOUT_H     0x3D
#define MPU_RA_ACCEL_YOUT_L     0x3E
#define MPU_RA_ACCEL_ZOUT_H     0x3F
#define MPU_RA_ACCEL_ZOUT_L     0x40
#define MPU_RA_TEMP_OUT_H       0x41
#define MPU_RA_TEMP_OUT_L       0x42
#define MPU_RA_GYRO_XOUT_H      0x43
#define MPU_RA_GYRO_XOUT_L      0x44
#define MPU_RA_GYRO_YOUT_H      0x45
#define MPU_RA_GYRO_YOUT_L      0x46
#define MPU_RA_GYRO_ZOUT_H      0x47
#define MPU_RA_GYRO_ZOUT_L      0x48
#define MPU_RA_EXT_SENS_DATA_00 0x49
#define MPU_RA_EXT_SENS_DATA_01 0x4A
#define MPU_RA_EXT_SENS_DATA_02 0x4B
#define MPU_RA_EXT_SENS_DATA_03 0x4C
#define MPU_RA_EXT_SENS_DATA_04 0x4D
#define MPU_RA_EXT_SENS_DATA_05 0x4E
#define MPU_RA_EXT_SENS_DATA_06 0x4F
#define MPU_RA_EXT_SENS_DATA_07 0x50
#define MPU_RA_EXT_SENS_DATA_08 0x51
#define MPU_RA_EXT_SENS_DATA_09 0x52
#define MPU_RA_EXT_SENS_DATA_10 0x53
#define MPU_RA_EXT_SENS_DATA_11 0x54
#define MPU_RA_EXT_SENS_DATA_12 0x55
#define MPU_RA_EXT_SENS_DATA_13 0x56
#define MPU_RA_EXT_SENS_DATA_14 0x57
#define MPU_RA_EXT_SENS_DATA_15 0x58
#define MPU_RA_EXT_SENS_DATA_16 0x59
#define MPU_RA_EXT_SENS_DATA_17 0x5A
#define MPU_RA_EXT_SENS_DATA_18 0x5B
#define MPU_RA_EXT_SENS_DATA_19 0x5C
#define MPU_RA_EXT_SENS_DATA_20 0x5D
#define MPU_RA_EXT_SENS_DATA_21 0x5E
#define MPU_RA_EXT_SENS_DATA_22 0x5F
#define MPU_RA_EXT_SENS_DATA_23 0x60
#define MPU_RA_MOT_DETECT_STATUS    0x61
#define MPU_RA_I2C_SLV0_DO      0x63
#define MPU_RA_I2C_SLV1_DO      0x64
#define MPU_RA_I2C_SLV2_DO      0x65
#define MPU_RA_I2C_SLV3_DO      0x66
#define MPU_RA_I2C_MST_DELAY_CTRL   0x67
#define MPU_RA_SIGNAL_PATH_RESET    0x68
#define MPU_RA_MOT_DETECT_CTRL      0x69
#define MPU_RA_USER_CTRL        0x6A
#define MPU_RA_PWR_MGMT_1       0x6B
#define MPU_RA_PWR_MGMT_2       0x6C
#define MPU_RA_BANK_SEL         0x6D
#define MPU_RA_MEM_START_ADDR   0x6E
#define MPU_RA_MEM_R_W          0x6F
#define MPU_RA_DMP_CFG_1        0x70
#define MPU_RA_DMP_CFG_2        0x71
#define MPU_RA_FIFO_COUNTH      0x72
#define MPU_RA_FIFO_COUNTL      0x73
#define MPU_RA_FIFO_R_W         0x74
#define MPU_RA_WHO_AM_I         0x75

#define MPU_TC_PWR_MODE_BIT     7
#define MPU_TC_OFFSET_BIT       6
#define MPU_TC_OFFSET_LENGTH    6
#define MPU_TC_OTP_BNK_VLD_BIT  0

#define MPU_VDDIO_LEVEL_VLOGIC  0
#define MPU_VDDIO_LEVEL_VDD     1

#define MPU_CFG_EXT_SYNC_SET_BIT    5
#define MPU_CFG_EXT_SYNC_SET_LENGTH 3
#define MPU_CFG_DLPF_CFG_BIT    2
#define MPU_CFG_DLPF_CFG_LENGTH 3

#define MPU_EXT_SYNC_DISABLED       0x0
#define MPU_EXT_SYNC_TEMP_OUT_L     0x1
#define MPU_EXT_SYNC_GYRO_XOUT_L    0x2
#define MPU_EXT_SYNC_GYRO_YOUT_L    0x3
#define MPU_EXT_SYNC_GYRO_ZOUT_L    0x4
#define MPU_EXT_SYNC_ACCEL_XOUT_L   0x5
#define MPU_EXT_SYNC_ACCEL_YOUT_L   0x6
#define MPU_EXT_SYNC_ACCEL_ZOUT_L   0x7

#define MPU_DLPF_BW_256         0x00
#define MPU_DLPF_BW_188         0x01
#define MPU_DLPF_BW_98          0x02
#define MPU_DLPF_BW_42          0x03
#define MPU_DLPF_BW_20          0x04
#define MPU_DLPF_BW_10          0x05
#define MPU_DLPF_BW_5           0x06

#define MPU_GCONFIG_FS_SEL_BIT      4
#define MPU_GCONFIG_FS_SEL_LENGTH   2

#define MPU_GYRO_FS_250         0x00
#define MPU_GYRO_FS_500         0x01
#define MPU_GYRO_FS_1000        0x02
#define MPU_GYRO_FS_2000        0x03

#define MPU_ACONFIG_XA_ST_BIT           7
#define MPU_ACONFIG_YA_ST_BIT           6
#define MPU_ACONFIG_ZA_ST_BIT           5
#define MPU_ACONFIG_AFS_SEL_BIT         4
#define MPU_ACONFIG_AFS_SEL_LENGTH      2
#define MPU_ACONFIG_ACCEL_HPF_BIT       2
#define MPU_ACONFIG_ACCEL_HPF_LENGTH    3

#define MPU_ACCEL_FS_2          0x00
#define MPU_ACCEL_FS_4          0x01
#define MPU_ACCEL_FS_8          0x02
#define MPU_ACCEL_FS_16         0x03

#define MPU_DHPF_RESET          0x00
#define MPU_DHPF_5              0x01
#define MPU_DHPF_2P5            0x02
#define MPU_DHPF_1P25           0x03
#define MPU_DHPF_0P63           0x04
#define MPU_DHPF_HOLD           0x07

#define MPU_TEMP_FIFO_EN_BIT    7
#define MPU_XG_FIFO_EN_BIT      6
#define MPU_YG_FIFO_EN_BIT      5
#define MPU_ZG_FIFO_EN_BIT      4
#define MPU_ACCEL_FIFO_EN_BIT   3
#define MPU_SLV2_FIFO_EN_BIT    2
#define MPU_SLV1_FIFO_EN_BIT    1
#define MPU_SLV0_FIFO_EN_BIT    0

#define MPU_MULT_MST_EN_BIT     7
#define MPU_WAIT_FOR_ES_BIT     6
#define MPU_SLV_3_FIFO_EN_BIT   5
#define MPU_I2C_MST_P_NSR_BIT   4
#define MPU_I2C_MST_CLK_BIT     3
#define MPU_I2C_MST_CLK_LENGTH  4

#define MPU_CLOCK_DIV_348       0x0
#define MPU_CLOCK_DIV_333       0x1
#define MPU_CLOCK_DIV_320       0x2
#define MPU_CLOCK_DIV_308       0x3
#define MPU_CLOCK_DIV_296       0x4
#define MPU_CLOCK_DIV_286       0x5
#define MPU_CLOCK_DIV_276       0x6
#define MPU_CLOCK_DIV_267       0x7
#define MPU_CLOCK_DIV_258       0x8
#define MPU_CLOCK_DIV_500       0x9
#define MPU_CLOCK_DIV_471       0xA
#define MPU_CLOCK_DIV_444       0xB
#define MPU_CLOCK_DIV_421       0xC
#define MPU_CLOCK_DIV_400       0xD
#define MPU_CLOCK_DIV_381       0xE
#define MPU_CLOCK_DIV_364       0xF

#define MPU_I2C_SLV_RW_BIT      7
#define MPU_I2C_SLV_ADDR_BIT    6
#define MPU_I2C_SLV_ADDR_LENGTH 7
#define MPU_I2C_SLV_EN_BIT      7
#define MPU_I2C_SLV_BYTE_SW_BIT 6
#define MPU_I2C_SLV_REG_DIS_BIT 5
#define MPU_I2C_SLV_GRP_BIT     4
#define MPU_I2C_SLV_LEN_BIT     3
#define MPU_I2C_SLV_LEN_LENGTH  4

#define MPU_I2C_SLV4_RW_BIT         7
#define MPU_I2C_SLV4_ADDR_BIT       6
#define MPU_I2C_SLV4_ADDR_LENGTH    7
#define MPU_I2C_SLV4_EN_BIT         7
#define MPU_I2C_SLV4_INT_EN_BIT     6
#define MPU_I2C_SLV4_REG_DIS_BIT    5
#define MPU_I2C_SLV4_MST_DLY_BIT    4
#define MPU_I2C_SLV4_MST_DLY_LENGTH 5

#define MPU_MST_PASS_THROUGH_BIT    7
#define MPU_MST_I2C_SLV4_DONE_BIT   6
#define MPU_MST_I2C_LOST_ARB_BIT    5
#define MPU_MST_I2C_SLV4_NACK_BIT   4
#define MPU_MST_I2C_SLV3_NACK_BIT   3
#define MPU_MST_I2C_SLV2_NACK_BIT   2
#define MPU_MST_I2C_SLV1_NACK_BIT   1
#define MPU_MST_I2C_SLV0_NACK_BIT   0

#define MPU_INTCFG_INT_LEVEL_BIT        7
#define MPU_INTCFG_INT_OPEN_BIT         6
#define MPU_INTCFG_LATCH_INT_EN_BIT     5
#define MPU_INTCFG_INT_RD_CLEAR_BIT     4
#define MPU_INTCFG_FSYNC_INT_LEVEL_BIT  3
#define MPU_INTCFG_FSYNC_INT_EN_BIT     2
#define MPU_INTCFG_I2C_BYPASS_EN_BIT    1
#define MPU_INTCFG_CLKOUT_EN_BIT        0

#define MPU_INTMODE_ACTIVEHIGH  0x00
#define MPU_INTMODE_ACTIVELOW   0x01

#define MPU_INTDRV_PUSHPULL     0x00
#define MPU_INTDRV_OPENDRAIN    0x01

#define MPU_INTLATCH_50USPULSE  0x00
#define MPU_INTLATCH_WAITCLEAR  0x01

#define MPU_INTCLEAR_STATUSREAD 0x00
#define MPU_INTCLEAR_ANYREAD    0x01

#define MPU_INTERRUPT_FF_BIT            7
#define MPU_INTERRUPT_MOT_BIT           6
#define MPU_INTERRUPT_ZMOT_BIT          5
#define MPU_INTERRUPT_FIFO_OFLOW_BIT    4
#define MPU_INTERRUPT_I2C_MST_INT_BIT   3
#define MPU_INTERRUPT_PLL_RDY_INT_BIT   2
#define MPU_INTERRUPT_DMP_INT_BIT       1
#define MPU_INTERRUPT_DATA_RDY_BIT      0

// TODO: figure out what these actually do
// UMPL source code is not very obivous
#define MPU_DMPINT_5_BIT            5
#define MPU_DMPINT_4_BIT            4
#define MPU_DMPINT_3_BIT            3
#define MPU_DMPINT_2_BIT            2
#define MPU_DMPINT_1_BIT            1
#define MPU_DMPINT_0_BIT            0

#define MPU_MOTION_MOT_XNEG_BIT     7
#define MPU_MOTION_MOT_XPOS_BIT     6
#define MPU_MOTION_MOT_YNEG_BIT     5
#define MPU_MOTION_MOT_YPOS_BIT     4
#define MPU_MOTION_MOT_ZNEG_BIT     3
#define MPU_MOTION_MOT_ZPOS_BIT     2
#define MPU_MOTION_MOT_ZRMOT_BIT    0

#define MPU_DELAYCTRL_DELAY_ES_SHADOW_BIT   7
#define MPU_DELAYCTRL_I2C_SLV4_DLY_EN_BIT   4
#define MPU_DELAYCTRL_I2C_SLV3_DLY_EN_BIT   3
#define MPU_DELAYCTRL_I2C_SLV2_DLY_EN_BIT   2
#define MPU_DELAYCTRL_I2C_SLV1_DLY_EN_BIT   1
#define MPU_DELAYCTRL_I2C_SLV0_DLY_EN_BIT   0

#define MPU_PATHRESET_GYRO_RESET_BIT    2
#define MPU_PATHRESET_ACCEL_RESET_BIT   1
#define MPU_PATHRESET_TEMP_RESET_BIT    0

#define MPU_DETECT_ACCEL_ON_DELAY_BIT       5
#define MPU_DETECT_ACCEL_ON_DELAY_LENGTH    2
#define MPU_DETECT_FF_COUNT_BIT             3
#define MPU_DETECT_FF_COUNT_LENGTH          2
#define MPU_DETECT_MOT_COUNT_BIT            1
#define MPU_DETECT_MOT_COUNT_LENGTH         2

#define MPU_DETECT_DECREMENT_RESET  0x0
#define MPU_DETECT_DECREMENT_1      0x1
#define MPU_DETECT_DECREMENT_2      0x2
#define MPU_DETECT_DECREMENT_4      0x3

#define MPU_USERCTRL_DMP_EN_BIT             7
#define MPU_USERCTRL_FIFO_EN_BIT            6
#define MPU_USERCTRL_I2C_MST_EN_BIT         5
#define MPU_USERCTRL_I2C_IF_DIS_BIT         4
#define MPU_USERCTRL_DMP_RESET_BIT          3
#define MPU_USERCTRL_FIFO_RESET_BIT         2
#define MPU_USERCTRL_I2C_MST_RESET_BIT      1
#define MPU_USERCTRL_SIG_COND_RESET_BIT     0

#define MPU_PWR1_DEVICE_RESET_BIT   7
#define MPU_PWR1_SLEEP_BIT          6
#define MPU_PWR1_CYCLE_BIT          5
#define MPU_PWR1_TEMP_DIS_BIT       3
#define MPU_PWR1_CLKSEL_BIT         2
#define MPU_PWR1_CLKSEL_LENGTH      3

#define MPU_CLOCK_INTERNAL          0x00
#define MPU_CLOCK_PLL_XGYRO         0x01
#define MPU_CLOCK_PLL_YGYRO         0x02
#define MPU_CLOCK_PLL_ZGYRO         0x03
#define MPU_CLOCK_PLL_EXT32K        0x04
#define MPU_CLOCK_PLL_EXT19M        0x05
#define MPU_CLOCK_KEEP_RESET        0x07

#define MPU_PWR2_LP_WAKE_CTRL_BIT       7
#define MPU_PWR2_LP_WAKE_CTRL_LENGTH    2
#define MPU_PWR2_STBY_XA_BIT            5
#define MPU_PWR2_STBY_YA_BIT            4
#define MPU_PWR2_STBY_ZA_BIT            3
#define MPU_PWR2_STBY_XG_BIT            2
#define MPU_PWR2_STBY_YG_BIT            1
#define MPU_PWR2_STBY_ZG_BIT            0

#define MPU_WAKE_FREQ_1P25      0x0
#define MPU_WAKE_FREQ_2P5       0x1
#define MPU_WAKE_FREQ_5         0x2
#define MPU_WAKE_FREQ_10        0x3

#define MPU_BANKSEL_PRFTCH_EN_BIT       6
#define MPU_BANKSEL_CFG_USER_BANK_BIT   5
#define MPU_BANKSEL_MEM_SEL_BIT         4
#define MPU_BANKSEL_MEM_SEL_LENGTH      5

#define MPU_WHO_AM_I_BIT        6
#define MPU_WHO_AM_I_LENGTH     6

#define MPU_DMP_MEMORY_BANKS        8
#define MPU_DMP_MEMORY_BANK_SIZE    256
#define MPU_DMP_MEMORY_CHUNK_SIZE   16

// Compass part
#define AK8975_ADDRESS				0x0C
#define AKM_REG_WHOAMI				0x00
#define AKM_REG_ST1					0x02
#define AKM_REG_HXL					0x03
#define AKM_REG_CNTL				0x0A
#define AKM_REG_ASTC				0x0C
#define AKM_REG_ASAX				0x10
#define AKM_REG_ASAY				0x11
#define AKM_REG_ASAZ				0x12
#define AKM_CNTL_POWER_DOWN			0x00
#define AKM_CNTL_SINGLE_MEASUREMENT 0x01
#define AKM_CNTL_SELF_TEST			0x08
#define AKM_CNTL_FUSE_ROM_ACCESS	0x0F

#define HMC5983_ADDRESS				0x1E
#define HMC5983_CONF_REG_A			0x00
#define HMC5983_CONF_REG_B			0x01
#define HMC5983_MODE_REG			0x02
#define HMC5983_DATA_OUT_START		0x03
#define HMC5983_STATUS				0x09
#define HMC5983_ID_A				0x10
#define HMC5983_ID_B				0x11
#define HMC5983_ID_C				0x12
#define HMC5983_TEMP_OUT			0x31

#endif /* MPU_H_ */
