/*
 * serialProtocol.c
 *
 *  Created on: 2016 mrc. 3
 *      Author: Sandor
 */


#include <inttypes.h>
#include <math.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

#include "inc/hw_eeprom.h"

#include "driverlib/eeprom.h"

#include "common.h"
#include "halUART.h"
#include "serialProtocol.h"


extern _FIFOu8* OutputFIFO;

//------------------------------------------------------------------------------
uint8_t calc_crc(tProtocol protocol){
	uint8_t validation;
	uint8_t hi,lo;

	lo = protocol.command.cmd_u16 & 0x00FF;
	hi = (protocol.data.u8[0] & protocol.data.u8[1]) ^ (protocol.data.u8[3]);

	validation = hi ^ lo ^ MAGIC_NUMBER;

	return validation;
}

//------------------------------------------------------------------------------
void protocolFillFIFO(tProtocol* protocol, _FIFOu8* fifo){
	if((fifo->Number + PROTOCOL_LEN) < BUFFER_SIZE){
		FIFO_Push(fifo, (uint8_t)PROTOCOL_SRART);
		FIFO_Push(fifo, protocol->command.cmd_u8[0]);
		FIFO_Push(fifo, protocol->command.cmd_u8[1]);
		FIFO_Push(fifo, protocol->data.u8[0]);
		FIFO_Push(fifo, protocol->data.u8[1]);
		FIFO_Push(fifo, protocol->data.u8[2]);
		FIFO_Push(fifo, protocol->data.u8[3]);
		FIFO_Push(fifo, calc_crc(*protocol));
		FIFO_Push(fifo, (uint8_t)PROTOCOL_END);
	}
}

//------------------------------------------------------------------------------
tProtocol* protocolProcess(_FIFOu8* fifo){
	uint8_t u = 0, p = 0, counter = 0;
	uint8_t tmp_buffer[PROTOCOL_LEN];
	tProtocol protocol;

	for(u = 0; u < PROTOCOL_LEN; u++){
		tmp_buffer[u] = 0;
	}
									/* Find the start of the protocol 		*/
	while((u!= '\r')& (counter++ < BUFFER_SIZE)){
		FIFO_Pop(fifo,&u);
	}

									/* save it in the array 				*/
	for(p = 0; p < PROTOCOL_LEN; p++){
		FIFO_Pop(fifo,tmp_buffer);
	}

									/* put it to the protocol struct 		*/
	protocol.command.cmd_u8[0] = tmp_buffer[1];
	protocol.command.cmd_u8[1] = tmp_buffer[2];

	protocol.data.u8[0] = tmp_buffer[3];
	protocol.data.u8[1] = tmp_buffer[4];
	protocol.data.u8[2] = tmp_buffer[5];
	protocol.data.u8[3] = tmp_buffer[6];

	protocol.crc = tmp_buffer[7];

	return &protocol;
}

//------------------------------------------------------------------------------
void protocolProcessDoing(tProtocol* protocol){
	uint16_t command = protocol->command.cmd_u16;
	uint16_t rw = 0;
	tu32union u32_union;

	u32_union.u16[0] = protocol->data.u16[0];
	u32_union.u16[1] = protocol->data.u16[1];

	if((command & 0xFF00) & PROTOCOL_READ){
		rw = PROTOCOL_READ;
	}else if((command & 0xFF00) & PROTOCOL_WRITE){
		rw = PROTOCOL_WRITE;
	}else{
		return;
	}



	command = command & 0x00FF;		/* "cut" the read/write command 		*/

	switch(command){
		case ADC_OFFSET:
				if(rw == PROTOCOL_WRITE){
					EEPROMProgram((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_ADC_OFFSET), 4);
				}else{
					EEPROMRead((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_ADC_OFFSET),4);
				}
				break;
		case MOTOR_1:
				if(rw == PROTOCOL_WRITE){
					EEPROMProgram((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_MOTOR_1), 4);
				}else{
					EEPROMRead((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_MOTOR_1),4);
				}
				break;
		case MOTOR_2:
				if(rw == PROTOCOL_WRITE){
					EEPROMProgram((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_MOTOR_2), 4);
				}else{
					EEPROMRead((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_MOTOR_2),4);
				}
				break;
		case MOTOR_3:
				if(rw == PROTOCOL_WRITE){
					EEPROMProgram((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_MOTOR_3), 4);
				}else{
					EEPROMRead((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_MOTOR_3),4);
				}
				break;
		case MOTOR_4:
				if(rw == PROTOCOL_WRITE){
					EEPROMProgram((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_MOTOR_4), 4);
				}else{
					EEPROMRead((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(EEPROM_MOTOR_4),4);
				}
				break;
		case MOTOR_OFFSET:
				if(rw == PROTOCOL_WRITE){
					EEPROMProgram((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(MOTOR_OFFSET), 4);
				}else{
					EEPROMRead((uint32_t*)u32_union.u32, EEPROM_ADRESS_SET(MOTOR_OFFSET),4);
				}
				break;
				/* need to be extend it with the PID variables +FLOAT+!! */
	}

	if(rw == PROTOCOL_READ){
		protocol->start = PROTOCOL_SRART;

		protocol->data.u16[0] = u32_union.u16[0];
		protocol->data.u16[1] = u32_union.u16[1];

		protocol->crc = calc_crc(*protocol);

		protocol->end = PROTOCOL_END;

		protocolFillFIFO(protocol,OutputFIFO);
	}
}
