/*
 * serialProtocol.h
 *
 *  Created on: 2016 mrc. 3
 *      Author: Sandor
 */

#ifndef SERIALPROTOCOL_H_
#define SERIALPROTOCOL_H_

#include "fifo.h"

/* Protocol
 * \r
 * CMD[2]
 * DATA[4]
 * CRC[1]
 * \n
 */

typedef union {
	uint8_t cmd_u8[2];
	uint16_t cmd_u16;
}tProtocolCmd;

typedef union {
	uint8_t u8[4];
	uint16_t u16[2];
	float f;
}tProtocolData;

typedef struct{
	uint8_t start;
	tProtocolCmd command;
	tProtocolData data;
	uint8_t crc;
	uint8_t end;
}tProtocol;

#define PROTOCOL_READ_FRAME	4		/* In one reading it will read 4 frame from the buffer */
#define PROTOCOL_LEN	9
#define PROTOCOL_SRART	'\r'
#define PROTOCOL_END	'\n'
#define MAGIC_NUMBER 	0x8539

#define POSITIVE_ACK	0xFF00
#define NEGATIVE_ACK	0x00FF

#define PROTOCOL_READ	0xC000
#define PROTOCOL_WRITE	0x3000

#define MPU_GYRO_X		0x0002		/* R */
#define MPU_GYRO_Y		0x0003		/* R */
#define MPU_GYRO_Z		0x0004		/* R */
#define MPU_GYRO_X_F	0x0005		/* R */
#define MPU_GYRO_Y_F	0x0006		/* R */
#define MPU_GYRO_Z_F	0x0007		/* R */
#define MPU_ACCEL_X		0x0008		/* R */
#define MPU_ACCEL_Y		0x0009		/* R */
#define MPU_ACCEL_Z		0x000A		/* R */
#define MPU_ACCEL_X_F	0x000B		/* R */
#define MPU_ACCEL_Y_F	0x000C		/* R */
#define MPU_ACCEL_Z_F	0x000D		/* R */
#define COMP_X			0x000E		/* R */
#define COMP_Y			0x000F		/* R */
#define COMP_Z			0x0010		/* R */
#define COMP_X_F		0x0011		/* R */
#define COMP_Y_F		0x0012		/* R */
#define COMP_Z_F		0x0013		/* R */
#define ADC				0x0014		/* R */
#define ADC_F			0x0015		/* R */
#define ADC_OFFSET		0x0016		/* RW */
#define MOTOR_1			0x0017		/* RW */
#define MOTOR_2			0x0018		/* RW */
#define MOTOR_3			0x0019		/* RW */
#define MOTOR_4			0x001A		/* RW */
#define MOTOR_OFFSET	0x001B		/* RW */		/* this contain 4 offset 	*/
#define PID1_P			0x001C		/* RW */		/* Kc 						*/
#define PID1_I			0x001D		/* RW */		/* Ki						*/
#define PID1_D			0x001E		/* RW */		/* Kd						*/
#define PID2_P			0x001F		/* RW */
#define PID2_I			0x0020		/* RW */
#define PID2_D			0x0021		/* RW */

/*
 * Function predeclarations
 */
uint8_t calc_crc(tProtocol protocol);
tProtocol* protocolProcess(_FIFOu8* fifo);
void protocolFillFIFO(tProtocol* protocol, _FIFOu8* fifo);
tProtocol* protocolProcess(_FIFOu8* fifo);
void protocolProcessDoing(tProtocol* protocol);


#endif /* SERIALPROTOCOL_H_ */
