
#include <inttypes.h>

#include "inc/hw_types.h"
#include "inc/hw_gpio.h"
#include "inc/hw_memmap.h"
#include "driverlib/rom.h"
#include "driverlib/gpio.h"
#include "driverlib/sysctl.h"
#include "driverlib/interrupt.h"
#include "driverlib/timer.h"
#include "driverlib/flash.h"
#include "driverlib/uart.h"

#include "startup_pll.h"

void Start_UP_PLL()
{
  SysCtlClockSet(SYSCTL_SYSDIV_1 | SYSCTL_USE_OSC | SYSCTL_OSC_MAIN | SYSCTL_XTAL_16MHZ);
  SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);

  GPIOPinTypeGPIOInput(SW_BASE, BUTTON_2);               			//  SW1 | SW2

  GPIOPinTypeGPIOOutput(LED_BASE, RED_LED);       		// LED
  


  // turn weak pull-ups on
  GPIOPadConfigSet(SW_BASE, BUTTON_2, GPIO_STRENGTH_8MA , GPIO_PIN_TYPE_STD_WPU);
  

  GPIOPinWrite(GPIO_PORTF_BASE, RED_LED, 0 );

  
//  SysCtlDelay(SysCtlClockGet()/2500);
//  while(1) {
    GPIOPinWrite(GPIO_PORTF_BASE, RED_LED, RED_LED );
//    if(!GPIOPinRead(SW_BASE, BUTTON_2)){
//
//      break;
//    }
//  }
  
  GPIOPinWrite(GPIO_PORTF_BASE, RED_LED, 0 );
}
