

 /* This is the stack that is used by code running within main()
  * In case of NORTOS,
  * - This means all the code outside of ISR uses this stack
  * In case of FreeRTOS
  * - This means all the code until vTaskStartScheduler() is called in main()
  *   uses this stack.
  * - After vTaskStartScheduler() each task created in FreeRTOS has its own stack
  */

 --stack_size=16384
/* This is the heap size for malloc() API in NORTOS and FreeRTOS
* This is also the heap used by pvPortMalloc in FreeRTOS
*/
 --heap_size=32768
--retain="*(.vectors)"  /* This is the entry of the application, _vector MUST be placed starting address 0x0 */




SECTIONS
{
    .vectors  : {
    } > M4F_VECS   , palign(8) 

    .text  : {
    } > M4F_IRAM   , palign(8) 

    .bss  : {
    } > M4F_DRAM   , align(8) 
    RUN_START(__BSS_START)
    RUN_END(__BSS_END)

    .data  : {
    } > M4F_DRAM   , palign(8) 

    .rodata  : {
    } > M4F_DRAM   , palign(8) 

    .sysmem  : {
    } > M4F_IRAM   , palign(8) 

    .stack  : {
    } > M4F_IRAM   , palign(8) 

    .ARM.exidx  : {
    } > M4F_IRAM   , palign(8) 

    .init_array  : {
    } > M4F_IRAM   , palign(8) 

    .fini_array  : {
    } > M4F_IRAM   , palign(8) 

    .bss.user_shared_mem (NOLOAD) : {
    } > USER_SHM_MEM    

    .bss.log_shared_mem (NOLOAD) : {
    } > LOG_SHM_MEM    

    .bss.ipc_vring_mem (NOLOAD) : {
    } > IPC_VRING_MEM    


}


MEMORY
{
    M4F_VECS   : ORIGIN = 0x0 , LENGTH = 0x200 
    M4F_IRAM   : ORIGIN = 0x200 , LENGTH = 0x2FE00 
    M4F_DRAM   : ORIGIN = 0x30000 , LENGTH = 0x10000 

    /* For memory Regions not defined in this core but shared by other cores with the current core */

    USER_SHM_MEM   : ORIGIN = 0x70180000 , LENGTH = 0x180  
    LOG_SHM_MEM   : ORIGIN = 0x70180180 , LENGTH = 0x3E80  
    IPC_VRING_MEM   : ORIGIN = 0x70184000 , LENGTH = 0xC000  

}
