/*
 * Copyright (C) 2021 Texas Instruments Incorporated
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 *   Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 *
 *   Neither the name of Texas Instruments Incorporated nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _L2_CPSW_DATAFLOW_H_
#define _L2_CPSW_DATAFLOW_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "l2_cpsw_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define ENETAPP_VLAN_TAG_MASK 0xfff0

#define ENETAPP_VLAN_ID_MOST_SIGNIFICANT_PART_MASK 0b0000111100000000

#define ENETAPP_VLAN_ID_LEAST_SIGNIFICANT_PART_MASK 0x00ff

#define ENETAPP_EIGHT_BYTE_SHIFT    8
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

void EnetApp_createClock(void);

void EnetApp_deleteClock(void);

void EnetApp_timerCallback(ClockP_Object *clkInst, void * arg);

void EnetApp_tickTask(void *args);

int32_t EnetApp_openDma(EnetApp_PerCtxt *perCtxt, uint32_t perCtxtIndex);

void EnetApp_closeDma(EnetApp_PerCtxt *perCtxt, uint32_t perCtxtIndex);

void EnetApp_initTxFreePktQ(void);

void EnetApp_initRxReadyPktQ(EnetDma_RxChHandle hRxCh);

uint32_t EnetApp_retrieveFreeTxPkts(EnetApp_PerCtxt *perCtxt);

void EnetApp_createRxTask(EnetApp_PerCtxt *perCtxt);

void EnetApp_destroyRxTask(EnetApp_PerCtxt *perCtxt);

void EnetApp_rxTask(void *args);

/**
 * Replace the VLAN ID part of the payload of EthFrame.
 *
 * \param pu8PayloadVlanIdStart Pointer to the byte that has last 4 bits in VLAN ID in the payload.
 * \param u16VlanId The VLAN ID that will replace the VLAN ID in the payload.
 */

void EnetApp_vReplaceThe2VlanId(uint8_t *pu8PayloadVlanIdStart, uint16_t u16VlanId);

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

#ifdef __cplusplus
}
#endif

#endif /* _L2_CPSW_DATAFLOW_H_ */
