/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
#include "sys_dma.h"
#include "adc.h"
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#define DMA_REQ10 10
#define G1_DMA_EN (1 << 0)
#define G1_BLK_XFER (1 << 2)
#define NUMBER_OF_SAMPLES 20
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
uint32_t ADC_Data[20];
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    g_dmaCTRL g_dmaCTRLPKT1;

    adcInit();
    adcREG1->G1DMACR    |=   (NUMBER_OF_SAMPLES << 16);
    adcREG1->G1DMACR    |=   (G1_DMA_EN | G1_BLK_XFER);


    /*Assign DMA request SCI3 transmit to Channel 0*/
    dmaReqAssign(DMA_CH0, DMA_REQ10);

    /*Configure control packet for Channel 0*/
    g_dmaCTRLPKT1.SADD      = (uint32_t)(&adcREG1->GxBUF[adcGROUP1].BUF0);    /* source address             */
    g_dmaCTRLPKT1.DADD      = (uint32_t)ADC_Data;            /* destination  address       */
    g_dmaCTRLPKT1.CHCTRL    = 0;                    /* channel control            */
    g_dmaCTRLPKT1.FRCNT    =  1;                  /* frame count                */
    g_dmaCTRLPKT1.ELCNT     = 20;                    /* element count              */
    g_dmaCTRLPKT1.ELDOFFSET = 0;                    /* element destination offset */
    g_dmaCTRLPKT1.ELSOFFSET = 0;                    /* element destination offset */
    g_dmaCTRLPKT1.FRDOFFSET = 0;                    /* frame destination offset   */
    g_dmaCTRLPKT1.FRSOFFSET = 0;                    /* frame destination offset   */
    g_dmaCTRLPKT1.PORTASGN  = 4;
    g_dmaCTRLPKT1.RDSIZE    = ACCESS_32_BIT;         /* read size                  */
    g_dmaCTRLPKT1.WRSIZE    = ACCESS_32_BIT;         /* write size                 */
    g_dmaCTRLPKT1.TTYPE     = FRAME_TRANSFER;       /* transfer type              */
    g_dmaCTRLPKT1.ADDMODERD = ADDR_FIXED;            /* address mode read          */
    g_dmaCTRLPKT1.ADDMODEWR = ADDR_INC1;           /* address mode write         */
    g_dmaCTRLPKT1.AUTOINIT  = AUTOINIT_OFF;         /* autoinit                   */

    dmaSetCtrlPacket(DMA_CH0, g_dmaCTRLPKT1);

    dmaSetChEnable(DMA_CH0, DMA_HW);

    /*Enable DMA*/
    dmaEnable();

    adcStartConversion(adcREG1,adcGROUP1);

    while(1)
    {

    }
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
/* USER CODE END */
