#include <stdint.h>
#include <stdbool.h>
#include <inc/hw_memmap.h>
#include "driverlib/gpio.h"
#include "driverlib/adc.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"


int main(void)
{
    unsigned int array[4];

    //Set clock to 16 MHz
    SysCtlClockSet(SYSCTL_SYSDIV_10 | SYSCTL_USE_PLL | SYSCTL_OSC_MAIN | SYSCTL_XTAL_16MHZ);

    // Enable the GPIOE peripheral

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);

    // Enable the ADC0 module.
    //
    SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC0);

    // Wait for the GPIOE module to be ready.

    while(!SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOE))
    {
    }
    // Wait for the ADC0 module to be ready.
    //
    while(!SysCtlPeripheralReady(SYSCTL_PERIPH_ADC0))
    {
    }

    //Configures ADC pins PE3 (AIN0) and PE2 (AIN1)
    GPIOPinTypeADC(GPIO_PORTE_BASE, GPIO_PIN_3 | GPIO_PIN_2);

    //Configure ADC functions
    // Using Sequence 1 which has a 4 entry FIFO
    ADCSequenceConfigure(ADC0_BASE, 1, ADC_TRIGGER_PROCESSOR, 0);
    ADCSequenceStepConfigure(ADC0_BASE, 1, 0, ADC_CTL_CH0 );
    ADCSequenceStepConfigure(ADC0_BASE, 1, 1, ADC_CTL_CH1 | ADC_CTL_IE | ADC_CTL_END);
    ADCSequenceEnable(ADC0_BASE,1);
    ADCIntClear(ADC0_BASE, 1);
    ADCClockConfigSet(ADC0_BASE, ADC_CLOCK_SRC_PIOSC | ADC_CLOCK_RATE_FULL, 1);



    while(1)
    {
        ADCProcessorTrigger(ADC0_BASE, 1);
        //wait for the conversion to be completed
        while(!ADCIntStatus(ADC0_BASE, 1, false))
        {
        }
        //clear Interrupt flag
        ADCIntClear(ADC0_BASE, 1);

        //Read ADC input and store PE3 in array[0], PE2 in array[1]
        ADCSequenceDataGet(ADC0_BASE, 1, array); //read the analog values
    }
}
