/*
 * CanMessage.h
 *
 *  Created on: 10 maj 2024
 *      Author: tobjo
 */

#ifndef SRC_CANMESSAGE_H_
#define SRC_CANMESSAGE_H_

static const int CAN_PACKET_HEADER_SIZE = 2;
static const int CAN_PACKET_ID_BYTES = 2;
static const int CAN_PACKET_DLC_BYTES = 1;
static const int CAN_PACKET_DATA_BYTES = 8;
static const int CAN_PACKET_SIZE_8_DATA = CAN_PACKET_HEADER_SIZE + CAN_PACKET_ID_BYTES + CAN_PACKET_DLC_BYTES + CAN_PACKET_DATA_BYTES;

static const int CAN_HEADER_1 = 0xEE;
static const int CAN_HEADER_2 = 0xAA;

typedef struct
{
    uint32_t id;
    uint32_t dlc;
    uint8_t data[8];
} can_message_t;

#endif /* SRC_CANMESSAGE_H_ */
