/*
 * Copyright (C) 2022-2023 Texas Instruments Incorporated
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 *   Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 *
 *   Neither the name of Texas Instruments Incorporated nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ADC_REG_RESULT_H_
#define ADC_REG_RESULT_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include "Adc_RegResult.h"
#include "Std_Types.h"

/**************************************************************************
* Hardware Region  :
**************************************************************************/


/**************************************************************************
* Register Overlay Structure
**************************************************************************/

typedef struct {
    volatile uint16 ADCRESULT0;
    volatile uint16 ADCRESULT1;
    volatile uint16 ADCRESULT2;
    volatile uint16 ADCRESULT3;
    volatile uint16 ADCRESULT4;
    volatile uint16 ADCRESULT5;
    volatile uint16 ADCRESULT6;
    volatile uint16 ADCRESULT7;
    volatile uint16 ADCRESULT8;
    volatile uint16 ADCRESULT9;
    volatile uint16 ADCRESULT10;
    volatile uint16 ADCRESULT11;
    volatile uint16 ADCRESULT12;
    volatile uint16 ADCRESULT13;
    volatile uint16 ADCRESULT14;
    volatile uint16 ADCRESULT15;
    volatile uint32 ADCPPB1RESULT;
    volatile uint32 ADCPPB2RESULT;
    volatile uint32 ADCPPB3RESULT;
    volatile uint32 ADCPPB4RESULT;
} MCAL_CSL_ADC_resultRegs;


/**************************************************************************
* Register Macros
**************************************************************************/

#define MCAL_CSL_ADC_RESULT_ADCRESULT0                                              (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT1                                              (0x00000002U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT2                                              (0x00000004U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT3                                              (0x00000006U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT4                                              (0x00000008U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT5                                              (0x0000000AU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT6                                              (0x0000000CU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT7                                              (0x0000000EU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT8                                              (0x00000010U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT9                                              (0x00000012U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT10                                             (0x00000014U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT11                                             (0x00000016U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT12                                             (0x00000018U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT13                                             (0x0000001AU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT14                                             (0x0000001CU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT15                                             (0x0000001EU)
#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT                                           (0x00000020U)
#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT                                           (0x00000024U)
#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT                                           (0x00000028U)
#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT                                           (0x0000002CU)

/**************************************************************************
* Field Definition Macros
**************************************************************************/


/* ADCRESULT0 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT0_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT0_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT0_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT0_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT0_RESETVAL                                     (0x0000U)

/* ADCRESULT1 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT1_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT1_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT1_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT1_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT1_RESETVAL                                     (0x0000U)

/* ADCRESULT2 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT2_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT2_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT2_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT2_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT2_RESETVAL                                     (0x0000U)

/* ADCRESULT3 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT3_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT3_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT3_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT3_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT3_RESETVAL                                     (0x0000U)

/* ADCRESULT4 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT4_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT4_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT4_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT4_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT4_RESETVAL                                     (0x0000U)

/* ADCRESULT5 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT5_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT5_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT5_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT5_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT5_RESETVAL                                     (0x0000U)

/* ADCRESULT6 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT6_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT6_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT6_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT6_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT6_RESETVAL                                     (0x0000U)

/* ADCRESULT7 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT7_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT7_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT7_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT7_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT7_RESETVAL                                     (0x0000U)

/* ADCRESULT8 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT8_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT8_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT8_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT8_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT8_RESETVAL                                     (0x0000U)

/* ADCRESULT9 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT9_RESULT_MASK                                  (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT9_RESULT_SHIFT                                 (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT9_RESULT_RESETVAL                              (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT9_RESULT_MAX                                   (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT9_RESETVAL                                     (0x0000U)

/* ADCRESULT10 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT10_RESULT_MASK                                 (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT10_RESULT_SHIFT                                (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT10_RESULT_RESETVAL                             (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT10_RESULT_MAX                                  (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT10_RESETVAL                                    (0x0000U)

/* ADCRESULT11 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT11_RESULT_MASK                                 (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT11_RESULT_SHIFT                                (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT11_RESULT_RESETVAL                             (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT11_RESULT_MAX                                  (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT11_RESETVAL                                    (0x0000U)

/* ADCRESULT12 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT12_RESULT_MASK                                 (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT12_RESULT_SHIFT                                (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT12_RESULT_RESETVAL                             (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT12_RESULT_MAX                                  (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT12_RESETVAL                                    (0x0000U)

/* ADCRESULT13 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT13_RESULT_MASK                                 (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT13_RESULT_SHIFT                                (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT13_RESULT_RESETVAL                             (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT13_RESULT_MAX                                  (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT13_RESETVAL                                    (0x0000U)

/* ADCRESULT14 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT14_RESULT_MASK                                 (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT14_RESULT_SHIFT                                (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT14_RESULT_RESETVAL                             (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT14_RESULT_MAX                                  (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT14_RESETVAL                                    (0x0000U)

/* ADCRESULT15 */

#define MCAL_CSL_ADC_RESULT_ADCRESULT15_RESULT_MASK                                 (0xFFFFU)
#define MCAL_CSL_ADC_RESULT_ADCRESULT15_RESULT_SHIFT                                (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT15_RESULT_RESETVAL                             (0x0000U)
#define MCAL_CSL_ADC_RESULT_ADCRESULT15_RESULT_MAX                                  (0xFFFFU)

#define MCAL_CSL_ADC_RESULT_ADCRESULT15_RESETVAL                                    (0x0000U)

/* ADCPPB1RESULT */

#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT_PPBRESULT_MASK                            (0x0000FFFFU)
#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT_PPBRESULT_SHIFT                           (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT_PPBRESULT_RESETVAL                        (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT_PPBRESULT_MAX                             (0x0000FFFFU)

#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT_SIGN_MASK                                 (0xFFFF0000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT_SIGN_SHIFT                                (0x00000010U)
#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT_SIGN_RESETVAL                             (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT_SIGN_MAX                                  (0x0000FFFFU)

#define MCAL_CSL_ADC_RESULT_ADCPPB1RESULT_RESETVAL                                  (0x00000000U)

/* ADCPPB2RESULT */

#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT_PPBRESULT_MASK                            (0x0000FFFFU)
#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT_PPBRESULT_SHIFT                           (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT_PPBRESULT_RESETVAL                        (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT_PPBRESULT_MAX                             (0x0000FFFFU)

#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT_SIGN_MASK                                 (0xFFFF0000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT_SIGN_SHIFT                                (0x00000010U)
#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT_SIGN_RESETVAL                             (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT_SIGN_MAX                                  (0x0000FFFFU)

#define MCAL_CSL_ADC_RESULT_ADCPPB2RESULT_RESETVAL                                  (0x00000000U)

/* ADCPPB3RESULT */

#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT_PPBRESULT_MASK                            (0x0000FFFFU)
#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT_PPBRESULT_SHIFT                           (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT_PPBRESULT_RESETVAL                        (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT_PPBRESULT_MAX                             (0x0000FFFFU)

#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT_SIGN_MASK                                 (0xFFFF0000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT_SIGN_SHIFT                                (0x00000010U)
#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT_SIGN_RESETVAL                             (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT_SIGN_MAX                                  (0x0000FFFFU)

#define MCAL_CSL_ADC_RESULT_ADCPPB3RESULT_RESETVAL                                  (0x00000000U)

/* ADCPPB4RESULT */

#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT_PPBRESULT_MASK                            (0x0000FFFFU)
#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT_PPBRESULT_SHIFT                           (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT_PPBRESULT_RESETVAL                        (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT_PPBRESULT_MAX                             (0x0000FFFFU)

#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT_SIGN_MASK                                 (0xFFFF0000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT_SIGN_SHIFT                                (0x00000010U)
#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT_SIGN_RESETVAL                             (0x00000000U)
#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT_SIGN_MAX                                  (0x0000FFFFU)

#define MCAL_CSL_ADC_RESULT_ADCPPB4RESULT_RESETVAL                                  (0x00000000U)

#ifdef __cplusplus
}
#endif
#endif
