/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Dio_priv.h
 *
 */

#ifndef DIO_PRIV_H_
#define DIO_PRIV_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#include "Std_Types.h"        
#include "hal_stdtypes.h"
#include "Dio.h"
#include "hw_ctrl_core.h"
#include "sys_common.h"

#if (DIO_DEV_ERROR_DETECT == STD_ON)
#include "Det.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define DIO_UTILS_ARRAYSIZE(array)             ((sizeof (array) / \
                                                 sizeof ((array)[0])))

/*
** \name Values used to configure the direction of GPIO pins.
* @{
*/
typedef enum {
    DIO_DIR_INPUT  = 0x1U,
    DIO_DIR_OUTPUT = 0x0U
} Dio_DirectionType;
/* @} */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
uint32 Dio_GetGPIOPortAddr(uint8 regNum);

void Dio_GpioBitToggle(gpioPORT_t *port, uint32 bit);
uint32 Dio_GpioGetPort(const gpioPORT_t *port);
uint32 Dio_GpioPortWrite(const gpioPORT_t * port, uint32 setBits);
void Dio_GpioSetBit(gpioPORT_t *port, uint32 bit, uint32 value);
uint32 Dio_GpioGetDirection(const gpioPORT_t *port, uint32 bit);
uint32 Dio_GpioGetLogicLvl(const gpioPORT_t *port, uint32 bit);
uint32 Dio_GpioGetPortDirection(const gpioPORT_t *port);


#ifdef __cplusplus
}
#endif

#endif  /* #ifndef DIO_PRIV_H_ */

