/*
 * Copyright (C) 2023 Texas Instruments Incorporated
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 *   Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 *
 *   Neither the name of Texas Instruments Incorporated nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CDD_DMA_H_
#define CDD_DMA_H_

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "Cdd_Dma_edma_lld.h"
/* ========================================================================== */
/*                            Version Checks                                  */
/* ========================================================================== */

/**
 *  \name CDD_DMA Driver Module SW Version Info
 *
 *  Defines for CDD_DMA Driver version used for compatibility checks
 *  @{
 */
/** \brief Driver Implementation Major Version */
#define CDD_DMA_SW_MAJOR_VERSION            (8U)
/** \brief Driver Implementation Minor Version */
#define CDD_DMA_SW_MINOR_VERSION            (6U)
/** \brief Driver Implementation Patch Version */
#define CDD_DMA_SW_PATCH_VERSION            (2U)
/* @} */

/**
 *  \name CDD_DMA Driver Module AUTOSAR Version Info
 *
 *  Defines for CDD_DMA Driver AUTOSAR version used for compatibility checks
 *  @{
 */
/** \brief AUTOSAR Major version specification implemented by CDD_DMA Driver */
#define CDD_DMA_AR_RELEASE_MAJOR_VERSION    (4U)
/** \brief AUTOSAR Minor  version specification implemented by CDD_DMA Driver */
#define CDD_DMA_AR_RELEASE_MINOR_VERSION    (3U)
/** \brief AUTOSAR Patch version specification implemented by CDD_DMA Driver */
#define CDD_DMA_AR_RELEASE_REVISION_VERSION (1U)
/* @} */

typedef  CDD_EDMACCEDMACCPaRAMEntry             CddDma_PaRAMEntryType   ;
typedef  CDD_EDMA_ResourceObject                CddDma_ResourceObject   ;
typedef  Cdd_Edma_IntrHandle                    CddDma_IntrHandleType   ;
typedef  Cdd_Edma_IntrObject                    CddDma_IntrObjectType   ;
typedef  Cdd_Edma_EventCallback                 CddDma_CallBackType     ;
typedef  Cdd_EDMALLD_InitHandle                 CddDma_InitHandleType   ;
typedef  Cdd_EDMALLD_Object                     CddDma_ObjectType       ;
typedef  Cdd_EDMALLD_Handle                     CddDma_HandleType       ;

typedef struct Cdd_Dma_ConfigType_s
{
    uint32 baseAddr;
    Cdd_EDMALLD_InitObject edmaConfig;
} Cdd_Dma_ConfigType;

typedef struct {
    volatile uint32 PID;
    volatile uint32 MSS_SW_INT;
    volatile uint32 MSS_CAPEVNT_SEL;
    volatile uint32 MSS_DMA_REQ_SEL;
    volatile uint32 MSS_DMA1_REQ_SEL;
    volatile uint32 MSS_IRQ_REQ_SEL;
    volatile uint32 MSS_SPI_TRIG_SRC;
    volatile uint32 MSS_ATCM_MEM_INIT;
    volatile uint32 MSS_ATCM_MEM_INIT_DONE;
    volatile uint32 MSS_ATCM_MEM_INIT_STATUS;
    volatile uint32 MSS_BTCM_MEM_INIT;
    volatile uint32 MSS_BTCM_MEM_INIT_DONE;
    volatile uint32 MSS_BTCM_MEM_INIT_STATUS;
    volatile uint32 MSS_L2_MEM_INIT;
    volatile uint32 MSS_L2_MEM_INIT_DONE;
    volatile uint32 MSS_L2_MEM_INIT_STATUS;
    volatile uint32 MSS_MAILBOX_MEM_INIT;
    volatile uint32 MSS_MAILBOX_MEM_INIT_DONE;
    volatile uint32 MSS_MAILBOX_MEM_INIT_STATUS;
    volatile uint32 MSS_RETRAM_MEM_INIT;
    volatile uint32 MSS_RETRAM_MEM_INIT_DONE;
    volatile uint32 MSS_RETRAM_MEM_INIT_STATUS;
    volatile uint32 MSS_SPIA_MEM_INIT;
    volatile uint32 MSS_SPIA_MEM_INIT_DONE;
    volatile uint32 MSS_SPIA_MEM_INIT_STATUS;
    volatile uint32 MSS_SPIB_MEM_INIT;
    volatile uint32 MSS_SPIB_MEM_INIT_DONE;
    volatile uint32 MSS_SPIB_MEM_INIT_STATUS;
    volatile uint32 MSS_TPCC_MEMINIT_START;
    volatile uint32 MSS_TPCC_MEMINIT_DONE;
    volatile uint32 MSS_TPCC_MEMINIT_STATUS;
    volatile uint32 MSS_GPADC_MEM_INIT;
    volatile uint32 MSS_GPADC_MEM_INIT_DONE;
    volatile uint32 MSS_GPADC_MEM_INIT_STATUS;
    volatile uint32 MSS_SPIA_CFG;
    volatile uint32 MSS_SPIB_CFG;
    volatile uint32 MSS_EPWM_CFG;
    volatile uint32 MSS_GIO_CFG;
    volatile uint32 MSS_MCAN_FE_SELECT;
    volatile uint32 HW_SPARE_REG1;
    volatile uint32 MSS_MCANA_INT_CLR;
    volatile uint32 MSS_MCANA_INT_MASK;
    volatile uint32 MSS_MCANA_INT_STAT;
    volatile uint32 HW_SPARE_REG2;
    volatile uint32 CCC_ERR_STATUS;
    volatile uint32 CCCA_CFG0;
    volatile uint32 CCCA_CFG1;
    volatile uint32 CCCA_CFG2;
    volatile uint32 CCCA_CFG3;
    volatile uint32 CCCA_CNTVAL;
    volatile uint32 CCCB_CFG0;
    volatile uint32 CCCB_CFG1;
    volatile uint32 CCCB_CFG2;
    volatile uint32 CCCB_CFG3;
    volatile uint32 CCCB_CNTVAL;
    volatile uint32 CCC_DCC_COMMON;
    volatile uint32 R5_GLOBAL_CONFIG;
    volatile uint32 R5_AHB_EN;
    volatile uint32 R5A_AHB_BASE;
    volatile uint32 R5A_AHB_SIZE;
    volatile uint32 R5B_AHB_BASE;
    volatile uint32 R5B_AHB_SIZE;
    volatile uint32 R5_TCM_EXT_ERR_EN;
    volatile uint32 R5_TCM_ERR_EN;
    volatile uint32 R5_INIT_TCM;
    volatile uint32 R5_TCM_ECC_WRENZ_EN;
    volatile uint32 ESM_GATING0;
    volatile uint32 ESM_GATING1;
    volatile uint32 ESM_GATING2;
    volatile uint32 ESM_GATING3;
    volatile uint32 ESM_GATING4;
    volatile uint32 ESM_GATING5;
    volatile uint32 ESM_GATING6;
    volatile uint32 ESM_GATING7;
    volatile uint32 ERR_PARITY_ATCM0;
    volatile uint32 ERR_PARITY_ATCM1;
    volatile uint32 ERR_PARITY_B0TCM0;
    volatile uint32 ERR_PARITY_B0TCM1;
    volatile uint32 ERR_PARITY_B1TCM0;
    volatile uint32 ERR_PARITY_B1TCM1;
    volatile uint32 TCM_PARITY_CTRL;
    volatile uint32 TCM_PARITY_ERRFRC;
    volatile uint32 HW_SPARE_REG3;
    volatile uint32 SPIA_IO_CFG;
    volatile uint32 SPIB_IO_CFG;
    volatile uint32 SPI_HOST_IRQ;
    volatile uint32 TPTC_DBS_CONFIG;
    volatile uint32 TPCC_PARITY_CTRL;
    volatile uint32 TPCC_PARITY_STATUS;
    volatile uint32 MSS_DBG_ACK_CTL0;
    volatile uint32 MSS_DBG_ACK_CTL1;
    volatile uint32 CPSW_CONTROL;
    volatile uint32 MSS_TPCC_A_ERRAGG_MASK;
    volatile uint32 MSS_TPCC_A_ERRAGG_STATUS;
    volatile uint32 MSS_TPCC_A_ERRAGG_STATUS_RAW;
    volatile uint32 MSS_TPCC_A_INTAGG_MASK;
    volatile uint32 MSS_TPCC_A_INTAGG_STATUS;
    volatile uint32 MSS_TPCC_A_INTAGG_STATUS_RAW;
    volatile uint32 MSS_TPCC_B_ERRAGG_MASK;
    volatile uint32 MSS_TPCC_B_ERRAGG_STATUS;
    volatile uint32 MSS_TPCC_B_ERRAGG_STATUS_RAW;
    volatile uint32 MSS_TPCC_B_INTAGG_MASK;
    volatile uint32 MSS_TPCC_B_INTAGG_STATUS;
    volatile uint32 MSS_TPCC_B_INTAGG_STATUS_RAW;
    volatile uint32 MSS_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CR5A_AXI_RD_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CR5A_AXI_RD_BUS_SAFETY_FI;
    volatile uint32 MSS_CR5A_AXI_RD_BUS_SAFETY_ERR;
    volatile uint32 MSS_CR5A_AXI_RD_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_CR5A_AXI_RD_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_CR5A_AXI_RD_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_CR5B_AXI_RD_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CR5B_AXI_RD_BUS_SAFETY_FI;
    volatile uint32 MSS_CR5B_AXI_RD_BUS_SAFETY_ERR;
    volatile uint32 MSS_CR5B_AXI_RD_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_CR5B_AXI_RD_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_CR5B_AXI_RD_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_CR5A_AXI_WR_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CR5A_AXI_WR_BUS_SAFETY_FI;
    volatile uint32 MSS_CR5A_AXI_WR_BUS_SAFETY_ERR;
    volatile uint32 MSS_CR5A_AXI_WR_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_CR5A_AXI_WR_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_CR5A_AXI_WR_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_CR5A_AXI_WR_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_CR5B_AXI_WR_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CR5B_AXI_WR_BUS_SAFETY_FI;
    volatile uint32 MSS_CR5B_AXI_WR_BUS_SAFETY_ERR;
    volatile uint32 MSS_CR5B_AXI_WR_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_CR5B_AXI_WR_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_CR5B_AXI_WR_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_CR5B_AXI_WR_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_CR5A_AXI_S_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CR5A_AXI_S_BUS_SAFETY_FI;
    volatile uint32 MSS_CR5A_AXI_S_BUS_SAFETY_ERR;
    volatile uint32 MSS_CR5A_AXI_S_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_CR5A_AXI_S_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_CR5A_AXI_S_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_CR5A_AXI_S_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_CR5A_AXI_S_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_CR5B_AXI_S_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CR5B_AXI_S_BUS_SAFETY_FI;
    volatile uint32 MSS_CR5B_AXI_S_BUS_SAFETY_ERR;
    volatile uint32 MSS_CR5B_AXI_S_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_CR5B_AXI_S_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_CR5B_AXI_S_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_CR5B_AXI_S_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_CR5B_AXI_S_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_TPTC_A0_RD_BUS_SAFETY_CTRL;
    volatile uint32 MSS_TPTC_A0_RD_BUS_SAFETY_FI;
    volatile uint32 MSS_TPTC_A0_RD_BUS_SAFETY_ERR;
    volatile uint32 MSS_TPTC_A0_RD_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_TPTC_A0_RD_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_TPTC_A0_RD_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_TPTC_A1_RD_BUS_SAFETY_CTRL;
    volatile uint32 MSS_TPTC_A1_RD_BUS_SAFETY_FI;
    volatile uint32 MSS_TPTC_A1_RD_BUS_SAFETY_ERR;
    volatile uint32 MSS_TPTC_A1_RD_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_TPTC_A1_RD_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_TPTC_A1_RD_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_TPTC_B0_RD_BUS_SAFETY_CTRL;
    volatile uint32 MSS_TPTC_B0_RD_BUS_SAFETY_FI;
    volatile uint32 MSS_TPTC_B0_RD_BUS_SAFETY_ERR;
    volatile uint32 MSS_TPTC_B0_RD_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_TPTC_B0_RD_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_TPTC_B0_RD_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_TPTC_A0_WR_BUS_SAFETY_CTRL;
    volatile uint32 MSS_TPTC_A0_WR_BUS_SAFETY_FI;
    volatile uint32 MSS_TPTC_A0_WR_BUS_SAFETY_ERR;
    volatile uint32 MSS_TPTC_A0_WR_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_TPTC_A0_WR_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_TPTC_A0_WR_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_TPTC_A0_WR_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_TPTC_A1_WR_BUS_SAFETY_CTRL;
    volatile uint32 MSS_TPTC_A1_WR_BUS_SAFETY_FI;
    volatile uint32 MSS_TPTC_A1_WR_BUS_SAFETY_ERR;
    volatile uint32 MSS_TPTC_A1_WR_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_TPTC_A1_WR_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_TPTC_A1_WR_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_TPTC_A1_WR_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_TPTC_B0_WR_BUS_SAFETY_CTRL;
    volatile uint32 MSS_TPTC_B0_WR_BUS_SAFETY_FI;
    volatile uint32 MSS_TPTC_B0_WR_BUS_SAFETY_ERR;
    volatile uint32 MSS_TPTC_B0_WR_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_TPTC_B0_WR_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_TPTC_B0_WR_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_TPTC_B0_WR_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 HSM_TPTC_A0_RD_BUS_SAFETY_CTRL;
    volatile uint32 HSM_TPTC_A0_RD_BUS_SAFETY_FI;
    volatile uint32 HSM_TPTC_A0_RD_BUS_SAFETY_ERR;
    volatile uint32 HSM_TPTC_A0_RD_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 HSM_TPTC_A0_RD_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 HSM_TPTC_A0_RD_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 HSM_TPTC_A1_RD_BUS_SAFETY_CTRL;
    volatile uint32 HSM_TPTC_A1_RD_BUS_SAFETY_FI;
    volatile uint32 HSM_TPTC_A1_RD_BUS_SAFETY_ERR;
    volatile uint32 HSM_TPTC_A1_RD_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 HSM_TPTC_A1_RD_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 HSM_TPTC_A1_RD_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 HSM_TPTC_A0_WR_BUS_SAFETY_CTRL;
    volatile uint32 HSM_TPTC_A0_WR_BUS_SAFETY_FI;
    volatile uint32 HSM_TPTC_A0_WR_BUS_SAFETY_ERR;
    volatile uint32 HSM_TPTC_A0_WR_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 HSM_TPTC_A0_WR_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 HSM_TPTC_A0_WR_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 HSM_TPTC_A0_WR_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 HSM_TPTC_A1_WR_BUS_SAFETY_CTRL;
    volatile uint32 HSM_TPTC_A1_WR_BUS_SAFETY_FI;
    volatile uint32 HSM_TPTC_A1_WR_BUS_SAFETY_ERR;
    volatile uint32 HSM_TPTC_A1_WR_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 HSM_TPTC_A1_WR_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 HSM_TPTC_A1_WR_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 HSM_TPTC_A1_WR_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_QSPI_BUS_SAFETY_CTRL;
    volatile uint32 MSS_QSPI_BUS_SAFETY_FI;
    volatile uint32 MSS_QSPI_BUS_SAFETY_ERR;
    volatile uint32 MSS_QSPI_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_QSPI_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_QSPI_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_QSPI_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_QSPI_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 HSM_DTHE_BUS_SAFETY_CTRL;
    volatile uint32 HSM_DTHE_BUS_SAFETY_FI;
    volatile uint32 HSM_DTHE_BUS_SAFETY_ERR;
    volatile uint32 HSM_DTHE_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 HSM_DTHE_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 HSM_DTHE_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 HSM_DTHE_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 HSM_DTHE_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_CPSW_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CPSW_BUS_SAFETY_FI;
    volatile uint32 MSS_CPSW_BUS_SAFETY_ERR;
    volatile uint32 MSS_CPSW_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_CPSW_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_CPSW_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_CPSW_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_CPSW_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_MCRC_BUS_SAFETY_CTRL;
    volatile uint32 MSS_MCRC_BUS_SAFETY_FI;
    volatile uint32 MSS_MCRC_BUS_SAFETY_ERR;
    volatile uint32 MSS_MCRC_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_MCRC_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_MCRC_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_MCRC_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_MCRC_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_PCR_BUS_SAFETY_CTRL;
    volatile uint32 MSS_PCR_BUS_SAFETY_FI;
    volatile uint32 MSS_PCR_BUS_SAFETY_ERR;
    volatile uint32 MSS_PCR_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_PCR_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_PCR_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_PCR_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_PCR_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_PCR2_BUS_SAFETY_CTRL;
    volatile uint32 MSS_PCR2_BUS_SAFETY_FI;
    volatile uint32 MSS_PCR2_BUS_SAFETY_ERR;
    volatile uint32 MSS_PCR2_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_PCR2_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_PCR2_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_PCR2_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_PCR2_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 HSM_M_BUS_SAFETY_CTRL;
    volatile uint32 HSM_M_BUS_SAFETY_FI;
    volatile uint32 HSM_M_BUS_SAFETY_ERR;
    volatile uint32 HSM_M_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 HSM_M_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 HSM_M_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 HSM_M_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 HSM_M_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 HSM_S_BUS_SAFETY_CTRL;
    volatile uint32 HSM_S_BUS_SAFETY_FI;
    volatile uint32 HSM_S_BUS_SAFETY_ERR;
    volatile uint32 HSM_S_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 HSM_S_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 HSM_S_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 HSM_S_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 HSM_S_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 DAP_R232_BUS_SAFETY_CTRL;
    volatile uint32 DAP_R232_BUS_SAFETY_FI;
    volatile uint32 DAP_R232_BUS_SAFETY_ERR;
    volatile uint32 DAP_R232_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 DAP_R232_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 DAP_R232_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 DAP_R232_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 DAP_R232_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_L2_A_BUS_SAFETY_CTRL;
    volatile uint32 MSS_L2_A_BUS_SAFETY_FI;
    volatile uint32 MSS_L2_A_BUS_SAFETY_ERR;
    volatile uint32 MSS_L2_A_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_L2_A_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_L2_A_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_L2_A_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_L2_A_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_L2_B_BUS_SAFETY_CTRL;
    volatile uint32 MSS_L2_B_BUS_SAFETY_FI;
    volatile uint32 MSS_L2_B_BUS_SAFETY_ERR;
    volatile uint32 MSS_L2_B_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_L2_B_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_L2_B_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_L2_B_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_L2_B_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_MBOX_BUS_SAFETY_CTRL;
    volatile uint32 MSS_MBOX_BUS_SAFETY_FI;
    volatile uint32 MSS_MBOX_BUS_SAFETY_ERR;
    volatile uint32 MSS_MBOX_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_MBOX_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_MBOX_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_MBOX_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_MBOX_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_SWBUF_BUS_SAFETY_CTRL;
    volatile uint32 MSS_SWBUF_BUS_SAFETY_FI;
    volatile uint32 MSS_SWBUF_BUS_SAFETY_ERR;
    volatile uint32 MSS_SWBUF_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_SWBUF_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_SWBUF_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_SWBUF_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_SWBUF_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_GPADC_BUS_SAFETY_CTRL;
    volatile uint32 MSS_GPADC_BUS_SAFETY_FI;
    volatile uint32 MSS_GPADC_BUS_SAFETY_ERR;
    volatile uint32 MSS_GPADC_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_GPADC_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_GPADC_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_GPADC_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_GPADC_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_BUS_SAFETY_SEC_ERR_STAT0;
    volatile uint32 MSS_BUS_SAFETY_SEC_ERR_STAT1;
    volatile uint32 HW_REG0;
    volatile uint32 HW_REG1;
    volatile uint32 HW_REG2;
    volatile uint32 HW_REG3;
    volatile uint32 HW_REG4;
    volatile uint32 HW_REG5;
    volatile uint32 HW_REG6;
    volatile uint32 HW_REG7;
    volatile uint32 MSS_DMM_BUS_SAFETY_CTRL;
    volatile uint32 MSS_DMM_BUS_SAFETY_FI;
    volatile uint32 MSS_DMM_BUS_SAFETY_ERR;
    volatile uint32 MSS_DMM_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_DMM_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_DMM_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_DMM_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_DMM_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_DMM_SLV_BUS_SAFETY_CTRL;
    volatile uint32 MSS_DMM_SLV_BUS_SAFETY_FI;
    volatile uint32 MSS_DMM_SLV_BUS_SAFETY_ERR;
    volatile uint32 MSS_DMM_SLV_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_DMM_SLV_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_DMM_SLV_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_DMM_SLV_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_DMM_SLV_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_TO_MDO_BUS_SAFETY_CTRL;
    volatile uint32 MSS_TO_MDO_BUS_SAFETY_FI;
    volatile uint32 MSS_TO_MDO_BUS_SAFETY_ERR;
    volatile uint32 MSS_TO_MDO_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_TO_MDO_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_TO_MDO_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_TO_MDO_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_TO_MDO_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_SCRP_BUS_SAFETY_CTRL;
    volatile uint32 MSS_SCRP_BUS_SAFETY_FI;
    volatile uint32 MSS_SCRP_BUS_SAFETY_ERR;
    volatile uint32 MSS_SCRP_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_SCRP_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_SCRP_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_SCRP_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_SCRP_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_CR5A_AHB_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CR5A_AHB_BUS_SAFETY_FI;
    volatile uint32 MSS_CR5A_AHB_BUS_SAFETY_ERR;
    volatile uint32 MSS_CR5A_AHB_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_CR5A_AHB_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_CR5A_AHB_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_CR5A_AHB_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_CR5A_AHB_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 MSS_CR5B_AHB_BUS_SAFETY_CTRL;
    volatile uint32 MSS_CR5B_AHB_BUS_SAFETY_FI;
    volatile uint32 MSS_CR5B_AHB_BUS_SAFETY_ERR;
    volatile uint32 MSS_CR5B_AHB_BUS_SAFETY_ERR_STAT_DATA0;
    volatile uint32 MSS_CR5B_AHB_BUS_SAFETY_ERR_STAT_CMD;
    volatile uint32 MSS_CR5B_AHB_BUS_SAFETY_ERR_STAT_WRITE;
    volatile uint32 MSS_CR5B_AHB_BUS_SAFETY_ERR_STAT_READ;
    volatile uint32 MSS_CR5B_AHB_BUS_SAFETY_ERR_STAT_WRITERESP;
    volatile uint32 DMM_CTRL_REG;
    volatile uint32 MSS_CR5A_MBOX_WRITE_DONE;
    volatile uint32 MSS_CR5A_MBOX_READ_REQ;
    volatile uint32 MSS_CR5A_MBOX_READ_DONE;
    volatile uint32 MSS_CR5B_MBOX_WRITE_DONE;
    volatile uint32 MSS_CR5B_MBOX_READ_REQ;
    volatile uint32 MSS_CR5B_MBOX_READ_DONE;
    volatile uint32 MSS_PBIST_KEY_RST;
    volatile uint32 MSS_PBIST_REG0;
    volatile uint32 MSS_PBIST_REG1;
    volatile uint32 MSS_PBIST_REG2;
    volatile uint32 MSS_QSPI_CONFIG;
    volatile uint32 MSS_STC_CONTROL;
    volatile uint32 MSS_CTI_TRIG_SEL;
    volatile uint32 MSS_DBGSS_CTI_TRIG_SEL;
    volatile uint32 MSS_BOOT_INFO_REG0;
    volatile uint32 MSS_BOOT_INFO_REG1;
    volatile uint32 MSS_BOOT_INFO_REG2;
    volatile uint32 MSS_BOOT_INFO_REG3;
    volatile uint32 MSS_BOOT_INFO_REG4;
    volatile uint32 MSS_BOOT_INFO_REG5;
    volatile uint32 MSS_BOOT_INFO_REG6;
    volatile uint32 MSS_BOOT_INFO_REG7;
    volatile uint32 MSS_TPTC_ECCAGGR_CLK_CNTRL;
    volatile uint32 MSS_PERIPH_ERRAGG_MASK0;
    volatile uint32 MSS_PERIPH_ERRAGG_STATUS0;
    volatile uint32 MSS_PERIPH_ERRAGG_STATUS_RAW0;
    volatile uint32 MSS_PERIPH_ERRAGG_MASK1;
    volatile uint32 MSS_PERIPH_ERRAGG_STATUS1;
    volatile uint32 MSS_PERIPH_ERRAGG_STATUS_RAW1;
    volatile uint32 MSS_DMM_EVENT0_REG;
    volatile uint32 MSS_DMM_EVENT1_REG;
    volatile uint32 MSS_DMM_EVENT2_REG;
    volatile uint32 MSS_DMM_EVENT3_REG;
    volatile uint32 MSS_DMM_EVENT4_REG;
    volatile uint32 MSS_DMM_EVENT5_REG;
    volatile uint32 MSS_DMM_EVENT6_REG;
    volatile uint32 MSS_DMM_EVENT7_REG;
    volatile uint32 MSS_DMM_EVENT8_REG;
    volatile uint32 MSS_DMM_EVENT9_REG;
    volatile uint32 MSS_DMM_EVENT10_REG;
    volatile uint32 MSS_DMM_EVENT11_REG;
    volatile uint32 MSS_DMM_EVENT12_REG;
    volatile uint32 MSS_DMM_EVENT13_REG;
    volatile uint32 MSS_DMM_EVENT14_REG;
    volatile uint32 MSS_DMM_EVENT15_REG;
    volatile uint32 MSS_TPTC_BOUNDARY_CFG;
    volatile uint32 MSS_TPTC_XID_REORDER_CFG;
    volatile uint32 GPADC_CTRL;
    volatile uint32 HW_SYNC_FE_CTRL;
    volatile uint32 DEBUGSS_CSETB_FLUSH;
    volatile uint32 ANALOG_WU_STATUS_REG_POLARITY_INV;
    volatile uint32 ANALOG_CLK_STATUS_REG_POLARITY_INV;
    volatile uint32 ANALOG_WU_STATUS_REG_GRP1_MASK;
    volatile uint32 ANALOG_CLK_STATUS_REG_GRP1_MASK;
    volatile uint32 ANALOG_WU_STATUS_REG_GRP2_MASK;
    volatile uint32 ANALOG_CLK_STATUS_REG_GRP2_MASK;
    volatile uint32 NERROR_MASK;
    volatile uint8  Resv_2048[288];
    volatile uint32 R5_CONTROL;
    volatile uint32 R5_ROM_ECLIPSE;
    volatile uint32 R5_COREA_HALT;
    volatile uint32 R5_COREB_HALT;
    volatile uint32 R5_STATUS_REG;
    volatile uint8  Resv_4048[1980];
    volatile uint32 HW_SPARE_RW0;
    volatile uint32 HW_SPARE_RW1;
    volatile uint32 HW_SPARE_RW2;
    volatile uint32 HW_SPARE_RW3;
    volatile uint32 HW_SPARE_RO0;
    volatile uint32 HW_SPARE_RO1;
    volatile uint32 HW_SPARE_RO2;
    volatile uint32 HW_SPARE_RO3;
    volatile uint32 MSS_CR5A_B_MBOX_READ_DONE_ACK;
    volatile uint32 HW_SPARE_REC;
    volatile uint8  Resv_4104[16];
    volatile uint32 LOCK0_KICK0;
    volatile uint32 LOCK0_KICK1;
    volatile uint32 INTR_RAW_STATUS;
    volatile uint32 INTR_ENABLED_STATUS_CLEAR;
    volatile uint32 INTR_ENABLE;
    volatile uint32 INTR_ENABLE_CLEAR;
    volatile uint32 EOI;
    volatile uint32 FAULT_ADDRESS;
    volatile uint32 FAULT_TYPE_STATUS;
    volatile uint32 FAULT_ATTR_STATUS;
    volatile uint32 FAULT_CLEAR;
} CDD_DMA_CSL_mss_ctrlRegs;


/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
void Cdd_Dma_Init(Cdd_Dma_ConfigType *ConfigPtr);
void Cdd_Dma_DeInit(void);
CddDma_HandleType Cdd_Dma_GetHandle(void);
uint64 Cdd_Dma_SOC_virtToPhy(void *virtAddr);
boolean Cdd_Dma_GetInitStatus(void);
#ifdef __cplusplus
}
#endif

#endif  /* #ifndef CDD_DMA_H_ */

/** @} */

