/********************************************************************
 * Copyright (C) 2020 Texas Instruments Incorporated.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Name        : cslr_controlss_dmaxbar.h
*/
#ifndef CSLR_CONTROLSS_DMAXBAR_H_
#define CSLR_CONTROLSS_DMAXBAR_H_

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* Hardware Region  : MMRs in region 0
**************************************************************************/

/**************************************************************************
    XBAR INPUT Macros
**************************************************************************/

#define CDD_DMA_XBAR_EPWM0_SOCA    (0)
#define CDD_DMA_XBAR_EPWM1_SOCA    (1)
#define CDD_DMA_XBAR_EPWM2_SOCA    (2)
#define CDD_DMA_XBAR_EPWM3_SOCA    (3)
#define CDD_DMA_XBAR_EPWM4_SOCA    (4)
#define CDD_DMA_XBAR_EPWM5_SOCA    (5)
#define CDD_DMA_XBAR_EPWM6_SOCA    (6)
#define CDD_DMA_XBAR_EPWM7_SOCA    (7)
#define CDD_DMA_XBAR_EPWM8_SOCA    (8)
#define CDD_DMA_XBAR_EPWM9_SOCA    (9)
#define CDD_DMA_XBAR_EPWM10_SOCA    (10)
#define CDD_DMA_XBAR_EPWM11_SOCA    (11)
#define CDD_DMA_XBAR_EPWM12_SOCA    (12)
#define CDD_DMA_XBAR_EPWM13_SOCA    (13)
#define CDD_DMA_XBAR_EPWM14_SOCA    (14)
#define CDD_DMA_XBAR_EPWM15_SOCA    (15)
#define CDD_DMA_XBAR_EPWM16_SOCA    (16)
#define CDD_DMA_XBAR_EPWM17_SOCA    (17)
#define CDD_DMA_XBAR_EPWM18_SOCA    (18)
#define CDD_DMA_XBAR_EPWM19_SOCA    (19)
#define CDD_DMA_XBAR_EPWM20_SOCA    (20)
#define CDD_DMA_XBAR_EPWM21_SOCA    (21)
#define CDD_DMA_XBAR_EPWM22_SOCA    (22)
#define CDD_DMA_XBAR_EPWM23_SOCA    (23)
#define CDD_DMA_XBAR_EPWM24_SOCA    (24)
#define CDD_DMA_XBAR_EPWM25_SOCA    (25)
#define CDD_DMA_XBAR_EPWM26_SOCA    (26)
#define CDD_DMA_XBAR_EPWM27_SOCA    (27)
#define CDD_DMA_XBAR_EPWM28_SOCA    (28)
#define CDD_DMA_XBAR_EPWM29_SOCA    (29)
#define CDD_DMA_XBAR_EPWM30_SOCA    (30)
#define CDD_DMA_XBAR_EPWM31_SOCA    (31)
#define CDD_DMA_XBAR_EPWM0_SOCB    (0)
#define CDD_DMA_XBAR_EPWM1_SOCB    (1)
#define CDD_DMA_XBAR_EPWM2_SOCB    (2)
#define CDD_DMA_XBAR_EPWM3_SOCB    (3)
#define CDD_DMA_XBAR_EPWM4_SOCB    (4)
#define CDD_DMA_XBAR_EPWM5_SOCB    (5)
#define CDD_DMA_XBAR_EPWM6_SOCB    (6)
#define CDD_DMA_XBAR_EPWM7_SOCB    (7)
#define CDD_DMA_XBAR_EPWM8_SOCB    (8)
#define CDD_DMA_XBAR_EPWM9_SOCB    (9)
#define CDD_DMA_XBAR_EPWM10_SOCB    (10)
#define CDD_DMA_XBAR_EPWM11_SOCB    (11)
#define CDD_DMA_XBAR_EPWM12_SOCB    (12)
#define CDD_DMA_XBAR_EPWM13_SOCB    (13)
#define CDD_DMA_XBAR_EPWM14_SOCB    (14)
#define CDD_DMA_XBAR_EPWM15_SOCB    (15)
#define CDD_DMA_XBAR_EPWM16_SOCB    (16)
#define CDD_DMA_XBAR_EPWM17_SOCB    (17)
#define CDD_DMA_XBAR_EPWM18_SOCB    (18)
#define CDD_DMA_XBAR_EPWM19_SOCB    (19)
#define CDD_DMA_XBAR_EPWM20_SOCB    (20)
#define CDD_DMA_XBAR_EPWM21_SOCB    (21)
#define CDD_DMA_XBAR_EPWM22_SOCB    (22)
#define CDD_DMA_XBAR_EPWM23_SOCB    (23)
#define CDD_DMA_XBAR_EPWM24_SOCB    (24)
#define CDD_DMA_XBAR_EPWM25_SOCB    (25)
#define CDD_DMA_XBAR_EPWM26_SOCB    (26)
#define CDD_DMA_XBAR_EPWM27_SOCB    (27)
#define CDD_DMA_XBAR_EPWM28_SOCB    (28)
#define CDD_DMA_XBAR_EPWM29_SOCB    (29)
#define CDD_DMA_XBAR_EPWM30_SOCB    (30)
#define CDD_DMA_XBAR_EPWM31_SOCB    (31)
#define CDD_DMA_XBAR_ADC0_INT1    (0)
#define CDD_DMA_XBAR_ADC0_INT2    (1)
#define CDD_DMA_XBAR_ADC0_INT3    (2)
#define CDD_DMA_XBAR_ADC0_INT4    (3)
#define CDD_DMA_XBAR_ADC0_EVTINT    (4)
#define CDD_DMA_XBAR_ADC1_INT1    (5)
#define CDD_DMA_XBAR_ADC1_INT2    (6)
#define CDD_DMA_XBAR_ADC1_INT3    (7)
#define CDD_DMA_XBAR_ADC1_INT4    (8)
#define CDD_DMA_XBAR_ADC1_EVTINT    (9)
#define CDD_DMA_XBAR_ADC2_INT1    (10)
#define CDD_DMA_XBAR_ADC2_INT2    (11)
#define CDD_DMA_XBAR_ADC2_INT3    (12)
#define CDD_DMA_XBAR_ADC2_INT4    (13)
#define CDD_DMA_XBAR_ADC2_EVTINT    (14)
#define CDD_DMA_XBAR_ADC3_INT1    (15)
#define CDD_DMA_XBAR_ADC3_INT2    (16)
#define CDD_DMA_XBAR_ADC3_INT3    (17)
#define CDD_DMA_XBAR_ADC3_INT4    (18)
#define CDD_DMA_XBAR_ADC3_EVTINT    (19)
#define CDD_DMA_XBAR_ADC4_INT1    (20)
#define CDD_DMA_XBAR_ADC4_INT2    (21)
#define CDD_DMA_XBAR_ADC4_INT3    (22)
#define CDD_DMA_XBAR_ADC4_INT4    (23)
#define CDD_DMA_XBAR_ADC4_EVTINT    (24)
#define CDD_DMA_XBAR_FSI0_RX_DMA_EVT    (0)
#define CDD_DMA_XBAR_FSI0_DMA_TRIG1     (1)
#define CDD_DMA_XBAR_FSI0_DMA_TRIG2     (2)
#define CDD_DMA_XBAR_FSI1_RX_DMA_EVT    (3)
#define CDD_DMA_XBAR_FSI1_DMA_TRIG1     (4)
#define CDD_DMA_XBAR_FSI1_DMA_TRIG2     (5)
#define CDD_DMA_XBAR_FSI2_RX_DMA_EVT    (6)
#define CDD_DMA_XBAR_FSI2_DMA_TRIG1     (7)
#define CDD_DMA_XBAR_FSI2_DMA_TRIG2     (8)
#define CDD_DMA_XBAR_FSI3_RX_DMA_EVT    (9)
#define CDD_DMA_XBAR_FSI3_DMA_TRIG1     (10)
#define CDD_DMA_XBAR_FSI3_DMA_TRIG2     (11)
#define CDD_DMA_XBAR_FSI0_TX_DMA_EVT    (12)
#define CDD_DMA_XBAR_FSI1_TX_DMA_EVT    (13)
#define CDD_DMA_XBAR_FSI2_TX_DMA_EVT    (14)
#define CDD_DMA_XBAR_FSI3_TX_DMA_EVT    (15)
#define CDD_DMA_XBAR_SD0_FILT0_DRINT    (0)
#define CDD_DMA_XBAR_SD0_FILT1_DRINT    (1)
#define CDD_DMA_XBAR_SD0_FILT2_DRINT    (2)
#define CDD_DMA_XBAR_SD0_FILT3_DRINT    (3)
#define CDD_DMA_XBAR_SD1_FILT0_DRINT    (4)
#define CDD_DMA_XBAR_SD1_FILT1_DRINT    (5)
#define CDD_DMA_XBAR_SD1_FILT2_DRINT    (6)
#define CDD_DMA_XBAR_SD1_FILT3_DRINT    (7)
#define CDD_DMA_XBAR_ECAP0_DMA_INT    (0)
#define CDD_DMA_XBAR_ECAP1_DMA_INT    (1)
#define CDD_DMA_XBAR_ECAP2_DMA_INT    (2)
#define CDD_DMA_XBAR_ECAP3_DMA_INT    (3)
#define CDD_DMA_XBAR_ECAP4_DMA_INT    (4)
#define CDD_DMA_XBAR_ECAP5_DMA_INT    (5)
#define CDD_DMA_XBAR_ECAP6_DMA_INT    (6)
#define CDD_DMA_XBAR_ECAP7_DMA_INT    (7)
#define CDD_DMA_XBAR_ECAP8_DMA_INT    (8)
#define CDD_DMA_XBAR_ECAP9_DMA_INT    (9)

/**************************************************************************
    XBAR OUTPUT Macros
**************************************************************************/

#define CDD_DMA_XBAR_DMA_TRIG_XBAR_0              0
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_1              1
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_2              2
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_3              3
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_4              4
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_5              5
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_6              6
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_7              7
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_8              8
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_9              9
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_10             10
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_11             11
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_12             12
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_13             13
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_14             14
#define CDD_DMA_XBAR_DMA_TRIG_XBAR_15             15

/**************************************************************************
* Register Macros
**************************************************************************/

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID                                               (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_GSEL                                     (0x00000100U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G0                                       (0x00000104U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G1                                       (0x00000108U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G2                                       (0x0000010CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G3                                       (0x00000110U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G4                                       (0x00000114U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G5                                       (0x00000118U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_GSEL                                     (0x00000140U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G0                                       (0x00000144U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G1                                       (0x00000148U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G2                                       (0x0000014CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G3                                       (0x00000150U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G4                                       (0x00000154U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G5                                       (0x00000158U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_GSEL                                     (0x00000180U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G0                                       (0x00000184U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G1                                       (0x00000188U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G2                                       (0x0000018CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G3                                       (0x00000190U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G4                                       (0x00000194U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G5                                       (0x00000198U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_GSEL                                     (0x000001C0U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G0                                       (0x000001C4U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G1                                       (0x000001C8U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G2                                       (0x000001CCU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G3                                       (0x000001D0U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G4                                       (0x000001D4U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G5                                       (0x000001D8U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_GSEL                                     (0x00000200U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G0                                       (0x00000204U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G1                                       (0x00000208U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G2                                       (0x0000020CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G3                                       (0x00000210U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G4                                       (0x00000214U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G5                                       (0x00000218U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_GSEL                                     (0x00000240U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G0                                       (0x00000244U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G1                                       (0x00000248U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G2                                       (0x0000024CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G3                                       (0x00000250U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G4                                       (0x00000254U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G5                                       (0x00000258U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_GSEL                                     (0x00000280U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G0                                       (0x00000284U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G1                                       (0x00000288U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G2                                       (0x0000028CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G3                                       (0x00000290U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G4                                       (0x00000294U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G5                                       (0x00000298U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_GSEL                                     (0x000002C0U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G0                                       (0x000002C4U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G1                                       (0x000002C8U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G2                                       (0x000002CCU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G3                                       (0x000002D0U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G4                                       (0x000002D4U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G5                                       (0x000002D8U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_GSEL                                     (0x00000300U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G0                                       (0x00000304U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G1                                       (0x00000308U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G2                                       (0x0000030CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G3                                       (0x00000310U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G4                                       (0x00000314U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G5                                       (0x00000318U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_GSEL                                     (0x00000340U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G0                                       (0x00000344U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G1                                       (0x00000348U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G2                                       (0x0000034CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G3                                       (0x00000350U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G4                                       (0x00000354U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G5                                       (0x00000358U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_GSEL                                    (0x00000380U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G0                                      (0x00000384U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G1                                      (0x00000388U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G2                                      (0x0000038CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G3                                      (0x00000390U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G4                                      (0x00000394U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G5                                      (0x00000398U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_GSEL                                    (0x000003C0U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G0                                      (0x000003C4U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G1                                      (0x000003C8U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G2                                      (0x000003CCU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G3                                      (0x000003D0U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G4                                      (0x000003D4U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G5                                      (0x000003D8U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_GSEL                                    (0x00000400U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G0                                      (0x00000404U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G1                                      (0x00000408U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G2                                      (0x0000040CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G3                                      (0x00000410U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G4                                      (0x00000414U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G5                                      (0x00000418U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_GSEL                                    (0x00000440U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G0                                      (0x00000444U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G1                                      (0x00000448U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G2                                      (0x0000044CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G3                                      (0x00000450U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G4                                      (0x00000454U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G5                                      (0x00000458U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_GSEL                                    (0x00000480U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G0                                      (0x00000484U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G1                                      (0x00000488U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G2                                      (0x0000048CU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G3                                      (0x00000490U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G4                                      (0x00000494U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G5                                      (0x00000498U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_GSEL                                    (0x000004C0U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G0                                      (0x000004C4U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G1                                      (0x000004C8U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G2                                      (0x000004CCU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G3                                      (0x000004D0U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G4                                      (0x000004D4U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G5                                      (0x000004D8U)

/**************************************************************************
* Field Definition Macros
**************************************************************************/


/* PID */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MINOR_MASK                                (0x0000003FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MINOR_SHIFT                               (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MINOR_RESETVAL                            (0x00000014U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MINOR_MAX                                 (0x0000003FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_CUSTOM_MASK                               (0x000000C0U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_CUSTOM_SHIFT                              (0x00000006U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_CUSTOM_RESETVAL                           (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_CUSTOM_MAX                                (0x00000003U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MAJOR_MASK                                (0x00000700U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MAJOR_SHIFT                               (0x00000008U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MAJOR_RESETVAL                            (0x00000002U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MAJOR_MAX                                 (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MISC_MASK                                 (0x0000F800U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MISC_SHIFT                                (0x0000000BU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MISC_RESETVAL                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MISC_MAX                                  (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MSB16_MASK                                (0xFFFF0000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MSB16_SHIFT                               (0x00000010U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MSB16_RESETVAL                            (0x00006180U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_PID_MSB16_MAX                                 (0x0000FFFFU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_PID_RESETVAL                                      (0x61800214U)

/* DMAXBAR0_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR0_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR0_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR0_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR0_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR0_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR0_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR0_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR1_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR1_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR1_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR1_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR1_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR1_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR1_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR1_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR2_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR2_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR2_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR2_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR2_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR2_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR2_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR2_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR3_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR3_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR3_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR3_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR3_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR3_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR3_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR3_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR4_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR4_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR4_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR4_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR4_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR4_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR4_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR4_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR5_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR5_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR5_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR5_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR5_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR5_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR5_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR5_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR6_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR6_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR6_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR6_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR6_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR6_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR6_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR6_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR7_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR7_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR7_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR7_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR7_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR7_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR7_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR7_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR8_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR8_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR8_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR8_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR8_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR8_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR8_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR8_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR9_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_GSEL_GSEL_MASK                           (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_GSEL_GSEL_SHIFT                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_GSEL_GSEL_RESETVAL                       (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_GSEL_GSEL_MAX                            (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_GSEL_RESETVAL                            (0x00000000U)

/* DMAXBAR9_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G0_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G0_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G0_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G0_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G0_RESETVAL                              (0x00000000U)

/* DMAXBAR9_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G1_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G1_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G1_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G1_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G1_RESETVAL                              (0x00000000U)

/* DMAXBAR9_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G2_SEL_MASK                              (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G2_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G2_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G2_SEL_MAX                               (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G2_RESETVAL                              (0x00000000U)

/* DMAXBAR9_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G3_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G3_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G3_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G3_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G3_RESETVAL                              (0x00000000U)

/* DMAXBAR9_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G4_SEL_MASK                              (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G4_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G4_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G4_SEL_MAX                               (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G4_RESETVAL                              (0x00000000U)

/* DMAXBAR9_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G5_SEL_MASK                              (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G5_SEL_SHIFT                             (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G5_SEL_RESETVAL                          (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G5_SEL_MAX                               (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR9_G5_RESETVAL                              (0x00000000U)

/* DMAXBAR10_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_GSEL_GSEL_MASK                          (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_GSEL_GSEL_SHIFT                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_GSEL_GSEL_RESETVAL                      (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_GSEL_GSEL_MAX                           (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_GSEL_RESETVAL                           (0x00000000U)

/* DMAXBAR10_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G0_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G0_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G0_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G0_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G0_RESETVAL                             (0x00000000U)

/* DMAXBAR10_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G1_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G1_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G1_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G1_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G1_RESETVAL                             (0x00000000U)

/* DMAXBAR10_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G2_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G2_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G2_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G2_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G2_RESETVAL                             (0x00000000U)

/* DMAXBAR10_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G3_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G3_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G3_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G3_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G3_RESETVAL                             (0x00000000U)

/* DMAXBAR10_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G4_SEL_MASK                             (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G4_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G4_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G4_SEL_MAX                              (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G4_RESETVAL                             (0x00000000U)

/* DMAXBAR10_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G5_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G5_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G5_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G5_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR10_G5_RESETVAL                             (0x00000000U)

/* DMAXBAR11_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_GSEL_GSEL_MASK                          (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_GSEL_GSEL_SHIFT                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_GSEL_GSEL_RESETVAL                      (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_GSEL_GSEL_MAX                           (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_GSEL_RESETVAL                           (0x00000000U)

/* DMAXBAR11_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G0_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G0_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G0_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G0_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G0_RESETVAL                             (0x00000000U)

/* DMAXBAR11_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G1_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G1_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G1_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G1_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G1_RESETVAL                             (0x00000000U)

/* DMAXBAR11_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G2_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G2_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G2_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G2_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G2_RESETVAL                             (0x00000000U)

/* DMAXBAR11_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G3_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G3_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G3_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G3_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G3_RESETVAL                             (0x00000000U)

/* DMAXBAR11_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G4_SEL_MASK                             (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G4_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G4_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G4_SEL_MAX                              (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G4_RESETVAL                             (0x00000000U)

/* DMAXBAR11_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G5_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G5_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G5_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G5_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR11_G5_RESETVAL                             (0x00000000U)

/* DMAXBAR12_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_GSEL_GSEL_MASK                          (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_GSEL_GSEL_SHIFT                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_GSEL_GSEL_RESETVAL                      (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_GSEL_GSEL_MAX                           (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_GSEL_RESETVAL                           (0x00000000U)

/* DMAXBAR12_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G0_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G0_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G0_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G0_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G0_RESETVAL                             (0x00000000U)

/* DMAXBAR12_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G1_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G1_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G1_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G1_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G1_RESETVAL                             (0x00000000U)

/* DMAXBAR12_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G2_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G2_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G2_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G2_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G2_RESETVAL                             (0x00000000U)

/* DMAXBAR12_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G3_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G3_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G3_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G3_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G3_RESETVAL                             (0x00000000U)

/* DMAXBAR12_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G4_SEL_MASK                             (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G4_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G4_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G4_SEL_MAX                              (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G4_RESETVAL                             (0x00000000U)

/* DMAXBAR12_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G5_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G5_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G5_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G5_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR12_G5_RESETVAL                             (0x00000000U)

/* DMAXBAR13_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_GSEL_GSEL_MASK                          (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_GSEL_GSEL_SHIFT                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_GSEL_GSEL_RESETVAL                      (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_GSEL_GSEL_MAX                           (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_GSEL_RESETVAL                           (0x00000000U)

/* DMAXBAR13_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G0_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G0_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G0_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G0_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G0_RESETVAL                             (0x00000000U)

/* DMAXBAR13_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G1_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G1_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G1_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G1_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G1_RESETVAL                             (0x00000000U)

/* DMAXBAR13_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G2_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G2_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G2_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G2_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G2_RESETVAL                             (0x00000000U)

/* DMAXBAR13_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G3_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G3_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G3_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G3_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G3_RESETVAL                             (0x00000000U)

/* DMAXBAR13_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G4_SEL_MASK                             (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G4_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G4_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G4_SEL_MAX                              (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G4_RESETVAL                             (0x00000000U)

/* DMAXBAR13_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G5_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G5_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G5_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G5_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR13_G5_RESETVAL                             (0x00000000U)

/* DMAXBAR14_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_GSEL_GSEL_MASK                          (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_GSEL_GSEL_SHIFT                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_GSEL_GSEL_RESETVAL                      (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_GSEL_GSEL_MAX                           (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_GSEL_RESETVAL                           (0x00000000U)

/* DMAXBAR14_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G0_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G0_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G0_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G0_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G0_RESETVAL                             (0x00000000U)

/* DMAXBAR14_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G1_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G1_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G1_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G1_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G1_RESETVAL                             (0x00000000U)

/* DMAXBAR14_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G2_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G2_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G2_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G2_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G2_RESETVAL                             (0x00000000U)

/* DMAXBAR14_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G3_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G3_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G3_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G3_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G3_RESETVAL                             (0x00000000U)

/* DMAXBAR14_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G4_SEL_MASK                             (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G4_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G4_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G4_SEL_MAX                              (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G4_RESETVAL                             (0x00000000U)

/* DMAXBAR14_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G5_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G5_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G5_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G5_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR14_G5_RESETVAL                             (0x00000000U)

/* DMAXBAR15_GSEL */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_GSEL_GSEL_MASK                          (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_GSEL_GSEL_SHIFT                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_GSEL_GSEL_RESETVAL                      (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_GSEL_GSEL_MAX                           (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_GSEL_RESETVAL                           (0x00000000U)

/* DMAXBAR15_G0 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G0_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G0_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G0_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G0_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G0_RESETVAL                             (0x00000000U)

/* DMAXBAR15_G1 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G1_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G1_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G1_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G1_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G1_RESETVAL                             (0x00000000U)

/* DMAXBAR15_G2 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G2_SEL_MASK                             (0x0000001FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G2_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G2_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G2_SEL_MAX                              (0x0000001FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G2_RESETVAL                             (0x00000000U)

/* DMAXBAR15_G3 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G3_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G3_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G3_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G3_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G3_RESETVAL                             (0x00000000U)

/* DMAXBAR15_G4 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G4_SEL_MASK                             (0x00000007U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G4_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G4_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G4_SEL_MAX                              (0x00000007U)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G4_RESETVAL                             (0x00000000U)

/* DMAXBAR15_G5 */

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G5_SEL_MASK                             (0x0000000FU)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G5_SEL_SHIFT                            (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G5_SEL_RESETVAL                         (0x00000000U)
#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G5_SEL_MAX                              (0x0000000FU)

#define CDD_DMA_CSL_CONTROLSS_DMAXBAR_DMAXBAR15_G5_RESETVAL                             (0x00000000U)

#ifdef __cplusplus
}
#endif
#endif
