/* ======================================================================
 *   Copyright (c) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Eth_Irq.h
 *
 *  \brief    This file contains ISR function declaration for ETH MCAL driver
 *
 */

/**
 *  \ingroup MCAL_ETH_API
 *  @{
 */

#ifndef ETH_IRQ_H_
#define ETH_IRQ_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#if (ETH_ISR_TYPE == ETH_ISR_CAT2)
#include "Os.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/**
 *  \name ETH Driver ISR SW Version Info
 *
 *  Defines for ETH Driver ISR version used for compatibility checks
 *  @{
 */
/** \brief Driver ISR Implementation Major Version */
#define ETH_IRQ_MAJOR_VERSION           (8U)
/** \brief Driver ISR Implementation Minor Version */
#define ETH_IRQ_MINOR_VERSION           (6U)
/** \brief Driver ISR Implementation Patch Version */
#define ETH_IRQ_PATCH_VERSION           (2U)
/* @} */



/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/**
 *  \brief ISR for frame reception interrupts of the indexed controller
 *
 *  \verbatim
 *  Service name      : Eth_RxIrqHdlr_0
 *  Syntax            : void Eth_RxIrqHdlr_0(void)
 *  Service ID[hex]   : 0x10
 *  Sync/Async        : Synchronous
 *  Reentrancy        : Non Reentrant.
 *  Parameters (in)   : None
 *  Parameters (inout): None
 *  Parameters (out)  : None
 *  Return value      : None
 *  Description       : Handles frame reception interrupts of the indexed
 *                      controller
 *  \endverbatim
 */
#if ((ETH_ISR_TYPE == ETH_ISR_CAT1) || (ETH_ISR_TYPE == ETH_ISR_VOID))
FUNC(void, ETH_CODE_ISR) Eth_RxIrqHdlr_0(void);
#elif (ETH_ISR_TYPE == ETH_ISR_CAT2)
ISR(Eth_RxIrqHdlr_0);
#endif

/**
 *  \brief ISR for frame transmission interrupts of the indexed controller
 *
 *  \verbatim
 *  Service name      : Eth_TxIrqHdlr_0
 *  Syntax            : void Eth_TxIrqHdlr_0(void)
 *  Service ID[hex]   : 0x11
 *  Sync/Async        : Synchronous
 *  Reentrancy        : Non Reentrant.
 *  Parameters (in)   : None
 *  Parameters (inout): None
 *  Parameters (out)  : None
 *  Return value      : None
 *  Description       : Handles frame transmission interrupts of the indexed
 *                      controller
 *  \endverbatim
 */

#if ((ETH_ISR_TYPE == ETH_ISR_CAT1) || (ETH_ISR_TYPE == ETH_ISR_VOID))
FUNC(void, ETH_CODE_ISR) Eth_TxIrqHdlr_0(void);
#elif (ETH_ISR_TYPE == ETH_ISR_CAT2)
ISR(Eth_TxIrqHdlr_0);
#endif

/**
 *  \brief ISR for misc. interrupts of the indexed controller
 *
 *  \verbatim
 *  Service name      : Eth_MiscIrqHdlr_0
 *  Syntax            : void Eth_MiscIrqHdlr_0(void)
 *  Service ID[hex]   : NA
 *  Sync/Async        : Synchronous
 *  Reentrancy        : Non Reentrant.
 *  Parameters (in)   : None
 *  Parameters (inout): None
 *  Parameters (out)  : None
 *  Return value      : None
 *  Description       : Handles misc. interrupts of the indexed
 *                      controller
 *  \endverbatim
 */
#if ((ETH_ISR_TYPE == ETH_ISR_CAT1) || (ETH_ISR_TYPE == ETH_ISR_VOID))
FUNC(void, ETH_CODE_ISR) Eth_MiscIrqHdlr_0(void);
#elif (ETH_ISR_TYPE == ETH_ISR_CAT2)
ISR(Eth_MiscIrqHdlr_0);
#endif

/**
 *  \brief ISR for Receive threshold interrupts of the indexed controller
 *
 *  \verbatim
 *  Service name      : Eth_RxThreshIrqHdlr_0
 *  Syntax            : void Eth_RxThreshIrqHdlr_0(void)
 *  Service ID[hex]   : NA
 *  Sync/Async        : Synchronous
 *  Reentrancy        : Non Reentrant.
 *  Parameters (in)   : None
 *  Parameters (inout): None
 *  Parameters (out)  : None
 *  Return value      : None
 *  Description       : Handles receive threshold interrupts of the indexed
 *                      controller
 *  \endverbatim
 */
#if ((ETH_ISR_TYPE == ETH_ISR_CAT1) || (ETH_ISR_TYPE == ETH_ISR_VOID))
void Eth_RxThreshIrqHdlr_0(void);
#elif (ETH_ISR_TYPE == ETH_ISR_CAT2)
ISR(Eth_RxThreshIrqHdlr_0);
#endif


#ifdef __cplusplus
}
#endif

#endif  /* #ifndef ETH_IRQ_H_ */

/* @} */
