/* ======================================================================
 *   Copyright (c) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file   cpsw_stats.h
 *
 *  \brief  This file contains the device abstraction layer API implementation
 *          corresponding to CPSW stats subsystem.
 */

#ifndef CPSW_STATS_H_
#define CPSW_STATS_H_

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
/* There are static inline functions in hw_types.h file. Map them as well */
#define ETH_START_SEC_CODE
/* MISRAC_2012_R.20.1
  * "Reason - This is the format to use for specifying memory sections " */
#include "Eth_MemMap.h"
#include "hw_types.h"
#define ETH_STOP_SEC_CODE
/* MISRAC_2012_R.20.1
  * "Reason - This is the format to use for specifying memory sections " */
#include "Eth_MemMap.h"

#include "cpsw_priv.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                 Internal Function Declarations                             */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/*---------------------------------------------------------------------------*\
 |                         Global Function Declarations                        |
 \*---------------------------------------------------------------------------*/

/**
 * \brief Initialize statistics module
 */
void EthStatsInit(uint32 baseAddr,
                            Eth_StatsObj *pStatsObj,
                            uint8 portIdx);

/**
 * \brief Deinit statistics module
 */
void EthStatsDeInit(uint32 baseAddr, Eth_StatsObj *pStatsObj, uint8 portIdx);

/**
 * \brief Get statistics. This would call updatestats to update statistics
 *        structure
 */
void EthGetStats(uint32         baseAddr,
                 Eth_StatsObj  *pStatsObj,
                 Eth_StatsType *pStatistics,
				 uint8 portNum);

/**
 * \brief statistics module update function (runs in the ISR context)
 */
void EthStatsUpdate(uint32 baseAddr, Eth_StatsObj *pStatsObj);

#ifdef __cplusplus
}
#endif

#endif /* _CPSW_STATS_H_ */

