/* ======================================================================
 *   Copyright (c) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/*
 * hw_cpsw_ale.h
 *
 * Register-level header file for CPSW_ALE
 */

#ifndef HW_CPSW_ALE_H_
#define HW_CPSW_ALE_H_

#ifdef __cplusplus
extern "C"
{
#endif


/*******************************************************************************
* Register Definitions
*******************************************************************************/
#define CPSW_ALE_IDVER_REG                                       (0x0003E000U)
#define CPSW_ALE_STATUS_REG                                      (0x0003E004U)
#define CPSW_ALE_CONTROL_REG                                     (0x0003E008U)
#define CPSW_ALE_CONTROL2_REG                                    (0x0003E00CU)
#define CPSW_ALE_PRESCALE_REG                                    (0x0003E010U)
#define CPSW_ALE_AGING_TIMER_REG                                 (0x0003E014U)
#define CPSW_ALE_TABLE_CONTROL_REG                               (0x0003E020U)
#define CPSW_ALE_TABLE_WORD(n)                                   ((uint32) 0x0003E03CU - ((uint32) (n) * 0x4U))
#define CPSW_ALE_PORT_CONTROL_REG(PORT_CONTROL_REG)              (0x0003E040U+((PORT_CONTROL_REG)*0x4U))
#define CPSW_ALE_UNKNOWN_VLAN_REG                                (0x0003E090U)
#define CPSW_ALE_UNKNOWN_MCAST_FLOOD_REG                         (0x0003E094U)
#define CPSW_ALE_UNKNOWN_REG_MCAST_FLOOD_REG                     (0x0003E098U)
#define CPSW_ALE_FORCE_UNTAGGED_EGRESS_REG                       (0x0003E09CU)
#define CPSW_ALE_VLAN_MASK_MUX0_REG                              (0x0003E0C0U)
#define CPSW_ALE_VLAN_MASK_MUX1_REG                              (0x0003E0C4U)
#define CPSW_ALE_VLAN_MASK_MUX2_REG                              (0x0003E0C8U)
#define CPSW_ALE_VLAN_MASK_MUX3_REG                              (0x0003E0CCU)
#define CPSW_ALE_VLAN_MASK_MUX4_REG                              (0x0003E0D0U)
#define CPSW_ALE_VLAN_MASK_MUX5_REG                              (0x0003E0D4U)
#define CPSW_ALE_VLAN_MASK_MUX6_REG                              (0x0003E0D8U)
#define CPSW_ALE_VLAN_MASK_MUX7_REG                              (0x0003E0DCU)
#define CPSW_ALE_POLICER_PORT_OUI_REG                            (0x0003E100U)
#define CPSW_ALE_POLICER_DA_SA_REG                               (0x0003E104U)
#define CPSW_ALE_POLICER_VLAN_REG                                (0x0003E108U)
#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG                      (0x0003E10CU)
#define CPSW_ALE_POLICER_IPDA_REG                                (0x0003E110U)
#define CPSW_ALE_POLICER_PIR_REG                                 (0x0003E118U)
#define CPSW_ALE_POLICER_CIR_REG                                 (0x0003E11CU)
#define CPSW_ALE_POLICER_TBL_CTL_REG                             (0x0003E120U)
#define CPSW_ALE_POLICER_CTL_REG                                 (0x0003E124U)
#define CPSW_ALE_POLICER_TEST_CTL_REG                            (0x0003E128U)
#define CPSW_ALE_POLICER_HIT_STATUS_REG                          (0x0003E12CU)
#define CPSW_ALE_THREAD_DEF_REG                                  (0x0003E134U)
#define CPSW_ALE_THREAD_CTL_REG                                  (0x0003E138U)
#define CPSW_ALE_THREAD_VAL_REG                                  (0x0003E13CU)

/*******************************************************************************
* Field Definition Macros
*******************************************************************************/
/* IDVER_REG */

#define CPSW_ALE_IDVER_REG_MINOR_VER_MASK                        (0x000000FFU)
#define CPSW_ALE_IDVER_REG_MINOR_VER_SHIFT                       (0x00000000U)
#define CPSW_ALE_IDVER_REG_MINOR_VER_MAX                         (0x000000FFU)

#define CPSW_ALE_IDVER_REG_MAJOR_VER_MASK                        (0x00000700U)
#define CPSW_ALE_IDVER_REG_MAJOR_VER_SHIFT                       (0x00000008U)
#define CPSW_ALE_IDVER_REG_MAJOR_VER_MAX                         (0x00000007U)

#define CPSW_ALE_IDVER_REG_RTL_VER_MASK                          (0x0000F800U)
#define CPSW_ALE_IDVER_REG_RTL_VER_SHIFT                         (0x0000000BU)
#define CPSW_ALE_IDVER_REG_RTL_VER_MAX                           (0x0000001FU)

#define CPSW_ALE_IDVER_REG_IDENT_MASK                            (0xFFFF0000U)
#define CPSW_ALE_IDVER_REG_IDENT_SHIFT                           (0x00000010U)
#define CPSW_ALE_IDVER_REG_IDENT_MAX                             (0x0000FFFFU)

/* STATUS_REG */

#define CPSW_ALE_STATUS_REG_ENTRIES_DIV_1024_MASK                (0x000000FFU)
#define CPSW_ALE_STATUS_REG_ENTRIES_DIV_1024_SHIFT               (0x00000000U)
#define CPSW_ALE_STATUS_REG_ENTRIES_DIV_1024_MAX                 (0x000000FFU)

#define CPSW_ALE_STATUS_REG_POLICERS_DIV_8_MASK                  (0x0000FF00U)
#define CPSW_ALE_STATUS_REG_POLICERS_DIV_8_SHIFT                 (0x00000008U)
#define CPSW_ALE_STATUS_REG_POLICERS_DIV_8_MAX                   (0x000000FFU)

/* CONTROL_REG */

#define CPSW_ALE_CONTROL_REG_ENABLE_RATE_LIMIT_MASK              (0x00000001U)
#define CPSW_ALE_CONTROL_REG_ENABLE_RATE_LIMIT_SHIFT             (0x00000000U)
#define CPSW_ALE_CONTROL_REG_ENABLE_RATE_LIMIT_MAX               (0x00000001U)

#define CPSW_ALE_CONTROL_REG_ENABLE_AUTH_MODE_MASK               (0x00000002U)
#define CPSW_ALE_CONTROL_REG_ENABLE_AUTH_MODE_SHIFT              (0x00000001U)
#define CPSW_ALE_CONTROL_REG_ENABLE_AUTH_MODE_MAX                (0x00000001U)

#define CPSW_ALE_CONTROL_REG_VLAN_AWARE_MASK                     (0x00000004U)
#define CPSW_ALE_CONTROL_REG_VLAN_AWARE_SHIFT                    (0x00000002U)
#define CPSW_ALE_CONTROL_REG_VLAN_AWARE_MAX                      (0x00000001U)

#define CPSW_ALE_CONTROL_REG_RATE_LIMIT_TX_MASK                  (0x00000008U)
#define CPSW_ALE_CONTROL_REG_RATE_LIMIT_TX_SHIFT                 (0x00000003U)
#define CPSW_ALE_CONTROL_REG_RATE_LIMIT_TX_MAX                   (0x00000001U)

#define CPSW_ALE_CONTROL_REG_BYPASS_MASK                         (0x00000010U)
#define CPSW_ALE_CONTROL_REG_BYPASS_SHIFT                        (0x00000004U)
#define CPSW_ALE_CONTROL_REG_BYPASS_MAX                          (0x00000001U)

#define CPSW_ALE_CONTROL_REG_ENABLE_OUI_DENY_MASK                (0x00000020U)
#define CPSW_ALE_CONTROL_REG_ENABLE_OUI_DENY_SHIFT               (0x00000005U)
#define CPSW_ALE_CONTROL_REG_ENABLE_OUI_DENY_MAX                 (0x00000001U)

#define CPSW_ALE_CONTROL_REG_EN_VID0_MODE_MASK                   (0x00000040U)
#define CPSW_ALE_CONTROL_REG_EN_VID0_MODE_SHIFT                  (0x00000006U)
#define CPSW_ALE_CONTROL_REG_EN_VID0_MODE_MAX                    (0x00000001U)

#define CPSW_ALE_CONTROL_REG_LEARN_NO_VID_MASK                   (0x00000080U)
#define CPSW_ALE_CONTROL_REG_LEARN_NO_VID_SHIFT                  (0x00000007U)
#define CPSW_ALE_CONTROL_REG_LEARN_NO_VID_MAX                    (0x00000001U)

#define CPSW_ALE_CONTROL_REG_UNI_FLOOD_TO_HOST_MASK              (0x00000100U)
#define CPSW_ALE_CONTROL_REG_UNI_FLOOD_TO_HOST_SHIFT             (0x00000008U)
#define CPSW_ALE_CONTROL_REG_UNI_FLOOD_TO_HOST_MAX               (0x00000001U)

#define CPSW_ALE_CONTROL_REG_MIRROR_SEN_MASK                     (0x00000400U)
#define CPSW_ALE_CONTROL_REG_MIRROR_SEN_SHIFT                    (0x0000000AU)
#define CPSW_ALE_CONTROL_REG_MIRROR_SEN_MAX                      (0x00000001U)

#define CPSW_ALE_CONTROL_REG_MIRROR_DEN_MASK                     (0x00000800U)
#define CPSW_ALE_CONTROL_REG_MIRROR_DEN_SHIFT                    (0x0000000BU)
#define CPSW_ALE_CONTROL_REG_MIRROR_DEN_MAX                      (0x00000001U)

#define CPSW_ALE_CONTROL_REG_MIRROR_MEN_MASK                     (0x00001000U)
#define CPSW_ALE_CONTROL_REG_MIRROR_MEN_SHIFT                    (0x0000000CU)
#define CPSW_ALE_CONTROL_REG_MIRROR_MEN_MAX                      (0x00000001U)

#define CPSW_ALE_CONTROL_REG_UVLAN_NO_LEARN_MASK                 (0x00002000U)
#define CPSW_ALE_CONTROL_REG_UVLAN_NO_LEARN_SHIFT                (0x0000000DU)
#define CPSW_ALE_CONTROL_REG_UVLAN_NO_LEARN_MAX                  (0x00000001U)

#define CPSW_ALE_CONTROL_REG_REG_UPD_STATIC_MASK                 (0x00008000U)
#define CPSW_ALE_CONTROL_REG_REG_UPD_STATIC_SHIFT                (0x0000000FU)
#define CPSW_ALE_CONTROL_REG_REG_UPD_STATIC_MAX                  (0x00000001U)

#define CPSW_ALE_CONTROL_REG_MIRROR_TOP_MASK                     (0x00010000U)
#define CPSW_ALE_CONTROL_REG_MIRROR_TOP_SHIFT                    (0x00000010U)
#define CPSW_ALE_CONTROL_REG_MIRROR_TOP_MAX                      (0x00000001U)

#define CPSW_ALE_CONTROL_REG_UPD_BW_CTL_MASK                     (0x00E00000U)
#define CPSW_ALE_CONTROL_REG_UPD_BW_CTL_SHIFT                    (0x00000015U)
#define CPSW_ALE_CONTROL_REG_UPD_BW_CTL_MAX                      (0x00000007U)

#define CPSW_ALE_CONTROL_REG_MIRROR_DP_MASK                      (0x01000000U)
#define CPSW_ALE_CONTROL_REG_MIRROR_DP_SHIFT                     (0x00000018U)
#define CPSW_ALE_CONTROL_REG_MIRROR_DP_MAX                       (0x00000001U)

#define CPSW_ALE_CONTROL_REG_AGE_OUT_NOW_MASK                    (0x20000000U)
#define CPSW_ALE_CONTROL_REG_AGE_OUT_NOW_SHIFT                   (0x0000001DU)
#define CPSW_ALE_CONTROL_REG_AGE_OUT_NOW_MAX                     (0x00000001U)

#define CPSW_ALE_CONTROL_REG_CLEAR_TABLE_MASK                    (0x40000000U)
#define CPSW_ALE_CONTROL_REG_CLEAR_TABLE_SHIFT                   (0x0000001EU)
#define CPSW_ALE_CONTROL_REG_CLEAR_TABLE_MAX                     (0x00000001U)

#define CPSW_ALE_CONTROL_REG_ENABLE_MASK                         (0x80000000U)
#define CPSW_ALE_CONTROL_REG_ENABLE_SHIFT                        (0x0000001FU)
#define CPSW_ALE_CONTROL_REG_ENABLE_MAX                          (0x00000001U)

/* CONTROL2_REG */

#define CPSW_ALE_CONTROL2_REG_TRK_EN_DST_MASK                    (0x80000000U)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_DST_SHIFT                   (0x0000001FU)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_DST_MAX                     (0x00000001U)

#define CPSW_ALE_CONTROL2_REG_TRK_EN_SRC_MASK                    (0x40000000U)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_SRC_SHIFT                   (0x0000001EU)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_SRC_MAX                     (0x00000001U)

#define CPSW_ALE_CONTROL2_REG_TRK_EN_PRI_MASK                    (0x20000000U)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_PRI_SHIFT                   (0x0000001DU)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_PRI_MAX                     (0x00000001U)

#define CPSW_ALE_CONTROL2_REG_TRK_EN_VLAN_MASK                   (0x08000000U)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_VLAN_SHIFT                  (0x0000001BU)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_VLAN_MAX                    (0x00000001U)

#define CPSW_ALE_CONTROL2_REG_TRK_EN_SIP_MASK                    (0x02000000U)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_SIP_SHIFT                   (0x00000019U)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_SIP_MAX                     (0x00000001U)

#define CPSW_ALE_CONTROL2_REG_TRK_EN_DIP_MASK                    (0x01000000U)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_DIP_SHIFT                   (0x00000018U)
#define CPSW_ALE_CONTROL2_REG_TRK_EN_DIP_MAX                     (0x00000001U)

#define CPSW_ALE_CONTROL2_REG_TRK_BASE_MASK                      (0x00070000U)
#define CPSW_ALE_CONTROL2_REG_TRK_BASE_SHIFT                     (0x00000010U)
#define CPSW_ALE_CONTROL2_REG_TRK_BASE_MAX                       (0x00000007U)

#define CPSW_ALE_CONTROL2_REG_MIRROR_MIDX_MASK                   (0x0000003FU)
#define CPSW_ALE_CONTROL2_REG_MIRROR_MIDX_SHIFT                  (0x00000000U)
#define CPSW_ALE_CONTROL2_REG_MIRROR_MIDX_MAX                    (0x0000003FU)

/* PRESCALE_REG */

#define CPSW_ALE_PRESCALE_REG_PRESCALE_MASK                      (0x000FFFFFU)
#define CPSW_ALE_PRESCALE_REG_PRESCALE_SHIFT                     (0x00000000U)
#define CPSW_ALE_PRESCALE_REG_PRESCALE_MAX                       (0x000FFFFFU)

/* AGING_TIMER_REG */

#define CPSW_ALE_AGING_TIMER_REG_AGING_TIMER_MASK                (0x00FFFFFFU)
#define CPSW_ALE_AGING_TIMER_REG_AGING_TIMER_SHIFT               (0x00000000U)
#define CPSW_ALE_AGING_TIMER_REG_AGING_TIMER_MAX                 (0x00FFFFFFU)

#define CPSW_ALE_AGING_TIMER_REG_PRESCALE_2_DISABLE_MASK         (0x40000000U)
#define CPSW_ALE_AGING_TIMER_REG_PRESCALE_2_DISABLE_SHIFT        (0x0000001EU)
#define CPSW_ALE_AGING_TIMER_REG_PRESCALE_2_DISABLE_MAX          (0x00000001U)

#define CPSW_ALE_AGING_TIMER_REG_PRESCALE_1_DISABLE_MASK         (0x80000000U)
#define CPSW_ALE_AGING_TIMER_REG_PRESCALE_1_DISABLE_SHIFT        (0x0000001FU)
#define CPSW_ALE_AGING_TIMER_REG_PRESCALE_1_DISABLE_MAX          (0x00000001U)

/* TABLE_CONTROL_REG */

#define CPSW_ALE_TABLE_CONTROL_REG_ENTRY_POINTER_MASK            (0x0000003FU)
#define CPSW_ALE_TABLE_CONTROL_REG_ENTRY_POINTER_SHIFT           (0x00000000U)
#define CPSW_ALE_TABLE_CONTROL_REG_ENTRY_POINTER_MAX             (0x0000003FU)

#define CPSW_ALE_TABLE_CONTROL_REG_WRITE_RDZ_MASK                (0x80000000U)
#define CPSW_ALE_TABLE_CONTROL_REG_WRITE_RDZ_SHIFT               (0x0000001FU)
#define CPSW_ALE_TABLE_CONTROL_REG_WRITE_RDZ_MAX                 (0x00000001U)

/* TABLE_WORD2_REG */

#define CPSW_ALE_TABLE_WORD2_REG_ENTRY_71_64_MASK                (0x0000007FU)
#define CPSW_ALE_TABLE_WORD2_REG_ENTRY_71_64_SHIFT               (0x00000000U)
#define CPSW_ALE_TABLE_WORD2_REG_ENTRY_71_64_MAX                 (0x0000007FU)

/* TABLE_WORD1_REG */

#define CPSW_ALE_TABLE_WORD1_REG_ENTRY_63_32_MASK                (0xFFFFFFFFU)
#define CPSW_ALE_TABLE_WORD1_REG_ENTRY_63_32_SHIFT               (0x00000000U)
#define CPSW_ALE_TABLE_WORD1_REG_ENTRY_63_32_MAX                 (0xFFFFFFFFU)

/* TABLE_WORD0_REG */

#define CPSW_ALE_TABLE_WORD0_REG_ENTRY_31_0_MASK                 (0xFFFFFFFFU)
#define CPSW_ALE_TABLE_WORD0_REG_ENTRY_31_0_SHIFT                (0x00000000U)
#define CPSW_ALE_TABLE_WORD0_REG_ENTRY_31_0_MAX                  (0xFFFFFFFFU)

/* PORT_CONTROL_REG */

#define CPSW_ALE_PORT_CONTROL_REG_PORT_STATE_MASK                (0x00000003U)
#define CPSW_ALE_PORT_CONTROL_REG_PORT_STATE_SHIFT               (0x00000000U)
#define CPSW_ALE_PORT_CONTROL_REG_PORT_STATE_MAX                 (0x00000003U)

#define CPSW_ALE_PORT_CONTROL_REG_DROP_UNTAGGED_MASK             (0x00000004U)
#define CPSW_ALE_PORT_CONTROL_REG_DROP_UNTAGGED_SHIFT            (0x00000002U)
#define CPSW_ALE_PORT_CONTROL_REG_DROP_UNTAGGED_MAX              (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_VID_INGRESS_CHECK_MASK         (0x00000008U)
#define CPSW_ALE_PORT_CONTROL_REG_VID_INGRESS_CHECK_SHIFT        (0x00000003U)
#define CPSW_ALE_PORT_CONTROL_REG_VID_INGRESS_CHECK_MAX          (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_NO_LEARN_MASK                  (0x00000010U)
#define CPSW_ALE_PORT_CONTROL_REG_NO_LEARN_SHIFT                 (0x00000004U)
#define CPSW_ALE_PORT_CONTROL_REG_NO_LEARN_MAX                   (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_NO_SA_UPDATE_MASK              (0x00000020U)
#define CPSW_ALE_PORT_CONTROL_REG_NO_SA_UPDATE_SHIFT             (0x00000005U)
#define CPSW_ALE_PORT_CONTROL_REG_NO_SA_UPDATE_MAX               (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_MIRROR_SP_MASK                 (0x00000080U)
#define CPSW_ALE_PORT_CONTROL_REG_MIRROR_SP_SHIFT                (0x00000007U)
#define CPSW_ALE_PORT_CONTROL_REG_MIRROR_SP_MAX                  (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_TRUNK_NUMBER_MASK              (0x00000300U)
#define CPSW_ALE_PORT_CONTROL_REG_TRUNK_NUMBER_SHIFT             (0x00000008U)
#define CPSW_ALE_PORT_CONTROL_REG_TRUNK_NUMBER_MAX               (0x00000003U)

#define CPSW_ALE_PORT_CONTROL_REG_TRUNK_EN_MASK                  (0x00000400U)
#define CPSW_ALE_PORT_CONTROL_REG_TRUNK_EN_SHIFT                 (0x0000000AU)
#define CPSW_ALE_PORT_CONTROL_REG_TRUNK_EN_MAX                   (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_MAC_ONLY_MASK                  (0x00000800U)
#define CPSW_ALE_PORT_CONTROL_REG_MAC_ONLY_SHIFT                 (0x0000000BU)
#define CPSW_ALE_PORT_CONTROL_REG_MAC_ONLY_MAX                   (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_DISABLE_AUTH_MODE_MASK         (0x00001000U)
#define CPSW_ALE_PORT_CONTROL_REG_DISABLE_AUTH_MODE_SHIFT        (0x0000000CU)
#define CPSW_ALE_PORT_CONTROL_REG_DISABLE_AUTH_MODE_MAX          (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_MAC_ONLY_CAF_MASK              (0x00002000U)
#define CPSW_ALE_PORT_CONTROL_REG_MAC_ONLY_CAF_SHIFT             (0x0000000DU)
#define CPSW_ALE_PORT_CONTROL_REG_MAC_ONLY_CAF_MAX               (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_DROP_DUAL_VLAN_MASK            (0x00004000U)
#define CPSW_ALE_PORT_CONTROL_REG_DROP_DUAL_VLAN_SHIFT           (0x0000000EU)
#define CPSW_ALE_PORT_CONTROL_REG_DROP_DUAL_VLAN_MAX             (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_DROP_DBL_VLAN_MASK             (0x00008000U)
#define CPSW_ALE_PORT_CONTROL_REG_DROP_DBL_VLAN_SHIFT            (0x0000000FU)
#define CPSW_ALE_PORT_CONTROL_REG_DROP_DBL_VLAN_MAX              (0x00000001U)

#define CPSW_ALE_PORT_CONTROL_REG_MCAST_LIMIT_MASK               (0x00FF0000U)
#define CPSW_ALE_PORT_CONTROL_REG_MCAST_LIMIT_SHIFT              (0x00000010U)
#define CPSW_ALE_PORT_CONTROL_REG_MCAST_LIMIT_MAX                (0x000000FFU)

#define CPSW_ALE_PORT_CONTROL_REG_BCAST_LIMIT_MASK               (0xFF000000U)
#define CPSW_ALE_PORT_CONTROL_REG_BCAST_LIMIT_SHIFT              (0x00000018U)
#define CPSW_ALE_PORT_CONTROL_REG_BCAST_LIMIT_MAX                (0x000000FFU)

/* UNKNOWN_VLAN_REG */

#define CPSW_ALE_UNKNOWN_VLAN_REG_LIST_MASK                      (0x00000007U)
#define CPSW_ALE_UNKNOWN_VLAN_REG_LIST_SHIFT                     (0x00000000U)
#define CPSW_ALE_UNKNOWN_VLAN_REG_LIST_MAX                       (0x00000007U)

/* UNKNOWN_MCAST_FLOOD_REG */

#define CPSW_ALE_UNKNOWN_MCAST_FLOOD_REG_MASK_MASK               (0x00000007U)
#define CPSW_ALE_UNKNOWN_MCAST_FLOOD_REG_MASK_SHIFT              (0x00000000U)
#define CPSW_ALE_UNKNOWN_MCAST_FLOOD_REG_MASK_MAX                (0x00000007U)

/* UNKNOWN_REG_MCAST_FLOOD_REG */

#define CPSW_ALE_UNKNOWN_REG_MCAST_FLOOD_REG_MASK_MASK           (0x00000007U)
#define CPSW_ALE_UNKNOWN_REG_MCAST_FLOOD_REG_MASK_SHIFT          (0x00000000U)
#define CPSW_ALE_UNKNOWN_REG_MCAST_FLOOD_REG_MASK_MAX            (0x00000007U)

/* FORCE_UNTAGGED_EGRESS_REG */

#define CPSW_ALE_FORCE_UNTAGGED_EGRESS_REG_MASK_MASK             (0x00000007U)
#define CPSW_ALE_FORCE_UNTAGGED_EGRESS_REG_MASK_SHIFT            (0x00000000U)
#define CPSW_ALE_FORCE_UNTAGGED_EGRESS_REG_MASK_MAX              (0x00000007U)

/* VLAN_MASK_MUX0_REG */

#define CPSW_ALE_VLAN_MASK_MUX0_REG_MASK_MASK                    (0x00000007U)
#define CPSW_ALE_VLAN_MASK_MUX0_REG_MASK_SHIFT                   (0x00000000U)
#define CPSW_ALE_VLAN_MASK_MUX0_REG_MASK_MAX                     (0x00000007U)

/* VLAN_MASK_MUX1_REG */

#define CPSW_ALE_VLAN_MASK_MUX1_REG_MASK_MASK                    (0x00000007U)
#define CPSW_ALE_VLAN_MASK_MUX1_REG_MASK_SHIFT                   (0x00000000U)
#define CPSW_ALE_VLAN_MASK_MUX1_REG_MASK_MAX                     (0x00000007U)

/* VLAN_MASK_MUX2_REG */

#define CPSW_ALE_VLAN_MASK_MUX2_REG_MASK_MASK                    (0x00000007U)
#define CPSW_ALE_VLAN_MASK_MUX2_REG_MASK_SHIFT                   (0x00000000U)
#define CPSW_ALE_VLAN_MASK_MUX2_REG_MASK_MAX                     (0x00000007U)

/* VLAN_MASK_MUX3_REG */

#define CPSW_ALE_VLAN_MASK_MUX3_REG_MASK_MASK                    (0x00000007U)
#define CPSW_ALE_VLAN_MASK_MUX3_REG_MASK_SHIFT                   (0x00000000U)
#define CPSW_ALE_VLAN_MASK_MUX3_REG_MASK_MAX                     (0x00000007U)

/* VLAN_MASK_MUX4_REG */

#define CPSW_ALE_VLAN_MASK_MUX4_REG_MASK_MASK                    (0x00000007U)
#define CPSW_ALE_VLAN_MASK_MUX4_REG_MASK_SHIFT                   (0x00000000U)
#define CPSW_ALE_VLAN_MASK_MUX4_REG_MASK_MAX                     (0x00000007U)

/* VLAN_MASK_MUX5_REG */

#define CPSW_ALE_VLAN_MASK_MUX5_REG_MASK_MASK                    (0x00000007U)
#define CPSW_ALE_VLAN_MASK_MUX5_REG_MASK_SHIFT                   (0x00000000U)
#define CPSW_ALE_VLAN_MASK_MUX5_REG_MASK_MAX                     (0x00000007U)

/* VLAN_MASK_MUX6_REG */

#define CPSW_ALE_VLAN_MASK_MUX6_REG_MASK_MASK                    (0x00000007U)
#define CPSW_ALE_VLAN_MASK_MUX6_REG_MASK_SHIFT                   (0x00000000U)
#define CPSW_ALE_VLAN_MASK_MUX6_REG_MASK_MAX                     (0x00000007U)

/* VLAN_MASK_MUX7_REG */

#define CPSW_ALE_VLAN_MASK_MUX7_REG_MASK_MASK                    (0x00000007U)
#define CPSW_ALE_VLAN_MASK_MUX7_REG_MASK_SHIFT                   (0x00000000U)
#define CPSW_ALE_VLAN_MASK_MUX7_REG_MASK_MAX                     (0x00000007U)

/* POLICER_PORT_OUI_REG */

#define CPSW_ALE_POLICER_PORT_OUI_REG_PORT_MEN_MASK              (0x80000000U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_PORT_MEN_SHIFT             (0x0000001FU)
#define CPSW_ALE_POLICER_PORT_OUI_REG_PORT_MEN_MAX               (0x00000001U)

#define CPSW_ALE_POLICER_PORT_OUI_REG_TRUNK_ID_MASK              (0x40000000U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_TRUNK_ID_SHIFT             (0x0000001EU)
#define CPSW_ALE_POLICER_PORT_OUI_REG_TRUNK_ID_MAX               (0x00000001U)

#define CPSW_ALE_POLICER_PORT_OUI_REG_PORT_NUM_MASK              (0x02000000U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_PORT_NUM_SHIFT             (0x00000019U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_PORT_NUM_MAX               (0x00000001U)

#define CPSW_ALE_POLICER_PORT_OUI_REG_PRI_MEN_MASK               (0x00080000U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_PRI_MEN_SHIFT              (0x00000013U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_PRI_MEN_MAX                (0x00000001U)

#define CPSW_ALE_POLICER_PORT_OUI_REG_PRI_VAL_MASK               (0x00070000U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_PRI_VAL_SHIFT              (0x00000010U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_PRI_VAL_MAX                (0x00000007U)

#define CPSW_ALE_POLICER_PORT_OUI_REG_OUI_MEN_MASK               (0x00008000U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_OUI_MEN_SHIFT              (0x0000000FU)
#define CPSW_ALE_POLICER_PORT_OUI_REG_OUI_MEN_MAX                (0x00000001U)

#define CPSW_ALE_POLICER_PORT_OUI_REG_OUI_INDEX_MASK             (0x0000003FU)
#define CPSW_ALE_POLICER_PORT_OUI_REG_OUI_INDEX_SHIFT            (0x00000000U)
#define CPSW_ALE_POLICER_PORT_OUI_REG_OUI_INDEX_MAX              (0x0000003FU)

/* POLICER_DA_SA_REG */

#define CPSW_ALE_POLICER_DA_SA_REG_DST_MEN_MASK                  (0x80000000U)
#define CPSW_ALE_POLICER_DA_SA_REG_DST_MEN_SHIFT                 (0x0000001FU)
#define CPSW_ALE_POLICER_DA_SA_REG_DST_MEN_MAX                   (0x00000001U)

#define CPSW_ALE_POLICER_DA_SA_REG_DST_INDEX_MASK                (0x003F0000U)
#define CPSW_ALE_POLICER_DA_SA_REG_DST_INDEX_SHIFT               (0x00000010U)
#define CPSW_ALE_POLICER_DA_SA_REG_DST_INDEX_MAX                 (0x0000003FU)

#define CPSW_ALE_POLICER_DA_SA_REG_SRC_MEN_MASK                  (0x00008000U)
#define CPSW_ALE_POLICER_DA_SA_REG_SRC_MEN_SHIFT                 (0x0000000FU)
#define CPSW_ALE_POLICER_DA_SA_REG_SRC_MEN_MAX                   (0x00000001U)

#define CPSW_ALE_POLICER_DA_SA_REG_SRC_INDEX_MASK                (0x0000003FU)
#define CPSW_ALE_POLICER_DA_SA_REG_SRC_INDEX_SHIFT               (0x00000000U)
#define CPSW_ALE_POLICER_DA_SA_REG_SRC_INDEX_MAX                 (0x0000003FU)

/* POLICER_VLAN_REG */

#define CPSW_ALE_POLICER_VLAN_REG_OVLAN_MEN_MASK                 (0x80000000U)
#define CPSW_ALE_POLICER_VLAN_REG_OVLAN_MEN_SHIFT                (0x0000001FU)
#define CPSW_ALE_POLICER_VLAN_REG_OVLAN_MEN_MAX                  (0x00000001U)

#define CPSW_ALE_POLICER_VLAN_REG_OVLAN_INDEX_MASK               (0x003F0000U)
#define CPSW_ALE_POLICER_VLAN_REG_OVLAN_INDEX_SHIFT              (0x00000010U)
#define CPSW_ALE_POLICER_VLAN_REG_OVLAN_INDEX_MAX                (0x0000003FU)

#define CPSW_ALE_POLICER_VLAN_REG_IVLAN_MEN_MASK                 (0x00008000U)
#define CPSW_ALE_POLICER_VLAN_REG_IVLAN_MEN_SHIFT                (0x0000000FU)
#define CPSW_ALE_POLICER_VLAN_REG_IVLAN_MEN_MAX                  (0x00000001U)

#define CPSW_ALE_POLICER_VLAN_REG_IVLAN_INDEX_MASK               (0x0000003FU)
#define CPSW_ALE_POLICER_VLAN_REG_IVLAN_INDEX_SHIFT              (0x00000000U)
#define CPSW_ALE_POLICER_VLAN_REG_IVLAN_INDEX_MAX                (0x0000003FU)

/* POLICER_ETHERTYPE_IPSA_REG */

#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_ETHERTYPE_MEN_MASK   (0x80000000U)
#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_ETHERTYPE_MEN_SHIFT  (0x0000001FU)
#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_ETHERTYPE_MEN_MAX    (0x00000001U)

#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_ETHERTYPE_INDEX_MASK (0x003F0000U)
#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_ETHERTYPE_INDEX_SHIFT (0x00000010U)
#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_ETHERTYPE_INDEX_MAX  (0x0000003FU)

#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_IPSRC_MEN_MASK       (0x00008000U)
#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_IPSRC_MEN_SHIFT      (0x0000000FU)
#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_IPSRC_MEN_MAX        (0x00000001U)

#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_IPSRC_INDEX_MASK     (0x0000003FU)
#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_IPSRC_INDEX_SHIFT    (0x00000000U)
#define CPSW_ALE_POLICER_ETHERTYPE_IPSA_REG_IPSRC_INDEX_MAX      (0x0000003FU)

/* POLICER_IPDA_REG */

#define CPSW_ALE_POLICER_IPDA_REG_IPDST_MEN_MASK                 (0x80000000U)
#define CPSW_ALE_POLICER_IPDA_REG_IPDST_MEN_SHIFT                (0x0000001FU)
#define CPSW_ALE_POLICER_IPDA_REG_IPDST_MEN_MAX                  (0x00000001U)

#define CPSW_ALE_POLICER_IPDA_REG_IPDST_INDEX_MASK               (0x003F0000U)
#define CPSW_ALE_POLICER_IPDA_REG_IPDST_INDEX_SHIFT              (0x00000010U)
#define CPSW_ALE_POLICER_IPDA_REG_IPDST_INDEX_MAX                (0x0000003FU)

/* POLICER_PIR_REG */

#define CPSW_ALE_POLICER_PIR_REG_PRI_IDLE_INC_VAL_MASK           (0xFFFFFFFFU)
#define CPSW_ALE_POLICER_PIR_REG_PRI_IDLE_INC_VAL_SHIFT          (0x00000000U)
#define CPSW_ALE_POLICER_PIR_REG_PRI_IDLE_INC_VAL_MAX            (0xFFFFFFFFU)

/* POLICER_CIR_REG */

#define CPSW_ALE_POLICER_CIR_REG_CIR_IDLE_INC_VAL_MASK           (0xFFFFFFFFU)
#define CPSW_ALE_POLICER_CIR_REG_CIR_IDLE_INC_VAL_SHIFT          (0x00000000U)
#define CPSW_ALE_POLICER_CIR_REG_CIR_IDLE_INC_VAL_MAX            (0xFFFFFFFFU)

/* POLICER_TBL_CTL_REG */

#define CPSW_ALE_POLICER_TBL_CTL_REG_WRITE_ENABLE_MASK           (0x80000000U)
#define CPSW_ALE_POLICER_TBL_CTL_REG_WRITE_ENABLE_SHIFT          (0x0000001FU)
#define CPSW_ALE_POLICER_TBL_CTL_REG_WRITE_ENABLE_MAX            (0x00000001U)

#define CPSW_ALE_POLICER_TBL_CTL_REG_POL_TBL_INDEX_MASK          (0x00000007U)
#define CPSW_ALE_POLICER_TBL_CTL_REG_POL_TBL_INDEX_SHIFT         (0x00000000U)
#define CPSW_ALE_POLICER_TBL_CTL_REG_POL_TBL_INDEX_MAX           (0x00000007U)

/* POLICER_CTL_REG */

#define CPSW_ALE_POLICER_CTL_REG_POL_EN_MASK                     (0x80000000U)
#define CPSW_ALE_POLICER_CTL_REG_POL_EN_SHIFT                    (0x0000001FU)
#define CPSW_ALE_POLICER_CTL_REG_POL_EN_MAX                      (0x00000001U)

#define CPSW_ALE_POLICER_CTL_REG_RED_DROP_EN_MASK                (0x20000000U)
#define CPSW_ALE_POLICER_CTL_REG_RED_DROP_EN_SHIFT               (0x0000001DU)
#define CPSW_ALE_POLICER_CTL_REG_RED_DROP_EN_MAX                 (0x00000001U)

#define CPSW_ALE_POLICER_CTL_REG_YELLOW_DROP_EN_MASK             (0x10000000U)
#define CPSW_ALE_POLICER_CTL_REG_YELLOW_DROP_EN_SHIFT            (0x0000001CU)
#define CPSW_ALE_POLICER_CTL_REG_YELLOW_DROP_EN_MAX              (0x00000001U)

#define CPSW_ALE_POLICER_CTL_REG_YELLOW_THRESH_MASK              (0x07000000U)
#define CPSW_ALE_POLICER_CTL_REG_YELLOW_THRESH_SHIFT             (0x00000018U)
#define CPSW_ALE_POLICER_CTL_REG_YELLOW_THRESH_MAX               (0x00000007U)

#define CPSW_ALE_POLICER_CTL_REG_POL_MATCH_MODE_MASK             (0x00C00000U)
#define CPSW_ALE_POLICER_CTL_REG_POL_MATCH_MODE_SHIFT            (0x00000016U)
#define CPSW_ALE_POLICER_CTL_REG_POL_MATCH_MODE_MAX              (0x00000003U)

/* POLICER_TEST_CTL_REG */

#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_MASK               (0x80000000U)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_SHIFT              (0x0000001FU)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_MAX                (0x00000001U)

#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_RED_MASK           (0x40000000U)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_RED_SHIFT          (0x0000001EU)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_RED_MAX            (0x00000001U)

#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_YELLOW_MASK        (0x20000000U)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_YELLOW_SHIFT       (0x0000001DU)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_YELLOW_MAX         (0x00000001U)

#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_SELECTED_MASK      (0x10000000U)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_SELECTED_SHIFT     (0x0000001CU)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_CLR_SELECTED_MAX       (0x00000001U)

#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_TEST_ENTRY_MASK        (0x00000007U)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_TEST_ENTRY_SHIFT       (0x00000000U)
#define CPSW_ALE_POLICER_TEST_CTL_REG_POL_TEST_ENTRY_MAX         (0x00000007U)

/* POLICER_HIT_STATUS_REG */

#define CPSW_ALE_POLICER_HIT_STATUS_REG_POL_HIT_MASK             (0x80000000U)
#define CPSW_ALE_POLICER_HIT_STATUS_REG_POL_HIT_SHIFT            (0x0000001FU)
#define CPSW_ALE_POLICER_HIT_STATUS_REG_POL_HIT_MAX              (0x00000001U)

#define CPSW_ALE_POLICER_HIT_STATUS_REG_POL_HIT_RED_MASK         (0x40000000U)
#define CPSW_ALE_POLICER_HIT_STATUS_REG_POL_HIT_RED_SHIFT        (0x0000001EU)
#define CPSW_ALE_POLICER_HIT_STATUS_REG_POL_HIT_RED_MAX          (0x00000001U)

#define CPSW_ALE_POLICER_HIT_STATUS_REG_POL_HIT_YELLOW_MASK      (0x20000000U)
#define CPSW_ALE_POLICER_HIT_STATUS_REG_POL_HIT_YELLOW_SHIFT     (0x0000001DU)
#define CPSW_ALE_POLICER_HIT_STATUS_REG_POL_HIT_YELLOW_MAX       (0x00000001U)

/* THREAD_DEF_REG */

#define CPSW_ALE_THREAD_DEF_REG_ENABLE_MASK                      (0x00008000U)
#define CPSW_ALE_THREAD_DEF_REG_ENABLE_SHIFT                     (0x0000000FU)
#define CPSW_ALE_THREAD_DEF_REG_ENABLE_MAX                       (0x00000001U)

#define CPSW_ALE_THREAD_DEF_REG_VALUE_MASK                       (0x0000003FU)
#define CPSW_ALE_THREAD_DEF_REG_VALUE_SHIFT                      (0x00000000U)
#define CPSW_ALE_THREAD_DEF_REG_VALUE_MAX                        (0x0000003FU)

/* THREAD_CTL_REG */

#define CPSW_ALE_THREAD_CTL_REG_ENTRY_PTR_MASK                   (0x00000007U)
#define CPSW_ALE_THREAD_CTL_REG_ENTRY_PTR_SHIFT                  (0x00000000U)
#define CPSW_ALE_THREAD_CTL_REG_ENTRY_PTR_MAX                    (0x00000007U)

/* THREAD_VAL_REG */

#define CPSW_ALE_THREAD_VAL_REG_ENABLE_MASK                      (0x00008000U)
#define CPSW_ALE_THREAD_VAL_REG_ENABLE_SHIFT                     (0x0000000FU)
#define CPSW_ALE_THREAD_VAL_REG_ENABLE_MAX                       (0x00000001U)

#define CPSW_ALE_THREAD_VAL_REG_VALUE_MASK                       (0x0000003FU)
#define CPSW_ALE_THREAD_VAL_REG_VALUE_SHIFT                      (0x00000000U)
#define CPSW_ALE_THREAD_VAL_REG_VALUE_MAX                        (0x0000003FU)

#ifdef __cplusplus
}
#endif
#endif  /* HW_CPSW_ALE_H_ */

