/* ======================================================================
 *   Copyright (c) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *   \file  hw_cpsw_port.h
 *
 *   \brief
 *      register-level header file for CPSW.
 *
 */

#ifndef HW_CPSW_PORT_H_
#define HW_CPSW_PORT_H_

#ifdef __cplusplus
extern "C"
{
#endif


/*!*****************************************************************************
* Register Definitions
*******************************************************************************/

#define CPSW_CPPI_P0_CONTROL_REG                         (0x00021004U)
#define CPSW_CPPI_P0_FLOW_ID_OFFSET_REG                  (0x00021008U)
#define CPSW_CPPI_P0_BLK_CNT_REG                         (0x00021010U)
#define CPSW_CPPI_P0_PORT_VLAN_REG                       (0x00021014U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG                      (0x00021018U)
#define CPSW_CPPI_P0_PRI_CTL_REG                         (0x0002101CU)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG                      (0x00021020U)
#define CPSW_CPPI_P0_RX_MAXLEN_REG                       (0x00021024U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG                     (0x00021028U)
#define CPSW_CPPI_P0_IDLE2LPI_REG                        (0x00021030U)
#define CPSW_CPPI_P0_LPI2WAKE_REG                        (0x00021034U)
#define CPSW_CPPI_P0_EEE_STATUS_REG                      (0x00021038U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG                     (0x0002103CU)
#define CPSW_CPPI_P0_RX_GAP_REG                          (0x0002104CU)
#define CPSW_CPPI_P0_FIFO_STATUS_REG                     (0x00021050U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG(P0_RX_DSCP_MAP_REG) (0x00021120U+((P0_RX_DSCP_MAP_REG)*0x4U))
#define CPSW_CPPI_P0_PRI_CIR_REG(P0_PRI_CIR_REG)         (0x00021140U+((P0_PRI_CIR_REG)*0x4U))
#define CPSW_CPPI_P0_PRI_EIR_REG(P0_PRI_EIR_REG)         (0x00021160U+((P0_PRI_EIR_REG)*0x4U))
#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG               (0x00021180U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG               (0x00021184U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG               (0x00021188U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG               (0x0002118CU)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG           (0x00021190U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG           (0x00021194U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG           (0x00021198U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG           (0x0002119CU)
#define CPSW_CPPI_P0_SRC_ID_A_REG                        (0x00021300U)
#define CPSW_CPPI_P0_SRC_ID_B_REG                        (0x00021304U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG                   (0x00021320U)
#define CPSW_ETH_PN_RESERVED_REG                         (0x00022000U)
#define CPSW_ETH_PN_CONTROL_REG                          (0x00022004U)
#define CPSW_ETH_PN_MAX_BLKS_REG                         (0x00022008U)
#define CPSW_ETH_PN_BLK_CNT_REG                          (0x00022010U)
#define CPSW_ETH_PN_PORT_VLAN_REG                        (0x00022014U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG                       (0x00022018U)
#define CPSW_ETH_PN_PRI_CTL_REG                          (0x0002201CU)
#define CPSW_ETH_PN_RX_PRI_MAP_REG                       (0x00022020U)
#define CPSW_ETH_PN_RX_MAXLEN_REG                        (0x00022024U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG                      (0x00022028U)
#define CPSW_ETH_PN_RX_FLOW_THRESH_REG                   (0x0002202CU)
#define CPSW_ETH_PN_IDLE2LPI_REG                         (0x00022030U)
#define CPSW_ETH_PN_LPI2WAKE_REG                         (0x00022034U)
#define CPSW_ETH_PN_EEE_STATUS_REG                       (0x00022038U)
#define CPSW_ETH_PN_FIFO_STATUS_REG                      (0x00022050U)
#define CPSW_ETH_PN_EST_CONTROL_REG                      (0x00022060U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG(PN_RX_DSCP_MAP_REG)  (0x00022120U+((PN_RX_DSCP_MAP_REG)*0x4U))
#define CPSW_ETH_PN_PRI_CIR_REG(PN_PRI_CIR_REG)          (0x00022140U+((PN_PRI_CIR_REG)*0x4U))
#define CPSW_ETH_PN_PRI_EIR_REG(PN_PRI_EIR_REG)          (0x00022160U+((PN_PRI_EIR_REG)*0x4U))
#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG                (0x00022180U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG                (0x00022184U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG                (0x00022188U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG                (0x0002218CU)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG            (0x00022190U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG            (0x00022194U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG            (0x00022198U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG            (0x0002219CU)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG              (0x00022300U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG              (0x00022304U)
#define CPSW_ETH_PN_SA_L_REG                             (0x00022308U)
#define CPSW_ETH_PN_SA_H_REG                             (0x0002230CU)
#define CPSW_ETH_PN_TS_CTL_REG                           (0x00022310U)
#define CPSW_ETH_PN_TS_SEQ_LTYPE_REG                     (0x00022314U)
#define CPSW_ETH_PN_TS_VLAN_LTYPE_REG                    (0x00022318U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG                    (0x0002231CU)
#define CPSW_ETH_PN_TS_CTL2_REG                          (0x00022320U)
#define CPSW_ETH_PN_MAC_CONTROL_REG                      (0x00022330U)
#define CPSW_ETH_PN_MAC_STATUS_REG                       (0x00022334U)
#define CPSW_ETH_PN_MAC_SOFT_RESET_REG                   (0x00022338U)
#define CPSW_ETH_PN_MAC_BOFFTEST_REG                     (0x0002233CU)
#define CPSW_ETH_PN_MAC_RX_PAUSETIMER_REG                (0x00022340U)
#define CPSW_ETH_PN_MAC_RXN_PAUSETIMER_REG(PN_MAC_RXN_PAUSETIMER_REG) (0x00022350U+((PN_MAC_RXN_PAUSETIMER_REG)*0x4U))
#define CPSW_ETH_PN_MAC_TX_PAUSETIMER_REG                (0x00022370U)
#define CPSW_ETH_PN_MAC_TXN_PAUSETIMER_REG(PN_MAC_TXN_PAUSETIMER_REG) (0x00022380U+((PN_MAC_TXN_PAUSETIMER_REG)*0x4U))
#define CPSW_ETH_PN_MAC_EMCONTROL_REG                    (0x000223A0U)
#define CPSW_ETH_PN_MAC_TX_GAP_REG                       (0x000223A4U)
#define CPSW_PN_OFFSET(n)                               (((uint32)n*0x1000U) - (uint32)0x1000U)

/*!*****************************************************************************
* Field Definition Macros
*******************************************************************************/

/*!************************************** CPSW_P0_CONTROL *********************/

/* P0_CONTROL_REG */

#define CPSW_CPPI_P0_CONTROL_REG_RX_CHECKSUM_EN_MASK     (0x00000001U)
#define CPSW_CPPI_P0_CONTROL_REG_RX_CHECKSUM_EN_SHIFT    (0x00000000U)
#define CPSW_CPPI_P0_CONTROL_REG_RX_CHECKSUM_EN_MAX      (0x00000001U)

#define CPSW_CPPI_P0_CONTROL_REG_DSCP_IPV4_EN_MASK       (0x00000002U)
#define CPSW_CPPI_P0_CONTROL_REG_DSCP_IPV4_EN_SHIFT      (0x00000001U)
#define CPSW_CPPI_P0_CONTROL_REG_DSCP_IPV4_EN_MAX        (0x00000001U)

#define CPSW_CPPI_P0_CONTROL_REG_DSCP_IPV6_EN_MASK       (0x00000004U)
#define CPSW_CPPI_P0_CONTROL_REG_DSCP_IPV6_EN_SHIFT      (0x00000002U)
#define CPSW_CPPI_P0_CONTROL_REG_DSCP_IPV6_EN_MAX        (0x00000001U)

#define CPSW_CPPI_P0_CONTROL_REG_TX_ECC_ERR_EN_MASK      (0x00004000U)
#define CPSW_CPPI_P0_CONTROL_REG_TX_ECC_ERR_EN_SHIFT     (0x0000000EU)
#define CPSW_CPPI_P0_CONTROL_REG_TX_ECC_ERR_EN_MAX       (0x00000001U)

#define CPSW_CPPI_P0_CONTROL_REG_RX_ECC_ERR_EN_MASK      (0x00008000U)
#define CPSW_CPPI_P0_CONTROL_REG_RX_ECC_ERR_EN_SHIFT     (0x0000000FU)
#define CPSW_CPPI_P0_CONTROL_REG_RX_ECC_ERR_EN_MAX       (0x00000001U)

#define CPSW_CPPI_P0_CONTROL_REG_RX_REMAP_VLAN_MASK      (0x00010000U)
#define CPSW_CPPI_P0_CONTROL_REG_RX_REMAP_VLAN_SHIFT     (0x00000010U)
#define CPSW_CPPI_P0_CONTROL_REG_RX_REMAP_VLAN_MAX       (0x00000001U)

#define CPSW_CPPI_P0_CONTROL_REG_RX_REMAP_DSCP_V4_MASK   (0x00020000U)
#define CPSW_CPPI_P0_CONTROL_REG_RX_REMAP_DSCP_V4_SHIFT  (0x00000011U)
#define CPSW_CPPI_P0_CONTROL_REG_RX_REMAP_DSCP_V4_MAX    (0x00000001U)

#define CPSW_CPPI_P0_CONTROL_REG_RX_REMAP_DSCP_V6_MASK   (0x00040000U)
#define CPSW_CPPI_P0_CONTROL_REG_RX_REMAP_DSCP_V6_SHIFT  (0x00000012U)
#define CPSW_CPPI_P0_CONTROL_REG_RX_REMAP_DSCP_V6_MAX    (0x00000001U)

/* P0_FLOW_ID_OFFSET_REG */

#define CPSW_CPPI_P0_FLOW_ID_OFFSET_REG_VALUE_MASK       (0x00003FFFU)
#define CPSW_CPPI_P0_FLOW_ID_OFFSET_REG_VALUE_SHIFT      (0x00000000U)
#define CPSW_CPPI_P0_FLOW_ID_OFFSET_REG_VALUE_MAX        (0x00003FFFU)

/* P0_BLK_CNT_REG */

#define CPSW_CPPI_P0_BLK_CNT_REG_RX_BLK_CNT_MASK         (0x0000003FU)
#define CPSW_CPPI_P0_BLK_CNT_REG_RX_BLK_CNT_SHIFT        (0x00000000U)
#define CPSW_CPPI_P0_BLK_CNT_REG_RX_BLK_CNT_MAX          (0x0000003FU)

#define CPSW_CPPI_P0_BLK_CNT_REG_TX_BLK_CNT_MASK         (0x00001F00U)
#define CPSW_CPPI_P0_BLK_CNT_REG_TX_BLK_CNT_SHIFT        (0x00000008U)
#define CPSW_CPPI_P0_BLK_CNT_REG_TX_BLK_CNT_MAX          (0x0000001FU)

/* P0_PORT_VLAN_REG */

#define CPSW_CPPI_P0_PORT_VLAN_REG_PORT_VID_MASK         (0x00000FFFU)
#define CPSW_CPPI_P0_PORT_VLAN_REG_PORT_VID_SHIFT        (0x00000000U)
#define CPSW_CPPI_P0_PORT_VLAN_REG_PORT_VID_MAX          (0x00000FFFU)

#define CPSW_CPPI_P0_PORT_VLAN_REG_PORT_CFI_MASK         (0x00001000U)
#define CPSW_CPPI_P0_PORT_VLAN_REG_PORT_CFI_SHIFT        (0x0000000CU)
#define CPSW_CPPI_P0_PORT_VLAN_REG_PORT_CFI_MAX          (0x00000001U)

#define CPSW_CPPI_P0_PORT_VLAN_REG_PORT_PRI_MASK         (0x0000E000U)
#define CPSW_CPPI_P0_PORT_VLAN_REG_PORT_PRI_SHIFT        (0x0000000DU)
#define CPSW_CPPI_P0_PORT_VLAN_REG_PORT_PRI_MAX          (0x00000007U)

/* P0_TX_PRI_MAP_REG */

#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI0_MASK            (0x00000007U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI0_SHIFT           (0x00000000U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI0_MAX             (0x00000007U)

#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI1_MASK            (0x00000070U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI1_SHIFT           (0x00000004U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI1_MAX             (0x00000007U)

#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI2_MASK            (0x00000700U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI2_SHIFT           (0x00000008U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI2_MAX             (0x00000007U)

#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI3_MASK            (0x00007000U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI3_SHIFT           (0x0000000CU)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI3_MAX             (0x00000007U)

#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI4_MASK            (0x00070000U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI4_SHIFT           (0x00000010U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI4_MAX             (0x00000007U)

#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI5_MASK            (0x00700000U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI5_SHIFT           (0x00000014U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI5_MAX             (0x00000007U)

#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI6_MASK            (0x07000000U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI6_SHIFT           (0x00000018U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI6_MAX             (0x00000007U)

#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI7_MASK            (0x70000000U)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI7_SHIFT           (0x0000001CU)
#define CPSW_CPPI_P0_TX_PRI_MAP_REG_PRI7_MAX             (0x00000007U)

/* P0_PRI_CTL_REG */

#define CPSW_CPPI_P0_PRI_CTL_REG_RX_PTYPE_MASK           (0x00000100U)
#define CPSW_CPPI_P0_PRI_CTL_REG_RX_PTYPE_SHIFT          (0x00000008U)
#define CPSW_CPPI_P0_PRI_CTL_REG_RX_PTYPE_MAX            (0x00000001U)

#define CPSW_CPPI_P0_PRI_CTL_REG_RX_FLOW_PRI_MASK        (0x00FF0000U)
#define CPSW_CPPI_P0_PRI_CTL_REG_RX_FLOW_PRI_SHIFT       (0x00000010U)
#define CPSW_CPPI_P0_PRI_CTL_REG_RX_FLOW_PRI_MAX         (0x000000FFU)

/* P0_RX_PRI_MAP_REG */

#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI0_MASK            (0x00000007U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI0_SHIFT           (0x00000000U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI0_MAX             (0x00000007U)

#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI1_MASK            (0x00000070U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI1_SHIFT           (0x00000004U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI1_MAX             (0x00000007U)

#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI2_MASK            (0x00000700U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI2_SHIFT           (0x00000008U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI2_MAX             (0x00000007U)

#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI3_MASK            (0x00007000U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI3_SHIFT           (0x0000000CU)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI3_MAX             (0x00000007U)

#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI4_MASK            (0x00070000U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI4_SHIFT           (0x00000010U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI4_MAX             (0x00000007U)

#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI5_MASK            (0x00700000U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI5_SHIFT           (0x00000014U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI5_MAX             (0x00000007U)

#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI6_MASK            (0x07000000U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI6_SHIFT           (0x00000018U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI6_MAX             (0x00000007U)

#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI7_MASK            (0x70000000U)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI7_SHIFT           (0x0000001CU)
#define CPSW_CPPI_P0_RX_PRI_MAP_REG_PRI7_MAX             (0x00000007U)

/* P0_RX_MAXLEN_REG */

#define CPSW_CPPI_P0_RX_MAXLEN_REG_RX_MAXLEN_MASK        (0x00003FFFU)
#define CPSW_CPPI_P0_RX_MAXLEN_REG_RX_MAXLEN_SHIFT       (0x00000000U)
#define CPSW_CPPI_P0_RX_MAXLEN_REG_RX_MAXLEN_MAX         (0x00003FFFU)

/* P0_TX_BLKS_PRI_REG */

#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI0_MASK           (0x0000000FU)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI0_SHIFT          (0x00000000U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI0_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI1_MASK           (0x000000F0U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI1_SHIFT          (0x00000004U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI1_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI2_MASK           (0x00000F00U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI2_SHIFT          (0x00000008U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI2_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI3_MASK           (0x0000F000U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI3_SHIFT          (0x0000000CU)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI3_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI4_MASK           (0x000F0000U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI4_SHIFT          (0x00000010U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI4_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI5_MASK           (0x00F00000U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI5_SHIFT          (0x00000014U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI5_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI6_MASK           (0x0F000000U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI6_SHIFT          (0x00000018U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI6_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI7_MASK           (0xF0000000U)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI7_SHIFT          (0x0000001CU)
#define CPSW_CPPI_P0_TX_BLKS_PRI_REG_PRI7_MAX            (0x0000000FU)

/* P0_IDLE2LPI_REG */

#define CPSW_CPPI_P0_IDLE2LPI_REG_COUNT_MASK             (0x00FFFFFFU)
#define CPSW_CPPI_P0_IDLE2LPI_REG_COUNT_SHIFT            (0x00000000U)
#define CPSW_CPPI_P0_IDLE2LPI_REG_COUNT_MAX              (0x00FFFFFFU)

/* P0_LPI2WAKE_REG */

#define CPSW_CPPI_P0_LPI2WAKE_REG_COUNT_MASK             (0x00FFFFFFU)
#define CPSW_CPPI_P0_LPI2WAKE_REG_COUNT_SHIFT            (0x00000000U)
#define CPSW_CPPI_P0_LPI2WAKE_REG_COUNT_MAX              (0x00FFFFFFU)

/* P0_EEE_STATUS_REG */

#define CPSW_CPPI_P0_EEE_STATUS_REG_WAIT_IDLE2LPI_MASK   (0x00000001U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_WAIT_IDLE2LPI_SHIFT  (0x00000000U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_WAIT_IDLE2LPI_MAX    (0x00000001U)

#define CPSW_CPPI_P0_EEE_STATUS_REG_RX_LPI_MASK          (0x00000002U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_RX_LPI_SHIFT         (0x00000001U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_RX_LPI_MAX           (0x00000001U)

#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_LPI_MASK          (0x00000004U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_LPI_SHIFT         (0x00000002U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_LPI_MAX           (0x00000001U)

#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_WAKE_MASK         (0x00000008U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_WAKE_SHIFT        (0x00000003U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_WAKE_MAX          (0x00000001U)

#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_FIFO_HOLD_MASK    (0x00000010U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_FIFO_HOLD_SHIFT   (0x00000004U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_FIFO_HOLD_MAX     (0x00000001U)

#define CPSW_CPPI_P0_EEE_STATUS_REG_RX_FIFO_EMPTY_MASK   (0x00000020U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_RX_FIFO_EMPTY_SHIFT  (0x00000005U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_RX_FIFO_EMPTY_MAX    (0x00000001U)

#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_FIFO_EMPTY_MASK   (0x00000040U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_FIFO_EMPTY_SHIFT  (0x00000006U)
#define CPSW_CPPI_P0_EEE_STATUS_REG_TX_FIFO_EMPTY_MAX    (0x00000001U)

/* P0_RX_PKTS_PRI_REG */

#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI0_MASK           (0x0000000FU)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI0_SHIFT          (0x00000000U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI0_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI1_MASK           (0x000000F0U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI1_SHIFT          (0x00000004U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI1_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI2_MASK           (0x00000F00U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI2_SHIFT          (0x00000008U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI2_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI3_MASK           (0x0000F000U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI3_SHIFT          (0x0000000CU)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI3_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI4_MASK           (0x000F0000U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI4_SHIFT          (0x00000010U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI4_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI5_MASK           (0x00F00000U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI5_SHIFT          (0x00000014U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI5_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI6_MASK           (0x0F000000U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI6_SHIFT          (0x00000018U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI6_MAX            (0x0000000FU)

#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI7_MASK           (0xF0000000U)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI7_SHIFT          (0x0000001CU)
#define CPSW_CPPI_P0_RX_PKTS_PRI_REG_PRI7_MAX            (0x0000000FU)

/* P0_RX_GAP_REG */

#define CPSW_CPPI_P0_RX_GAP_REG_RX_GAP_EN_MASK           (0x000000FFU)
#define CPSW_CPPI_P0_RX_GAP_REG_RX_GAP_EN_SHIFT          (0x00000000U)
#define CPSW_CPPI_P0_RX_GAP_REG_RX_GAP_EN_MAX            (0x000000FFU)

#define CPSW_CPPI_P0_RX_GAP_REG_RX_GAP_CNT_MASK          (0x03FF0000U)
#define CPSW_CPPI_P0_RX_GAP_REG_RX_GAP_CNT_SHIFT         (0x00000010U)
#define CPSW_CPPI_P0_RX_GAP_REG_RX_GAP_CNT_MAX           (0x000003FFU)

/* P0_FIFO_STATUS_REG */

#define CPSW_CPPI_P0_FIFO_STATUS_REG_TX_PRI_ACTIVE_MASK  (0x000000FFU)
#define CPSW_CPPI_P0_FIFO_STATUS_REG_TX_PRI_ACTIVE_SHIFT (0x00000000U)
#define CPSW_CPPI_P0_FIFO_STATUS_REG_TX_PRI_ACTIVE_MAX   (0x000000FFU)

/* P0_RX_DSCP_MAP_REG */

#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI0_MASK           (0x00000007U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI0_SHIFT          (0x00000000U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI0_MAX            (0x00000007U)

#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI1_MASK           (0x00000070U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI1_SHIFT          (0x00000004U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI1_MAX            (0x00000007U)

#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI2_MASK           (0x00000700U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI2_SHIFT          (0x00000008U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI2_MAX            (0x00000007U)

#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI3_MASK           (0x00007000U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI3_SHIFT          (0x0000000CU)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI3_MAX            (0x00000007U)

#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI4_MASK           (0x00070000U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI4_SHIFT          (0x00000010U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI4_MAX            (0x00000007U)

#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI5_MASK           (0x00700000U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI5_SHIFT          (0x00000014U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI5_MAX            (0x00000007U)

#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI6_MASK           (0x07000000U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI6_SHIFT          (0x00000018U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI6_MAX            (0x00000007U)

#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI7_MASK           (0x70000000U)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI7_SHIFT          (0x0000001CU)
#define CPSW_CPPI_P0_RX_DSCP_MAP_REG_PRI7_MAX            (0x00000007U)

/* P0_PRI_CIR_REG */

#define CPSW_CPPI_P0_PRI_CIR_REG_PRI_CIR_MASK            (0x0FFFFFFFU)
#define CPSW_CPPI_P0_PRI_CIR_REG_PRI_CIR_SHIFT           (0x00000000U)
#define CPSW_CPPI_P0_PRI_CIR_REG_PRI_CIR_MAX             (0x0FFFFFFFU)

/* P0_PRI_EIR_REG */

#define CPSW_CPPI_P0_PRI_EIR_REG_PRI_EIR_MASK            (0x0FFFFFFFU)
#define CPSW_CPPI_P0_PRI_EIR_REG_PRI_EIR_SHIFT           (0x00000000U)
#define CPSW_CPPI_P0_PRI_EIR_REG_PRI_EIR_MAX             (0x0FFFFFFFU)

/* P0_TX_D_THRESH_SET_L_REG */

#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI0_MASK     (0x0000001FU)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI0_SHIFT    (0x00000000U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI0_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI1_MASK     (0x00001F00U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI1_SHIFT    (0x00000008U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI1_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI2_MASK     (0x001F0000U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI2_SHIFT    (0x00000010U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI2_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI3_MASK     (0x1F000000U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI3_SHIFT    (0x00000018U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_L_REG_PRI3_MAX      (0x0000001FU)

/* P0_TX_D_THRESH_SET_H_REG */

#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI4_MASK     (0x0000001FU)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI4_SHIFT    (0x00000000U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI4_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI5_MASK     (0x00001F00U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI5_SHIFT    (0x00000008U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI5_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI6_MASK     (0x001F0000U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI6_SHIFT    (0x00000010U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI6_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI7_MASK     (0x1F000000U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI7_SHIFT    (0x00000018U)
#define CPSW_CPPI_P0_TX_D_THRESH_SET_H_REG_PRI7_MAX      (0x0000001FU)

/* P0_TX_D_THRESH_CLR_L_REG */

#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI0_MASK     (0x0000001FU)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI0_SHIFT    (0x00000000U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI0_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI1_MASK     (0x00001F00U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI1_SHIFT    (0x00000008U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI1_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI2_MASK     (0x001F0000U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI2_SHIFT    (0x00000010U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI2_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI3_MASK     (0x1F000000U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI3_SHIFT    (0x00000018U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_L_REG_PRI3_MAX      (0x0000001FU)

/* P0_TX_D_THRESH_CLR_H_REG */

#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI4_MASK     (0x0000001FU)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI4_SHIFT    (0x00000000U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI4_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI5_MASK     (0x00001F00U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI5_SHIFT    (0x00000008U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI5_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI6_MASK     (0x001F0000U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI6_SHIFT    (0x00000010U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI6_MAX      (0x0000001FU)

#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI7_MASK     (0x1F000000U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI7_SHIFT    (0x00000018U)
#define CPSW_CPPI_P0_TX_D_THRESH_CLR_H_REG_PRI7_MAX      (0x0000001FU)

/* P0_TX_G_BUF_THRESH_SET_L_REG */

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI0_MASK  (0x0000001FU)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI0_SHIFT (0x00000000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI0_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI1_MASK  (0x00001F00U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI1_SHIFT (0x00000008U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI1_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI2_MASK  (0x001F0000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI2_SHIFT (0x00000010U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI2_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI3_MASK  (0x1F000000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI3_SHIFT (0x00000018U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_L_REG_PRI3_MAX   (0x0000001FU)

/* P0_TX_G_BUF_THRESH_SET_H_REG */

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI4_MASK  (0x0000001FU)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI4_SHIFT (0x00000000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI4_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI5_MASK  (0x00001F00U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI5_SHIFT (0x00000008U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI5_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI6_MASK  (0x001F0000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI6_SHIFT (0x00000010U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI6_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI7_MASK  (0x1F000000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI7_SHIFT (0x00000018U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_SET_H_REG_PRI7_MAX   (0x0000001FU)

/* P0_TX_G_BUF_THRESH_CLR_L_REG */

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI0_MASK  (0x0000001FU)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI0_SHIFT (0x00000000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI0_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI1_MASK  (0x00001F00U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI1_SHIFT (0x00000008U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI1_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI2_MASK  (0x001F0000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI2_SHIFT (0x00000010U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI2_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI3_MASK  (0x1F000000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI3_SHIFT (0x00000018U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_L_REG_PRI3_MAX   (0x0000001FU)

/* P0_TX_G_BUF_THRESH_CLR_H_REG */

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI4_MASK  (0x0000001FU)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI4_SHIFT (0x00000000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI4_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI5_MASK  (0x00001F00U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI5_SHIFT (0x00000008U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI5_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI6_MASK  (0x001F0000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI6_SHIFT (0x00000010U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI6_MAX   (0x0000001FU)

#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI7_MASK  (0x1F000000U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI7_SHIFT (0x00000018U)
#define CPSW_CPPI_P0_TX_G_BUF_THRESH_CLR_H_REG_PRI7_MAX   (0x0000001FU)

/* P0_SRC_ID_A_REG */

#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT1_MASK             (0x000000FFU)
#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT1_SHIFT            (0x00000000U)
#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT1_MAX              (0x000000FFU)

#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT2_MASK             (0x0000FF00U)
#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT2_SHIFT            (0x00000008U)
#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT2_MAX              (0x000000FFU)

#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT3_MASK             (0x00FF0000U)
#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT3_SHIFT            (0x00000010U)
#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT3_MAX              (0x000000FFU)

#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT4_MASK             (0xFF000000U)
#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT4_SHIFT            (0x00000018U)
#define CPSW_CPPI_P0_SRC_ID_A_REG_PORT4_MAX              (0x000000FFU)

/* P0_SRC_ID_B_REG */

#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT5_MASK             (0x000000FFU)
#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT5_SHIFT            (0x00000000U)
#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT5_MAX              (0x000000FFU)

#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT6_MASK             (0x0000FF00U)
#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT6_SHIFT            (0x00000008U)
#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT6_MAX              (0x000000FFU)

#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT7_MASK             (0x00FF0000U)
#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT7_SHIFT            (0x00000010U)
#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT7_MAX              (0x000000FFU)

#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT8_MASK             (0xFF000000U)
#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT8_SHIFT            (0x00000018U)
#define CPSW_CPPI_P0_SRC_ID_B_REG_PORT8_MAX              (0x000000FFU)

/* P0_HOST_BLKS_PRI_REG */

#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI0_MASK         (0x0000000FU)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI0_SHIFT        (0x00000000U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI0_MAX          (0x0000000FU)

#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI1_MASK         (0x000000F0U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI1_SHIFT        (0x00000004U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI1_MAX          (0x0000000FU)

#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI2_MASK         (0x00000F00U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI2_SHIFT        (0x00000008U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI2_MAX          (0x0000000FU)

#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI3_MASK         (0x0000F000U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI3_SHIFT        (0x0000000CU)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI3_MAX          (0x0000000FU)

#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI4_MASK         (0x000F0000U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI4_SHIFT        (0x00000010U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI4_MAX          (0x0000000FU)

#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI5_MASK         (0x00F00000U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI5_SHIFT        (0x00000014U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI5_MAX          (0x0000000FU)

#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI6_MASK         (0x0F000000U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI6_SHIFT        (0x00000018U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI6_MAX          (0x0000000FU)

#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI7_MASK         (0xF0000000U)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI7_SHIFT        (0x0000001CU)
#define CPSW_CPPI_P0_HOST_BLKS_PRI_REG_PRI7_MAX          (0x0000000FU)

/* PN_RESERVED_REG */

#define CPSW_ETH_PN_RESERVED_REG_RESERVED_MASK           (0xFFFFFFFFU)
#define CPSW_ETH_PN_RESERVED_REG_RESERVED_SHIFT          (0x00000000U)
#define CPSW_ETH_PN_RESERVED_REG_RESERVED_MAX            (0xFFFFFFFFU)

/* PN_CONTROL_REG */

#define CPSW_ETH_PN_CONTROL_REG_DSCP_IPV4_EN_MASK        (0x00000002U)
#define CPSW_ETH_PN_CONTROL_REG_DSCP_IPV4_EN_SHIFT       (0x00000001U)
#define CPSW_ETH_PN_CONTROL_REG_DSCP_IPV4_EN_MAX         (0x00000001U)

#define CPSW_ETH_PN_CONTROL_REG_DSCP_IPV6_EN_MASK        (0x00000004U)
#define CPSW_ETH_PN_CONTROL_REG_DSCP_IPV6_EN_SHIFT       (0x00000002U)
#define CPSW_ETH_PN_CONTROL_REG_DSCP_IPV6_EN_MAX         (0x00000001U)

#define CPSW_ETH_PN_CONTROL_REG_TX_LPI_CLKSTOP_EN_MASK   (0x00001000U)
#define CPSW_ETH_PN_CONTROL_REG_TX_LPI_CLKSTOP_EN_SHIFT  (0x0000000CU)
#define CPSW_ETH_PN_CONTROL_REG_TX_LPI_CLKSTOP_EN_MAX    (0x00000001U)

#define CPSW_ETH_PN_CONTROL_REG_TX_ECC_ERR_EN_MASK       (0x00004000U)
#define CPSW_ETH_PN_CONTROL_REG_TX_ECC_ERR_EN_SHIFT      (0x0000000EU)
#define CPSW_ETH_PN_CONTROL_REG_TX_ECC_ERR_EN_MAX        (0x00000001U)

#define CPSW_ETH_PN_CONTROL_REG_RX_ECC_ERR_EN_MASK       (0x00008000U)
#define CPSW_ETH_PN_CONTROL_REG_RX_ECC_ERR_EN_SHIFT      (0x0000000FU)
#define CPSW_ETH_PN_CONTROL_REG_RX_ECC_ERR_EN_MAX        (0x00000001U)

#define CPSW_ETH_PN_CONTROL_REG_IET_PORT_EN_MASK         (0x00010000U)
#define CPSW_ETH_PN_CONTROL_REG_IET_PORT_EN_SHIFT        (0x00000010U)
#define CPSW_ETH_PN_CONTROL_REG_IET_PORT_EN_MAX          (0x00000001U)

#define CPSW_ETH_PN_CONTROL_REG_EST_PORT_EN_MASK         (0x00020000U)
#define CPSW_ETH_PN_CONTROL_REG_EST_PORT_EN_SHIFT        (0x00000011U)
#define CPSW_ETH_PN_CONTROL_REG_EST_PORT_EN_MAX          (0x00000001U)

/* PN_MAX_BLKS_REG */

#define CPSW_ETH_PN_MAX_BLKS_REG_RX_MAX_BLKS_MASK        (0x000000FFU)
#define CPSW_ETH_PN_MAX_BLKS_REG_RX_MAX_BLKS_SHIFT       (0x00000000U)
#define CPSW_ETH_PN_MAX_BLKS_REG_RX_MAX_BLKS_MAX         (0x000000FFU)

#define CPSW_ETH_PN_MAX_BLKS_REG_TX_MAX_BLKS_MASK        (0x0000FF00U)
#define CPSW_ETH_PN_MAX_BLKS_REG_TX_MAX_BLKS_SHIFT       (0x00000008U)
#define CPSW_ETH_PN_MAX_BLKS_REG_TX_MAX_BLKS_MAX         (0x000000FFU)

/* PN_BLK_CNT_REG */

#define CPSW_ETH_PN_BLK_CNT_REG_RX_BLK_CNT_E_MASK        (0x0000003FU)
#define CPSW_ETH_PN_BLK_CNT_REG_RX_BLK_CNT_E_SHIFT       (0x00000000U)
#define CPSW_ETH_PN_BLK_CNT_REG_RX_BLK_CNT_E_MAX         (0x0000003FU)

#define CPSW_ETH_PN_BLK_CNT_REG_TX_BLK_CNT_MASK          (0x00001F00U)
#define CPSW_ETH_PN_BLK_CNT_REG_TX_BLK_CNT_SHIFT         (0x00000008U)
#define CPSW_ETH_PN_BLK_CNT_REG_TX_BLK_CNT_MAX           (0x0000001FU)

#define CPSW_ETH_PN_BLK_CNT_REG_RX_BLK_CNT_P_MASK        (0x003F0000U)
#define CPSW_ETH_PN_BLK_CNT_REG_RX_BLK_CNT_P_SHIFT       (0x00000010U)
#define CPSW_ETH_PN_BLK_CNT_REG_RX_BLK_CNT_P_MAX         (0x0000003FU)

/* PN_PORT_VLAN_REG */

#define CPSW_ETH_PN_PORT_VLAN_REG_PORT_VID_MASK          (0x00000FFFU)
#define CPSW_ETH_PN_PORT_VLAN_REG_PORT_VID_SHIFT         (0x00000000U)
#define CPSW_ETH_PN_PORT_VLAN_REG_PORT_VID_MAX           (0x00000FFFU)

#define CPSW_ETH_PN_PORT_VLAN_REG_PORT_CFI_MASK          (0x00001000U)
#define CPSW_ETH_PN_PORT_VLAN_REG_PORT_CFI_SHIFT         (0x0000000CU)
#define CPSW_ETH_PN_PORT_VLAN_REG_PORT_CFI_MAX           (0x00000001U)

#define CPSW_ETH_PN_PORT_VLAN_REG_PORT_PRI_MASK          (0x0000E000U)
#define CPSW_ETH_PN_PORT_VLAN_REG_PORT_PRI_SHIFT         (0x0000000DU)
#define CPSW_ETH_PN_PORT_VLAN_REG_PORT_PRI_MAX           (0x00000007U)

/* PN_TX_PRI_MAP_REG */

#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI0_MASK             (0x00000007U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI0_SHIFT            (0x00000000U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI0_MAX              (0x00000007U)

#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI1_MASK             (0x00000070U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI1_SHIFT            (0x00000004U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI1_MAX              (0x00000007U)

#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI2_MASK             (0x00000700U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI2_SHIFT            (0x00000008U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI2_MAX              (0x00000007U)

#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI3_MASK             (0x00007000U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI3_SHIFT            (0x0000000CU)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI3_MAX              (0x00000007U)

#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI4_MASK             (0x00070000U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI4_SHIFT            (0x00000010U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI4_MAX              (0x00000007U)

#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI5_MASK             (0x00700000U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI5_SHIFT            (0x00000014U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI5_MAX              (0x00000007U)

#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI6_MASK             (0x07000000U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI6_SHIFT            (0x00000018U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI6_MAX              (0x00000007U)

#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI7_MASK             (0x70000000U)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI7_SHIFT            (0x0000001CU)
#define CPSW_ETH_PN_TX_PRI_MAP_REG_PRI7_MAX              (0x00000007U)

/* PN_PRI_CTL_REG */

#define CPSW_ETH_PN_PRI_CTL_REG_TX_HOST_BLKS_REM_MASK    (0x0000F000U)
#define CPSW_ETH_PN_PRI_CTL_REG_TX_HOST_BLKS_REM_SHIFT   (0x0000000CU)
#define CPSW_ETH_PN_PRI_CTL_REG_TX_HOST_BLKS_REM_MAX     (0x0000000FU)

#define CPSW_ETH_PN_PRI_CTL_REG_RX_FLOW_PRI_MASK         (0x00FF0000U)
#define CPSW_ETH_PN_PRI_CTL_REG_RX_FLOW_PRI_SHIFT        (0x00000010U)
#define CPSW_ETH_PN_PRI_CTL_REG_RX_FLOW_PRI_MAX          (0x000000FFU)

#define CPSW_ETH_PN_PRI_CTL_REG_TX_FLOW_PRI_MASK         (0xFF000000U)
#define CPSW_ETH_PN_PRI_CTL_REG_TX_FLOW_PRI_SHIFT        (0x00000018U)
#define CPSW_ETH_PN_PRI_CTL_REG_TX_FLOW_PRI_MAX          (0x000000FFU)

/* PN_RX_PRI_MAP_REG */

#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI0_MASK             (0x00000007U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI0_SHIFT            (0x00000000U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI0_MAX              (0x00000007U)

#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI1_MASK             (0x00000070U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI1_SHIFT            (0x00000004U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI1_MAX              (0x00000007U)

#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI2_MASK             (0x00000700U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI2_SHIFT            (0x00000008U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI2_MAX              (0x00000007U)

#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI3_MASK             (0x00007000U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI3_SHIFT            (0x0000000CU)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI3_MAX              (0x00000007U)

#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI4_MASK             (0x00070000U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI4_SHIFT            (0x00000010U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI4_MAX              (0x00000007U)

#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI5_MASK             (0x00700000U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI5_SHIFT            (0x00000014U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI5_MAX              (0x00000007U)

#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI6_MASK             (0x07000000U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI6_SHIFT            (0x00000018U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI6_MAX              (0x00000007U)

#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI7_MASK             (0x70000000U)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI7_SHIFT            (0x0000001CU)
#define CPSW_ETH_PN_RX_PRI_MAP_REG_PRI7_MAX              (0x00000007U)

/* PN_RX_MAXLEN_REG */

#define CPSW_ETH_PN_RX_MAXLEN_REG_RX_MAXLEN_MASK         (0x00003FFFU)
#define CPSW_ETH_PN_RX_MAXLEN_REG_RX_MAXLEN_SHIFT        (0x00000000U)
#define CPSW_ETH_PN_RX_MAXLEN_REG_RX_MAXLEN_MAX          (0x00003FFFU)

/* PN_TX_BLKS_PRI_REG */

#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI0_MASK            (0x0000000FU)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI0_SHIFT           (0x00000000U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI0_MAX             (0x0000000FU)

#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI1_MASK            (0x000000F0U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI1_SHIFT           (0x00000004U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI1_MAX             (0x0000000FU)

#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI2_MASK            (0x00000F00U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI2_SHIFT           (0x00000008U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI2_MAX             (0x0000000FU)

#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI3_MASK            (0x0000F000U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI3_SHIFT           (0x0000000CU)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI3_MAX             (0x0000000FU)

#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI4_MASK            (0x000F0000U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI4_SHIFT           (0x00000010U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI4_MAX             (0x0000000FU)

#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI5_MASK            (0x00F00000U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI5_SHIFT           (0x00000014U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI5_MAX             (0x0000000FU)

#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI6_MASK            (0x0F000000U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI6_SHIFT           (0x00000018U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI6_MAX             (0x0000000FU)

#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI7_MASK            (0xF0000000U)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI7_SHIFT           (0x0000001CU)
#define CPSW_ETH_PN_TX_BLKS_PRI_REG_PRI7_MAX             (0x0000000FU)

/* PN_RX_FLOW_THRESH_REG */

#define CPSW_ETH_PN_RX_FLOW_THRESH_REG_COUNT_MASK        (0x000001FFU)
#define CPSW_ETH_PN_RX_FLOW_THRESH_REG_COUNT_SHIFT       (0x00000000U)
#define CPSW_ETH_PN_RX_FLOW_THRESH_REG_COUNT_MAX         (0x000001FFU)

/* PN_IDLE2LPI_REG */

#define CPSW_ETH_PN_IDLE2LPI_REG_COUNT_MASK              (0x00FFFFFFU)
#define CPSW_ETH_PN_IDLE2LPI_REG_COUNT_SHIFT             (0x00000000U)
#define CPSW_ETH_PN_IDLE2LPI_REG_COUNT_MAX               (0x00FFFFFFU)

/* PN_LPI2WAKE_REG */

#define CPSW_ETH_PN_LPI2WAKE_REG_COUNT_MASK              (0x00FFFFFFU)
#define CPSW_ETH_PN_LPI2WAKE_REG_COUNT_SHIFT             (0x00000000U)
#define CPSW_ETH_PN_LPI2WAKE_REG_COUNT_MAX               (0x00FFFFFFU)

/* PN_EEE_STATUS_REG */

#define CPSW_ETH_PN_EEE_STATUS_REG_WAIT_IDLE2LPI_MASK    (0x00000001U)
#define CPSW_ETH_PN_EEE_STATUS_REG_WAIT_IDLE2LPI_SHIFT   (0x00000000U)
#define CPSW_ETH_PN_EEE_STATUS_REG_WAIT_IDLE2LPI_MAX     (0x00000001U)

#define CPSW_ETH_PN_EEE_STATUS_REG_RX_LPI_MASK           (0x00000002U)
#define CPSW_ETH_PN_EEE_STATUS_REG_RX_LPI_SHIFT          (0x00000001U)
#define CPSW_ETH_PN_EEE_STATUS_REG_RX_LPI_MAX            (0x00000001U)

#define CPSW_ETH_PN_EEE_STATUS_REG_TX_LPI_MASK           (0x00000004U)
#define CPSW_ETH_PN_EEE_STATUS_REG_TX_LPI_SHIFT          (0x00000002U)
#define CPSW_ETH_PN_EEE_STATUS_REG_TX_LPI_MAX            (0x00000001U)

#define CPSW_ETH_PN_EEE_STATUS_REG_TX_WAKE_MASK          (0x00000008U)
#define CPSW_ETH_PN_EEE_STATUS_REG_TX_WAKE_SHIFT         (0x00000003U)
#define CPSW_ETH_PN_EEE_STATUS_REG_TX_WAKE_MAX           (0x00000001U)

#define CPSW_ETH_PN_EEE_STATUS_REG_TX_FIFO_HOLD_MASK     (0x00000010U)
#define CPSW_ETH_PN_EEE_STATUS_REG_TX_FIFO_HOLD_SHIFT    (0x00000004U)
#define CPSW_ETH_PN_EEE_STATUS_REG_TX_FIFO_HOLD_MAX      (0x00000001U)

#define CPSW_ETH_PN_EEE_STATUS_REG_RX_FIFO_EMPTY_MASK    (0x00000020U)
#define CPSW_ETH_PN_EEE_STATUS_REG_RX_FIFO_EMPTY_SHIFT   (0x00000005U)
#define CPSW_ETH_PN_EEE_STATUS_REG_RX_FIFO_EMPTY_MAX     (0x00000001U)

#define CPSW_ETH_PN_EEE_STATUS_REG_TX_FIFO_EMPTY_MASK    (0x00000040U)
#define CPSW_ETH_PN_EEE_STATUS_REG_TX_FIFO_EMPTY_SHIFT   (0x00000006U)
#define CPSW_ETH_PN_EEE_STATUS_REG_TX_FIFO_EMPTY_MAX     (0x00000001U)

/* PN_FIFO_STATUS_REG */

#define CPSW_ETH_PN_FIFO_STATUS_REG_TX_PRI_ACTIVE_MASK   (0x000000FFU)
#define CPSW_ETH_PN_FIFO_STATUS_REG_TX_PRI_ACTIVE_SHIFT  (0x00000000U)
#define CPSW_ETH_PN_FIFO_STATUS_REG_TX_PRI_ACTIVE_MAX    (0x000000FFU)

#define CPSW_ETH_PN_FIFO_STATUS_REG_TX_E_MAC_ALLOW_MASK  (0x0000FF00U)
#define CPSW_ETH_PN_FIFO_STATUS_REG_TX_E_MAC_ALLOW_SHIFT (0x00000008U)
#define CPSW_ETH_PN_FIFO_STATUS_REG_TX_E_MAC_ALLOW_MAX   (0x000000FFU)

#define CPSW_ETH_PN_FIFO_STATUS_REG_EST_CNT_ERR_MASK     (0x00010000U)
#define CPSW_ETH_PN_FIFO_STATUS_REG_EST_CNT_ERR_SHIFT    (0x00000010U)
#define CPSW_ETH_PN_FIFO_STATUS_REG_EST_CNT_ERR_MAX      (0x00000001U)

#define CPSW_ETH_PN_FIFO_STATUS_REG_EST_ADD_ERR_MASK     (0x00020000U)
#define CPSW_ETH_PN_FIFO_STATUS_REG_EST_ADD_ERR_SHIFT    (0x00000011U)
#define CPSW_ETH_PN_FIFO_STATUS_REG_EST_ADD_ERR_MAX      (0x00000001U)

#define CPSW_ETH_PN_FIFO_STATUS_REG_EST_BUFACT_MASK      (0x00040000U)
#define CPSW_ETH_PN_FIFO_STATUS_REG_EST_BUFACT_SHIFT     (0x00000012U)
#define CPSW_ETH_PN_FIFO_STATUS_REG_EST_BUFACT_MAX       (0x00000001U)

/* PN_EST_CONTROL_REG */

#define CPSW_ETH_PN_EST_CONTROL_REG_EST_ONEBUF_MASK      (0x00000001U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_ONEBUF_SHIFT     (0x00000000U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_ONEBUF_MAX       (0x00000001U)

#define CPSW_ETH_PN_EST_CONTROL_REG_EST_BUFSEL_MASK      (0x00000002U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_BUFSEL_SHIFT     (0x00000001U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_BUFSEL_MAX       (0x00000001U)

#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_EN_MASK       (0x00000004U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_EN_SHIFT      (0x00000002U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_EN_MAX        (0x00000001U)

#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_FIRST_MASK    (0x00000008U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_FIRST_SHIFT   (0x00000003U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_FIRST_MAX     (0x00000001U)

#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_ONEPRI_MASK   (0x00000010U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_ONEPRI_SHIFT  (0x00000004U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_ONEPRI_MAX    (0x00000001U)

#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_PRI_MASK      (0x000000E0U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_PRI_SHIFT     (0x00000005U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_TS_PRI_MAX       (0x00000007U)

#define CPSW_ETH_PN_EST_CONTROL_REG_EST_FILL_EN_MASK     (0x00000100U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_FILL_EN_SHIFT    (0x00000008U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_FILL_EN_MAX      (0x00000001U)

#define CPSW_ETH_PN_EST_CONTROL_REG_EST_FILL_MARGIN_MASK (0x03FF0000U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_FILL_MARGIN_SHIFT (0x00000010U)
#define CPSW_ETH_PN_EST_CONTROL_REG_EST_FILL_MARGIN_MAX  (0x000003FFU)

/* PN_RX_DSCP_MAP_REG */

#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI0_MASK            (0x00000007U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI0_SHIFT           (0x00000000U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI0_MAX             (0x00000007U)

#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI1_MASK            (0x00000070U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI1_SHIFT           (0x00000004U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI1_MAX             (0x00000007U)

#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI2_MASK            (0x00000700U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI2_SHIFT           (0x00000008U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI2_MAX             (0x00000007U)

#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI3_MASK            (0x00007000U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI3_SHIFT           (0x0000000CU)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI3_MAX             (0x00000007U)

#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI4_MASK            (0x00070000U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI4_SHIFT           (0x00000010U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI4_MAX             (0x00000007U)

#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI5_MASK            (0x00700000U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI5_SHIFT           (0x00000014U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI5_MAX             (0x00000007U)

#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI6_MASK            (0x07000000U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI6_SHIFT           (0x00000018U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI6_MAX             (0x00000007U)

#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI7_MASK            (0x70000000U)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI7_SHIFT           (0x0000001CU)
#define CPSW_ETH_PN_RX_DSCP_MAP_REG_PRI7_MAX             (0x00000007U)

/* PN_PRI_CIR_REG */

#define CPSW_ETH_PN_PRI_CIR_REG_PRI_CIR_MASK             (0x0FFFFFFFU)
#define CPSW_ETH_PN_PRI_CIR_REG_PRI_CIR_SHIFT            (0x00000000U)
#define CPSW_ETH_PN_PRI_CIR_REG_PRI_CIR_MAX              (0x0FFFFFFFU)

/* PN_PRI_EIR_REG */

#define CPSW_ETH_PN_PRI_EIR_REG_PRI_EIR_MASK             (0x0FFFFFFFU)
#define CPSW_ETH_PN_PRI_EIR_REG_PRI_EIR_SHIFT            (0x00000000U)
#define CPSW_ETH_PN_PRI_EIR_REG_PRI_EIR_MAX              (0x0FFFFFFFU)

/* PN_TX_D_THRESH_SET_L_REG */

#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI0_MASK      (0x0000001FU)
#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI0_SHIFT     (0x00000000U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI0_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI1_MASK      (0x00001F00U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI1_SHIFT     (0x00000008U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI1_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI2_MASK      (0x001F0000U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI2_SHIFT     (0x00000010U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI2_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI3_MASK      (0x1F000000U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI3_SHIFT     (0x00000018U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_L_REG_PRI3_MAX       (0x0000001FU)

/* PN_TX_D_THRESH_SET_H_REG */

#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI4_MASK      (0x0000001FU)
#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI4_SHIFT     (0x00000000U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI4_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI5_MASK      (0x00001F00U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI5_SHIFT     (0x00000008U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI5_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI6_MASK      (0x001F0000U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI6_SHIFT     (0x00000010U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI6_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI7_MASK      (0x1F000000U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI7_SHIFT     (0x00000018U)
#define CPSW_ETH_PN_TX_D_THRESH_SET_H_REG_PRI7_MAX       (0x0000001FU)

/* PN_TX_D_THRESH_CLR_L_REG */

#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI0_MASK      (0x0000001FU)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI0_SHIFT     (0x00000000U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI0_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI1_MASK      (0x00001F00U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI1_SHIFT     (0x00000008U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI1_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI2_MASK      (0x001F0000U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI2_SHIFT     (0x00000010U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI2_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI3_MASK      (0x1F000000U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI3_SHIFT     (0x00000018U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_L_REG_PRI3_MAX       (0x0000001FU)

/* PN_TX_D_THRESH_CLR_H_REG */

#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI4_MASK      (0x0000001FU)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI4_SHIFT     (0x00000000U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI4_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI5_MASK      (0x00001F00U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI5_SHIFT     (0x00000008U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI5_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI6_MASK      (0x001F0000U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI6_SHIFT     (0x00000010U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI6_MAX       (0x0000001FU)

#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI7_MASK      (0x1F000000U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI7_SHIFT     (0x00000018U)
#define CPSW_ETH_PN_TX_D_THRESH_CLR_H_REG_PRI7_MAX       (0x0000001FU)

/* PN_TX_G_BUF_THRESH_SET_L_REG */

#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI0_MASK  (0x0000001FU)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI0_SHIFT (0x00000000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI0_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI1_MASK  (0x00001F00U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI1_SHIFT (0x00000008U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI1_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI2_MASK  (0x001F0000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI2_SHIFT (0x00000010U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI2_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI3_MASK  (0x1F000000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI3_SHIFT (0x00000018U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_L_REG_PRI3_MAX   (0x0000001FU)

/* PN_TX_G_BUF_THRESH_SET_H_REG */

#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI4_MASK  (0x0000001FU)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI4_SHIFT (0x00000000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI4_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI5_MASK  (0x00001F00U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI5_SHIFT (0x00000008U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI5_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI6_MASK  (0x001F0000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI6_SHIFT (0x00000010U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI6_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI7_MASK  (0x1F000000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI7_SHIFT (0x00000018U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_SET_H_REG_PRI7_MAX   (0x0000001FU)

/* PN_TX_G_BUF_THRESH_CLR_L_REG */

#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI0_MASK  (0x0000001FU)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI0_SHIFT (0x00000000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI0_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI1_MASK  (0x00001F00U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI1_SHIFT (0x00000008U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI1_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI2_MASK  (0x001F0000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI2_SHIFT (0x00000010U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI2_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI3_MASK  (0x1F000000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI3_SHIFT (0x00000018U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_L_REG_PRI3_MAX   (0x0000001FU)

/* PN_TX_G_BUF_THRESH_CLR_H_REG */

#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI4_MASK  (0x0000001FU)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI4_SHIFT (0x00000000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI4_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI5_MASK  (0x00001F00U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI5_SHIFT (0x00000008U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI5_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI6_MASK  (0x001F0000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI6_SHIFT (0x00000010U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI6_MAX   (0x0000001FU)

#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI7_MASK  (0x1F000000U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI7_SHIFT (0x00000018U)
#define CPSW_ETH_PN_TX_G_BUF_THRESH_CLR_H_REG_PRI7_MAX   (0x0000001FU)

/* PN_TX_D_OFLOW_ADDVAL_L_REG */

#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI0_MASK    (0x0000001FU)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI0_SHIFT   (0x00000000U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI0_MAX     (0x0000001FU)

#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI1_MASK    (0x00001F00U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI1_SHIFT   (0x00000008U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI1_MAX     (0x0000001FU)

#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI2_MASK    (0x001F0000U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI2_SHIFT   (0x00000010U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI2_MAX     (0x0000001FU)

#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI3_MASK    (0x1F000000U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI3_SHIFT   (0x00000018U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_L_REG_PRI3_MAX     (0x0000001FU)

/* PN_TX_D_OFLOW_ADDVAL_H_REG */

#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI4_MASK    (0x0000001FU)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI4_SHIFT   (0x00000000U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI4_MAX     (0x0000001FU)

#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI5_MASK    (0x00001F00U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI5_SHIFT   (0x00000008U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI5_MAX     (0x0000001FU)

#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI6_MASK    (0x001F0000U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI6_SHIFT   (0x00000010U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI6_MAX     (0x0000001FU)

#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI7_MASK    (0x1F000000U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI7_SHIFT   (0x00000018U)
#define CPSW_ETH_PN_TX_D_OFLOW_ADDVAL_H_REG_PRI7_MAX     (0x0000001FU)

/* PN_SA_L_REG */

#define CPSW_ETH_PN_SA_L_REG_MACSRCADDR_15_8_MASK        (0x000000FFU)
#define CPSW_ETH_PN_SA_L_REG_MACSRCADDR_15_8_SHIFT       (0x00000000U)
#define CPSW_ETH_PN_SA_L_REG_MACSRCADDR_15_8_MAX         (0x000000FFU)

#define CPSW_ETH_PN_SA_L_REG_MACSRCADDR_7_0_MASK         (0x0000FF00U)
#define CPSW_ETH_PN_SA_L_REG_MACSRCADDR_7_0_SHIFT        (0x00000008U)
#define CPSW_ETH_PN_SA_L_REG_MACSRCADDR_7_0_MAX          (0x000000FFU)

/* PN_SA_H_REG */

#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_47_40_MASK       (0x000000FFU)
#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_47_40_SHIFT      (0x00000000U)
#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_47_40_MAX        (0x000000FFU)

#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_39_32_MASK       (0x0000FF00U)
#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_39_32_SHIFT      (0x00000008U)
#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_39_32_MAX        (0x000000FFU)

#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_31_24_MASK       (0x00FF0000U)
#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_31_24_SHIFT      (0x00000010U)
#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_31_24_MAX        (0x000000FFU)

#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_23_16_MASK       (0xFF000000U)
#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_23_16_SHIFT      (0x00000018U)
#define CPSW_ETH_PN_SA_H_REG_MACSRCADDR_23_16_MAX        (0x000000FFU)

/* PN_TS_CTL_REG */

#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_ANNEX_F_EN_MASK     (0x00000001U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_ANNEX_F_EN_SHIFT    (0x00000000U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_ANNEX_F_EN_MAX      (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_VLAN_LTYPE1_EN_MASK (0x00000002U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_VLAN_LTYPE1_EN_SHIFT (0x00000001U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_VLAN_LTYPE1_EN_MAX  (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_VLAN_LTYPE2_EN_MASK (0x00000004U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_VLAN_LTYPE2_EN_SHIFT (0x00000002U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_VLAN_LTYPE2_EN_MAX  (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_ANNEX_D_EN_MASK     (0x00000008U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_ANNEX_D_EN_SHIFT    (0x00000003U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_ANNEX_D_EN_MAX      (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_ANNEX_F_EN_MASK     (0x00000010U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_ANNEX_F_EN_SHIFT    (0x00000004U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_ANNEX_F_EN_MAX      (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_VLAN_LTYPE1_EN_MASK (0x00000020U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_VLAN_LTYPE1_EN_SHIFT (0x00000005U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_VLAN_LTYPE1_EN_MAX  (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_VLAN_LTYPE2_EN_MASK (0x00000040U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_VLAN_LTYPE2_EN_SHIFT (0x00000006U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_VLAN_LTYPE2_EN_MAX  (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_ANNEX_D_EN_MASK     (0x00000080U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_ANNEX_D_EN_SHIFT    (0x00000007U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_ANNEX_D_EN_MAX      (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_LTYPE2_EN_MASK         (0x00000100U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_LTYPE2_EN_SHIFT        (0x00000008U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_LTYPE2_EN_MAX          (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_ANNEX_E_EN_MASK     (0x00000200U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_ANNEX_E_EN_SHIFT    (0x00000009U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_RX_ANNEX_E_EN_MAX      (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_ANNEX_E_EN_MASK     (0x00000400U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_ANNEX_E_EN_SHIFT    (0x0000000AU)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_ANNEX_E_EN_MAX      (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_HOST_TS_EN_MASK     (0x00000800U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_HOST_TS_EN_SHIFT    (0x0000000BU)
#define CPSW_ETH_PN_TS_CTL_REG_TS_TX_HOST_TS_EN_MAX      (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_REG_TS_MSG_TYPE_EN_MASK       (0xFFFF0000U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_MSG_TYPE_EN_SHIFT      (0x00000010U)
#define CPSW_ETH_PN_TS_CTL_REG_TS_MSG_TYPE_EN_MAX        (0x0000FFFFU)

/* PN_TS_SEQ_LTYPE_REG */

#define CPSW_ETH_PN_TS_SEQ_LTYPE_REG_TS_LTYPE1_MASK      (0x0000FFFFU)
#define CPSW_ETH_PN_TS_SEQ_LTYPE_REG_TS_LTYPE1_SHIFT     (0x00000000U)
#define CPSW_ETH_PN_TS_SEQ_LTYPE_REG_TS_LTYPE1_MAX       (0x0000FFFFU)

#define CPSW_ETH_PN_TS_SEQ_LTYPE_REG_TS_SEQ_ID_OFFSET_MASK (0x003F0000U)
#define CPSW_ETH_PN_TS_SEQ_LTYPE_REG_TS_SEQ_ID_OFFSET_SHIFT (0x00000010U)
#define CPSW_ETH_PN_TS_SEQ_LTYPE_REG_TS_SEQ_ID_OFFSET_MAX (0x0000003FU)

/* PN_TS_VLAN_LTYPE_REG */

#define CPSW_ETH_PN_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE1_MASK (0x0000FFFFU)
#define CPSW_ETH_PN_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE1_SHIFT (0x00000000U)
#define CPSW_ETH_PN_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE1_MAX (0x0000FFFFU)

#define CPSW_ETH_PN_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE2_MASK (0xFFFF0000U)
#define CPSW_ETH_PN_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE2_SHIFT (0x00000010U)
#define CPSW_ETH_PN_TS_VLAN_LTYPE_REG_TS_VLAN_LTYPE2_MAX (0x0000FFFFU)

/* PN_TS_CTL_LTYPE2_REG */

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_LTYPE2_MASK     (0x0000FFFFU)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_LTYPE2_SHIFT    (0x00000000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_LTYPE2_MAX      (0x0000FFFFU)

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_107_MASK        (0x00010000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_107_SHIFT       (0x00000010U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_107_MAX         (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_129_MASK        (0x00020000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_129_SHIFT       (0x00000011U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_129_MAX         (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_130_MASK        (0x00040000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_130_SHIFT       (0x00000012U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_130_MAX         (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_131_MASK        (0x00080000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_131_SHIFT       (0x00000013U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_131_MAX         (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_132_MASK        (0x00100000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_132_SHIFT       (0x00000014U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_132_MAX         (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_319_MASK        (0x00200000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_319_SHIFT       (0x00000015U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_319_MAX         (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_320_MASK        (0x00400000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_320_SHIFT       (0x00000016U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_320_MAX         (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_TTL_NONZERO_MASK (0x00800000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_TTL_NONZERO_SHIFT (0x00000017U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_TTL_NONZERO_MAX (0x00000001U)

#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_UNI_EN_MASK     (0x01000000U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_UNI_EN_SHIFT    (0x00000018U)
#define CPSW_ETH_PN_TS_CTL_LTYPE2_REG_TS_UNI_EN_MAX      (0x00000001U)

/* PN_TS_CTL2_REG */

#define CPSW_ETH_PN_TS_CTL2_REG_TS_MCAST_TYPE_EN_MASK    (0x0000FFFFU)
#define CPSW_ETH_PN_TS_CTL2_REG_TS_MCAST_TYPE_EN_SHIFT   (0x00000000U)
#define CPSW_ETH_PN_TS_CTL2_REG_TS_MCAST_TYPE_EN_MAX     (0x0000FFFFU)

#define CPSW_ETH_PN_TS_CTL2_REG_TS_DOMAIN_OFFSET_MASK    (0x003F0000U)
#define CPSW_ETH_PN_TS_CTL2_REG_TS_DOMAIN_OFFSET_SHIFT   (0x00000010U)
#define CPSW_ETH_PN_TS_CTL2_REG_TS_DOMAIN_OFFSET_MAX     (0x0000003FU)

/* PN_MAC_CONTROL_REG */

#define CPSW_ETH_PN_MAC_CONTROL_REG_FULLDUPLEX_MASK      (0x00000001U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_FULLDUPLEX_SHIFT     (0x00000000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_FULLDUPLEX_MAX       (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_LOOPBACK_MASK        (0x00000002U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_LOOPBACK_SHIFT       (0x00000001U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_LOOPBACK_MAX         (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_MTEST_MASK           (0x00000004U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_MTEST_SHIFT          (0x00000002U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_MTEST_MAX            (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_FLOW_EN_MASK      (0x00000008U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_FLOW_EN_SHIFT     (0x00000003U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_FLOW_EN_MAX       (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_FLOW_EN_MASK      (0x00000010U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_FLOW_EN_SHIFT     (0x00000004U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_FLOW_EN_MAX       (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_GMII_EN_MASK         (0x00000020U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_GMII_EN_SHIFT        (0x00000005U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_GMII_EN_MAX          (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_PACE_MASK         (0x00000040U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_PACE_SHIFT        (0x00000006U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_PACE_MAX          (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_GIG_MASK             (0x00000080U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_GIG_SHIFT            (0x00000007U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_GIG_MAX              (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_SHORT_GAP_ENABLE_MASK (0x00000400U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_SHORT_GAP_ENABLE_SHIFT (0x0000000AU)
#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_SHORT_GAP_ENABLE_MAX (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_CMD_IDLE_MASK        (0x00000800U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_CMD_IDLE_SHIFT       (0x0000000BU)
#define CPSW_ETH_PN_MAC_CONTROL_REG_CMD_IDLE_MAX         (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_CRC_TYPE_MASK        (0x00001000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_CRC_TYPE_SHIFT       (0x0000000CU)
#define CPSW_ETH_PN_MAC_CONTROL_REG_CRC_TYPE_MAX         (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_IFCTL_A_MASK         (0x00008000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_IFCTL_A_SHIFT        (0x0000000FU)
#define CPSW_ETH_PN_MAC_CONTROL_REG_IFCTL_A_MAX          (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_IFCTL_B_MASK         (0x00010000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_IFCTL_B_SHIFT        (0x00000010U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_IFCTL_B_MAX          (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_GIG_FORCE_MASK       (0x00020000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_GIG_FORCE_SHIFT      (0x00000011U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_GIG_FORCE_MAX        (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_CTL_EN_MASK          (0x00040000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_CTL_EN_SHIFT         (0x00000012U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_CTL_EN_MAX           (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_EXT_RX_FLOW_EN_MASK  (0x00080000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_EXT_RX_FLOW_EN_SHIFT (0x00000013U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_EXT_RX_FLOW_EN_MAX   (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_EXT_TX_FLOW_EN_MASK  (0x00100000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_EXT_TX_FLOW_EN_SHIFT (0x00000014U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_EXT_TX_FLOW_EN_MAX   (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_SHORT_GAP_LIM_EN_MASK (0x00200000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_SHORT_GAP_LIM_EN_SHIFT (0x00000015U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_TX_SHORT_GAP_LIM_EN_MAX (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_CEF_EN_MASK       (0x00400000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_CEF_EN_SHIFT      (0x00000016U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_CEF_EN_MAX        (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_CSF_EN_MASK       (0x00800000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_CSF_EN_SHIFT      (0x00000017U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_CSF_EN_MAX        (0x00000001U)

#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_CMF_EN_MASK       (0x01000000U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_CMF_EN_SHIFT      (0x00000018U)
#define CPSW_ETH_PN_MAC_CONTROL_REG_RX_CMF_EN_MAX        (0x00000001U)

/* PN_MAC_STATUS_REG */

#define CPSW_ETH_PN_MAC_STATUS_REG_TX_FLOW_ACT_MASK      (0x00000001U)
#define CPSW_ETH_PN_MAC_STATUS_REG_TX_FLOW_ACT_SHIFT     (0x00000000U)
#define CPSW_ETH_PN_MAC_STATUS_REG_TX_FLOW_ACT_MAX       (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_RX_FLOW_ACT_MASK      (0x00000002U)
#define CPSW_ETH_PN_MAC_STATUS_REG_RX_FLOW_ACT_SHIFT     (0x00000001U)
#define CPSW_ETH_PN_MAC_STATUS_REG_RX_FLOW_ACT_MAX       (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_FULLDUPLEX_MASK   (0x00000008U)
#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_FULLDUPLEX_SHIFT  (0x00000003U)
#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_FULLDUPLEX_MAX    (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_GIG_MASK          (0x00000010U)
#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_GIG_SHIFT         (0x00000004U)
#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_GIG_MAX           (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_TX_FLOW_EN_MASK   (0x00000020U)
#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_TX_FLOW_EN_SHIFT  (0x00000005U)
#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_TX_FLOW_EN_MAX    (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_RX_FLOW_EN_MASK   (0x00000040U)
#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_RX_FLOW_EN_SHIFT  (0x00000006U)
#define CPSW_ETH_PN_MAC_STATUS_REG_EXT_RX_FLOW_EN_MAX    (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_RX_PFC_FLOW_ACT_MASK  (0x0000FF00U)
#define CPSW_ETH_PN_MAC_STATUS_REG_RX_PFC_FLOW_ACT_SHIFT (0x00000008U)
#define CPSW_ETH_PN_MAC_STATUS_REG_RX_PFC_FLOW_ACT_MAX   (0x000000FFU)

#define CPSW_ETH_PN_MAC_STATUS_REG_TX_PFC_FLOW_ACT_MASK  (0x00FF0000U)
#define CPSW_ETH_PN_MAC_STATUS_REG_TX_PFC_FLOW_ACT_SHIFT (0x00000010U)
#define CPSW_ETH_PN_MAC_STATUS_REG_TX_PFC_FLOW_ACT_MAX   (0x000000FFU)

#define CPSW_ETH_PN_MAC_STATUS_REG_TORF_PRI_MASK         (0x07000000U)
#define CPSW_ETH_PN_MAC_STATUS_REG_TORF_PRI_SHIFT        (0x00000018U)
#define CPSW_ETH_PN_MAC_STATUS_REG_TORF_PRI_MAX          (0x00000007U)

#define CPSW_ETH_PN_MAC_STATUS_REG_TORF_MASK             (0x08000000U)
#define CPSW_ETH_PN_MAC_STATUS_REG_TORF_SHIFT            (0x0000001BU)
#define CPSW_ETH_PN_MAC_STATUS_REG_TORF_MAX              (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_TX_IDLE_MASK          (0x10000000U)
#define CPSW_ETH_PN_MAC_STATUS_REG_TX_IDLE_SHIFT         (0x0000001CU)
#define CPSW_ETH_PN_MAC_STATUS_REG_TX_IDLE_MAX           (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_P_IDLE_MASK           (0x20000000U)
#define CPSW_ETH_PN_MAC_STATUS_REG_P_IDLE_SHIFT          (0x0000001DU)
#define CPSW_ETH_PN_MAC_STATUS_REG_P_IDLE_MAX            (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_E_IDLE_MASK           (0x40000000U)
#define CPSW_ETH_PN_MAC_STATUS_REG_E_IDLE_SHIFT          (0x0000001EU)
#define CPSW_ETH_PN_MAC_STATUS_REG_E_IDLE_MAX            (0x00000001U)

#define CPSW_ETH_PN_MAC_STATUS_REG_IDLE_MASK             (0x80000000U)
#define CPSW_ETH_PN_MAC_STATUS_REG_IDLE_SHIFT            (0x0000001FU)
#define CPSW_ETH_PN_MAC_STATUS_REG_IDLE_MAX              (0x00000001U)

/* PN_MAC_SOFT_RESET_REG */

#define CPSW_ETH_PN_MAC_SOFT_RESET_REG_SOFT_RESET_MASK   (0x00000001U)
#define CPSW_ETH_PN_MAC_SOFT_RESET_REG_SOFT_RESET_SHIFT  (0x00000000U)
#define CPSW_ETH_PN_MAC_SOFT_RESET_REG_SOFT_RESET_MAX    (0x00000001U)


/* PN_MAC_SOFT_RESET_REG */

#define CPSW_CPDMA_SOFT_RESET_REG_SOFT_RESET_MASK   (0x00000001U)
#define CPSW_CPDMA_SOFT_RESET_REG_SOFT_RESET_SHIFT  (0x00000000U)
#define CPSW_CPDMA_SOFT_RESET_REG_SOFT_RESET_MAX    (0x00000001U)

/* PN_MAC_BOFFTEST_REG */

#define CPSW_ETH_PN_MAC_BOFFTEST_REG_TX_BACKOFF_MASK     (0x000003FFU)
#define CPSW_ETH_PN_MAC_BOFFTEST_REG_TX_BACKOFF_SHIFT    (0x00000000U)
#define CPSW_ETH_PN_MAC_BOFFTEST_REG_TX_BACKOFF_MAX      (0x000003FFU)

#define CPSW_ETH_PN_MAC_BOFFTEST_REG_COLL_COUNT_MASK     (0x0000F000U)
#define CPSW_ETH_PN_MAC_BOFFTEST_REG_COLL_COUNT_SHIFT    (0x0000000CU)
#define CPSW_ETH_PN_MAC_BOFFTEST_REG_COLL_COUNT_MAX      (0x0000000FU)

#define CPSW_ETH_PN_MAC_BOFFTEST_REG_RNDNUM_MASK         (0x03FF0000U)
#define CPSW_ETH_PN_MAC_BOFFTEST_REG_RNDNUM_SHIFT        (0x00000010U)
#define CPSW_ETH_PN_MAC_BOFFTEST_REG_RNDNUM_MAX          (0x000003FFU)

#define CPSW_ETH_PN_MAC_BOFFTEST_REG_PACEVAL_MASK        (0x7C000000U)
#define CPSW_ETH_PN_MAC_BOFFTEST_REG_PACEVAL_SHIFT       (0x0000001AU)
#define CPSW_ETH_PN_MAC_BOFFTEST_REG_PACEVAL_MAX         (0x0000001FU)

/* PN_MAC_RX_PAUSETIMER_REG */

#define CPSW_ETH_PN_MAC_RX_PAUSETIMER_REG_RX_PAUSETIMER_MASK (0x0000FFFFU)
#define CPSW_ETH_PN_MAC_RX_PAUSETIMER_REG_RX_PAUSETIMER_SHIFT (0x00000000U)
#define CPSW_ETH_PN_MAC_RX_PAUSETIMER_REG_RX_PAUSETIMER_MAX (0x0000FFFFU)

/* PN_MAC_RXN_PAUSETIMER_REG */

#define CPSW_ETH_PN_MAC_RXN_PAUSETIMER_REG_RX_PAUSETIMER_MASK (0x0000FFFFU)
#define CPSW_ETH_PN_MAC_RXN_PAUSETIMER_REG_RX_PAUSETIMER_SHIFT (0x00000000U)
#define CPSW_ETH_PN_MAC_RXN_PAUSETIMER_REG_RX_PAUSETIMER_MAX (0x0000FFFFU)

/* PN_MAC_TX_PAUSETIMER_REG */

#define CPSW_ETH_PN_MAC_TX_PAUSETIMER_REG_TX_PAUSETIMER_MASK (0x0000FFFFU)
#define CPSW_ETH_PN_MAC_TX_PAUSETIMER_REG_TX_PAUSETIMER_SHIFT (0x00000000U)
#define CPSW_ETH_PN_MAC_TX_PAUSETIMER_REG_TX_PAUSETIMER_MAX (0x0000FFFFU)

/* PN_MAC_TXN_PAUSETIMER_REG */

#define CPSW_ETH_PN_MAC_TXN_PAUSETIMER_REG_TX_PAUSETIMER_MASK (0x0000FFFFU)
#define CPSW_ETH_PN_MAC_TXN_PAUSETIMER_REG_TX_PAUSETIMER_SHIFT (0x00000000U)
#define CPSW_ETH_PN_MAC_TXN_PAUSETIMER_REG_TX_PAUSETIMER_MAX (0x0000FFFFU)

/* PN_MAC_EMCONTROL_REG */

#define CPSW_ETH_PN_MAC_EMCONTROL_REG_FREE_MASK          (0x00000001U)
#define CPSW_ETH_PN_MAC_EMCONTROL_REG_FREE_SHIFT         (0x00000000U)
#define CPSW_ETH_PN_MAC_EMCONTROL_REG_FREE_MAX           (0x00000001U)

#define CPSW_ETH_PN_MAC_EMCONTROL_REG_SOFT_MASK          (0x00000002U)
#define CPSW_ETH_PN_MAC_EMCONTROL_REG_SOFT_SHIFT         (0x00000001U)
#define CPSW_ETH_PN_MAC_EMCONTROL_REG_SOFT_MAX           (0x00000001U)

/* PN_MAC_TX_GAP_REG */

#define CPSW_ETH_PN_MAC_TX_GAP_REG_TX_GAP_MASK           (0x0000FFFFU)
#define CPSW_ETH_PN_MAC_TX_GAP_REG_TX_GAP_SHIFT          (0x00000000U)
#define CPSW_ETH_PN_MAC_TX_GAP_REG_TX_GAP_MAX            (0x0000FFFFU)


/*!*****************************************************************************
* End of File
*******************************************************************************/
#ifdef __cplusplus
}
#endif

#endif  /* _HW_CPSW_PORT_H_ */
