/* ======================================================================
 *   Copyright (c) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/*
 * hw_cpsw_stats.h
 *
 * Register-level header file for STATS
 */

#ifndef HW_CPSW_STATS_H_
#define HW_CPSW_STATS_H_

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
 * Register Definitions
 ******************************************************************************/
#define CPSW_STAT_0_RXGOODFRAMES                         (0x0003A000U)
#define CPSW_STAT_0_RXBROADCASTFRAMES                    (0x0003A004U)
#define CPSW_STAT_0_RXMULTICASTFRAMES                    (0x0003A008U)
#define CPSW_STAT_0_RXCRCERRORS                          (0x0003A010U)
#define CPSW_STAT_0_RXOVERSIZEDFRAMES                    (0x0003A018U)
#define CPSW_STAT_0_RXUNDERSIZEDFRAMES                   (0x0003A020U)
#define CPSW_STAT_0_RXFRAGMENTS                          (0x0003A024U)
#define CPSW_STAT_0_ALE_DROP                             (0x0003A028U)
#define CPSW_STAT_0_ALE_OVERRUN_DROP                     (0x0003A02CU)
#define CPSW_STAT_0_RXOCTETS                             (0x0003A030U)
#define CPSW_STAT_0_TXGOODFRAMES                         (0x0003A034U)
#define CPSW_STAT_0_TXBROADCASTFRAMES                    (0x0003A038U)
#define CPSW_STAT_0_TXMULTICASTFRAMES                    (0x0003A03CU)
#define CPSW_STAT_0_TXOCTETS                             (0x0003A064U)
#define CPSW_STAT_0_OCTETFRAMES64                        (0x0003A068U)
#define CPSW_STAT_0_OCTETFRAMES65T127                    (0x0003A06CU)
#define CPSW_STAT_0_OCTETFRAMES128T255                   (0x0003A070U)
#define CPSW_STAT_0_OCTETFRAMES256T511                   (0x0003A074U)
#define CPSW_STAT_0_OCTETFRAMES512T1023                  (0x0003A078U)
#define CPSW_STAT_0_OCTETFRAMES1024TUP                   (0x0003A07CU)
#define CPSW_STAT_0_NETOCTETS                            (0x0003A080U)
#define CPSW_STAT_0_RX_BOTTOM_OF_FIFO_DROP               (0x0003A084U)
#define CPSW_STAT_0_PORTMASK_DROP                        (0x0003A088U)
#define CPSW_STAT_0_RX_TOP_OF_FIFO_DROP                  (0x0003A08CU)
#define CPSW_STAT_0_ALE_RATE_LIMIT_DROP                  (0x0003A090U)
#define CPSW_STAT_0_ALE_VID_INGRESS_DROP                 (0x0003A094U)
#define CPSW_STAT_0_ALE_DA_EQ_SA_DROP                    (0x0003A098U)
#define CPSW_STAT_0_ALE_BLOCK_DROP                       (0x0003A09CU)
#define CPSW_STAT_0_ALE_SECURE_DROP                      (0x0003A0A0U)
#define CPSW_STAT_0_ALE_AUTH_DROP                        (0x0003A0A4U)
#define CPSW_STAT_0_ALE_UNKN_UNI                         (0x0003A0A8U)
#define CPSW_STAT_0_ALE_UNKN_UNI_BCNT                    (0x0003A0ACU)
#define CPSW_STAT_0_ALE_UNKN_MLT                         (0x0003A0B0U)
#define CPSW_STAT_0_ALE_UNKN_MLT_BCNT                    (0x0003A0B4U)
#define CPSW_STAT_0_ALE_UNKN_BRD                         (0x0003A0B8U)
#define CPSW_STAT_0_ALE_UNKN_BRD_BCNT                    (0x0003A0BCU)
#define CPSW_STAT_0_ALE_POL_MATCH                        (0x0003A0C0U)
#define CPSW_STAT_0_ALE_POL_MATCH_RED                    (0x0003A0C4U)
#define CPSW_STAT_0_ALE_POL_MATCH_YELLOW                 (0x0003A0C8U)
#define CPSW_STAT_0_TX_MEMORY_PROTECT_ERROR              (0x0003A17CU)
#define CPSW_STAT_1_RXGOODFRAMES                         (0x0003A200U)
#define CPSW_STAT_1_RXBROADCASTFRAMES                    (0x0003A204U)
#define CPSW_STAT_1_RXMULTICASTFRAMES                    (0x0003A208U)
#define CPSW_STAT_1_RXPAUSEFRAMES                        (0x0003A20CU)
#define CPSW_STAT_1_RXCRCERRORS                          (0x0003A210U)
#define CPSW_STAT_1_RXALIGNCODEERRORS                    (0x0003A214U)
#define CPSW_STAT_1_RXOVERSIZEDFRAMES                    (0x0003A218U)
#define CPSW_STAT_1_RXJABBERFRAMES                       (0x0003A21CU)
#define CPSW_STAT_1_RXUNDERSIZEDFRAMES                   (0x0003A220U)
#define CPSW_STAT_1_RXFRAGMENTS                          (0x0003A224U)
#define CPSW_STAT_1_ALE_DROP                             (0x0003A228U)
#define CPSW_STAT_1_ALE_OVERRUN_DROP                     (0x0003A22CU)
#define CPSW_STAT_1_RXOCTETS                             (0x0003A230U)
#define CPSW_STAT_1_TXGOODFRAMES                         (0x0003A234U)
#define CPSW_STAT_1_TXBROADCASTFRAMES                    (0x0003A238U)
#define CPSW_STAT_1_TXMULTICASTFRAMES                    (0x0003A23CU)
#define CPSW_STAT_1_TXPAUSEFRAMES                        (0x0003A240U)
#define CPSW_STAT_1_TXDEFERREDFRAMES                     (0x0003A244U)
#define CPSW_STAT_1_TXCOLLISIONFRAMES                    (0x0003A248U)
#define CPSW_STAT_1_TXSINGLECOLLFRAMES                   (0x0003A24CU)
#define CPSW_STAT_1_TXMULTCOLLFRAMES                     (0x0003A250U)
#define CPSW_STAT_1_TXEXCESSIVECOLLISIONS                (0x0003A254U)
#define CPSW_STAT_1_TXLATECOLLISIONS                     (0x0003A258U)
#define CPSW_STAT_1_RXIPGERROR                           (0x0003A25CU)
#define CPSW_STAT_1_TXCARRIERSENSEERRORS                 (0x0003A260U)
#define CPSW_STAT_1_TXOCTETS                             (0x0003A264U)
#define CPSW_STAT_1_OCTETFRAMES64                        (0x0003A268U)
#define CPSW_STAT_1_OCTETFRAMES65T127                    (0x0003A26CU)
#define CPSW_STAT_1_OCTETFRAMES128T255                   (0x0003A270U)
#define CPSW_STAT_1_OCTETFRAMES256T511                   (0x0003A274U)
#define CPSW_STAT_1_OCTETFRAMES512T1023                  (0x0003A278U)
#define CPSW_STAT_1_OCTETFRAMES1024TUP                   (0x0003A27CU)
#define CPSW_STAT_1_NETOCTETS                            (0x0003A280U)
#define CPSW_STAT_1_RX_BOTTOM_OF_FIFO_DROP               (0x0003A284U)
#define CPSW_STAT_1_PORTMASK_DROP                        (0x0003A288U)
#define CPSW_STAT_1_RX_TOP_OF_FIFO_DROP                  (0x0003A28CU)
#define CPSW_STAT_1_ALE_RATE_LIMIT_DROP                  (0x0003A290U)
#define CPSW_STAT_1_ALE_VID_INGRESS_DROP                 (0x0003A294U)
#define CPSW_STAT_1_ALE_DA_EQ_SA_DROP                    (0x0003A298U)
#define CPSW_STAT_1_ALE_BLOCK_DROP                       (0x0003A29CU)
#define CPSW_STAT_1_ALE_SECURE_DROP                      (0x0003A2A0U)
#define CPSW_STAT_1_ALE_AUTH_DROP                        (0x0003A2A4U)
#define CPSW_STAT_1_ALE_UNKN_UNI                         (0x0003A2A8U)
#define CPSW_STAT_1_ALE_UNKN_UNI_BCNT                    (0x0003A2ACU)
#define CPSW_STAT_1_ALE_UNKN_MLT                         (0x0003A2B0U)
#define CPSW_STAT_1_ALE_UNKN_MLT_BCNT                    (0x0003A2B4U)
#define CPSW_STAT_1_ALE_UNKN_BRD                         (0x0003A2B8U)
#define CPSW_STAT_1_ALE_UNKN_BRD_BCNT                    (0x0003A2BCU)
#define CPSW_STAT_1_ALE_POL_MATCH                        (0x0003A2C0U)
#define CPSW_STAT_1_ALE_POL_MATCH_RED                    (0x0003A2C4U)
#define CPSW_STAT_1_ALE_POL_MATCH_YELLOW                 (0x0003A2C8U)
#define CPSW_STAT_1_TX_MEMORY_PROTECT_ERROR              (0x0003A37CU)
#define CPSW_STAT_1_ENET_PN_TX_PRI_REG(ENET_PN_TX_PRI_REG) (0x0003A380U+((ENET_PN_TX_PRI_REG)*0x4U))
#define CPSW_STAT_1_ENET_PN_TX_PRI_BCNT_REG(ENET_PN_TX_PRI_BCNT_REG) (0x0003A3A0U+((ENET_PN_TX_PRI_BCNT_REG)*0x4U))
#define CPSW_STAT_1_ENET_PN_TX_PRI_DROP_REG(ENET_PN_TX_PRI_DROP_REG) (0x0003A3C0U+((ENET_PN_TX_PRI_DROP_REG)*0x4U))
#define CPSW_STAT_1_ENET_PN_TX_PRI_DROP_BCNT_REG(ENET_PN_TX_PRI_DROP_BCNT_REG) (0x0003A3E0U+((ENET_PN_TX_PRI_DROP_BCNT_REG)*0x4U))
#define CPSW_STAT_OFFSET(portNum)						 (0x00000200U * (portNum - 1))


/*******************************************************************************
 * Field Definition Macros
 ******************************************************************************/
/* RXGOODFRAMES */

#define CPSW_STAT_0_RXGOODFRAMES_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_0_RXGOODFRAMES_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_0_RXGOODFRAMES_COUNT_MAX               (0xFFFFFFFFU)

/* RXBROADCASTFRAMES */

#define CPSW_STAT_0_RXBROADCASTFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_RXBROADCASTFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_RXBROADCASTFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* RXMULTICASTFRAMES */

#define CPSW_STAT_0_RXMULTICASTFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_RXMULTICASTFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_RXMULTICASTFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* RXCRCERRORS */

#define CPSW_STAT_0_RXCRCERRORS_COUNT_MASK               (0xFFFFFFFFU)
#define CPSW_STAT_0_RXCRCERRORS_COUNT_SHIFT              (0x00000000U)
#define CPSW_STAT_0_RXCRCERRORS_COUNT_MAX                (0xFFFFFFFFU)

/* RXOVERSIZEDFRAMES */

#define CPSW_STAT_0_RXOVERSIZEDFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_RXOVERSIZEDFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_RXOVERSIZEDFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* RXUNDERSIZEDFRAMES */

#define CPSW_STAT_0_RXUNDERSIZEDFRAMES_COUNT_MASK        (0xFFFFFFFFU)
#define CPSW_STAT_0_RXUNDERSIZEDFRAMES_COUNT_SHIFT       (0x00000000U)
#define CPSW_STAT_0_RXUNDERSIZEDFRAMES_COUNT_MAX         (0xFFFFFFFFU)

/* RXFRAGMENTS */

#define CPSW_STAT_0_RXFRAGMENTS_COUNT_MASK               (0xFFFFFFFFU)
#define CPSW_STAT_0_RXFRAGMENTS_COUNT_SHIFT              (0x00000000U)
#define CPSW_STAT_0_RXFRAGMENTS_COUNT_MAX                (0xFFFFFFFFU)

/* ALE_DROP */

#define CPSW_STAT_0_ALE_DROP_COUNT_MASK                  (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_DROP_COUNT_SHIFT                 (0x00000000U)
#define CPSW_STAT_0_ALE_DROP_COUNT_MAX                   (0xFFFFFFFFU)

/* ALE_OVERRUN_DROP */

#define CPSW_STAT_0_ALE_OVERRUN_DROP_COUNT_MASK          (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_OVERRUN_DROP_COUNT_SHIFT         (0x00000000U)
#define CPSW_STAT_0_ALE_OVERRUN_DROP_COUNT_MAX           (0xFFFFFFFFU)

/* RXOCTETS */

#define CPSW_STAT_0_RXOCTETS_COUNT_MASK                  (0xFFFFFFFFU)
#define CPSW_STAT_0_RXOCTETS_COUNT_SHIFT                 (0x00000000U)
#define CPSW_STAT_0_RXOCTETS_COUNT_MAX                   (0xFFFFFFFFU)

/* TXGOODFRAMES */

#define CPSW_STAT_0_TXGOODFRAMES_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_0_TXGOODFRAMES_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_0_TXGOODFRAMES_COUNT_MAX               (0xFFFFFFFFU)

/* TXBROADCASTFRAMES */

#define CPSW_STAT_0_TXBROADCASTFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_TXBROADCASTFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_TXBROADCASTFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* TXMULTICASTFRAMES */

#define CPSW_STAT_0_TXMULTICASTFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_TXMULTICASTFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_TXMULTICASTFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* TXOCTETS */

#define CPSW_STAT_0_TXOCTETS_COUNT_MASK                  (0xFFFFFFFFU)
#define CPSW_STAT_0_TXOCTETS_COUNT_SHIFT                 (0x00000000U)
#define CPSW_STAT_0_TXOCTETS_COUNT_MAX                   (0xFFFFFFFFU)

/* OCTETFRAMES64 */

#define CPSW_STAT_0_OCTETFRAMES64_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_0_OCTETFRAMES64_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_0_OCTETFRAMES64_COUNT_MAX              (0xFFFFFFFFU)

/* OCTETFRAMES65T127 */

#define CPSW_STAT_0_OCTETFRAMES65T127_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_OCTETFRAMES65T127_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_OCTETFRAMES65T127_COUNT_MAX          (0xFFFFFFFFU)

/* OCTETFRAMES128T255 */

#define CPSW_STAT_0_OCTETFRAMES128T255_COUNT_MASK        (0xFFFFFFFFU)
#define CPSW_STAT_0_OCTETFRAMES128T255_COUNT_SHIFT       (0x00000000U)
#define CPSW_STAT_0_OCTETFRAMES128T255_COUNT_MAX         (0xFFFFFFFFU)

/* OCTETFRAMES256T511 */

#define CPSW_STAT_0_OCTETFRAMES256T511_COUNT_MASK        (0xFFFFFFFFU)
#define CPSW_STAT_0_OCTETFRAMES256T511_COUNT_SHIFT       (0x00000000U)
#define CPSW_STAT_0_OCTETFRAMES256T511_COUNT_MAX         (0xFFFFFFFFU)

/* OCTETFRAMES512T1023 */

#define CPSW_STAT_0_OCTETFRAMES512T1023_COUNT_MASK       (0xFFFFFFFFU)
#define CPSW_STAT_0_OCTETFRAMES512T1023_COUNT_SHIFT      (0x00000000U)
#define CPSW_STAT_0_OCTETFRAMES512T1023_COUNT_MAX        (0xFFFFFFFFU)

/* OCTETFRAMES1024TUP */

#define CPSW_STAT_0_OCTETFRAMES1024TUP_COUNT_MASK        (0xFFFFFFFFU)
#define CPSW_STAT_0_OCTETFRAMES1024TUP_COUNT_SHIFT       (0x00000000U)
#define CPSW_STAT_0_OCTETFRAMES1024TUP_COUNT_MAX         (0xFFFFFFFFU)

/* NETOCTETS */

#define CPSW_STAT_0_NETOCTETS_COUNT_MASK                 (0xFFFFFFFFU)
#define CPSW_STAT_0_NETOCTETS_COUNT_SHIFT                (0x00000000U)
#define CPSW_STAT_0_NETOCTETS_COUNT_MAX                  (0xFFFFFFFFU)

/* RX_BOTTOM_OF_FIFO_DROP */

#define CPSW_STAT_0_RX_BOTTOM_OF_FIFO_DROP_COUNT_MASK    (0xFFFFFFFFU)
#define CPSW_STAT_0_RX_BOTTOM_OF_FIFO_DROP_COUNT_SHIFT   (0x00000000U)
#define CPSW_STAT_0_RX_BOTTOM_OF_FIFO_DROP_COUNT_MAX     (0xFFFFFFFFU)

/* PORTMASK_DROP */

#define CPSW_STAT_0_PORTMASK_DROP_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_0_PORTMASK_DROP_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_0_PORTMASK_DROP_COUNT_MAX              (0xFFFFFFFFU)

/* RX_TOP_OF_FIFO_DROP */

#define CPSW_STAT_0_RX_TOP_OF_FIFO_DROP_COUNT_MASK       (0xFFFFFFFFU)
#define CPSW_STAT_0_RX_TOP_OF_FIFO_DROP_COUNT_SHIFT      (0x00000000U)
#define CPSW_STAT_0_RX_TOP_OF_FIFO_DROP_COUNT_MAX        (0xFFFFFFFFU)

/* ALE_RATE_LIMIT_DROP */

#define CPSW_STAT_0_ALE_RATE_LIMIT_DROP_COUNT_MASK       (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_RATE_LIMIT_DROP_COUNT_SHIFT      (0x00000000U)
#define CPSW_STAT_0_ALE_RATE_LIMIT_DROP_COUNT_MAX        (0xFFFFFFFFU)

/* ALE_VID_INGRESS_DROP */

#define CPSW_STAT_0_ALE_VID_INGRESS_DROP_COUNT_MASK      (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_VID_INGRESS_DROP_COUNT_SHIFT     (0x00000000U)
#define CPSW_STAT_0_ALE_VID_INGRESS_DROP_COUNT_MAX       (0xFFFFFFFFU)

/* ALE_DA_EQ_SA_DROP */

#define CPSW_STAT_0_ALE_DA_EQ_SA_DROP_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_DA_EQ_SA_DROP_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_ALE_DA_EQ_SA_DROP_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_BLOCK_DROP */

#define CPSW_STAT_0_ALE_BLOCK_DROP_COUNT_MASK            (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_BLOCK_DROP_COUNT_SHIFT           (0x00000000U)
#define CPSW_STAT_0_ALE_BLOCK_DROP_COUNT_MAX             (0xFFFFFFFFU)

/* ALE_SECURE_DROP */

#define CPSW_STAT_0_ALE_SECURE_DROP_COUNT_MASK           (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_SECURE_DROP_COUNT_SHIFT          (0x00000000U)
#define CPSW_STAT_0_ALE_SECURE_DROP_COUNT_MAX            (0xFFFFFFFFU)

/* ALE_AUTH_DROP */

#define CPSW_STAT_0_ALE_AUTH_DROP_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_AUTH_DROP_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_0_ALE_AUTH_DROP_COUNT_MAX              (0xFFFFFFFFU)

/* ALE_UNKN_UNI */

#define CPSW_STAT_0_ALE_UNKN_UNI_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_UNKN_UNI_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_0_ALE_UNKN_UNI_COUNT_MAX               (0xFFFFFFFFU)

/* ALE_UNKN_UNI_BCNT */

#define CPSW_STAT_0_ALE_UNKN_UNI_BCNT_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_UNKN_UNI_BCNT_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_ALE_UNKN_UNI_BCNT_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_UNKN_MLT */

#define CPSW_STAT_0_ALE_UNKN_MLT_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_UNKN_MLT_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_0_ALE_UNKN_MLT_COUNT_MAX               (0xFFFFFFFFU)

/* ALE_UNKN_MLT_BCNT */

#define CPSW_STAT_0_ALE_UNKN_MLT_BCNT_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_UNKN_MLT_BCNT_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_ALE_UNKN_MLT_BCNT_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_UNKN_BRD */

#define CPSW_STAT_0_ALE_UNKN_BRD_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_UNKN_BRD_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_0_ALE_UNKN_BRD_COUNT_MAX               (0xFFFFFFFFU)

/* ALE_UNKN_BRD_BCNT */

#define CPSW_STAT_0_ALE_UNKN_BRD_BCNT_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_UNKN_BRD_BCNT_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_ALE_UNKN_BRD_BCNT_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_POL_MATCH */

#define CPSW_STAT_0_ALE_POL_MATCH_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_POL_MATCH_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_0_ALE_POL_MATCH_COUNT_MAX              (0xFFFFFFFFU)

/* ALE_POL_MATCH_RED */

#define CPSW_STAT_0_ALE_POL_MATCH_RED_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_POL_MATCH_RED_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_0_ALE_POL_MATCH_RED_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_POL_MATCH_YELLOW */

#define CPSW_STAT_0_ALE_POL_MATCH_YELLOW_COUNT_MASK      (0xFFFFFFFFU)
#define CPSW_STAT_0_ALE_POL_MATCH_YELLOW_COUNT_SHIFT     (0x00000000U)
#define CPSW_STAT_0_ALE_POL_MATCH_YELLOW_COUNT_MAX       (0xFFFFFFFFU)

/* TX_MEMORY_PROTECT_ERROR */

#define CPSW_STAT_0_TX_MEMORY_PROTECT_ERROR_COUNT_MASK   (0x000000FFU)
#define CPSW_STAT_0_TX_MEMORY_PROTECT_ERROR_COUNT_SHIFT  (0x00000000U)
#define CPSW_STAT_0_TX_MEMORY_PROTECT_ERROR_COUNT_MAX    (0x000000FFU)

/* RXGOODFRAMES */

#define CPSW_STAT_1_RXGOODFRAMES_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_1_RXGOODFRAMES_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_1_RXGOODFRAMES_COUNT_MAX               (0xFFFFFFFFU)

/* RXBROADCASTFRAMES */

#define CPSW_STAT_1_RXBROADCASTFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_RXBROADCASTFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_RXBROADCASTFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* RXMULTICASTFRAMES */

#define CPSW_STAT_1_RXMULTICASTFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_RXMULTICASTFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_RXMULTICASTFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* RXPAUSEFRAMES */

#define CPSW_STAT_1_RXPAUSEFRAMES_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_1_RXPAUSEFRAMES_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_1_RXPAUSEFRAMES_COUNT_MAX              (0xFFFFFFFFU)

/* RXCRCERRORS */

#define CPSW_STAT_1_RXCRCERRORS_COUNT_MASK               (0xFFFFFFFFU)
#define CPSW_STAT_1_RXCRCERRORS_COUNT_SHIFT              (0x00000000U)
#define CPSW_STAT_1_RXCRCERRORS_COUNT_MAX                (0xFFFFFFFFU)

/* RXALIGNCODEERRORS */

#define CPSW_STAT_1_RXALIGNCODEERRORS_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_RXALIGNCODEERRORS_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_RXALIGNCODEERRORS_COUNT_MAX          (0xFFFFFFFFU)

/* RXOVERSIZEDFRAMES */

#define CPSW_STAT_1_RXOVERSIZEDFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_RXOVERSIZEDFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_RXOVERSIZEDFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* RXJABBERFRAMES */

#define CPSW_STAT_1_RXJABBERFRAMES_COUNT_MASK            (0xFFFFFFFFU)
#define CPSW_STAT_1_RXJABBERFRAMES_COUNT_SHIFT           (0x00000000U)
#define CPSW_STAT_1_RXJABBERFRAMES_COUNT_MAX             (0xFFFFFFFFU)

/* RXUNDERSIZEDFRAMES */

#define CPSW_STAT_1_RXUNDERSIZEDFRAMES_COUNT_MASK        (0xFFFFFFFFU)
#define CPSW_STAT_1_RXUNDERSIZEDFRAMES_COUNT_SHIFT       (0x00000000U)
#define CPSW_STAT_1_RXUNDERSIZEDFRAMES_COUNT_MAX         (0xFFFFFFFFU)

/* RXFRAGMENTS */

#define CPSW_STAT_1_RXFRAGMENTS_COUNT_MASK               (0xFFFFFFFFU)
#define CPSW_STAT_1_RXFRAGMENTS_COUNT_SHIFT              (0x00000000U)
#define CPSW_STAT_1_RXFRAGMENTS_COUNT_MAX                (0xFFFFFFFFU)

/* ALE_DROP */

#define CPSW_STAT_1_ALE_DROP_COUNT_MASK                  (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_DROP_COUNT_SHIFT                 (0x00000000U)
#define CPSW_STAT_1_ALE_DROP_COUNT_MAX                   (0xFFFFFFFFU)

/* ALE_OVERRUN_DROP */

#define CPSW_STAT_1_ALE_OVERRUN_DROP_COUNT_MASK          (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_OVERRUN_DROP_COUNT_SHIFT         (0x00000000U)
#define CPSW_STAT_1_ALE_OVERRUN_DROP_COUNT_MAX           (0xFFFFFFFFU)

/* RXOCTETS */

#define CPSW_STAT_1_RXOCTETS_COUNT_MASK                  (0xFFFFFFFFU)
#define CPSW_STAT_1_RXOCTETS_COUNT_SHIFT                 (0x00000000U)
#define CPSW_STAT_1_RXOCTETS_COUNT_MAX                   (0xFFFFFFFFU)

/* TXGOODFRAMES */

#define CPSW_STAT_1_TXGOODFRAMES_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_1_TXGOODFRAMES_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_1_TXGOODFRAMES_COUNT_MAX               (0xFFFFFFFFU)

/* TXBROADCASTFRAMES */

#define CPSW_STAT_1_TXBROADCASTFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_TXBROADCASTFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_TXBROADCASTFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* TXMULTICASTFRAMES */

#define CPSW_STAT_1_TXMULTICASTFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_TXMULTICASTFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_TXMULTICASTFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* TXPAUSEFRAMES */

#define CPSW_STAT_1_TXPAUSEFRAMES_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_1_TXPAUSEFRAMES_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_1_TXPAUSEFRAMES_COUNT_MAX              (0xFFFFFFFFU)

/* TXDEFERREDFRAMES */

#define CPSW_STAT_1_TXDEFERREDFRAMES_COUNT_MASK          (0xFFFFFFFFU)
#define CPSW_STAT_1_TXDEFERREDFRAMES_COUNT_SHIFT         (0x00000000U)
#define CPSW_STAT_1_TXDEFERREDFRAMES_COUNT_MAX           (0xFFFFFFFFU)

/* TXCOLLISIONFRAMES */

#define CPSW_STAT_1_TXCOLLISIONFRAMES_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_TXCOLLISIONFRAMES_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_TXCOLLISIONFRAMES_COUNT_MAX          (0xFFFFFFFFU)

/* TXSINGLECOLLFRAMES */

#define CPSW_STAT_1_TXSINGLECOLLFRAMES_COUNT_MASK        (0xFFFFFFFFU)
#define CPSW_STAT_1_TXSINGLECOLLFRAMES_COUNT_SHIFT       (0x00000000U)
#define CPSW_STAT_1_TXSINGLECOLLFRAMES_COUNT_MAX         (0xFFFFFFFFU)

/* TXMULTCOLLFRAMES */

#define CPSW_STAT_1_TXMULTCOLLFRAMES_COUNT_MASK          (0xFFFFFFFFU)
#define CPSW_STAT_1_TXMULTCOLLFRAMES_COUNT_SHIFT         (0x00000000U)
#define CPSW_STAT_1_TXMULTCOLLFRAMES_COUNT_MAX           (0xFFFFFFFFU)

/* TXEXCESSIVECOLLISIONS */

#define CPSW_STAT_1_TXEXCESSIVECOLLISIONS_COUNT_MASK     (0xFFFFFFFFU)
#define CPSW_STAT_1_TXEXCESSIVECOLLISIONS_COUNT_SHIFT    (0x00000000U)
#define CPSW_STAT_1_TXEXCESSIVECOLLISIONS_COUNT_MAX      (0xFFFFFFFFU)

/* TXLATECOLLISIONS */

#define CPSW_STAT_1_TXLATECOLLISIONS_COUNT_MASK          (0xFFFFFFFFU)
#define CPSW_STAT_1_TXLATECOLLISIONS_COUNT_SHIFT         (0x00000000U)
#define CPSW_STAT_1_TXLATECOLLISIONS_COUNT_MAX           (0xFFFFFFFFU)

/* RXIPGERROR */

#define CPSW_STAT_1_RXIPGERROR_COUNT_MASK                (0xFFFFFFFFU)
#define CPSW_STAT_1_RXIPGERROR_COUNT_SHIFT               (0x00000000U)
#define CPSW_STAT_1_RXIPGERROR_COUNT_MAX                 (0xFFFFFFFFU)

/* TXCARRIERSENSEERRORS */

#define CPSW_STAT_1_TXCARRIERSENSEERRORS_COUNT_MASK      (0xFFFFFFFFU)
#define CPSW_STAT_1_TXCARRIERSENSEERRORS_COUNT_SHIFT     (0x00000000U)
#define CPSW_STAT_1_TXCARRIERSENSEERRORS_COUNT_MAX       (0xFFFFFFFFU)

/* TXOCTETS */

#define CPSW_STAT_1_TXOCTETS_COUNT_MASK                  (0xFFFFFFFFU)
#define CPSW_STAT_1_TXOCTETS_COUNT_SHIFT                 (0x00000000U)
#define CPSW_STAT_1_TXOCTETS_COUNT_MAX                   (0xFFFFFFFFU)

/* OCTETFRAMES64 */

#define CPSW_STAT_1_OCTETFRAMES64_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_1_OCTETFRAMES64_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_1_OCTETFRAMES64_COUNT_MAX              (0xFFFFFFFFU)

/* OCTETFRAMES65T127 */

#define CPSW_STAT_1_OCTETFRAMES65T127_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_OCTETFRAMES65T127_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_OCTETFRAMES65T127_COUNT_MAX          (0xFFFFFFFFU)

/* OCTETFRAMES128T255 */

#define CPSW_STAT_1_OCTETFRAMES128T255_COUNT_MASK        (0xFFFFFFFFU)
#define CPSW_STAT_1_OCTETFRAMES128T255_COUNT_SHIFT       (0x00000000U)
#define CPSW_STAT_1_OCTETFRAMES128T255_COUNT_MAX         (0xFFFFFFFFU)

/* OCTETFRAMES256T511 */

#define CPSW_STAT_1_OCTETFRAMES256T511_COUNT_MASK        (0xFFFFFFFFU)
#define CPSW_STAT_1_OCTETFRAMES256T511_COUNT_SHIFT       (0x00000000U)
#define CPSW_STAT_1_OCTETFRAMES256T511_COUNT_MAX         (0xFFFFFFFFU)

/* OCTETFRAMES512T1023 */

#define CPSW_STAT_1_OCTETFRAMES512T1023_COUNT_MASK       (0xFFFFFFFFU)
#define CPSW_STAT_1_OCTETFRAMES512T1023_COUNT_SHIFT      (0x00000000U)
#define CPSW_STAT_1_OCTETFRAMES512T1023_COUNT_MAX        (0xFFFFFFFFU)

/* OCTETFRAMES1024TUP */

#define CPSW_STAT_1_OCTETFRAMES1024TUP_COUNT_MASK        (0xFFFFFFFFU)
#define CPSW_STAT_1_OCTETFRAMES1024TUP_COUNT_SHIFT       (0x00000000U)
#define CPSW_STAT_1_OCTETFRAMES1024TUP_COUNT_MAX         (0xFFFFFFFFU)

/* NETOCTETS */

#define CPSW_STAT_1_NETOCTETS_COUNT_MASK                 (0xFFFFFFFFU)
#define CPSW_STAT_1_NETOCTETS_COUNT_SHIFT                (0x00000000U)
#define CPSW_STAT_1_NETOCTETS_COUNT_MAX                  (0xFFFFFFFFU)

/* RX_BOTTOM_OF_FIFO_DROP */

#define CPSW_STAT_1_RX_BOTTOM_OF_FIFO_DROP_COUNT_MASK    (0xFFFFFFFFU)
#define CPSW_STAT_1_RX_BOTTOM_OF_FIFO_DROP_COUNT_SHIFT   (0x00000000U)
#define CPSW_STAT_1_RX_BOTTOM_OF_FIFO_DROP_COUNT_MAX     (0xFFFFFFFFU)

/* PORTMASK_DROP */

#define CPSW_STAT_1_PORTMASK_DROP_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_1_PORTMASK_DROP_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_1_PORTMASK_DROP_COUNT_MAX              (0xFFFFFFFFU)

/* RX_TOP_OF_FIFO_DROP */

#define CPSW_STAT_1_RX_TOP_OF_FIFO_DROP_COUNT_MASK       (0xFFFFFFFFU)
#define CPSW_STAT_1_RX_TOP_OF_FIFO_DROP_COUNT_SHIFT      (0x00000000U)
#define CPSW_STAT_1_RX_TOP_OF_FIFO_DROP_COUNT_MAX        (0xFFFFFFFFU)

/* ALE_RATE_LIMIT_DROP */

#define CPSW_STAT_1_ALE_RATE_LIMIT_DROP_COUNT_MASK       (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_RATE_LIMIT_DROP_COUNT_SHIFT      (0x00000000U)
#define CPSW_STAT_1_ALE_RATE_LIMIT_DROP_COUNT_MAX        (0xFFFFFFFFU)

/* ALE_VID_INGRESS_DROP */

#define CPSW_STAT_1_ALE_VID_INGRESS_DROP_COUNT_MASK      (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_VID_INGRESS_DROP_COUNT_SHIFT     (0x00000000U)
#define CPSW_STAT_1_ALE_VID_INGRESS_DROP_COUNT_MAX       (0xFFFFFFFFU)

/* ALE_DA_EQ_SA_DROP */

#define CPSW_STAT_1_ALE_DA_EQ_SA_DROP_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_DA_EQ_SA_DROP_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_ALE_DA_EQ_SA_DROP_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_BLOCK_DROP */

#define CPSW_STAT_1_ALE_BLOCK_DROP_COUNT_MASK            (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_BLOCK_DROP_COUNT_SHIFT           (0x00000000U)
#define CPSW_STAT_1_ALE_BLOCK_DROP_COUNT_MAX             (0xFFFFFFFFU)

/* ALE_SECURE_DROP */

#define CPSW_STAT_1_ALE_SECURE_DROP_COUNT_MASK           (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_SECURE_DROP_COUNT_SHIFT          (0x00000000U)
#define CPSW_STAT_1_ALE_SECURE_DROP_COUNT_MAX            (0xFFFFFFFFU)

/* ALE_AUTH_DROP */

#define CPSW_STAT_1_ALE_AUTH_DROP_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_AUTH_DROP_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_1_ALE_AUTH_DROP_COUNT_MAX              (0xFFFFFFFFU)

/* ALE_UNKN_UNI */

#define CPSW_STAT_1_ALE_UNKN_UNI_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_UNKN_UNI_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_1_ALE_UNKN_UNI_COUNT_MAX               (0xFFFFFFFFU)

/* ALE_UNKN_UNI_BCNT */

#define CPSW_STAT_1_ALE_UNKN_UNI_BCNT_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_UNKN_UNI_BCNT_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_ALE_UNKN_UNI_BCNT_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_UNKN_MLT */

#define CPSW_STAT_1_ALE_UNKN_MLT_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_UNKN_MLT_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_1_ALE_UNKN_MLT_COUNT_MAX               (0xFFFFFFFFU)

/* ALE_UNKN_MLT_BCNT */

#define CPSW_STAT_1_ALE_UNKN_MLT_BCNT_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_UNKN_MLT_BCNT_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_ALE_UNKN_MLT_BCNT_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_UNKN_BRD */

#define CPSW_STAT_1_ALE_UNKN_BRD_COUNT_MASK              (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_UNKN_BRD_COUNT_SHIFT             (0x00000000U)
#define CPSW_STAT_1_ALE_UNKN_BRD_COUNT_MAX               (0xFFFFFFFFU)

/* ALE_UNKN_BRD_BCNT */

#define CPSW_STAT_1_ALE_UNKN_BRD_BCNT_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_UNKN_BRD_BCNT_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_ALE_UNKN_BRD_BCNT_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_POL_MATCH */

#define CPSW_STAT_1_ALE_POL_MATCH_COUNT_MASK             (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_POL_MATCH_COUNT_SHIFT            (0x00000000U)
#define CPSW_STAT_1_ALE_POL_MATCH_COUNT_MAX              (0xFFFFFFFFU)

/* ALE_POL_MATCH_RED */

#define CPSW_STAT_1_ALE_POL_MATCH_RED_COUNT_MASK         (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_POL_MATCH_RED_COUNT_SHIFT        (0x00000000U)
#define CPSW_STAT_1_ALE_POL_MATCH_RED_COUNT_MAX          (0xFFFFFFFFU)

/* ALE_POL_MATCH_YELLOW */

#define CPSW_STAT_1_ALE_POL_MATCH_YELLOW_COUNT_MASK      (0xFFFFFFFFU)
#define CPSW_STAT_1_ALE_POL_MATCH_YELLOW_COUNT_SHIFT     (0x00000000U)
#define CPSW_STAT_1_ALE_POL_MATCH_YELLOW_COUNT_MAX       (0xFFFFFFFFU)

/* TX_MEMORY_PROTECT_ERROR */

#define CPSW_STAT_1_TX_MEMORY_PROTECT_ERROR_COUNT_MASK   (0x000000FFU)
#define CPSW_STAT_1_TX_MEMORY_PROTECT_ERROR_COUNT_SHIFT  (0x00000000U)
#define CPSW_STAT_1_TX_MEMORY_PROTECT_ERROR_COUNT_MAX    (0x000000FFU)

/* ENET_PN_TX_PRI_REG */

#define CPSW_STAT_1_ENET_PN_TX_PRI_REG_PN_TX_PRIN_MASK   (0xFFFFFFFFU)
#define CPSW_STAT_1_ENET_PN_TX_PRI_REG_PN_TX_PRIN_SHIFT  (0x00000000U)
#define CPSW_STAT_1_ENET_PN_TX_PRI_REG_PN_TX_PRIN_MAX    (0xFFFFFFFFU)

/* ENET_PN_TX_PRI_BCNT_REG */

#define CPSW_STAT_1_ENET_PN_TX_PRI_BCNT_REG_PN_TX_PRIN_BCNT_MASK (0xFFFFFFFFU)
#define CPSW_STAT_1_ENET_PN_TX_PRI_BCNT_REG_PN_TX_PRIN_BCNT_SHIFT (0x00000000U)
#define CPSW_STAT_1_ENET_PN_TX_PRI_BCNT_REG_PN_TX_PRIN_BCNT_MAX (0xFFFFFFFFU)

/* ENET_PN_TX_PRI_DROP_REG */

#define CPSW_STAT_1_ENET_PN_TX_PRI_DROP_REG_PN_TX_PRIN_DROP_MASK (0xFFFFFFFFU)
#define CPSW_STAT_1_ENET_PN_TX_PRI_DROP_REG_PN_TX_PRIN_DROP_SHIFT (0x00000000U)
#define CPSW_STAT_1_ENET_PN_TX_PRI_DROP_REG_PN_TX_PRIN_DROP_MAX (0xFFFFFFFFU)

/* ENET_PN_TX_PRI_DROP_BCNT_REG */

#define CPSW_STAT_1_ENET_PN_TX_PRI_DROP_BCNT_REG_PN_TX_PRIN_DROP_BCNT_MASK (0xFFFFFFFFU)
#define CPSW_STAT_1_ENET_PN_TX_PRI_DROP_BCNT_REG_PN_TX_PRIN_DROP_BCNT_SHIFT (0x00000000U)
#define CPSW_STAT_1_ENET_PN_TX_PRI_DROP_BCNT_REG_PN_TX_PRIN_DROP_BCNT_MAX (0xFFFFFFFFU)


#ifdef __cplusplus
}
#endif
#endif  /* HW_CPSW_STATS_H_ */
