/*
*
* Copyright (c) 2022 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* any redistribution and use are licensed by TI for use only with TI Devices.
*
* Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

/**
 *
 * \file  Fls_NOR_s25fl128sa.h
 *
 *
 *****************************************************************************/
#ifndef FLS_NOR_S25FL128SA_H_
#define FLS_NOR_S25FL128SA_H_

/**************************************************************************
                            Macro Definitions
 **************************************************************************/

#define NOR_CMD_RDID              (0x9FU)
#define NOR_CMD_SINGLE_READ       (0x03U)
#define NOR_CMD_QUAD_READ         (0x6BU)
#define NOR_PAGE_PROG             (0x02U)
#define NOR_CMD_RSTEN             (0x66U)
#define NOR_CMD_RST               (0x99U)
#define NOR_RDID_NUM_BYTES        (0x3U)
#define NOR_MANF_ID               (0x1U)
#define NOR_DEVICE_ID             (0x2018U)
#define NOR_CMD_WREN              (0x06U)
#define NOR_CMD_WRR               (0x01U)
#define NOR_CMD_RDSR1             (0x05U)
#define NOR_CMD_RDCR              (0x35U)
#define NOR_CMD_RDSR2             (0x07U)
#define NOR_CMD_SECTOR_ERASE      (0x20U)
#define NOR_CMD_BLOCK_ERASE       (0xD8U)
#define NOR_CMD_BULK_ERASE        (0x60U)
#define NOR_QUAD_READ_DUMMY_CYCLE (8U)
#define NOR_BULK_ERASE_TIMEOUT    ((165U * 1000U * 1000U))
#define NOR_WRR_WRITE_TIMEOUT     ((600U * 1000U))
#define NOR_PAGE_PROG_TIMEOUT     (400U)
#define NOR_PAGE_SIZE             (256U)
#define NOR_ADDR_NUM_BYTES        (3)

#define NOR_SIZE                  (16U * 1024U * 1024U)
#define NOR_SECTOR_SIZE            (4U * 1024U)
#define NOR_BLOCK_SIZE             (64U * 1024U)
#define FLASH_PAGE_SIZE             (256U)
#define FLASH_NUM_BLOCKS            (NOR_SIZE / NOR_SECTOR_SIZE)
#define FLASH_NUM_PAGES_PER_BLOCK   (NOR_SECTOR_SIZE / FLASH_PAGE_SIZE)
#define NOR_ERASED_DATA              (0xFF)
#define FLS_QE_BIT                      (1)
#endif /* S25FL128SA_H_ */

/* Nothing past this point */
