/* ======================================================================
 *   Copyright (C) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Gpt_Irq.h
 *
 *  \brief    This file contains ISR function declaration for GPT MCAL driver
 *
 */

/**
 *  \ingroup MCAL_GPT_API
 *  @{
 */

#ifndef GPT_IRQ_H_
#define GPT_IRQ_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "Gpt.h"

#if (GPT_ISR_TYPE == GPT_ISR_CAT2)
#include "Os.h"
#endif
#ifdef __cplusplus
extern "C"
{
#endif

/*********************************************************************************************************************
 * INCLUDES
 ********************************************************************************************************************/

/********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 ********************************************************************************************************************/

/* Version identification */
#define GPT_IRQ_MAJOR_VERSION    (8U)
#define GPT_IRQ_MINOR_VERSION    (6U)
#define GPT_IRQ_PATCH_VERSION    (2U)


#define CHANNEL_MODES  2U    
/**********************************************************************************************************************
 *  GLOBAL FUNCTION MACROS
 *********************************************************************************************************************/

/**********************************************************************************************************************
 *  GLOBAL DATA TYPES AND STRUCTURES
 *********************************************************************************************************************/
/**
 *  \name GPT Driver ISR category level
 *
 *  Defines for GPT Driver ISR ISR category level
 *  @{
 */
/** \brief void ISR type */
#define GPT_ISR_VOID                    (0x00U)
/** \brief Category 1 ISR type */
#define GPT_ISR_CAT1                    (0x01U)
/** \brief Category 2 ISR type */
#define GPT_ISR_CAT2                    (0x02U)
/* @} */

/** \brief Typedef for the ISR Function Array */
typedef void(*Gpt_IsrRefType)(uint32 channel );

/**********************************************************************************************************************
 *  GLOBAL DATA PROTOTYPES
 *********************************************************************************************************************/

/** \brief The Index for the ISR_Function Array*/
extern VAR (uint32, GPT_DATA) Gpt_IsrIndex[GPT_RTI_MAX];

/** \brief The Index for the notification Function Array*/
extern CONST (Gpt_IsrRefType, GPT_CONST) Gpt_IsrNotifyFunctions[CHANNEL_MODES];

/**********************************************************************************************************************
 *  GLOBAL FUNCTION PROTOTYPES
 *********************************************************************************************************************/

/** \brief Interrupt Functions */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 0 interrupt service routine */
   void Gpt_Ch0Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch0Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 1 interrupt service routine */
   void Gpt_Ch1Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch1Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 2 interrupt service routine */
   void Gpt_Ch2Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch2Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 3 interrupt service routine */
   void Gpt_Ch3Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch3Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 4 interrupt service routine */
   void Gpt_Ch4Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch4Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 5 interrupt service routine */
   void Gpt_Ch5Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch5Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 6 interrupt service routine */
   void Gpt_Ch6Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch6Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 7 interrupt service routine */
   void Gpt_Ch7Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch7Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 8 interrupt service routine */
   void Gpt_Ch8Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch8Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 9 interrupt service routine */
   void Gpt_Ch9Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch9Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 10 interrupt service routine */
   void Gpt_Ch10Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch10Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 11 interrupt service routine */
   void Gpt_Ch11Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch11Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 12 interrupt service routine */
   void Gpt_Ch12Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch12Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 13 interrupt service routine */
   void Gpt_Ch13Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch13Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 14 interrupt service routine */
   void Gpt_Ch14Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch14Isr );
#endif /* GPT_ISR_TYPE */

#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
    /** \brief Channel 15 interrupt service routine */
   void Gpt_Ch15Isr( void );
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
   ISR( Gpt_Ch15Isr );
#endif /* GPT_ISR_TYPE */

/** \brief  Continuous notification ISR */
FUNC(void, GPT_CODE) Gpt_NotifContIsr( Gpt_ChannelType Channel);
/** \brief Singleshot notification ISR */
FUNC(void, GPT_CODE) Gpt_NotifSingleIsr( Gpt_ChannelType Channel);

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef GPT_IRQ_H_ */

/* @} */

