#define GPT_IRQ_SOURCE

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
/* Requirements : SWS_Gpt_00261 */

#include "Std_Types.h"
#include "Gpt.h"
#include "Gpt_Irq.h"




/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/

#if (   (GPT_IRQ_MAJOR_VERSION != (8U)) \
     || (GPT_IRQ_MINOR_VERSION != (6U)))
  #error "Version numbers of Gpt_Irq.c and Gpt_Irq.h are inconsistent!"
#endif

#define GPT_START_SEC_ISR_CODE
/*LDRA_INSPECTED 243 S : MISRAC_2012_D.4.10
 * "Reason - Memmap file cannot have include guard w.r.o autosar spec " */
#include "Gpt_MemMap.h"

/**********************************************************************************************************************
    Function name:  Gpt_Ch0Isr
    Description: The Channel0 Interrupt Subroutine calls Notification function depending on the channel mode.
    If Gpt_IsrIndex[0] = GPT_CH_MODE_CONTINUOUS, the Function called is Gpt_NotifContIsr
    If Gpt_IsrIndex[0] = GPT_CH_MODE_ONESHOT, the Function called is Gpt_NotifSingleIsr
    If Gpt_IsrIndex[0] = GPT_CH_MODE_CONT_WAKEUP, the Function called is Gpt_WakeupContIsr
    If Gpt_IsrIndex[0] = GPT_CH_MODE_ONESHOT_WAKEUP, the Function called is Gpt_WakeupSingleIsr
**********************************************************************************************************************/
/*LDRA_INSPECTED 76 D : MISRAC_2012_R.2.1
 * "Reason - ISR is registered in application and called by dispatcher" */
#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch0Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch0Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[0U]]( 0U );
}
/**********************************************************************************************************************
   Function name:  Gpt_Ch1Isr
   Description: The Channel1 Interrupt Subroutine calls Notification function depending on the channel mode.
    If Gpt_IsrIndex[1] = GPT_CH_MODE_CONTINUOUS, the Function called is Gpt_NotifContIsr
    If Gpt_IsrIndex[1] = GPT_CH_MODE_ONESHOT, the Function called is Gpt_NotifSingleIsr
    If Gpt_IsrIndex[1] = GPT_CH_MODE_CONT_WAKEUP, the Function called is Gpt_WakeupContIsr
    If Gpt_IsrIndex[1] = GPT_CH_MODE_ONESHOT_WAKEUP, the Function called is Gpt_WakeupSingleIsr
 **********************************************************************************************************************/
/*LDRA_INSPECTED 76 D : MISRAC_2012_R.2.1
 * "Reason - ISR is registered in application and called by dispatcher" */
#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch1Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch1Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[1U]]( 1U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch2Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch2Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[2U]]( 2U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch3Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch3Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[3U]]( 3U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch4Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch4Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[4U]]( 4U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch5Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch5Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[5U]]( 5U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch6Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch6Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[6U]]( 6U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch7Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch7Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[7U]]( 7U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch8Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch8Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[8U]]( 8U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch9Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch9Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[9U]]( 9U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch10Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch10Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[10U]]( 10U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch11Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch11Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[11U]]( 11U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch12Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch12Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[12U]]( 12U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch13Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch13Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[13U]]( 13U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch14Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch14Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[14U]]( 14U );
}

#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((GPT_ISR_TYPE == GPT_ISR_CAT1) || (GPT_ISR_TYPE == GPT_ISR_VOID))
void Gpt_Ch15Isr( void )
#elif (GPT_ISR_TYPE == GPT_ISR_CAT2)
ISR( Gpt_Ch15Isr )
#endif
{
   Gpt_IsrNotifyFunctions[Gpt_IsrIndex[15U]]( 15U );
}

/*LDRA_INSPECTED 338 S : MISRAC_2012_R.20.1
 * "Reason - Required to comply with AUTOSAR memmap spec " */
#define GPT_STOP_SEC_ISR_CODE
#include "Gpt_MemMap.h"


