/*
*
* Copyright (c) 2023 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

/**
 *  \file     Cdd_I2c_hw_reg.h
 *
 *  \brief    This file contains all the I2C register offset addresses and mask values
 *
 */

#ifndef CDD_I2C_HW_REG_H_
#define CDD_I2C_HW_REG_H_

/* ================================================================ */
/*                             Include Files                        */
/* ================================================================ */

/*None*/


/**************************************************************************
* Register Macros
**************************************************************************/

#define CDD_I2C_ICOAR                                                     (0x00000000U)
#define CDD_I2C_ICIMR                                                     (0x00000004U)
#define CDD_I2C_ICSTR                                                     (0x00000008U)
#define CDD_I2C_ICCLKL                                                    (0x0000000CU)
#define CDD_I2C_ICCLKH                                                    (0x00000010U)
#define CDD_I2C_ICCNT                                                     (0x00000014U)
#define CDD_I2C_ICDRR                                                     (0x00000018U)
#define CDD_I2C_ICSAR                                                     (0x0000001CU)
#define CDD_I2C_ICDXR                                                     (0x00000020U)
#define CDD_I2C_ICMDR                                                     (0x00000024U)
#define CDD_I2C_ICIVR                                                     (0x00000028U)
#define CDD_I2C_ICEMDR                                                    (0x0000002CU)
#define CDD_I2C_ICPSC                                                     (0x00000030U)
#define CDD_I2C_ICPID1                                                    (0x00000034U)
#define CDD_I2C_ICPID2                                                    (0x00000038U)
#define CDD_I2C_ICDMAC                                                    (0x0000003CU)
#define CDD_I2C_I2C_RESERVED1                                             (0x00000040U)
#define CDD_I2C_I2C_RESERVED2                                             (0x00000044U)
#define CDD_I2C_ICPFUNC                                                   (0x00000048U)
#define CDD_I2C_ICPDIR                                                    (0x0000004CU)
#define CDD_I2C_ICPDIN                                                    (0x00000050U)
#define CDD_I2C_ICPDOUT                                                   (0x00000054U)
#define CDD_I2C_ICPDSET                                                   (0x00000058U)
#define CDD_I2C_ICPDCLR                                                   (0x0000005CU)
#define CDD_I2C_ICPDRV                                                    (0x00000060U)

/**************************************************************************
* Field Definition Macros
**************************************************************************/


/* ICOAR */

#define CDD_I2C_ICOAR_OADDR_MASK                                          (0x000003FFU)
#define CDD_I2C_ICOAR_OADDR_SHIFT                                         (0x00000000U)
#define CDD_I2C_ICOAR_OADDR_RESETVAL                                      (0x00000000U)
#define CDD_I2C_ICOAR_OADDR_MAX                                           (0x000003FFU)

#define CDD_I2C_ICOAR_NU_MASK                                             (0xFFFFFC00U)
#define CDD_I2C_ICOAR_NU_SHIFT                                            (0x0000000AU)
#define CDD_I2C_ICOAR_NU_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICOAR_NU_MAX                                              (0x003FFFFFU)

#define CDD_I2C_ICOAR_RESETVAL                                            (0x00000000U)

/* ICIMR */

#define CDD_I2C_ICIMR_AL_MASK                                             (0x00000001U)
#define CDD_I2C_ICIMR_AL_SHIFT                                            (0x00000000U)
#define CDD_I2C_ICIMR_AL_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICIMR_AL_MAX                                              (0x00000001U)

/*----AL Tokens----*/
#define CDD_I2C_ICIMR_AL_DISABLE                                          (0x00000000U)
#define CDD_I2C_ICIMR_AL_ENABLE                                           (0x00000001U)

#define CDD_I2C_ICIMR_NACK_MASK                                           (0x00000002U)
#define CDD_I2C_ICIMR_NACK_SHIFT                                          (0x00000001U)
#define CDD_I2C_ICIMR_NACK_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICIMR_NACK_MAX                                            (0x00000001U)

/*----NACK Tokens----*/
#define CDD_I2C_ICIMR_NACK_DISABLE                                        (0x00000000U)
#define CDD_I2C_ICIMR_NACK_ENABLE                                         (0x00000001U)

#define CDD_I2C_ICIMR_ARDY_MASK                                           (0x00000004U)
#define CDD_I2C_ICIMR_ARDY_SHIFT                                          (0x00000002U)
#define CDD_I2C_ICIMR_ARDY_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICIMR_ARDY_MAX                                            (0x00000001U)

/*----ARDY Tokens----*/
#define CDD_I2C_ICIMR_ARDY_DISABLE                                        (0x00000000U)
#define CDD_I2C_ICIMR_ARDY_ENABLE                                         (0x00000001U)

#define CDD_I2C_ICIMR_ICRRDY_MASK                                         (0x00000008U)
#define CDD_I2C_ICIMR_ICRRDY_SHIFT                                        (0x00000003U)
#define CDD_I2C_ICIMR_ICRRDY_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICIMR_ICRRDY_MAX                                          (0x00000001U)

/*----ICRRDY Tokens----*/
#define CDD_I2C_ICIMR_ICRRDY_DISABLE                                      (0x00000000U)
#define CDD_I2C_ICIMR_ICRRDY_ENABLE                                       (0x00000001U)

#define CDD_I2C_ICIMR_ICXRDY_MASK                                         (0x00000010U)
#define CDD_I2C_ICIMR_ICXRDY_SHIFT                                        (0x00000004U)
#define CDD_I2C_ICIMR_ICXRDY_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICIMR_ICXRDY_MAX                                          (0x00000001U)

/*----ICXRDY Tokens----*/
#define CDD_I2C_ICIMR_ICXRDY_DISABLE                                      (0x00000000U)
#define CDD_I2C_ICIMR_ICXRDY_ENABLE                                       (0x00000001U)

#define CDD_I2C_ICIMR_SCD_MASK                                            (0x00000020U)
#define CDD_I2C_ICIMR_SCD_SHIFT                                           (0x00000005U)
#define CDD_I2C_ICIMR_SCD_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICIMR_SCD_MAX                                             (0x00000001U)

/*----SCD Tokens----*/
#define CDD_I2C_ICIMR_SCD_DISABLE                                         (0x00000000U)
#define CDD_I2C_ICIMR_SCD_ENABLE                                          (0x00000001U)

#define CDD_I2C_ICIMR_AAS_MASK                                            (0x00000040U)
#define CDD_I2C_ICIMR_AAS_SHIFT                                           (0x00000006U)
#define CDD_I2C_ICIMR_AAS_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICIMR_AAS_MAX                                             (0x00000001U)

/*----AAS Tokens----*/
#define CDD_I2C_ICIMR_AAS_DISABLE                                         (0x00000000U)
#define CDD_I2C_ICIMR_AAS_ENABLE                                          (0x00000001U)

#define CDD_I2C_ICIMR_NU_MASK                                             (0xFFFFFF80U)
#define CDD_I2C_ICIMR_NU_SHIFT                                            (0x00000007U)
#define CDD_I2C_ICIMR_NU_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICIMR_NU_MAX                                              (0x01FFFFFFU)

#define CDD_I2C_ICIMR_RESETVAL                                            (0x00000000U)

/* ICSTR */

#define CDD_I2C_ICSTR_AL_MASK                                             (0x00000001U)
#define CDD_I2C_ICSTR_AL_SHIFT                                            (0x00000000U)
#define CDD_I2C_ICSTR_AL_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICSTR_AL_MAX                                              (0x00000001U)

#define CDD_I2C_ICSTR_NACK_MASK                                           (0x00000002U)
#define CDD_I2C_ICSTR_NACK_SHIFT                                          (0x00000001U)
#define CDD_I2C_ICSTR_NACK_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICSTR_NACK_MAX                                            (0x00000001U)

#define CDD_I2C_ICSTR_ARDY_MASK                                           (0x00000004U)
#define CDD_I2C_ICSTR_ARDY_SHIFT                                          (0x00000002U)
#define CDD_I2C_ICSTR_ARDY_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICSTR_ARDY_MAX                                            (0x00000001U)

#define CDD_I2C_ICSTR_ICRRDY_MASK                                         (0x00000008U)
#define CDD_I2C_ICSTR_ICRRDY_SHIFT                                        (0x00000003U)
#define CDD_I2C_ICSTR_ICRRDY_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICSTR_ICRRDY_MAX                                          (0x00000001U)

#define CDD_I2C_ICSTR_ICXRDY_MASK                                         (0x00000010U)
#define CDD_I2C_ICSTR_ICXRDY_SHIFT                                        (0x00000004U)
#define CDD_I2C_ICSTR_ICXRDY_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICSTR_ICXRDY_MAX                                          (0x00000001U)

#define CDD_I2C_ICSTR_SCD_MASK                                            (0x00000020U)
#define CDD_I2C_ICSTR_SCD_SHIFT                                           (0x00000005U)
#define CDD_I2C_ICSTR_SCD_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICSTR_SCD_MAX                                             (0x00000001U)

#define CDD_I2C_ICSTR_NU1_MASK                                            (0x000000C0U)
#define CDD_I2C_ICSTR_NU1_SHIFT                                           (0x00000006U)
#define CDD_I2C_ICSTR_NU1_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICSTR_NU1_MAX                                             (0x00000003U)

#define CDD_I2C_ICSTR_AD0_MASK                                            (0x00000100U)
#define CDD_I2C_ICSTR_AD0_SHIFT                                           (0x00000008U)
#define CDD_I2C_ICSTR_AD0_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICSTR_AD0_MAX                                             (0x00000001U)

#define CDD_I2C_ICSTR_AAS_MASK                                            (0x00000200U)
#define CDD_I2C_ICSTR_AAS_SHIFT                                           (0x00000009U)
#define CDD_I2C_ICSTR_AAS_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICSTR_AAS_MAX                                             (0x00000001U)

#define CDD_I2C_ICSTR_XSMT_MASK                                           (0x00000400U)
#define CDD_I2C_ICSTR_XSMT_SHIFT                                          (0x0000000AU)
#define CDD_I2C_ICSTR_XSMT_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICSTR_XSMT_MAX                                            (0x00000001U)

#define CDD_I2C_ICSTR_RSFULL_MASK                                         (0x00000800U)
#define CDD_I2C_ICSTR_RSFULL_SHIFT                                        (0x0000000BU)
#define CDD_I2C_ICSTR_RSFULL_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICSTR_RSFULL_MAX                                          (0x00000001U)

#define CDD_I2C_ICSTR_BB_MASK                                             (0x00001000U)
#define CDD_I2C_ICSTR_BB_SHIFT                                            (0x0000000CU)
#define CDD_I2C_ICSTR_BB_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICSTR_BB_MAX                                              (0x00000001U)

#define CDD_I2C_ICSTR_NACKSNT_MASK                                        (0x00002000U)
#define CDD_I2C_ICSTR_NACKSNT_SHIFT                                       (0x0000000DU)
#define CDD_I2C_ICSTR_NACKSNT_RESETVAL                                    (0x00000000U)
#define CDD_I2C_ICSTR_NACKSNT_MAX                                         (0x00000001U)

#define CDD_I2C_ICSTR_SDIR_MASK                                           (0x00004000U)
#define CDD_I2C_ICSTR_SDIR_SHIFT                                          (0x0000000EU)
#define CDD_I2C_ICSTR_SDIR_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICSTR_SDIR_MAX                                            (0x00000001U)

#define CDD_I2C_ICSTR_NU2_MASK                                            (0xFFFF8000U)
#define CDD_I2C_ICSTR_NU2_SHIFT                                           (0x0000000FU)
#define CDD_I2C_ICSTR_NU2_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICSTR_NU2_MAX                                             (0x0001FFFFU)

#define CDD_I2C_ICSTR_RESETVAL                                            (0x00000000U)

/* ICCLKL */

#define CDD_I2C_ICCLKL_ICCL_MASK                                          (0x0000FFFFU)
#define CDD_I2C_ICCLKL_ICCL_SHIFT                                         (0x00000000U)
#define CDD_I2C_ICCLKL_ICCL_RESETVAL                                      (0x00000000U)
#define CDD_I2C_ICCLKL_ICCL_MAX                                           (0x0000FFFFU)

#define CDD_I2C_ICCLKL_NU_MASK                                            (0xFFFF0000U)
#define CDD_I2C_ICCLKL_NU_SHIFT                                           (0x00000010U)
#define CDD_I2C_ICCLKL_NU_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICCLKL_NU_MAX                                             (0x0000FFFFU)

#define CDD_I2C_ICCLKL_RESETVAL                                           (0x00000000U)

/* ICCLKH */

#define CDD_I2C_ICCLKH_ICCH_MASK                                          (0x0000FFFFU)
#define CDD_I2C_ICCLKH_ICCH_SHIFT                                         (0x00000000U)
#define CDD_I2C_ICCLKH_ICCH_RESETVAL                                      (0x00000000U)
#define CDD_I2C_ICCLKH_ICCH_MAX                                           (0x0000FFFFU)

#define CDD_I2C_ICCLKH_NU_MASK                                            (0xFFFF0000U)
#define CDD_I2C_ICCLKH_NU_SHIFT                                           (0x00000010U)
#define CDD_I2C_ICCLKH_NU_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICCLKH_NU_MAX                                             (0x0000FFFFU)

#define CDD_I2C_ICCLKH_RESETVAL                                           (0x00000000U)

/* ICCNT */

#define CDD_I2C_ICCNT_ICDC_MASK                                           (0x0000FFFFU)
#define CDD_I2C_ICCNT_ICDC_SHIFT                                          (0x00000000U)
#define CDD_I2C_ICCNT_ICDC_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICCNT_ICDC_MAX                                            (0x0000FFFFU)

#define CDD_I2C_ICCNT_NU_MASK                                             (0xFFFF0000U)
#define CDD_I2C_ICCNT_NU_SHIFT                                            (0x00000010U)
#define CDD_I2C_ICCNT_NU_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICCNT_NU_MAX                                              (0x0000FFFFU)

#define CDD_I2C_ICCNT_RESETVAL                                            (0x00000000U)

/* ICDRR */

#define CDD_I2C_ICDRR_D_MASK                                              (0x000000FFU)
#define CDD_I2C_ICDRR_D_SHIFT                                             (0x00000000U)
#define CDD_I2C_ICDRR_D_RESETVAL                                          (0x00000000U)
#define CDD_I2C_ICDRR_D_MAX                                               (0x000000FFU)

#define CDD_I2C_ICDRR_NU_MASK                                             (0xFFFFFF00U)
#define CDD_I2C_ICDRR_NU_SHIFT                                            (0x00000008U)
#define CDD_I2C_ICDRR_NU_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICDRR_NU_MAX                                              (0x00FFFFFFU)

#define CDD_I2C_ICDRR_RESETVAL                                            (0x00000000U)

/* ICSAR */

#define CDD_I2C_ICSAR_SADDR_MASK                                          (0x000003FFU)
#define CDD_I2C_ICSAR_SADDR_SHIFT                                         (0x00000000U)
#define CDD_I2C_ICSAR_SADDR_RESETVAL                                      (0x00000000U)
#define CDD_I2C_ICSAR_SADDR_MAX                                           (0x000003FFU)

#define CDD_I2C_ICSAR_NU_MASK                                             (0xFFFFFC00U)
#define CDD_I2C_ICSAR_NU_SHIFT                                            (0x0000000AU)
#define CDD_I2C_ICSAR_NU_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICSAR_NU_MAX                                              (0x003FFFFFU)

#define CDD_I2C_ICSAR_RESETVAL                                            (0x00000000U)

/* ICDXR */

#define CDD_I2C_ICDXR_D_MASK                                              (0x000000FFU)
#define CDD_I2C_ICDXR_D_SHIFT                                             (0x00000000U)
#define CDD_I2C_ICDXR_D_RESETVAL                                          (0x00000000U)
#define CDD_I2C_ICDXR_D_MAX                                               (0x000000FFU)

#define CDD_I2C_ICDXR_NU_MASK                                             (0xFFFFFF00U)
#define CDD_I2C_ICDXR_NU_SHIFT                                            (0x00000008U)
#define CDD_I2C_ICDXR_NU_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICDXR_NU_MAX                                              (0x00FFFFFFU)

#define CDD_I2C_ICDXR_RESETVAL                                            (0x00000000U)

/* ICMDR */

#define CDD_I2C_ICMDR_BC_MASK                                             (0x00000007U)
#define CDD_I2C_ICMDR_BC_SHIFT                                            (0x00000000U)
#define CDD_I2C_ICMDR_BC_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICMDR_BC_MAX                                              (0x00000007U)

#define CDD_I2C_ICMDR_FDF_MASK                                            (0x00000008U)
#define CDD_I2C_ICMDR_FDF_SHIFT                                           (0x00000003U)
#define CDD_I2C_ICMDR_FDF_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_FDF_MAX                                             (0x00000001U)

#define CDD_I2C_ICMDR_STB_MASK                                            (0x00000010U)
#define CDD_I2C_ICMDR_STB_SHIFT                                           (0x00000004U)
#define CDD_I2C_ICMDR_STB_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_STB_MAX                                             (0x00000001U)

#define CDD_I2C_ICMDR_IRS_MASK                                            (0x00000020U)
#define CDD_I2C_ICMDR_IRS_SHIFT                                           (0x00000005U)
#define CDD_I2C_ICMDR_IRS_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_IRS_MAX                                             (0x00000001U)

#define CDD_I2C_ICMDR_DLB_MASK                                            (0x00000040U)
#define CDD_I2C_ICMDR_DLB_SHIFT                                           (0x00000006U)
#define CDD_I2C_ICMDR_DLB_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_DLB_MAX                                             (0x00000001U)

#define CDD_I2C_ICMDR_RM_MASK                                             (0x00000080U)
#define CDD_I2C_ICMDR_RM_SHIFT                                            (0x00000007U)
#define CDD_I2C_ICMDR_RM_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICMDR_RM_MAX                                              (0x00000001U)

#define CDD_I2C_ICMDR_XA_MASK                                             (0x00000100U)
#define CDD_I2C_ICMDR_XA_SHIFT                                            (0x00000008U)
#define CDD_I2C_ICMDR_XA_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICMDR_XA_MAX                                              (0x00000001U)

#define CDD_I2C_ICMDR_TRX_MASK                                            (0x00000200U)
#define CDD_I2C_ICMDR_TRX_SHIFT                                           (0x00000009U)
#define CDD_I2C_ICMDR_TRX_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_TRX_MAX                                             (0x00000001U)

#define CDD_I2C_ICMDR_MST_MASK                                            (0x00000400U)
#define CDD_I2C_ICMDR_MST_SHIFT                                           (0x0000000AU)
#define CDD_I2C_ICMDR_MST_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_MST_MAX                                             (0x00000001U)

#define CDD_I2C_ICMDR_STP_MASK                                            (0x00000800U)
#define CDD_I2C_ICMDR_STP_SHIFT                                           (0x0000000BU)
#define CDD_I2C_ICMDR_STP_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_STP_MAX                                             (0x00000001U)

#define CDD_I2C_ICMDR_NU1_MASK                                            (0x00001000U)
#define CDD_I2C_ICMDR_NU1_SHIFT                                           (0x0000000CU)
#define CDD_I2C_ICMDR_NU1_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_NU1_MAX                                             (0x00000001U)

#define CDD_I2C_ICMDR_STT_MASK                                            (0x00002000U)
#define CDD_I2C_ICMDR_STT_SHIFT                                           (0x0000000DU)
#define CDD_I2C_ICMDR_STT_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_STT_MAX                                             (0x00000001U)

#define CDD_I2C_ICMDR_FREE_MASK                                           (0x00004000U)
#define CDD_I2C_ICMDR_FREE_SHIFT                                          (0x0000000EU)
#define CDD_I2C_ICMDR_FREE_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICMDR_FREE_MAX                                            (0x00000001U)

#define CDD_I2C_ICMDR_NACKMOD_MASK                                        (0x00008000U)
#define CDD_I2C_ICMDR_NACKMOD_SHIFT                                       (0x0000000FU)
#define CDD_I2C_ICMDR_NACKMOD_RESETVAL                                    (0x00000000U)
#define CDD_I2C_ICMDR_NACKMOD_MAX                                         (0x00000001U)

#define CDD_I2C_ICMDR_NU2_MASK                                            (0xFFFF0000U)
#define CDD_I2C_ICMDR_NU2_SHIFT                                           (0x00000010U)
#define CDD_I2C_ICMDR_NU2_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICMDR_NU2_MAX                                             (0x0000FFFFU)

#define CDD_I2C_ICMDR_RESETVAL                                            (0x00000000U)

/* ICIVR */

#define CDD_I2C_ICIVR_INTCODE_MASK                                        (0x00000007U)
#define CDD_I2C_ICIVR_INTCODE_SHIFT                                       (0x00000000U)
#define CDD_I2C_ICIVR_INTCODE_RESETVAL                                    (0x00000000U)
#define CDD_I2C_ICIVR_INTCODE_MAX                                         (0x00000007U)

/*----INTCODE Tokens----*/
#define CDD_I2C_ICIVR_INTCODE_NONE                                        (0x00000000U)
#define CDD_I2C_ICIVR_INTCODE_AL                                          (0x00000001U)
#define CDD_I2C_ICIVR_INTCODE_NACK                                        (0x00000002U)
#define CDD_I2C_ICIVR_INTCODE_RAR                                         (0x00000003U)
#define CDD_I2C_ICIVR_INTCODE_RDR                                         (0x00000004U)
#define CDD_I2C_ICIVR_INTCODE_TDR                                         (0x00000005U)
#define CDD_I2C_ICIVR_INTCODE_SCD                                         (0x00000006U)
#define CDD_I2C_ICIVR_INTCODE_AAS                                         (0x00000007U)

#define CDD_I2C_ICIVR_NU1_MASK                                            (0x000000F8U)
#define CDD_I2C_ICIVR_NU1_SHIFT                                           (0x00000003U)
#define CDD_I2C_ICIVR_NU1_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICIVR_NU1_MAX                                             (0x0000001FU)

#define CDD_I2C_ICIVR_TESTMD_MASK                                         (0x00000F00U)
#define CDD_I2C_ICIVR_TESTMD_SHIFT                                        (0x00000008U)
#define CDD_I2C_ICIVR_TESTMD_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICIVR_TESTMD_MAX                                          (0x0000000FU)

#define CDD_I2C_ICIVR_NU2_MASK                                            (0xFFFFF000U)
#define CDD_I2C_ICIVR_NU2_SHIFT                                           (0x0000000CU)
#define CDD_I2C_ICIVR_NU2_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICIVR_NU2_MAX                                             (0x000FFFFFU)

#define CDD_I2C_ICIVR_RESETVAL                                            (0x00000000U)

/* ICEMDR */

#define CDD_I2C_ICEMDR_BCM_MASK                                           (0x00000001U)
#define CDD_I2C_ICEMDR_BCM_SHIFT                                          (0x00000000U)
#define CDD_I2C_ICEMDR_BCM_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICEMDR_BCM_MAX                                            (0x00000001U)

#define CDD_I2C_ICEMDR_IGNACK_MASK                                        (0x00000002U)
#define CDD_I2C_ICEMDR_IGNACK_SHIFT                                       (0x00000001U)
#define CDD_I2C_ICEMDR_IGNACK_RESETVAL                                    (0x00000000U)
#define CDD_I2C_ICEMDR_IGNACK_MAX                                         (0x00000001U)

#define CDD_I2C_ICEMDR_NU_MASK                                            (0xFFFFFFFCU)
#define CDD_I2C_ICEMDR_NU_SHIFT                                           (0x00000002U)
#define CDD_I2C_ICEMDR_NU_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICEMDR_NU_MAX                                             (0x3FFFFFFFU)

#define CDD_I2C_ICEMDR_RESETVAL                                           (0x00000000U)

/* ICPSC */

#define CDD_I2C_ICPSC_IPSC_MASK                                           (0x000000FFU)
#define CDD_I2C_ICPSC_IPSC_SHIFT                                          (0x00000000U)
#define CDD_I2C_ICPSC_IPSC_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICPSC_IPSC_MAX                                            (0x000000FFU)

#define CDD_I2C_ICPSC_NU_MASK                                             (0xFFFFFF00U)
#define CDD_I2C_ICPSC_NU_SHIFT                                            (0x00000008U)
#define CDD_I2C_ICPSC_NU_RESETVAL                                         (0x00000000U)
#define CDD_I2C_ICPSC_NU_MAX                                              (0x00FFFFFFU)

#define CDD_I2C_ICPSC_RESETVAL                                            (0x00000000U)

/* ICPID1 */

#define CDD_I2C_ICPID1_REVISION_MASK                                      (0x000000FFU)
#define CDD_I2C_ICPID1_REVISION_SHIFT                                     (0x00000000U)
#define CDD_I2C_ICPID1_REVISION_RESETVAL                                  (0x00000000U)
#define CDD_I2C_ICPID1_REVISION_MAX                                       (0x000000FFU)

#define CDD_I2C_ICPID1_CLASS_MASK                                         (0x0000FF00U)
#define CDD_I2C_ICPID1_CLASS_SHIFT                                        (0x00000008U)
#define CDD_I2C_ICPID1_CLASS_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICPID1_CLASS_MAX                                          (0x000000FFU)

#define CDD_I2C_ICPID1_NU_MASK                                            (0xFFFF0000U)
#define CDD_I2C_ICPID1_NU_SHIFT                                           (0x00000010U)
#define CDD_I2C_ICPID1_NU_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICPID1_NU_MAX                                             (0x0000FFFFU)

#define CDD_I2C_ICPID1_RESETVAL                                           (0x00000000U)

/* ICPID2 */

#define CDD_I2C_ICPID2_TYPE_MASK                                          (0x000000FFU)
#define CDD_I2C_ICPID2_TYPE_SHIFT                                         (0x00000000U)
#define CDD_I2C_ICPID2_TYPE_RESETVAL                                      (0x00000000U)
#define CDD_I2C_ICPID2_TYPE_MAX                                           (0x000000FFU)

#define CDD_I2C_ICPID2_NU_MASK                                            (0xFFFFFF00U)
#define CDD_I2C_ICPID2_NU_SHIFT                                           (0x00000008U)
#define CDD_I2C_ICPID2_NU_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICPID2_NU_MAX                                             (0x00FFFFFFU)

#define CDD_I2C_ICPID2_RESETVAL                                           (0x00000000U)

/* ICDMAC */

#define CDD_I2C_ICDMAC_RXDMAEN_MASK                                       (0x00000001U)
#define CDD_I2C_ICDMAC_RXDMAEN_SHIFT                                      (0x00000000U)
#define CDD_I2C_ICDMAC_RXDMAEN_RESETVAL                                   (0x00000000U)
#define CDD_I2C_ICDMAC_RXDMAEN_MAX                                        (0x00000001U)

#define CDD_I2C_ICDMAC_TXDMAEN_MASK                                       (0x00000002U)
#define CDD_I2C_ICDMAC_TXDMAEN_SHIFT                                      (0x00000001U)
#define CDD_I2C_ICDMAC_TXDMAEN_RESETVAL                                   (0x00000000U)
#define CDD_I2C_ICDMAC_TXDMAEN_MAX                                        (0x00000001U)

#define CDD_I2C_ICDMAC_NU_MASK                                            (0xFFFFFFFCU)
#define CDD_I2C_ICDMAC_NU_SHIFT                                           (0x00000002U)
#define CDD_I2C_ICDMAC_NU_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICDMAC_NU_MAX                                             (0x3FFFFFFFU)

#define CDD_I2C_ICDMAC_RESETVAL                                           (0x00000000U)

/* I2C_RESERVED1 */

#define CDD_I2C_I2C_RESERVED1_NU_MASK                                     (0xFFFFFFFFU)
#define CDD_I2C_I2C_RESERVED1_NU_SHIFT                                    (0x00000000U)
#define CDD_I2C_I2C_RESERVED1_NU_RESETVAL                                 (0x00000000U)
#define CDD_I2C_I2C_RESERVED1_NU_MAX                                      (0xFFFFFFFFU)

#define CDD_I2C_I2C_RESERVED1_RESETVAL                                    (0x00000000U)

/* I2C_RESERVED2 */

#define CDD_I2C_I2C_RESERVED2_NU_MASK                                     (0xFFFFFFFFU)
#define CDD_I2C_I2C_RESERVED2_NU_SHIFT                                    (0x00000000U)
#define CDD_I2C_I2C_RESERVED2_NU_RESETVAL                                 (0x00000000U)
#define CDD_I2C_I2C_RESERVED2_NU_MAX                                      (0xFFFFFFFFU)

#define CDD_I2C_I2C_RESERVED2_RESETVAL                                    (0x00000000U)

/* ICPFUNC */

#define CDD_I2C_ICPFUNC_PFUNC0_MASK                                       (0x00000001U)
#define CDD_I2C_ICPFUNC_PFUNC0_SHIFT                                      (0x00000000U)
#define CDD_I2C_ICPFUNC_PFUNC0_RESETVAL                                   (0x00000000U)
#define CDD_I2C_ICPFUNC_PFUNC0_MAX                                        (0x00000001U)

#define CDD_I2C_ICPFUNC_NU_MASK                                           (0xFFFFFFFEU)
#define CDD_I2C_ICPFUNC_NU_SHIFT                                          (0x00000001U)
#define CDD_I2C_ICPFUNC_NU_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICPFUNC_NU_MAX                                            (0x7FFFFFFFU)

#define CDD_I2C_ICPFUNC_RESETVAL                                          (0x00000000U)

/* ICPDIR */

#define CDD_I2C_ICPDIR_PDIR0_MASK                                         (0x00000001U)
#define CDD_I2C_ICPDIR_PDIR0_SHIFT                                        (0x00000000U)
#define CDD_I2C_ICPDIR_PDIR0_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICPDIR_PDIR0_MAX                                          (0x00000001U)

#define CDD_I2C_ICPDIR_PDIR1_MASK                                         (0x00000002U)
#define CDD_I2C_ICPDIR_PDIR1_SHIFT                                        (0x00000001U)
#define CDD_I2C_ICPDIR_PDIR1_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICPDIR_PDIR1_MAX                                          (0x00000001U)

#define CDD_I2C_ICPDIR_NU_MASK                                            (0xFFFFFFFCU)
#define CDD_I2C_ICPDIR_NU_SHIFT                                           (0x00000002U)
#define CDD_I2C_ICPDIR_NU_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICPDIR_NU_MAX                                             (0x3FFFFFFFU)

#define CDD_I2C_ICPDIR_RESETVAL                                           (0x00000000U)

/* ICPDIN */

#define CDD_I2C_ICPDIN_PDIN0_MASK                                         (0x00000001U)
#define CDD_I2C_ICPDIN_PDIN0_SHIFT                                        (0x00000000U)
#define CDD_I2C_ICPDIN_PDIN0_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICPDIN_PDIN0_MAX                                          (0x00000001U)

#define CDD_I2C_ICPDIN_PDIN1_MASK                                         (0x00000002U)
#define CDD_I2C_ICPDIN_PDIN1_SHIFT                                        (0x00000001U)
#define CDD_I2C_ICPDIN_PDIN1_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICPDIN_PDIN1_MAX                                          (0x00000001U)

#define CDD_I2C_ICPDIN_NU_MASK                                            (0xFFFFFFFCU)
#define CDD_I2C_ICPDIN_NU_SHIFT                                           (0x00000002U)
#define CDD_I2C_ICPDIN_NU_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICPDIN_NU_MAX                                             (0x3FFFFFFFU)

#define CDD_I2C_ICPDIN_RESETVAL                                           (0x00000000U)

/* ICPDOUT */

#define CDD_I2C_ICPDOUT_PDOUT0_MASK                                       (0x00000001U)
#define CDD_I2C_ICPDOUT_PDOUT0_SHIFT                                      (0x00000000U)
#define CDD_I2C_ICPDOUT_PDOUT0_RESETVAL                                   (0x00000000U)
#define CDD_I2C_ICPDOUT_PDOUT0_MAX                                        (0x00000001U)

#define CDD_I2C_ICPDOUT_PDOUT1_MASK                                       (0x00000002U)
#define CDD_I2C_ICPDOUT_PDOUT1_SHIFT                                      (0x00000001U)
#define CDD_I2C_ICPDOUT_PDOUT1_RESETVAL                                   (0x00000000U)
#define CDD_I2C_ICPDOUT_PDOUT1_MAX                                        (0x00000001U)

#define CDD_I2C_ICPDOUT_NU_MASK                                           (0xFFFFFFFCU)
#define CDD_I2C_ICPDOUT_NU_SHIFT                                          (0x00000002U)
#define CDD_I2C_ICPDOUT_NU_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICPDOUT_NU_MAX                                            (0x3FFFFFFFU)

#define CDD_I2C_ICPDOUT_RESETVAL                                          (0x00000000U)

/* ICPDSET */

#define CDD_I2C_ICPDSET_PDSET0_MASK                                       (0x00000001U)
#define CDD_I2C_ICPDSET_PDSET0_SHIFT                                      (0x00000000U)
#define CDD_I2C_ICPDSET_PDSET0_RESETVAL                                   (0x00000000U)
#define CDD_I2C_ICPDSET_PDSET0_MAX                                        (0x00000001U)

#define CDD_I2C_ICPDSET_PDSET1_MASK                                       (0x00000002U)
#define CDD_I2C_ICPDSET_PDSET1_SHIFT                                      (0x00000001U)
#define CDD_I2C_ICPDSET_PDSET1_RESETVAL                                   (0x00000000U)
#define CDD_I2C_ICPDSET_PDSET1_MAX                                        (0x00000001U)

#define CDD_I2C_ICPDSET_NU_MASK                                           (0xFFFFFFFCU)
#define CDD_I2C_ICPDSET_NU_SHIFT                                          (0x00000002U)
#define CDD_I2C_ICPDSET_NU_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICPDSET_NU_MAX                                            (0x3FFFFFFFU)

#define CDD_I2C_ICPDSET_RESETVAL                                          (0x00000000U)

/* ICPDCLR */

#define CDD_I2C_ICPDCLR_PDCLR0_MASK                                       (0x00000001U)
#define CDD_I2C_ICPDCLR_PDCLR0_SHIFT                                      (0x00000000U)
#define CDD_I2C_ICPDCLR_PDCLR0_RESETVAL                                   (0x00000000U)
#define CDD_I2C_ICPDCLR_PDCLR0_MAX                                        (0x00000001U)

#define CDD_I2C_ICPDCLR_PDCLR1_MASK                                       (0x00000002U)
#define CDD_I2C_ICPDCLR_PDCLR1_SHIFT                                      (0x00000001U)
#define CDD_I2C_ICPDCLR_PDCLR1_RESETVAL                                   (0x00000000U)
#define CDD_I2C_ICPDCLR_PDCLR1_MAX                                        (0x00000001U)

#define CDD_I2C_ICPDCLR_NU_MASK                                           (0xFFFFFFFCU)
#define CDD_I2C_ICPDCLR_NU_SHIFT                                          (0x00000002U)
#define CDD_I2C_ICPDCLR_NU_RESETVAL                                       (0x00000000U)
#define CDD_I2C_ICPDCLR_NU_MAX                                            (0x3FFFFFFFU)

#define CDD_I2C_ICPDCLR_RESETVAL                                          (0x00000000U)

/* ICPDRV */

#define CDD_I2C_ICPDRV_PDRV0_MASK                                         (0x00000001U)
#define CDD_I2C_ICPDRV_PDRV0_SHIFT                                        (0x00000000U)
#define CDD_I2C_ICPDRV_PDRV0_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICPDRV_PDRV0_MAX                                          (0x00000001U)

#define CDD_I2C_ICPDRV_PDRV1_MASK                                         (0x00000002U)
#define CDD_I2C_ICPDRV_PDRV1_SHIFT                                        (0x00000001U)
#define CDD_I2C_ICPDRV_PDRV1_RESETVAL                                     (0x00000000U)
#define CDD_I2C_ICPDRV_PDRV1_MAX                                          (0x00000001U)

#define CDD_I2C_ICPDRV_NU_MASK                                            (0xFFFFFFFCU)
#define CDD_I2C_ICPDRV_NU_SHIFT                                           (0x00000002U)
#define CDD_I2C_ICPDRV_NU_RESETVAL                                        (0x00000000U)
#define CDD_I2C_ICPDRV_NU_MAX                                             (0x3FFFFFFFU)

#define CDD_I2C_ICPDRV_RESETVAL                                           (0x00000000U)

#endif