#include "mcal_hw_soc.h"
#include "mcal_hw_soc_baseaddress.h"

/* mailbox registers */
#define R5FSS0_0_MBOX_WRITE_DONE    (MCAL_CSL_MSS_CTRL_U_BASE + MCAL_CSL_MSS_CTRL_R5SS0_CORE0_MBOX_WRITE_DONE)
#define R5FSS0_0_MBOX_READ_REQ      (MCAL_CSL_MSS_CTRL_U_BASE + MCAL_CSL_MSS_CTRL_R5SS0_CORE0_MBOX_READ_REQ)
#define R5FSS0_1_MBOX_WRITE_DONE    (MCAL_CSL_MSS_CTRL_U_BASE + MCAL_CSL_MSS_CTRL_R5SS0_CORE1_MBOX_WRITE_DONE)
#define R5FSS0_1_MBOX_READ_REQ      (MCAL_CSL_MSS_CTRL_U_BASE + MCAL_CSL_MSS_CTRL_R5SS0_CORE1_MBOX_READ_REQ)
#define R5FSS1_0_MBOX_WRITE_DONE    (MCAL_CSL_MSS_CTRL_U_BASE + MCAL_CSL_MSS_CTRL_R5SS1_CORE0_MBOX_WRITE_DONE)
#define R5FSS1_0_MBOX_READ_REQ      (MCAL_CSL_MSS_CTRL_U_BASE + MCAL_CSL_MSS_CTRL_R5SS1_CORE0_MBOX_READ_REQ)
#define R5FSS1_1_MBOX_WRITE_DONE    (MCAL_CSL_MSS_CTRL_U_BASE + MCAL_CSL_MSS_CTRL_R5SS1_CORE1_MBOX_WRITE_DONE)
#define R5FSS1_1_MBOX_READ_REQ      (MCAL_CSL_MSS_CTRL_U_BASE + MCAL_CSL_MSS_CTRL_R5SS1_CORE1_MBOX_READ_REQ)

/* CPU bit positions within the mailbox registers */
#define R5FSS0_0_MBOX_PROC_BIT_POS  ( 0U)
#define R5FSS0_1_MBOX_PROC_BIT_POS  ( 4U)
#define R5FSS1_0_MBOX_PROC_BIT_POS  ( 8U)
#define R5FSS1_1_MBOX_PROC_BIT_POS  (12U)

/* mailbox interrupts */
#define R5FSS0_0_MBOX_READ_REQ_INTR ( 136U)
#define R5FSS0_1_MBOX_READ_REQ_INTR ( 136U)
#define R5FSS1_0_MBOX_READ_REQ_INTR ( 136U)
#define R5FSS1_1_MBOX_READ_REQ_INTR ( 136U)

/* dedicated mailbox memories address and size */
#define MSS_MBOX_MEM                (MCAL_CSL_MBOX_SRAM_U_BASE)
#define MSS_MBOX_MEM_SIZE           (16U*1024U)

/*
 * SW queue between each pair of CPUs
 *
 * place SW queues at the bottom of the dedicated mailbox memories.
 * Driver assume this memory is init to zero in bootloader as it's ECC protected and
 * needs to be intialized only once and to ensure that only one core has done the
 * mailbox ram initialization before ipc_init. If SBL is not used then Gel does the initialization.
 * We need 4*3 SW Q's for the 4x R5F to send messages to each other, i.e 384 B.
 *
 * Rest of the mailbox memory cna be used for ipc_rpmessage or custom message passing.
 */
#define R5FSS0_0_TO_R5FSS0_1_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*12)
#define R5FSS0_0_TO_R5FSS1_0_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*11)
#define R5FSS0_0_TO_R5FSS1_1_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*10)
#define R5FSS0_1_TO_R5FSS0_0_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*9)
#define R5FSS0_1_TO_R5FSS1_0_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*8)
#define R5FSS0_1_TO_R5FSS1_1_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*7)
#define R5FSS1_0_TO_R5FSS0_0_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*6)
#define R5FSS1_0_TO_R5FSS0_1_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*5)
#define R5FSS1_0_TO_R5FSS1_1_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*4)
#define R5FSS1_1_TO_R5FSS0_0_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*3)
#define R5FSS1_1_TO_R5FSS0_1_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*2)
#define R5FSS1_1_TO_R5FSS1_0_SW_QUEUE      (IpcNotify_SwQueue*)(MSS_MBOX_MEM + MSS_MBOX_MEM_SIZE - MAILBOX_MAX_SW_QUEUE_SIZE*1)

IpcNotify_InterruptConfig* IpcNotifyCfg_getInterruptConfig(uint32 coreId);
uint32 IpcNotifyCfg_getInterruptConfigNum(uint32 coreId);
IpcNotify_MailboxConfig* IpcNotifyCfg_getMailboxConfig(uint32 selfCoreId, uint32 remoteCoreId);