/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Mcu_priv.h
 *
 */

#ifndef MCU_PRIV_H_
#define MCU_PRIV_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "Std_Types.h"
#include "sys_common.h"
#include "Mcu.h"

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


#define MCU_SOFT_SYSRST     0x00

/*Single port memory*/
#define RL_SP_ST_M_MBOX                    (uint64)((uint64)1U << 21U)
#define RL_SP_ST_M_MCAN                    (uint64)((uint64)1U << 39U)

/*Two port memory*/
#define RL_TP_ST_M_SPIB                    (uint64)((uint64)1U << 43U)
#define RL_TP_ST_M_DCAN1                   (uint64)((uint64)1U << 25U)
#define RL_TP_ST_M_DCAN2                   (uint64)((uint64)1U << 26U)
#define RL_TP_ST_M_DMA                     (uint64)((uint64)1U << 27U)
#define RL_TP_ST_M_SPIA                    (uint64)((uint64)1U << 28U)
#define RL_TP_ST_M_VIM                     (uint64)((uint64)1U << 29U)
#define XTAL_CLKINP                        ((uint64)25000000)

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

typedef struct
{
    uint8         rawresetval;
    Mcu_ResetType resetReason;
} Mcu_ResetStatusMap;


typedef struct
{
    uint8   numFields;
    const   Mcu_ResetStatusMap *resetMap;
} Mcu_ResetInfo;


/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
/*None*/

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
#if (STD_OFF == MCU_NO_PLL)
Mcu_PllStatusType Mcu_GetPllLockStatus(void);
Std_ReturnType Mcu_PLLInitAll(const Mcu_ConfigType *);
#endif
#if (STD_ON == MCU_PERFORM_RESET_API)
void Mcu_PerformSoftSysReset(uint32 resetVal);
#endif
Mcu_ResetType Mcu_GetPlatformResetReason(void);
Mcu_RawResetType Mcu_GetPlatformRawResetReason(void);
#if (STD_ON == MCU_INIT_CLOCK_API)
uint32 Mcu_getMultibitValue(uint32 clk_srcId);
Std_ReturnType Mcu_ClockSetSourceCR5(Mcu_ClkSourceIdType clk_srcId,
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMCAN0(Mcu_ClkSourceIdType clk_srcId, 
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMCAN1(Mcu_ClkSourceIdType clk_srcId,
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMCAN2(Mcu_ClkSourceIdType clk_srcId, 
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMCAN3(Mcu_ClkSourceIdType clk_srcId,
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceRTI0(Mcu_ClkSourceIdType clk_srcId,
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceRTI1(Mcu_ClkSourceIdType clk_srcId, 
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceRTI2(Mcu_ClkSourceIdType clk_srcId, 
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceRTI3(Mcu_ClkSourceIdType clk_srcId, 
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceWDT0(Mcu_ClkSourceIdType clk_srcId,
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceWDT1(Mcu_ClkSourceIdType clk_srcId, 
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceWDT2(Mcu_ClkSourceIdType clk_srcId, 
														       uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceWDT3(Mcu_ClkSourceIdType clk_srcId, 
															   uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceQSPI(Mcu_ClkSourceIdType clk_srcId, 
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMCSPI0(Mcu_ClkSourceIdType clk_srcId,
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMCSPI1(Mcu_ClkSourceIdType clk_srcId,
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMCSPI2(Mcu_ClkSourceIdType clk_srcId,
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMCSPI3(Mcu_ClkSourceIdType clk_srcId,
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMCSPI4(Mcu_ClkSourceIdType clk_srcId, 
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceI2C(Mcu_ClkSourceIdType clk_srcId, 
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceSCI0(Mcu_ClkSourceIdType clk_srcId,
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceSCI1(Mcu_ClkSourceIdType clk_srcId,
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceSCI2(Mcu_ClkSourceIdType clk_srcId, 
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceSCI3(Mcu_ClkSourceIdType clk_srcId,
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceSCI4(Mcu_ClkSourceIdType clk_srcId,
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceSCI5(Mcu_ClkSourceIdType clk_srcId, 
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceCPSW(Mcu_ClkSourceIdType clk_srcId,
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceCPTS(Mcu_ClkSourceIdType clk_srcId, 
                                                               uint32 clkDivId);
Std_ReturnType Mcu_ClockSetSourceMcuClkout(Mcu_ClkSourceIdType clk_srcId, 
                                                              uint32 clk_divId);
#if 0
Std_ReturnType Mcu_ClockSetSourcePmicClkout(Mcu_ClkSourceIdType clk_srcId, 
                                                              uint32 clk_divId);
#endif
Std_ReturnType Mcu_ClockSetSourceMII100Clk(Mcu_ClkSourceIdType clk_srcId, 
                                                              uint32 clk_divId);
Std_ReturnType Mcu_ClockSetSourceMII10Clk(Mcu_ClkSourceIdType clk_srcId,
                                                              uint32 clk_divId);
Std_ReturnType Mcu_ClockSetSourceRGMIClk(Mcu_ClkSourceIdType clk_srcId,
                                                              uint32 clk_divId);

Std_ReturnType Mcu_SetUpDCDC_Contrl(void);
#endif

void Mcu_MMR_unlock(uint32 *kick0, uint32 *kick1);
void Mcu_unlockMMR(void);

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef MCU_PRIV_H_ */

