/* ======================================================================
 *   Copyright (c) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Port_priv.h
 *
 */

#ifndef PORT_PRIV_H_
#define PORT_PRIV_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#include "Std_Types.h"
#include "hal_stdtypes.h"
#include "hw_ctrl_core.h"
#include "soc.h"

#include "sys_common.h"


#include "Port.h"
#if (PORT_DEV_ERROR_DETECT == STD_ON)
#include "Det.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/*This is a false error report in LDRA for 61 X "Identifier match in
  * 31 characters ". Adding LDRA no analysis for this part of the
  * code to improve the readability  */
#define PORT_PAD_REGSETTING_PULLTYPESELECT_PULL_UP      (1U)
#define PORT_PAD_REGSETTING_PULLTYPESELECT_PULL_DOWN    (0U)

#define PORT_PAD_REGSETTING_SLEWCONTROL_FAST_SLEW       (0U)
#define PORT_PAD_REGSETTING_SLEWCONTROL_SLOW_SLEW       (1U)

#define PORT_PAD_REGSETTING_PULLINHIBIT_ENABLE         (0U)
#define PORT_PAD_REGSETTING_PULLINHIBIT_DISABLE        (1U)

#define PORT_PAD_REGSETTING_NON_INVERSION_EN            (0U)
#define PORT_PAD_REGSETTING_INVERSION_EN                (1U)

#define PORT_PAD_REGSETTING_SYNC_QUAL_EN                (0U)
#define PORT_PAD_REGSETTING_THREE_SAMPLE_QUAL_EN        (1U)
#define PORT_PAD_REGSETTING_SIX_SAMPLE_QUAL_EN          (2U)
#define PORT_PAD_REGSETTING_ASYNC_QUAL_EN               (3U)

#define PORT_PAD_REGSETTING_DEFAULT                     (0xFFU)

#define PORT_DIO_INVALID_BASE_ADDR                      (0U)

#define PORT_UNLOCKPAD_IOCFGKICK0					   0x83E70B13U
#define PORT_UNLOCKPAD_IOCFGKICK1					   0x95A4F1E0U

#define PORT_LOCKPADVALUE							   (0x0U)

#define PORT_CLEAR_EDGE							       (0x0U)


#define PORT_UTILS_ARRAYSIZE(array)            ((sizeof(array) / \
                                                 sizeof((array)[0])))

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/** \brief Data type to define the pad configuration */
typedef struct
{
    uint32 pin_reg_offset;
    uint32 slewcontrol;
    uint32 pulludenable;
    uint32 pullinhibit;
    uint32 oe_n_override;
    uint32 oe_n_override_ctrl;
    uint32 ie_n_override;
    uint32 ie_n_override_ctrl;
    uint32 muxmode;
    uint32 HSmaster;
    uint32 HSmode;
    uint32 inversion;
    uint32 qualifiertype;
} Port_PadRegSettingType;

typedef struct
{
    uint32 gpioIntBank;
	uint32 channelId;
    
} Port_IntrSettingType;


/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
void Port_UnlockPadConfig(pinMuxBase_t *pinMuxRegp);
void Port_LockPadConfig(pinMuxBase_t *pinMuxRegp);
void Port_ConfigurePadCore( uint32 baseAdd,
    CONSTP2CONST(Port_PadRegSettingType, AUTO, PORT_APPL_DATA)padRegSetting);
void Port_GPIOPortInit(const gpioPORT_t  *portAddr);
uint32 Port_GetGPIOPortAddr(uint32 regNum);
uint32 Port_ReadMuxMode(uint32 pin_reg_offset);
void Port_GPIOInit(gpioBASE_t *gioBaseREG );
void Port_ConfigurePad(
    P2CONST(Port_PinConfigType, AUTO, PORT_APPL_DATA)padCfg,
    Port_PinModeType pinMode);
void Port_GPIOIntConfigure(gpioBASE_t *gioBaseREG, const Port_IntrSettingType* gpioIntr);
void Port_SetDirection(const gpioPORT_t *port, uint32 bit, uint32 dir);
void Port_GPIOSetBit(gpioPORT_t *port, uint32 bit, uint32 value);
sint32 Port_ConfigOverrideCtrl(uint32 *pinMuxBase, uint32 pin, uint32 outputCtrl, uint32 inputCtrl);
sint32 Port_SelectFunc(uint32 *pinMuxBase, uint32 pin, uint32 func);
sint32 Port_ConfigPulls(uint32 *pinMuxBase, uint32 pin, uint32 pullVal);
sint32 Port_ConfigSlew(uint32 *pinMuxBase, uint32 pin, uint32 slewVal);
sint32 Port_ConfigPullInhibitEnable(uint32 *pinMuxBase, uint32 pin, uint32 InhibitVal);
sint32 Port_ResetPadConfig(uint32 *pinMuxBase, uint32 pin);
void Port_GPIOEdgTrigConfigure(const gpioPORT_t  *portAddr,uint32 bit,
                              Port_EdgeTrig  TriEdge,
                              boolean TriggerEn);
sint32 Port_ConfigInversion(uint32 *pinMuxBase, uint32 pin, uint32 invVal);
sint32 Port_ConfigQualType(uint32 *pinMuxBase, uint32 pin, uint32 qualifierValue);
sint32 Port_ConfigHSmaster(uint32 *pinMuxBase, uint32 pin, uint32 hsmasterValue);
sint32 Port_ConfigHSmode(uint32 *pinMuxBase, uint32 pin, uint32 hsmodeValue);
#ifdef __cplusplus
}
#endif

#endif  /* #ifndef PORT_PRIV_H_ */

