/* ===============================================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ============================================================================================ */

/**
 *  \file     Cdd_Uart_Irq.h
 *
 *  \brief    This file contains ISR function declaration for Complex Device Driver
 *
 */

/**
 *  \ingroup MCAL_CDD_API
 *  @{
 */

#ifndef CDD_UART_IRQ_H_
#define CDD_UART_IRQ_H_

/*************************************************************************************************
 * INCLUDES
 ************************************************************************************************/

#include "Os.h"
#include "Cdd_Uart.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*************************************************************************************************
 *  GLOBAL MACROS
 ************************************************************************************************/

/**
 *  \name CDD Driver ISR category level
 *  Requirements: SITARAMCU_MCAL-___
 *  Defines for CDD UART Driver ISR category level
 *  @{
 */
/** \brief void ISR type */
#define CDD_UART_ISR_VOID                    (0x00U)
/** \brief Category 1 ISR type */
#define CDD_UART_ISR_CAT1                    (0x01U)
/** \brief Category 2 ISR type */
#define CDD_UART_ISR_CAT2                    (0x02U)
/* @} */


/** \brief UART Master ISR function */
FUNC(void, CDD_UART_CODE) Cdd_Uart_ChannelIsr(uint8 ChannelID) __attribute__((target("arm")));

#if (STD_ON == CDD_UART_DMA_ENABLE)
/** \brief UART DMA Master ISR function */
	#if ((CDD_UART_ISR_TYPE == CDD_UART_ISR_CAT1) || (CDD_UART_ISR_TYPE == CDD_UART_ISR_VOID))
FUNC(void, CDD_UART_CODE) Cdd_Uart_ChannelEdmaIsr();
	#elif (CDD_UART_ISR_TYPE == CDD_UART_ISR_CAT2)
ISR( Cdd_Uart_ChannelEdmaIsr );
	#endif
#endif

#endif