/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Cdd_Uart_Irq.c
 *
 *  \brief    This file contains CDD UART driver IRQ functions
 *
 */
#define CDD_UART_IRQ_SOURCE

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/

#include "Std_Types.h"
#include "Cdd_Uart.h"
#include "Cdd_Uart_Irq.h"

extern CddUart_Object CddUart_ChannelObjects[CDD_UART_NUM_CHANNELS];

/**********************************************************************************************************************
 *  GLOBAL FUNCTION DEFINITIONS
 *********************************************************************************************************************/

#define CDD_UART_START_SEC_ISR_CODE
#include "Cdd_Uart_MemMap.h"

/* Function name: Cdd_Uart_ChannelIsr
   Description: The Channel-specific Interrupt Subroutine calls handler function based on the channel input. */
__attribute__((target("arm"))) FUNC(void, CDD_UART_CODE) Cdd_Uart_ChannelIsr(uint8 ChannelID)
{
  Uart_Cdd_masterIsr(&CddUart_ChannelObjects[ChannelID]);
}

#if (CDD_UART_DMA_ENABLE == STD_ON)
/* Function name: Cdd_Uart_ChannelEdmaIsr
   Description: The Channel-specific Interrupt Subroutine calls handler function based on the channel input. */
__attribute__((target("arm"), aligned(4)))
#if ((CDD_UART_ISR_TYPE == CDD_UART_ISR_CAT1) || (CDD_UART_ISR_TYPE == CDD_UART_ISR_VOID))
FUNC(void, CDD_UART_CODE) Cdd_Uart_ChannelEdmaIsr()
#elif (CDD_UART_ISR_TYPE == CDD_UART_ISR_CAT2)
ISR( Cdd_Uart_ChannelEdmaIsr )
#endif
{
  CDD_EDMA_lld_transferCompletionMasterIsrFxn();
}
#endif

#define CDD_UART_STOP_SEC_ISR_CODE
#include "Cdd_Uart_MemMap.h"