/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Wdg_Irq.h
 *
 *  \brief    This file contains ISR function declaration for WDG MCAL driver
 *
 */

#ifndef WDG_IRQ_H_
#define WDG_IRQ_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#include "Wdg.h"
#if (WDG_ISR_TYPE == WDG_ISR_CAT2)
#include "Os.h"
#endif
#ifdef __cplusplus
extern "C"
{
#endif

/********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 ********************************************************************************************************************/

/* Version identification */
#define WDG_IRQ_MAJOR_VERSION    (8U)
#define WDG_IRQ_MINOR_VERSION    (6U)
#define WDG_IRQ_PATCH_VERSION    (2U)

/**********************************************************************************************************************
 *  GLOBAL DATA TYPES AND STRUCTURES
 *********************************************************************************************************************/
/**
 *  \name WDG Driver ISR category level
 *
 *  Defines for WDG Driver ISR ISR category level
 *  @{
 */

/**
 *  \name Watchdog ISR Type defines
 *
 *  Type of watchdog ISRs supported
 *  @{
 */
/** \brief No ISR */
#define WDG_ISR_VOID                    (0x00U)
/** \brief OSEK Category 1 ISR */
#define WDG_ISR_CAT1                    (0x01U)
/** \brief OSEK Category 2 ISR */
#define WDG_ISR_CAT2                    (0x02U)
/* @} */

/**********************************************************************************************************************
 *  GLOBAL FUNCTION PROTOTYPES
 *********************************************************************************************************************/
 
/* Interrupt Service */
#if (WDG_ISR_TYPE == WDG_ISR_CAT1 || WDG_ISR_TYPE == WDG_ISR_VOID)
/**
 *  \brief This function is the Interrupt frame for WDT instance 0
 *
 *  \verbatim
 *  Function name     : WdgIsr_0
 *  Syntax            : void WdgIsr_0( void )
 *  Service ID[hex]   : N/A
 *  Sync/Async        : Synchronous
 *  Reentrancy        : Non-Reentrant
 *  Parameters (in)   : None
 *  Parameters (inout): None
 *  Parameters (out)  : None
 *  Return value      : None
 *  Description       : This function is the Interrupt frame for WDT 0 <br>
 *                      This function should be plugged into the vector table
 *                      for Category 1 ISR
 *  \endverbatim
 */
FUNC(void, WDG_CODE_ISR) WdgIsr_0(void);
#elif (WDG_ISR_TYPE == WDG_ISR_CAT2)
/* Function prototype is declared by OS */
ISR(WdgIsr_0);
#endif

#ifdef __cplusplus
}
#endif

#endif 