/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Wdg_Irq.c
 *
 *  \brief    This file contains WDG IRQ
 */

#define WDG_IRQ_SOURCE

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "Wdg.h"
#include "Wdg_Irq.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structure Declarations                             */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Function Definitions                              */
/* ========================================================================== */

#define WDG_START_SEC_ISR_CODE
#include "Wdg_MemMap.h"

/* Design : WDG_DesignId_005 */
/* Requirements : SWS_Wdg_00166 */
#if defined(CLANG)
__attribute__((target("arm")))
#endif
#if ((WDG_ISR_TYPE == WDG_ISR_CAT1) || (WDG_ISR_TYPE == WDG_ISR_VOID))
FUNC(void, WDG_CODE_ISR) WdgIsr_0(void)
#elif (WDG_ISR_TYPE == WDG_ISR_CAT2)
ISR(WdgIsr_0)
#endif
{
    Wdg_Trigger();
}

#define WDG_STOP_SEC_ISR_CODE
#include "Wdg_MemMap.h"
