/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Wdg_priv.h
 *
 *  \brief    This file contains Wdg MCAL driver private include file
 */

#ifndef WDG_PRIV_H_
#define WDG_PRIV_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "Std_Types.h"
#include "Wdg.h"
#if (WDG_DEV_ERROR_DETECT == STD_ON)
#include "Det.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define WDG_UTILS_ARRAYSIZE(array)             ((sizeof (array) / \
                                                 sizeof ((array)[0])))

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/**
 *  \brief WDG driver object structure.
 */
typedef struct
{
    uint32 baseAddr;
    /**< Base address of the hardware */
    uint32 timeOutCounter;
    /**< Watchdog timeOutCounter value */
    uint32 counterRef;
    /**< Counter refence value for trigge */
} Wdg_DriverObjType;

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

FUNC(Std_ReturnType, WDG_CODE) Wdg_platformInit(
    P2CONST(Wdg_ConfigType, AUTOMATIC, WDG_APPL_CONST) ConfigPtr);
FUNC(uint32, WDG_CODE) Wdg_getCurrentDownCounter(uint32 baseAddr);
FUNC(void, WDG_CODE) Wdg_counterEnable(uint32 baseAddr);
FUNC(void, WDG_CODE) Wdg_generateSysReset(uint32 baseAddr);
FUNC(void, WDG_CODE) Wdg_service(uint32 baseAddr);
FUNC(uint32, WDG_CODE) Wdg_getReloadValue(uint32 baseAddr);
FUNC(uint32, WDG_CODE) Wdg_getWdgBaseAddr(uint16 regNum);
#if (STD_ON == WDG_DEV_ERROR_DETECT)
void Wdg_reportDetError(uint8 apiId, uint8 errorId);
#endif  /* #if (STD_ON == WDG_DEV_ERROR_DETECT) */
void Wdg_reportDemError(Dem_EventIdType     eventId,
                        Dem_EventStatusType eventStatus);

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef WDG_PRIV_H_ */
