/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     EthApp.c
 *
 *  \brief    This file contains the EthApp test example header file
 *
 */

#ifndef ETHAPP_H_
#define ETHAPP_H_
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define ETHAPP_MODULE_ID                                    ((uint8)0x0U)

#define ETHAPP_STRESS_TEST                                  (STD_OFF)

#define ETHAPP_MAINFUNCTION_TEST                            (STD_ON)
#define ETHAPP_FILTER_TEST                                  (STD_ON)
#define ETHAPP_TIMESTAMP_TEST                               (STD_ON)
#define ETHAPP_MIN_PACKETSIZE_TEST                          (STD_ON)
#define ETHAPP_TRAFFIC_SHAPING_TEST                         (STD_ON)
#define ETHAPP_THROUGHPUT_TEST                              (STD_OFF)
#define ETHAPP_STACKUSAGE_TEST                              (STD_OFF)

#define ETHAPP_NUM_RECEIVE_PACKET                           (50000U)
#define ETHAPP_NUM_TRANSMIT_PACKET                          (50000U)
#define ETHAPP_NUM_TIME_SYNC_PACKET                         (100U)
#define ETHAPP_NUM_SET_GLB_TIME_CNT                         (100U)
#define ETH_APP_LOOP_COUNT                                  (0x1U)

#define ETHAPP_NUM_RECEIVE_PACKET_FILTER                    (1000U)

#define ENABLE_PACKET_CPU_COPY                              (0U)
#define ENABLE_PACKET_EDMA_COPY                             (0U)
#define ENABLE_VLAN_TAG                                     (0U)

/* MAX ACOUNT */
#define MAX_ACOUNT                  (1500U)
/* MAX BCOUNT */
#define MAX_BCOUNT                  (1U)
/* MAX CCOUNT */
#define MAX_CCOUNT                  (1U)
/**
 * Buffers (src and dest) are needed for mem-2-mem data transfers.
 * This define is for the MAXIMUM size and hence the maximum data
 * which could be transferred using the sample test cases below.
 */
#define MAX_BUFFER_SIZE             (MAX_ACOUNT * MAX_BCOUNT * MAX_CCOUNT)


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */


/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

uint8  timeSyncPacket[] = {
    /* Ethernet HEADER(commented as will be added by driver) */
    /*
     * 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // # Destination MAC
     * 0xFB, 0xB1, 0x56, 0xA9, 0xF4, 0xDF, // # Source MAC
     * 0x08, 0x00,                         // # Protocol
     */

    /* PTP packet */
    0x0, 0x2, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf,
    0xf, 0x0, 0x9, 0xa, 0x0, 0x1, 0x4, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x1, 0x1, 0xd,
    0xe, 0xc, 0x0, 0x0,
};

uint8  pDelayRequestPacket[] = {
    0x2, 0x0, 0xe, 0x0, 0x0, 0xb, 0x0, 0x0,
    0x3, 0x0, 0x9, 0xa, 0x8, 0x0, 0x5, 0x0,
    0x0, 0x2, 0x5, 0xf, 0x0, 0x0, 0x1, 0x1,
    0x0, 0x2, 0x0, 0x8, 0x2, 0x6, 0x0, 0x0,
    0x0, 0xb, 0x1, 0xf, 0x1, 0xf, 0x0, 0xe,
    0x0, 0x0, 0x2, 0x2, 0x0, 0x6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf, 0xf, 0x0, 0x9, 0xa, 0x0, 0x1,
    0xe, 0x8, 0x5, 0xf, 0x0, 0x0, 0x5, 0x1,
    0x1, 0x1, 0x4, 0x2, 0x9, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
};

uint8  delayRequestPacket[] = {
    0x1, 0x0, 0xe, 0x0, 0x0, 0xb, 0x0, 0x0,
    0x3, 0x0, 0x9, 0xa, 0x8, 0x0, 0x5, 0x0,
    0x0, 0x2, 0x5, 0xf, 0x0, 0x0, 0x1, 0x1,
    0x0, 0x2, 0x0, 0x8, 0x2, 0x6, 0x0, 0x0,
    0x0, 0xb, 0x1, 0xf, 0x1, 0xf, 0x0, 0xe,
    0x0, 0x0, 0x2, 0x2, 0x0, 0x6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf, 0xf, 0x0, 0x9, 0xa, 0x0, 0x1,
    0xe, 0x8, 0x5, 0xf, 0x0, 0x0, 0x5, 0x1,
    0x1, 0x1, 0x4, 0x2, 0x9, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
};


	  
	  
uint16 lengthOfTimeSyncPacket = (sizeof (timeSyncPacket) / sizeof (timeSyncPacket[0U]));
uint16 lengthOfPdelayRequestPacket = (sizeof (pDelayRequestPacket) / sizeof (pDelayRequestPacket[0U]));
uint16 lengthOfDlayRequestPacket = (sizeof (delayRequestPacket) / sizeof (delayRequestPacket[0U]));

extern void EthTrcvInitRGMII(uint8 CtrlIdx);
void I2C();
void I2C_Write(uint32 cmd, uint32 reg);
void I2C_Read(uint32 cmd, uint32 *reg);

/* None */
#ifdef __cplusplus
}
#endif

#endif  /* #ifndef ETHAPP_H_ */

/* @} */
