/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     IcuApp.h
 *
 *  \brief    ICU example header file
 *
 */

#ifndef ICU_APP_H_
#define ICU_APP_H_

#define CSL_ETPWM_PER_CNT                (32U)
#define CONTROLSS_CTRL_PARTITION0                          (3)

#define CSL_CONTROLSS_CTRL_U_BASE                  (0x502F0000ul)
#define CSL_CONTROLSS_CTRL_EPWM_CLKSYNC                                  (0x00000010U)
#define CSL_CONTROLSS_CTRL_EPWM_CLKSYNC_BIT_MASK                         (0xFFFFFFFFU)
#define CSL_CONTROLSS_CTRL_EPWM_STATICXBAR_SEL0                          (0x00000004U)

#define CSL_CONTROLSS_CTRL_LOCK0_KICK0                                   (0x00001008U)
#define CSL_CONTROLSS_CTRL_LOCK0_KICK1                                   (0x0000100CU)

#define TEST_KICK_LOCK_VAL                           (0x00000000U)
#define TEST_KICK0_UNLOCK_VAL                        (0x01234567U)
#define TEST_KICK1_UNLOCK_VAL                        (0x0FEDCBA8U)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0                                       (0x00000100U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1                                       (0x00000104U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2                                       (0x00000108U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3                                       (0x0000010CU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4                                       (0x00000110U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5                                       (0x00000114U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6                                       (0x00000118U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR1_G0                                       (0x00000140U)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_SEL_MASK                              (0xFFFFFFFFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_SEL_MAX                               (0xFFFFFFFFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_RESETVAL                              (0x00000000U)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_SEL_MASK                              (0xFFFFFFFFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_SEL_MAX                               (0xFFFFFFFFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_RESETVAL                              (0x00000000U)

/* INTXBAR0_G2 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_SEL_MASK                              (0x01FFFFFFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_SEL_MAX                               (0x01FFFFFFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_RESETVAL                              (0x00000000U)

/* INTXBAR0_G3 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_SEL_MASK                              (0x0000FFFFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_SEL_MAX                               (0x0000FFFFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_RESETVAL                              (0x00000000U)

/* INTXBAR0_G4 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_SEL_MASK                              (0x000003FFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_SEL_MAX                               (0x000003FFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_RESETVAL                              (0x00000000U)

/* INTXBAR0_G5 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_SEL_MASK                              (0x000003FFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_SEL_MAX                               (0x000003FFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_RESETVAL                              (0x00000000U)

/* INTXBAR0_G6 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_SEL_MASK                              (0x00000007U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_SEL_MAX                               (0x00000007U)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_RESETVAL                              (0x00000000U)
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define APP_NAME                        "ICU_APP"
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef ICU_APP_H_ */
