/* ======================================================================
 *   Copyright (c) 2021 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     McuApp.c
 *
 *  \brief    This file contains the Mcu test example
 */

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/

/* Include Files */
#include "assert.h"
/*LDRA_NOANALYSIS*/
#include "string.h"
#include "Std_Types.h"
#include "Det.h"
#include "Dem.h"
/*LDRA_ANALYSIS*/
#include "Mcu.h"
#include "EcuM_Cbk.h"
#include "Mcu.h"
#include "Mcu_Cfg.h"
#include "Port.h"
#include "Port_Cfg.h"
#include "app_utils.h"
#include "trace.h"
#include "sys_vim.h"
#include "hw_ctrl_core.h"
#include "hw_types.h"
#include "esm.h"
#define APP_PERFORMANCE_MODE   STD_OFF
#define APP_NAME "Mcu_App"
uint8 MainFunc_Execution;
#if (STD_ON == APP_PERFORMANCE_MODE)
static void MCSPIExample_PerformanceTest();
#endif
void Stop_Timer(uint8 Api_Id);
void Start_Timer(void);
uint32 Performance_Result[10];
uint32 						frc;//,mask = 0x00000000U;
#ifdef __cplusplus
extern "C" {
#endif

/** @fn void main(void)
 *   @brief Application main function
 *   @note This function is empty by default.
 *
 *   This function is called after startup.
 *   The user can use this function to implement the application.
 */

Std_VersionInfoType      VersionInfo;
sint32 TestState = TRUE;

void Uart_Delay(uint32 Delay)
{
    for ( Delay=0 ;Delay<5000; Delay++)
    {
        
        ;
    }
}

void  SchM_Enter_Mcu_MCU_EXCLUSIVE_AREA_0()
{
    AppUtils_SchM_Enter_EXCLUSIVE_AREA_0();
}

void   SchM_Exit_Mcu_MCU_EXCLUSIVE_AREA_0()
{
     AppUtils_SchM_Exit_EXCLUSIVE_AREA_0();
}

void  SchM_Enter_Port_PORT_EXCLUSIVE_AREA_0()
{
    AppUtils_SchM_Enter_EXCLUSIVE_AREA_0();

}

void   SchM_Exit_Port_PORT_EXCLUSIVE_AREA_0()
{

  AppUtils_SchM_Exit_EXCLUSIVE_AREA_0();

}

#if (STD_ON == APP_PERFORMANCE_MODE)
static void McuExample_PerformanceTest()
{
    char           option;
    boolean quit_opt = 0;
    uint32 cntr_cnt;//,mask = 0x00000000U;
    const Mcu_ConfigType *ConfigPtr;
	Std_VersionInfoType versioninfo;
	
    ConfigPtr = &McuModuleConfiguration;
    
	Start_Timer();
	Mcu_GetVersionInfo(&versioninfo);
	Stop_Timer(0);
	
	Start_Timer();
	Mcu_Init(ConfigPtr);
	Stop_Timer(1);
	
	Start_Timer();
	Mcu_InitClock(4U);
    Stop_Timer(2);
	
	Start_Timer();
	Mcu_InitRamSection(0);
	Stop_Timer(3);
	
	Start_Timer();
	Mcu_DistributePllClock();
	Stop_Timer(4);
	
	Start_Timer();
	Mcu_GetPllStatus();
	Stop_Timer(5);
	
	Start_Timer();
	Mcu_PerformReset();
	Stop_Timer(6);
	
	Start_Timer();
	Mcu_GetResetRawValue();
	Stop_Timer(7);
	
	Start_Timer();
	Mcu_GetResetReason();
	Stop_Timer(8);
	
}
#endif
int32_t main(void)
{
    uint8 referenceArray[20];
    uint16 mss_uart_tx_pin, mss_uart_rx_pin;
    uint32 sys_clk_freq_vclk_const;
    uint32 countVal;
	
    
#if (STD_ON == MCU_VARIANT_PRE_COMPILE)
        Mcu_Init((const Mcu_ConfigType *) NULL_PTR);
    #else
        Mcu_Init(&McuModuleConfiguration);
    #endif
	AppUtils_defaultInit();
	AppUtils_sectionInit();
    Port_Init(&PortConfigSet_0);
	
	
    /* Default is AWR29XX*/
    mss_uart_tx_pin = 13;
    mss_uart_rx_pin = 14;
    
    /* Set up the pinmux for UART tx */
    Port_SetPinMode(mss_uart_tx_pin, PORT_PIN_MODE_LIN0);

    /* Set up the pinmux for UART rx */
    Port_SetPinMode(mss_uart_rx_pin, PORT_PIN_MODE_LIN0);
    Port_SetPinDirection(mss_uart_rx_pin, PORT_PIN_IN);
    /* Initialize interrupt */
    vimInit();
	
	 
	

    #if (STD_OFF == MCU_NO_PLL)
    if(McuModuleConfiguration.Mcu_PllSourceId == MCU_CLKSRC_DPLL)
    {
        sys_clk_freq_vclk_const = (McuModuleConfiguration.Mcu_PllConfig[MCU_CLKSRC_DPLL].Mcu_PllClk1.MCU_PLL_HSDIV2 / (2e6)) * 30;
    }
    else
    {
        sys_clk_freq_vclk_const = (McuModuleConfiguration.Mcu_PllConfig[MCU_CLKSRC_APLL].Mcu_PllClk1.MCU_PLL_HSDIV0 / (2e6)) * 30;
    }
    Enable_Uart();
    #else
    Enable_Uart();
    #endif
    /* Delay for UART to settle up */
    Uart_Delay(5000);
	
	#if (STD_ON == MCU_VARIANT_PRE_COMPILE)
        AppUtils_printf(APP_NAME ": Variant - Pre Compile being used !!!\n\r");
        
    #else
       AppUtils_printf(APP_NAME ": Variant - Post Build being used !!!\n\r");
        
    #endif
    AppUtils_printf("\n\rMcuApp: Sample Application - STARTS !!!\n\r");
#if (STD_ON == MCU_GET_VERSION_INFO_API)
    Mcu_GetVersionInfo(&VersionInfo);
    AppUtils_printf("Mcu Driver version info:%d.%d.%d\n\r",
                    VersionInfo.sw_major_version,
                    VersionInfo.sw_minor_version,
                    VersionInfo.sw_patch_version);
    AppUtils_printf("Mcu Driver Module/Driver:%d.%d \n\r",
                    VersionInfo.moduleID,
                    VersionInfo.vendorID);
#endif

    
    
    
    my_memset((uint8*)0x70000000, 0, 20);
    my_memset(referenceArray, 0xBE, 20);

#if (STD_ON == APP_PERFORMANCE_MODE)
	McuExample_PerformanceTest();
#endif

#if (STD_ON == MCU_INIT_RAM_API)
    Mcu_InitRamSection(0);
#endif

    if (memcmp((uint8*)0x70000000, &referenceArray[0], 20) != 0)
    {
        GT_0trace(McalAppTrace, GT_INFO,
               "RAM section is not initialized properly");
		AppUtils_printf("MCU Test Failed!!!\n\r");
        TestState = FALSE;
    }
    else
    {
		GT_0trace(McalAppTrace, GT_INFO,
               "RAM section is initialized properly\n\r");
        /* check the wakeup cause */
        if(Mcu_GetResetReason() == MCU_POWER_ON_RESET)
        {
            GT_0trace(McalAppTrace, GT_INFO,
                   "Wake up from Power ON\n\r");
			AppUtils_printf("MCU Test Passed!!!\n\r");
        }
        else
        {
            GT_0trace(McalAppTrace, GT_INFO,
                   " Wake up from Soft Reset\n\r");
			AppUtils_printf("MCU Test Passed!!!\n\r");
        }
		GT_1trace(McalAppTrace, GT_INFO,
                  "MCU Stack Usage: %d bytes\n\r", AppUtils_getStackUsage());
        if (AppUtils_checkStackAndSectionCorruption() != E_OK)
        {
            GT_0trace(McalAppTrace, GT_ERR, "MCU Stack/section corruption!!!\n\r");
        }
    }
	
    return TestState;
		
}

void Start_Timer(void)
{
	
      HW_WR_REG32(0x52180000, 0x00000000);//GCTRL
	  HW_WR_REG32(0x52180008, 0x00000000);//Capture Control
	  HW_WR_REG32(0x5218000C, 0x00000000);//COMP CTRL
	  HW_WR_REG32(0x52180010, 0x00000000);//FRC0
	  HW_WR_REG32(0x52180014, 0x00000000);//UP Counter
	  HW_WR_REG32(0x52180018, 0x00000001);//Compare Up Counter
	  HW_WR_REG32(0x52180084, 0x00070F0F);//Clear Interrupt
	  HW_WR_REG32(0x52180000, 0x00000001);//GCTRL Start Timer
	  
}

void Stop_Timer(uint8 Api_Id)
{
		  HW_WR_REG32(0x52180000, 0x00000000);//GCTRL Stop Timer
          frc = HW_RD_REG32(0x52180010);
		  Performance_Result[Api_Id] = frc;
}

void EcuM_CheckWakeup(EcuM_WakeupSourceType wakeupSource)
{
    MainFunc_Execution = 1;
}


#ifdef __cplusplus
}
#endif

