/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     hw_types.c
 *
 *  \brief    This file contains HW read/write functions used when dynamic
 *            analysis build is enabled. This is needed to avoid getting
 *            non-coverage for HW static inline functions.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "stdio.h"
/*LDRA_NOANALYSIS*/
#include "Std_Types.h"
/*LDRA_ANALYSIS*/
#include "hw_types.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                 Internal Function Declarations                             */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Function Definitions                              */
/* ========================================================================== */

uint32 HW_RD_REG32_RAW(uint32 addr)
{
    uint32 regVal = *(volatile uint32 *) addr;
    return (regVal);
}

void HW_WR_REG32_RAW(uint32 addr, uint32 value)
{
    *(volatile uint32 *) addr = value;
    return;
}

uint16 HW_RD_REG16_RAW(uint32 addr)
{
    uint16 regVal = *(volatile uint16 *) addr;
    return (regVal);
}

void HW_WR_REG16_RAW(uint32 addr, uint16 value)
{
    *(volatile uint16 *) addr = value;
    return;
}

uint8 HW_RD_REG8_RAW(uint32 addr)
{
    uint8 regVal = *(volatile uint8 *) addr;
    return (regVal);
}

void HW_WR_REG8_RAW(uint32 addr, uint8 value)
{
    *(volatile uint8 *) addr = value;
    return;
}

void HW_WR_FIELD32_RAW(uint32 addr,
                                     uint32 mask,
                                     uint32 shift,
                                     uint32 value)
{
    uint32 regVal = *(volatile uint32 *) addr;
    regVal &= (~mask);
    regVal |= (value << shift) & mask;
    *(volatile uint32 *) addr = regVal;
    return;
}

void HW_WR_FIELD16_RAW(uint32 addr,
                                     uint16 mask,
                                     uint32 shift,
                                     uint16 value)
{
    uint32 tempVal;
    uint16 regVal = *(volatile uint16 *) addr;
    tempVal  = ((uint32) regVal);
    tempVal &= (~((uint32) mask));
    tempVal |= (((uint32) value) << shift) & ((uint32) mask);
    regVal   = (uint16) tempVal;
    *(volatile uint16 *) addr = regVal;
    return;
}

void HW_WR_FIELD8_RAW(uint32 addr,
                                    uint8  mask,
                                    uint32 shift,
                                    uint8  value)
{
    uint32 tempVal;
    uint8  regVal = *(volatile uint8 *) addr;
    tempVal  = ((uint32) regVal);
    tempVal &= (~((uint32) mask));
    tempVal |= (((uint32) value) << shift) & ((uint32) mask);
    regVal   = (uint8) tempVal;
    *(volatile uint8 *) addr = regVal;
    return;
}

uint32 HW_RD_FIELD32_RAW(uint32 addr,
                                       uint32 mask,
                                       uint32 shift)
{
    uint32 regVal = *(volatile uint32 *) addr;
    regVal = (regVal & mask) >> shift;
    return (regVal);
}

uint16 HW_RD_FIELD16_RAW(uint32 addr,
                                       uint16 mask,
                                       uint32 shift)
{
    uint32 tempVal;
    uint16 regVal = *(volatile uint16 *) addr;
    tempVal = (((uint32) regVal & (uint32) mask) >> shift);
    regVal  = (uint16) tempVal;
    return (regVal);
}

uint8 HW_RD_FIELD8_RAW(uint32 addr,
                                     uint8  mask,
                                     uint32 shift)
{
    uint32 tempVal;
    uint8  regVal = *(volatile uint8 *) addr;
    tempVal = (((uint32) regVal & (uint32) mask) >> shift);
    regVal  = (uint8) tempVal;
    return (regVal);
}
