/*
* Copyright (C) 2022 Texas Instruments Incorporated - TI web adress www.ti.com
*
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

#ifndef REG_PINMUX_H
#define REG_PINMUX_H

#include "sys_common.h"

/*---------------------------------------------------------------------------------------
 * MSS_IOMUX_REGS
 *---------------------------------------------------------------------------------------
 */

/** @typedef pinMuxBase_t
*   @brief Pinmux Register Frame Type Definition
*
*   This type is used to access the Pinmux Registers.
*/
typedef volatile struct
{
    uint32 IOMUX_QSPI0_CSN1_CFG_REG;
    uint32 IOMUX_QSPI0_CSN0_CFG_REG;
    uint32 IOMUX_QSPI0_CLK_CFG_REG;
    uint32 IOMUX_QSPI0_D0_CFG_REG;
    uint32 IOMUX_QSPI0_D1_CFG_REG;
    uint32 IOMUX_QSPI0_D2_CFG_REG;
    uint32 IOMUX_QSPI0_D3_CFG_REG;
    uint32 IOMUX_MCAN0_RX_CFG_REG;
    uint32 IOMUX_MCAN0_TX_CFG_REG;
    uint32 IOMUX_MCAN1_RX_CFG_REG;
    uint32 IOMUX_MCAN1_TX_CFG_REG;
    uint32 IOMUX_SPI0_CS0_CFG_REG;
    uint32 IOMUX_SPI0_CLK_CFG_REG;
    uint32 IOMUX_SPI0_D0_CFG_REG;
    uint32 IOMUX_SPI0_D1_CFG_REG;
    uint32 IOMUX_SPI1_CS0_CFG_REG;
    uint32 IOMUX_SPI1_CLK_CFG_REG;
    uint32 IOMUX_SPI1_D0_CFG_REG;
    uint32 IOMUX_SPI1_D1_CFG_REG;
    uint32 IOMUX_LIN1_RXD_CFG_REG;
    uint32 IOMUX_LIN1_TXD_CFG_REG;
    uint32 IOMUX_LIN2_RXD_CFG_REG;
    uint32 IOMUX_LIN2_TXD_CFG_REG;
    uint32 IOMUX_I2C1_SCL_CFG_REG;
    uint32 IOMUX_I2C1_SDA_CFG_REG;
    uint32 IOMUX_UART0_RTSN_CFG_REG;
    uint32 IOMUX_UART0_CTSN_CFG_REG;
    uint32 IOMUX_UART0_RXD_CFG_REG;
    uint32 IOMUX_UART0_TXD_CFG_REG;
    uint32 IOMUX_RGMII1_RXC_CFG_REG;
    uint32 IOMUX_RGMII1_RX_CTL_CFG_REG;
    uint32 IOMUX_RGMII1_RD0_CFG_REG;
    uint32 IOMUX_RGMII1_RD1_CFG_REG;
    uint32 IOMUX_RGMII1_RD2_CFG_REG;
    uint32 IOMUX_RGMII1_RD3_CFG_REG;
    uint32 IOMUX_RGMII1_TXC_CFG_REG;
    uint32 IOMUX_RGMII1_TX_CTL_CFG_REG;
    uint32 IOMUX_RGMII1_TD0_CFG_REG;
    uint32 IOMUX_RGMII1_TD1_CFG_REG;
    uint32 IOMUX_RGMII1_TD2_CFG_REG;
    uint32 IOMUX_RGMII1_TD3_CFG_REG;
    uint32 IOMUX_MDIO0_MDIO_CFG_REG;
    uint32 IOMUX_MDIO0_MDC_CFG_REG;
    uint32 IOMUX_EPWM0_A_CFG_REG;
    uint32 IOMUX_EPWM0_B_CFG_REG;
    uint32 IOMUX_EPWM1_A_CFG_REG;
    uint32 IOMUX_EPWM1_B_CFG_REG;
    uint32 IOMUX_EPWM2_A_CFG_REG;
    uint32 IOMUX_EPWM2_B_CFG_REG;
    uint32 IOMUX_EPWM3_A_CFG_REG;
    uint32 IOMUX_EPWM3_B_CFG_REG;
    uint32 IOMUX_EPWM4_A_CFG_REG;
    uint32 IOMUX_EPWM4_B_CFG_REG;
    uint32 IOMUX_EPWM5_A_CFG_REG;
    uint32 IOMUX_EPWM5_B_CFG_REG;
    uint32 IOMUX_EPWM6_A_CFG_REG;
    uint32 IOMUX_EPWM6_B_CFG_REG;
    uint32 IOMUX_EPWM7_A_CFG_REG;
    uint32 IOMUX_EPWM7_B_CFG_REG;
    uint32 IOMUX_EPWM8_A_CFG_REG;
    uint32 IOMUX_EPWM8_B_CFG_REG;
    uint32 IOMUX_EPWM9_A_CFG_REG;
    uint32 IOMUX_EPWM9_B_CFG_REG;
    uint32 IOMUX_EPWM10_A_CFG_REG;
    uint32 IOMUX_EPWM10_B_CFG_REG;
    uint32 IOMUX_EPWM11_A_CFG_REG;
    uint32 IOMUX_EPWM11_B_CFG_REG;
    uint32 IOMUX_EPWM12_A_CFG_REG;
    uint32 IOMUX_EPWM12_B_CFG_REG;
    uint32 IOMUX_EPWM13_A_CFG_REG;
    uint32 IOMUX_EPWM13_B_CFG_REG;
    uint32 IOMUX_EPWM14_A_CFG_REG;
    uint32 IOMUX_EPWM14_B_CFG_REG;
    uint32 IOMUX_EPWM15_A_CFG_REG;
    uint32 IOMUX_EPWM15_B_CFG_REG;
    uint32 IOMUX_UART1_RXD_CFG_REG;
    uint32 IOMUX_UART1_TXD_CFG_REG;
    uint32 IOMUX_MMC0_CLK_CFG_REG;
    uint32 IOMUX_MMC0_CMD_CFG_REG;
    uint32 IOMUX_MMC0_D0_CFG_REG;
    uint32 IOMUX_MMC0_D1_CFG_REG;
    uint32 IOMUX_MMC0_D2_CFG_REG;
    uint32 IOMUX_MMC0_D3_CFG_REG;
    uint32 IOMUX_MMC0_WP_CFG_REG;
    uint32 IOMUX_MMC0_CD_CFG_REG;
    uint32 IOMUX_PR0_MDIO0_MDIO_CFG_REG;
    uint32 IOMUX_PR0_MDIO0_MDC_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO5_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO9_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO10_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO8_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO6_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO4_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO0_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO1_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO2_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO3_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO16_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO15_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO11_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO12_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO13_CFG_REG;
    uint32 IOMUX_PR0_PRU0_GPO14_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO5_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO9_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO10_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO8_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO6_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO4_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO0_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO1_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO2_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO3_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO16_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO15_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO11_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO12_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO13_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO14_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO19_CFG_REG;
    uint32 IOMUX_PR0_PRU1_GPO18_CFG_REG;
    uint32 IOMUX_EXT_REFCLK0_CFG_REG;
    uint32 IOMUX_SDFM0_CLK0_CFG_REG;
    uint32 IOMUX_SDFM0_D0_CFG_REG;
    uint32 IOMUX_SDFM0_CLK1_CFG_REG;
    uint32 IOMUX_SDFM0_D1_CFG_REG;
    uint32 IOMUX_SDFM0_CLK2_CFG_REG;
    uint32 IOMUX_SDFM0_D2_CFG_REG;
    uint32 IOMUX_SDFM0_CLK3_CFG_REG;
    uint32 IOMUX_SDFM0_D3_CFG_REG;
    uint32 IOMUX_EQEP0_A_CFG_REG;
    uint32 IOMUX_EQEP0_B_CFG_REG;
    uint32 IOMUX_EQEP0_STROBE_CFG_REG;
    uint32 IOMUX_EQEP0_INDEX_CFG_REG;
    uint32 IOMUX_I2C0_SDA_CFG_REG;
    uint32 IOMUX_I2C0_SCL_CFG_REG;
    uint32 IOMUX_MCAN2_TX_CFG_REG;
    uint32 IOMUX_MCAN2_RX_CFG_REG;
    uint32 IOMUX_CLKOUT0_CFG_REG;
    uint32 IOMUX_WARMRSTN_CFG_REG;
    uint32 IOMUX_SAFETY_ERRORN_CFG_REG;
    uint32 IOMUX_TDI_CFG_REG;
    uint32 IOMUX_TDO_CFG_REG;
    uint32 IOMUX_TMS_CFG_REG;
    uint32 IOMUX_TCK_CFG_REG;
    uint32 IOMUX_QSPI0_CLKLB_CFG_REG;
    uint32 IOMUX_QUAL_GRP_0_CFG_REG;
    uint32 IOMUX_QUAL_GRP_1_CFG_REG;
    uint32 IOMUX_QUAL_GRP_2_CFG_REG;
    uint32 IOMUX_QUAL_GRP_3_CFG_REG;
    uint32 IOMUX_QUAL_GRP_4_CFG_REG;
    uint32 IOMUX_QUAL_GRP_5_CFG_REG;
    uint32 IOMUX_QUAL_GRP_6_CFG_REG;
    uint32 IOMUX_QUAL_GRP_7_CFG_REG;
    uint32 IOMUX_QUAL_GRP_8_CFG_REG;
    uint32 IOMUX_QUAL_GRP_9_CFG_REG;
    uint32 IOMUX_QUAL_GRP_10_CFG_REG;
    uint32 IOMUX_QUAL_GRP_11_CFG_REG;
    uint32 IOMUX_QUAL_GRP_12_CFG_REG;
    uint32 IOMUX_QUAL_GRP_13_CFG_REG;
    uint32 IOMUX_QUAL_GRP_14_CFG_REG;
    uint32 IOMUX_QUAL_GRP_15_CFG_REG;
    uint32 IOMUX_QUAL_GRP_16_CFG_REG;
    uint32 IOMUX_QUAL_GRP_17_CFG_REG;
    uint32 IOMUX_USER_MODE_EN;
    uint32 IOMUX_PADGLBL_CFG_REG;
    uint32 IOMUX_IO_CFG_KICK0;
    uint32 IOMUX_IO_CFG_KICK1;
} pinMuxBase_t;

/** @def pinMuxReg
*   @brief  Register Frame Pointer
*
*   This pointer is used by the PinMux driver to access the pinmux module registers.
*/
#define pinMuxReg ((pinMuxBase_t *)0x53100000U)

#define pinMuxBase ((uint32 *)0x53100000U)

#endif
/*
 * END OF REG_PINMUX_H
 */

