/* ======================================================================
 *   Copyright (c) 2021 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     WdgApp.h
 *
 *  \brief    WDG example header file
 *
 */

#ifndef WDG_APP_H_
#define WDG_APP_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
extern "C"
{
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define APP_NAME                        "WDG_APP"

/* Default loop count. */
#define WDG_APP_LOOP_COUNT              (1U)

/* Number of times to service wdt before letting it expire */
#define WDG_APP_SERVICE_LOOP_COUNT         (0xFFU)

#define CSL_TOP_CTRL_LOCK0_KICK0                                          (0x00001008U)
#define CSL_TOP_CTRL_LOCK0_KICK1                                          (0x0000100CU)

/* LOCK0_KICK0 */

#define CSL_TOP_CTRL_LOCK0_KICK0_LOCK0_KICK0_MASK                         (0xFFFFFFFFU)
#define CSL_TOP_CTRL_LOCK0_KICK0_LOCK0_KICK0_SHIFT                        (0x00000000U)
#define CSL_TOP_CTRL_LOCK0_KICK0_LOCK0_KICK0_RESETVAL                     (0x00000000U)
#define CSL_TOP_CTRL_LOCK0_KICK0_LOCK0_KICK0_MAX                          (0xFFFFFFFFU)

#define CSL_TOP_CTRL_LOCK0_KICK0_RESETVAL                                 (0x00000000U)

/* LOCK0_KICK1 */

#define CSL_TOP_CTRL_LOCK0_KICK1_LOCK0_KICK1_MASK                         (0xFFFFFFFFU)
#define CSL_TOP_CTRL_LOCK0_KICK1_LOCK0_KICK1_SHIFT                        (0x00000000U)
#define CSL_TOP_CTRL_LOCK0_KICK1_LOCK0_KICK1_RESETVAL                     (0x00000000U)
#define CSL_TOP_CTRL_LOCK0_KICK1_LOCK0_KICK1_MAX                          (0xFFFFFFFFU)

#define CSL_TOP_CTRL_LOCK0_KICK1_RESETVAL                                 (0x00000000U)

#define CSL_CONTROLSS_CTRL_U_BASE                  (0x502F0000ul)
#define CSL_CONTROLSS_CTRL_LOCK0_KICK0                                   (0x00001008U)
#define CSL_CONTROLSS_CTRL_LOCK0_KICK1                                   (0x0000100CU)

/* LOCK0_KICK0 */

#define CSL_CONTROLSS_CTRL_LOCK0_KICK0_LOCK0_KICK0_MASK                  (0xFFFFFFFFU)
#define CSL_CONTROLSS_CTRL_LOCK0_KICK0_LOCK0_KICK0_SHIFT                 (0x00000000U)
#define CSL_CONTROLSS_CTRL_LOCK0_KICK0_LOCK0_KICK0_RESETVAL              (0x00000000U)
#define CSL_CONTROLSS_CTRL_LOCK0_KICK0_LOCK0_KICK0_MAX                   (0xFFFFFFFFU)

#define CSL_CONTROLSS_CTRL_LOCK0_KICK0_RESETVAL                          (0x00000000U)

/* LOCK0_KICK1 */

#define CSL_CONTROLSS_CTRL_LOCK0_KICK1_LOCK0_KICK1_MASK                  (0xFFFFFFFFU)
#define CSL_CONTROLSS_CTRL_LOCK0_KICK1_LOCK0_KICK1_SHIFT                 (0x00000000U)
#define CSL_CONTROLSS_CTRL_LOCK0_KICK1_LOCK0_KICK1_RESETVAL              (0x00000000U)
#define CSL_CONTROLSS_CTRL_LOCK0_KICK1_LOCK0_KICK1_MAX                   (0xFFFFFFFFU)

#define CSL_CONTROLSS_CTRL_LOCK0_KICK1_RESETVAL                          (0x00000000U)

/*Control MMRs partition*/
#define MSS_CTRL_PARTITION0                                (1)
#define TOP_CTRL_PARTITION0                                (2)
#define CONTROLSS_CTRL_PARTITION0                          (3)

/*Clock and reset MMRs partition*/
#define MSS_RCM_PARTITION0                                 (4)
#define TOP_RCM_PARTITION0                                 (5)

#define CSL_CONTROLSS_CTRL_EPWM_STATICXBAR_SEL0       (0x00000004U)
#define CSL_CONTROLSS_INTXBAR_U_BASE                  (0x502D5000ul)

/* define the unlock and lock values for MSS_CTRL, TOP_CTRL, MSS_RCM, TOP_RCM*/
#define TEST_KICK_LOCK_VAL                           (0x00000000U)
#define TEST_KICK0_UNLOCK_VAL                        (0x01234567U)
#define TEST_KICK1_UNLOCK_VAL                        (0x0FEDCBA8U)

/** @brief Number of ETPWM instances */
#define CSL_ETPWM_PER_CNT                (32U)
#define CONTROLSS_CTRL_PARTITION0                          (3)

#define CSL_CONTROLSS_CTRL_EPWM_CLKSYNC                                  (0x00000010U)

/* EPWM_CLKSYNC */

#define CSL_CONTROLSS_CTRL_EPWM_CLKSYNC_BIT_MASK                         (0xFFFFFFFFU)
#define CSL_CONTROLSS_CTRL_EPWM_CLKSYNC_BIT_SHIFT                        (0x00000000U)
#define CSL_CONTROLSS_CTRL_EPWM_CLKSYNC_BIT_RESETVAL                     (0x00000000U)
#define CSL_CONTROLSS_CTRL_EPWM_CLKSYNC_BIT_MAX                          (0xFFFFFFFFU)

#define CSL_CONTROLSS_CTRL_EPWM_CLKSYNC_RESETVAL                         (0x00000000U)

/* INTXBAR0_G0 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_SEL_MASK                              (0xFFFFFFFFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_SEL_MAX                               (0xFFFFFFFFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0_RESETVAL                              (0x00000000U)

/* INTXBAR0_G1 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_SEL_MASK                              (0xFFFFFFFFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_SEL_MAX                               (0xFFFFFFFFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1_RESETVAL                              (0x00000000U)

/* INTXBAR0_G2 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_SEL_MASK                              (0x01FFFFFFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_SEL_MAX                               (0x01FFFFFFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2_RESETVAL                              (0x00000000U)

/* INTXBAR0_G3 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_SEL_MASK                              (0x0000FFFFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_SEL_MAX                               (0x0000FFFFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3_RESETVAL                              (0x00000000U)

/* INTXBAR0_G4 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_SEL_MASK                              (0x000003FFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_SEL_MAX                               (0x000003FFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4_RESETVAL                              (0x00000000U)

/* INTXBAR0_G5 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_SEL_MASK                              (0x000003FFU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_SEL_MAX                               (0x000003FFU)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5_RESETVAL                              (0x00000000U)

/* INTXBAR0_G6 */

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_SEL_MASK                              (0x00000007U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_SEL_SHIFT                             (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_SEL_RESETVAL                          (0x00000000U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_SEL_MAX                               (0x00000007U)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6_RESETVAL                              (0x00000000U)

#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G0                                       (0x00000100U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G1                                       (0x00000104U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G2                                       (0x00000108U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G3                                       (0x0000010CU)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G4                                       (0x00000110U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G5                                       (0x00000114U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR0_G6                                       (0x00000118U)
#define CSL_CONTROLSS_INTXBAR_INTXBAR1_G0                                       (0x00000140U)

#define CSL_CONTROLSS_INPUTXBAR_STEP        (CSL_CONTROLSS_INPUTXBAR_INPUTXBAR1_GSEL - CSL_CONTROLSS_INPUTXBAR_INPUTXBAR0_GSEL)
#define CSL_CONTROLSS_PWMXBAR_STEP          (CSL_CONTROLSS_PWMXBAR_PWMXBAR1_G0 - CSL_CONTROLSS_PWMXBAR_PWMXBAR0_G0)
#define CSL_CONTROLSS_MDLXBAR_STEP          (CSL_CONTROLSS_MDLXBAR_MDLXBAR1_G0 - CSL_CONTROLSS_MDLXBAR_MDLXBAR0_G0)
#define CSL_CONTROLSS_ICLXBAR_STEP          (CSL_CONTROLSS_ICLXBAR_ICLXBAR1_G0 - CSL_CONTROLSS_ICLXBAR_ICLXBAR0_G0)
#define CSL_CONTROLSS_INTXBAR_STEP          (CSL_CONTROLSS_INTXBAR_INTXBAR1_G0 - CSL_CONTROLSS_INTXBAR_INTXBAR0_G0)
#define CSL_CONTROLSS_DMAXBAR_STEP          (CSL_CONTROLSS_DMAXBAR_DMAXBAR1_GSEL - CSL_CONTROLSS_DMAXBAR_DMAXBAR0_GSEL)
#define CSL_CONTROLSS_OUTPUTXBAR_STEP       (CSL_CONTROLSS_OUTPUTXBAR_OUTPUTXBAR1_G0 - CSL_CONTROLSS_OUTPUTXBAR_OUTPUTXBAR0_G0)
#define CSL_CONTROLSS_PWMSYNCOUTXBAR_STEP   (CSL_CONTROLSS_PWMSYNCOUTXBAR_PWMSYNCOUTXBAR1_G0 - CSL_CONTROLSS_PWMSYNCOUTXBAR_PWMSYNCOUTXBAR0_G0)

#define CSL_CONTROLSS_INPUTXBAR_PID                                             (0x00000000U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR0_GSEL                                 (0x00000100U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR0_G0                                   (0x00000104U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR0_G1                                   (0x00000108U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR1_GSEL                                 (0x00000140U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR1_G0                                   (0x00000144U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR1_G1                                   (0x00000148U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR2_GSEL                                 (0x00000180U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR2_G0                                   (0x00000184U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR2_G1                                   (0x00000188U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR3_GSEL                                 (0x000001C0U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR3_G0                                   (0x000001C4U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR3_G1                                   (0x000001C8U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR4_GSEL                                 (0x00000200U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR4_G0                                   (0x00000204U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR4_G1                                   (0x00000208U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR5_GSEL                                 (0x00000240U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR5_G0                                   (0x00000244U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR5_G1                                   (0x00000248U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR6_GSEL                                 (0x00000280U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR6_G0                                   (0x00000284U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR6_G1                                   (0x00000288U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR7_GSEL                                 (0x000002C0U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR7_G0                                   (0x000002C4U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR7_G1                                   (0x000002C8U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR8_GSEL                                 (0x00000300U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR8_G0                                   (0x00000304U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR8_G1                                   (0x00000308U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR9_GSEL                                 (0x00000340U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR9_G0                                   (0x00000344U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR9_G1                                   (0x00000348U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR10_GSEL                                (0x00000380U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR10_G0                                  (0x00000384U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR10_G1                                  (0x00000388U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR11_GSEL                                (0x000003C0U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR11_G0                                  (0x000003C4U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR11_G1                                  (0x000003C8U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR12_GSEL                                (0x00000400U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR12_G0                                  (0x00000404U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR12_G1                                  (0x00000408U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR13_GSEL                                (0x00000440U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR13_G0                                  (0x00000444U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR13_G1                                  (0x00000448U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR14_GSEL                                (0x00000480U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR14_G0                                  (0x00000484U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR14_G1                                  (0x00000488U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR15_GSEL                                (0x000004C0U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR15_G0                                  (0x000004C4U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR15_G1                                  (0x000004C8U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR16_GSEL                                (0x00000500U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR16_G0                                  (0x00000504U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR16_G1                                  (0x00000508U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR17_GSEL                                (0x00000540U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR17_G0                                  (0x00000544U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR17_G1                                  (0x00000548U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR18_GSEL                                (0x00000580U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR18_G0                                  (0x00000584U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR18_G1                                  (0x00000588U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR19_GSEL                                (0x000005C0U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR19_G0                                  (0x000005C4U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR19_G1                                  (0x000005C8U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR20_GSEL                                (0x00000600U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR20_G0                                  (0x00000604U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR20_G1                                  (0x00000608U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR21_GSEL                                (0x00000640U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR21_G0                                  (0x00000644U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR21_G1                                  (0x00000648U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR22_GSEL                                (0x00000680U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR22_G0                                  (0x00000684U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR22_G1                                  (0x00000688U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR23_GSEL                                (0x000006C0U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR23_G0                                  (0x000006C4U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR23_G1                                  (0x000006C8U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR24_GSEL                                (0x00000700U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR24_G0                                  (0x00000704U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR24_G1                                  (0x00000708U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR25_GSEL                                (0x00000740U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR25_G0                                  (0x00000744U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR25_G1                                  (0x00000748U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR26_GSEL                                (0x00000780U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR26_G0                                  (0x00000784U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR26_G1                                  (0x00000788U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR27_GSEL                                (0x000007C0U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR27_G0                                  (0x000007C4U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR27_G1                                  (0x000007C8U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR28_GSEL                                (0x00000800U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR28_G0                                  (0x00000804U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR28_G1                                  (0x00000808U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR29_GSEL                                (0x00000840U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR29_G0                                  (0x00000844U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR29_G1                                  (0x00000848U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR30_GSEL                                (0x00000880U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR30_G0                                  (0x00000884U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR30_G1                                  (0x00000888U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR31_GSEL                                (0x000008C0U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR31_G0                                  (0x000008C4U)
#define CSL_CONTROLSS_INPUTXBAR_INPUTXBAR31_G1                                  (0x000008C8U)


#define CSL_TOP_CTRL_ADC_REFBUF0_CTRL                                     (0x00000C00U)
#define CSL_TOP_CTRL_ADC_REFBUF1_CTRL                                     (0x00000C04U)
#define CSL_TOP_CTRL_U_BASE                                               (0x50D80000U)
#define CSL_TOP_CTRL_ADC_REF_COMP_CTRL                                    (0x00000C08U)
#define CSL_TOP_CTRL_ADC_REF_GOOD_STATUS                                  (0x00000C0CU)
#define CSL_TOP_CTRL_VMON_CTRL                                            (0x00000C10U)
#define CSL_TOP_CTRL_VMON_STAT                                            (0x00000C14U)
#define CSL_TOP_CTRL_PMU_COARSE_STAT                                      (0x00000C18U)
#define CSL_TOP_CTRL_MASK_VMON_ERROR_ESM_H                                (0x00000C20U)
#define CSL_TOP_CTRL_MASK_VMON_ERROR_ESM_L                                (0x00000C24U)
#define CSL_TOP_CTRL_MASK_ANA_ISO                                         (0x00000C30U)
#define CSL_TOP_CTRL_VMON_FILTER_CTRL                                     (0x00000C34U)
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/**
 *  \brief SPI application test parameters.
 *  The test case execution happens based on values of this structure
 */
typedef struct
{
    char          *testDescStr;
    /**< Test description. */
    uint32         loopCount;
    /**< Number of iteration. */
    uint32         serviceInterval;
    /**< wdg service interval (in millisecond) */
    const Wdg_ConfigType *wdgConfig;
    /**< WDG configuration */
    uint32         numServiceCount;
    /**< Number of times to service the watchdog before letting it expire */
    uint32         testId;
    /**< Test ID for print purpose. This is initialized in the code */
} Wdg_App_TestParams;

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
extern CONST(Wdg_ConfigType, WDG_PBCFG) WdgSettingsConfig;

static Wdg_App_TestParams Wdg_AppTestPrms[] =
{
    [0] =
    {
        .testId = 0U,
        .loopCount       = WDG_APP_LOOP_COUNT,
        .testDescStr     = "AM263x WDG Example",
        .numServiceCount = 100,
        .serviceInterval = 25, /* In millisecond */
        .wdgConfig       = &WdgSettingsConfig,
    },
};

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef WDG_APP_H_ */
