/*
*
* Copyright (c) 2023 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

  /*****************************************************************************
    Project: AM263x
    Date   : 2023-05-05 22:44:32

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 ******************************************************************************/

/**
 *  \file     Adc_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for ADC MCAL driver
 *
 */

/**
 *  \defgroup MCAL_ADC_CFG ADC Configuration
 *
 *  This files defines ADC MCAL configuration structures
 *  @{
 */


#ifndef ADC_CFG_H_
#define ADC_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "Std_Types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 *  \name ADC Driver Configuration SW Version Info
 *
 *  Defines for ADC Driver configuration version
 *  @{
 */
/** \brief ADC configuration Major Version */
#define ADC_CFG_MAJOR_VERSION                 (8U)
/** \brief CDD DMA configuration Minor Version */
#define ADC_CFG_MINOR_VERSION                 (6U)
/** \brief CDD DMA configuration Patch Version */
#define ADC_CFG_PATCH_VERSION                 (2U)
/* @} */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/**
*  \brief ADC Build Variant.
*   Build variants.(i.e Pre Compile,Post Build)
*/
#define ADC_VARIANT_PRE_COMPILE   (STD_OFF)

#define ADC_VARIANT_POST_BUILD    (STD_ON)



/** \brief Enable/disable ADC dev detect error */
#define ADC_DEV_ERROR_DETECT             (STD_ON)

/** \brief Enable/disable ADC group log */
#define ADC_GROUP_LOG                    (STD_ON)

/** \brief Enable/disable ADC group Error log */
#define ADC_ERR_LOG                      (STD_ON)

/** \brief Maximum group log entries when logging is ON */
#define ADC_MAX_GROUP_LOG               (100U)

/** \brief Maximum Error log entries when logging is ON */
#define ADC_MAX_ERR_LOG                 (100U)

/** \brief Counter ID for counter used to count wait ticks */
#define ADC_OS_COUNTER_ID               (0U)

/** \brief Enable/disable ADC get version info API */
#define ADC_VERSION_INFO_API             (STD_ON)

/** \brief Read group API */
#define ADC_READ_GROUP_API               (STD_ON)

/** \brief Enable/disable ADC enable/disable group notify API */
#define ADC_GRP_NOTIF_CAPABILITY_API     (STD_ON)

/** \brief Enable/disable ADC AdcStartGroupConversion and  AdcStopGroupConversion API */
#define ADC_ENABLE_START_STOP_GROUP_API  (STD_ON)

/** \brief Enable/disable ADC AdcEnableHardwareTrigger and AdcDisableHardwareTrigger group notify API */
#define ADC_HW_TRIGGER_API  (STD_ON)

/** \brief Enable/disable ADC DMA Access method. */
#define ADC_DMA_MODE                   (STD_ON)

/** \brief Enable/disable ADC deinit API */
#define ADC_DEINIT_API                   (STD_ON)

/** \brief Determines whether a priority mechanism is available for
 *   prioritization of the conversion requests and if available, the type of
 *   prioritization mechanism */
#define ADC_PRIORITY_NONE      (0)
#define ADC_PRIORITY_HW        (1)
#define ADC_PRIORITY_HW_SW     (2)
#define ADC_PRIORITY_IMPLEMENTATION     (ADC_PRIORITY_HW_SW)

/** \brief Determines, if the queuing mechanism is active in case of priority
 *   mechanism disabled */
#define ADC_ENABLE_QUEUING               (STD_ON)

/** \brief Determines, if the Limit Check feature is enabled for channels. */
#define ADC_ENABLE_LIMIT_CHECK          (STD_OFF)

/** \brief Alignment of ADC raw results in ADC result buffer
 *  (left/right alignment) */
#define ADC_ALIGN_LEFT                  (0) 
#define ADC_ALIGN_RIGHT                 (1) 
#define ADC_RESULT_ALIGNMENT            (ADC_ALIGN_RIGHT)


/** \brief Maximum group across all hwunit */
#define ADC_MAX_GROUP                   ((uint8)6U)


/**
 *  \brief Maximum HW unit - This should match the sum for the below units ISR
 *  which are ON.
 */
#define ADC_MAX_HW_UNIT                 ((uint8)2U)

/*
 * All below macros are used for enabling the ISR for a particular hardware.
 */
/*!< ADC UNIT INSTANCE */
#define ADC_INSTANCE_0
/*!< ADC UNIT INSTANCE */
#define ADC_INSTANCE_3


/** \brief ISR type */
#define ADC_ISR_TYPE                    (ADC_ISR_CAT1)

/** \brief Enable/disable ADC register read back API */
#define ADC_REGISTER_READBACK_API        (STD_ON)

/**
 *  \name Adc Group Id names
 *
 *  Defines for symbolic names for the AdcGroupId
 *  @{
 */
#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_0   (0)
#define ADC_GROUP_ID_0 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_0

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_1   (1)
#define ADC_GROUP_ID_1 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_1

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2   (2)
#define ADC_GROUP_ID_2 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_3   (3)
#define ADC_GROUP_ID_3 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_3

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_4   (4)
#define ADC_GROUP_ID_4 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_4

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5   (5)
#define ADC_GROUP_ID_5 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5


/* @} */

/**
 *  \name Adc Hw Unit Id names
 *
 *  Defines for symbolic names for the AdcHwUnitId
 *  @{
 */
#define AdcConf_AdcHwUnit_AdcHwUnit_0   0
#define ADC_HW_UNIT_ID_0 (ADC_HWUNIT_0)
#define AdcConf_AdcHwUnit_AdcHwUnit_1   1
#define ADC_HW_UNIT_ID_1 (ADC_HWUNIT_3)

/* @} */

/**
 *  \name Adc Group Channel Id names
 *
 *  Defines for symbolic names for the Adc Group Channel Id
 *  @{
 */
/** \brief Channel Ids for each group*/

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_0_AdcChannel_AdcChannel_0 (0U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_GROUP_ID_AdcGroup_0_CHANNEL_ID_ADCCHANNEL_0 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_0_AdcChannel_AdcChannel_0

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_1_AdcChannel_AdcChannel_0 (0U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_GROUP_ID_AdcGroup_1_CHANNEL_ID_ADCCHANNEL_0 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_1_AdcChannel_AdcChannel_0

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2_AdcChannel_AdcChannel_0 (0U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_GROUP_ID_AdcGroup_2_CHANNEL_ID_ADCCHANNEL_0 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2_AdcChannel_AdcChannel_0

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2_AdcChannel_AdcChannel_2 (2U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_GROUP_ID_AdcGroup_2_CHANNEL_ID_ADCCHANNEL_2 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2_AdcChannel_AdcChannel_2

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2_AdcChannel_AdcChannel_2 (2U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_GROUP_ID_AdcGroup_2_CHANNEL_ID_ADCCHANNEL_2 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2_AdcChannel_AdcChannel_2

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2_AdcChannel_AdcChannel_3 (3U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_GROUP_ID_AdcGroup_2_CHANNEL_ID_ADCCHANNEL_3 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2_AdcChannel_AdcChannel_3

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_3_AdcChannel_AdcChannel_0 (0U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_GROUP_ID_AdcGroup_3_CHANNEL_ID_ADCCHANNEL_0 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_3_AdcChannel_AdcChannel_0

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_3_AdcChannel_AdcChannel_1 (1U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_GROUP_ID_AdcGroup_3_CHANNEL_ID_ADCCHANNEL_1 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_3_AdcChannel_AdcChannel_1

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_4_AdcChannel_AdcChannel_0 (0U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_GROUP_ID_AdcGroup_4_CHANNEL_ID_ADCCHANNEL_0 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_4_AdcChannel_AdcChannel_0

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_0 (0U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_GROUP_ID_AdcGroup_5_CHANNEL_ID_ADCCHANNEL_0 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_0

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_1 (1U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_GROUP_ID_AdcGroup_5_CHANNEL_ID_ADCCHANNEL_1 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_1

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_2 (2U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_GROUP_ID_AdcGroup_5_CHANNEL_ID_ADCCHANNEL_2 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_2

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_3 (3U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_GROUP_ID_AdcGroup_5_CHANNEL_ID_ADCCHANNEL_3 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_3

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_4 (4U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_GROUP_ID_AdcGroup_5_CHANNEL_ID_ADCCHANNEL_4 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_4

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_5 (5U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_GROUP_ID_AdcGroup_5_CHANNEL_ID_ADCCHANNEL_5 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5_AdcChannel_AdcChannel_5

/* @} */

/**
 *  \name Adc Channel Id names
 *
 *  Defines for symbolic names for the Adc Channel Id
 *  @{
 */
/** \brief Channel Ids for all channels */

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_0 (0U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_CHANNEL_ID_ADCCHANNEL_0 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_0

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_1 (1U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_CHANNEL_ID_ADCCHANNEL_1 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_1

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_2 (2U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_CHANNEL_ID_ADCCHANNEL_2 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_2

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_3 (3U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_CHANNEL_ID_ADCCHANNEL_3 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_3

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_4 (4U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_CHANNEL_ID_ADCCHANNEL_4 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_4

#define AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_5 (5U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_0_CHANNEL_ID_ADCCHANNEL_5 AdcConf_AdcHwUnit_AdcHwUnit_0_AdcChannel_AdcChannel_5

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_0 (0U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_CHANNEL_ID_ADCCHANNEL_0 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_0

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_1 (1U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_CHANNEL_ID_ADCCHANNEL_1 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_1

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_2 (2U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_CHANNEL_ID_ADCCHANNEL_2 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_2

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_3 (3U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_CHANNEL_ID_ADCCHANNEL_3 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_3

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_4 (4U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_CHANNEL_ID_ADCCHANNEL_4 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_4

#define AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_5 (5U)
#define ADC_HW_UNIT_ID_ADCHWUNIT_1_CHANNEL_ID_ADCCHANNEL_5 AdcConf_AdcHwUnit_AdcHwUnit_1_AdcChannel_AdcChannel_5

/* @} */


/**
 *  \name ADC HW unit Info
 *  @{
 */
/** \brief ADC0 instance */
#define ADC_HWUNIT_0                      ((Adc_HWUnitType) 0U)
/** \brief ADC1 instance */
#define ADC_HWUNIT_1                      ((Adc_HWUnitType) 1U)
/** \brief ADC2 instance */
#define ADC_HWUNIT_2                      ((Adc_HWUnitType) 2U)
/** \brief ADC3 instance */
#define ADC_HWUNIT_3                      ((Adc_HWUnitType) 3U)
/** \brief ADC4 instance */
#define ADC_HWUNIT_4                      ((Adc_HWUnitType) 4U)

/**
 *  \brief Total HW units - used for array allocation. This should be +1 of the
 *  max unit number
 */
#define ADC_HW_UNIT_CNT                 (5U)


/**
 *  \name Adc DMA Id names
 *
 *  Defines for symbolic names for the AdcGroupId
 *  @{
 */

#define ADC_DMA_CHANNEL_ID_0   0

#define ADC_DMA_CHANNEL_ID_1   1

#define ADC_DMA_CHANNEL_ID_2   2

#define ADC_DMA_CHANNEL_ID_3   3

#define ADC_DMA_CHANNEL_ID_6   6

#define ADC_DMA_CHANNEL_ID_7   7

#define ADC_DMA_CHANNEL_ID_8   8

#define ADC_DMA_CHANNEL_ID_9   9

#define ADC_DMA_CHANNEL_ID_10   10

#define ADC_DMA_CHANNEL_ID_11   11

/** \brief Maximum DMA channels Configured. */
#define ADC_DMA_CHANNELS_CONFIGURED   (10)

/** \brief DMA Instance for ADC module. */
#define ADC_DMA_HANDLE_ID         ((uint8)0U) 

/** \brief Maximum DMA channels avialable. */
#define ADC_MAX_DMA_CHANNELS      ((uint8)63U)  
/* @} */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/** \brief ADC Configuration struct declaration */
extern const struct Adc_ConfigType_s AdcConfigSet;


#ifdef __cplusplus
}
#endif
















#endif  /* #ifndef ADC_CFG_H_ */

/* @} */
