/*
*
* Copyright (c) 2023 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/
  /*****************************************************************************
    Project: AM263x
    Date   : 2023-05-05 22:44:32
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way

 ******************************************************************************/

/*******************************************************************************
 *  INCLUDES
 ******************************************************************************/
#include "Std_Types.h"
#include "Adc.h"
#include "Adc_Irq.h"

/******************************************************************************
 *  VERSION CHECK
 ******************************************************************************/
#if ( (ADC_CFG_MAJOR_VERSION != (8U)) \
    ||(ADC_CFG_MINOR_VERSION != (6U)))
  #error "Version numbers of Adc_PBcfg.c and Adc_Cfg.h are inconsistent!"
#endif

/*******************************************************************************
 *  GLOBAL CONFIG DATA
 ******************************************************************************/
#define ADC_START_SEC_CONFIG_DATA
#include "Adc_MemMap.h"

#ifdef __cplusplus
extern "C" {
#endif




extern void AdcApp_HwUnit0_Group0EndNotification(void);
extern void AdcApp_HwUnit0_Group1EndNotification(void);
extern void AdcApp_HwUnit0_Group2EndNotification(void);
extern void AdcApp_HwUnit0_Group3EndNotification(void);
extern void AdcApp_HwUnit0_Group4EndNotification(void);
extern void AdcApp_HwUnit1_Group5EndNotification(void);

/* Create runtime configurations. */
CONST(struct Adc_ConfigType_s, ADC_CONFIG_DATA) AdcConfigSet =
{
    .maxGroup = 6U,
    .maxHwUnit = 2U,
    .groupCfg  =
    {
        [0] =
        {
            .groupId = AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_0,
            .groupPriority =0U,
            .hwUnitId = 0,
            .Adc_GroupEndNotification = AdcApp_HwUnit0_Group0EndNotification,
            .streamNumSamples = (Adc_StreamNumSampleType)1,
            .resolution = ADC_DEF_CHANNEL_RESOLUTION,/* This is not configurable and should be set to ADC_DEF_CHANNEL_RESOLUTION */
            .convMode = ADC_CONV_MODE_ONESHOT,
            .triggSrc = ADC_TRIGG_SRC_SW,
            .accessMode = ADC_ACCESS_MODE_SINGLE,
            .streamBufMode = ADC_STREAM_BUFFER_LINEAR,
            .hwTrigSignal = ADC_HW_TRIG_BOTH_EDGES,
            .hwTrigTimer =ADC_TRIGGER_SW_ONLY,            
            .groupReplacement = (Adc_GroupReplacementType)ADC_GROUP_REPL_SUSPEND_RESUME,
            .groupChannelMask = 0x1,
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
            .grouplimitcheck = FALSE,
#endif
            .groupDataAccessMode = ADC_GROUP_INTERRUPT_ACCESS,
            .numChannels = 1U,
            .channelConfig =
            {
                [0] =
                {
                    .hwChannelId = 0U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 0,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =2482,
                    .lowRange =1241,
#endif
                },
            },
        },
        [1] =
        {
            .groupId = AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_1,
            .groupPriority =2U,
            .hwUnitId = 0,
            .Adc_GroupEndNotification = AdcApp_HwUnit0_Group1EndNotification,
            .streamNumSamples = (Adc_StreamNumSampleType)1,
            .resolution = ADC_DEF_CHANNEL_RESOLUTION,/* This is not configurable and should be set to ADC_DEF_CHANNEL_RESOLUTION */
            .convMode = ADC_CONV_MODE_CONTINUOUS,
            .triggSrc = ADC_TRIGG_SRC_SW,
            .accessMode = ADC_ACCESS_MODE_SINGLE,
            .streamBufMode = ADC_STREAM_BUFFER_LINEAR,
            .hwTrigSignal = ADC_HW_TRIG_BOTH_EDGES,
            .hwTrigTimer =ADC_TRIGGER_SW_ONLY,            
            .groupReplacement = (Adc_GroupReplacementType)ADC_GROUP_REPL_SUSPEND_RESUME,
            .groupChannelMask = 0x1,
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
            .grouplimitcheck = FALSE,
#endif
            .groupDataAccessMode = ADC_GROUP_INTERRUPT_ACCESS,
            .numChannels = 1U,
            .channelConfig =
            {
                [0] =
                {
                    .hwChannelId = 0U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 0,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =2482,
                    .lowRange =1241,
#endif
                },
            },
        },
        [2] =
        {
            .groupId = AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_2,
            .groupPriority =3U,
            .hwUnitId = 0,
            .Adc_GroupEndNotification = AdcApp_HwUnit0_Group2EndNotification,
            .streamNumSamples = (Adc_StreamNumSampleType)1,
            .resolution = ADC_DEF_CHANNEL_RESOLUTION,/* This is not configurable and should be set to ADC_DEF_CHANNEL_RESOLUTION */
            .convMode = ADC_CONV_MODE_ONESHOT,
            .triggSrc = ADC_TRIGG_SRC_HW,
            .accessMode = ADC_ACCESS_MODE_SINGLE,
            .streamBufMode = ADC_STREAM_BUFFER_LINEAR,
            .hwTrigSignal = ADC_HW_TRIG_BOTH_EDGES,
            .hwTrigTimer =ADC_TRIGGER_EPWM0_SOCA,            
            .groupReplacement = (Adc_GroupReplacementType)ADC_GROUP_REPL_SUSPEND_RESUME,
            .groupChannelMask = 0xd,
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
            .grouplimitcheck = FALSE,
#endif
            .groupDataAccessMode = ADC_GROUP_INTERRUPT_ACCESS,
            .numChannels = 4U,
            .channelConfig =
            {
                [0] =
                {
                    .hwChannelId = 0U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 0,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =2482,
                    .lowRange =1241,
#endif
                },
                [1] =
                {
                    .hwChannelId = 2U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 2,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [2] =
                {
                    .hwChannelId = 2U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 2,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [3] =
                {
                    .hwChannelId = 3U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 3,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
            },
        },
        [3] =
        {
            .groupId = AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_3,
            .groupPriority =4U,
            .hwUnitId = 0,
            .Adc_GroupEndNotification = AdcApp_HwUnit0_Group3EndNotification,
            .streamNumSamples = (Adc_StreamNumSampleType)1,
            .resolution = ADC_DEF_CHANNEL_RESOLUTION,/* This is not configurable and should be set to ADC_DEF_CHANNEL_RESOLUTION */
            .convMode = ADC_CONV_MODE_ONESHOT,
            .triggSrc = ADC_TRIGG_SRC_HW,
            .accessMode = ADC_ACCESS_MODE_SINGLE,
            .streamBufMode = ADC_STREAM_BUFFER_LINEAR,
            .hwTrigSignal = ADC_HW_TRIG_BOTH_EDGES,
            .hwTrigTimer =ADC_TRIGGER_EPWM0_SOCB,            
            .groupReplacement = (Adc_GroupReplacementType)ADC_GROUP_REPL_SUSPEND_RESUME,
            .groupChannelMask = 0xd,
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
            .grouplimitcheck = FALSE,
#endif
            .groupDataAccessMode = ADC_GROUP_INTERRUPT_ACCESS,
            .numChannels = 4U,
            .channelConfig =
            {
                [0] =
                {
                    .hwChannelId = 0U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 0,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =2482,
                    .lowRange =1241,
#endif
                },
                [1] =
                {
                    .hwChannelId = 2U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 2,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [2] =
                {
                    .hwChannelId = 2U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 2,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [3] =
                {
                    .hwChannelId = 3U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 3,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
            },
        },
        [4] =
        {
            .groupId = AdcConf_AdcHwUnit_AdcHwUnit_0_AdcGroup_AdcGroup_4,
            .groupPriority =5U,
            .hwUnitId = 0,
            .Adc_GroupEndNotification = AdcApp_HwUnit0_Group4EndNotification,
            .streamNumSamples = (Adc_StreamNumSampleType)1,
            .resolution = ADC_DEF_CHANNEL_RESOLUTION,/* This is not configurable and should be set to ADC_DEF_CHANNEL_RESOLUTION */
            .convMode = ADC_CONV_MODE_ONESHOT,
            .triggSrc = ADC_TRIGG_SRC_HW,
            .accessMode = ADC_ACCESS_MODE_SINGLE,
            .streamBufMode = ADC_STREAM_BUFFER_LINEAR,
            .hwTrigSignal = ADC_HW_TRIG_BOTH_EDGES,
            .hwTrigTimer =ADC_TRIGGER_EPWM1_SOCB,            
            .groupReplacement = (Adc_GroupReplacementType)ADC_GROUP_REPL_SUSPEND_RESUME,
            .groupChannelMask = 0xd,
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
            .grouplimitcheck = FALSE,
#endif
            .groupDataAccessMode = ADC_GROUP_INTERRUPT_ACCESS,
            .numChannels = 4U,
            .channelConfig =
            {
                [0] =
                {
                    .hwChannelId = 0U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 0,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =2482,
                    .lowRange =1241,
#endif
                },
                [1] =
                {
                    .hwChannelId = 2U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 2,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [2] =
                {
                    .hwChannelId = 2U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 2,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [3] =
                {
                    .hwChannelId = 3U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 3,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
            },
        },
        [5] =
        {
            .groupId = AdcConf_AdcHwUnit_AdcHwUnit_1_AdcGroup_AdcGroup_5,
            .groupPriority =0U,
            .hwUnitId = 1,
            .Adc_GroupEndNotification = AdcApp_HwUnit1_Group5EndNotification,
            .streamNumSamples = (Adc_StreamNumSampleType)1,
            .resolution = ADC_DEF_CHANNEL_RESOLUTION,/* This is not configurable and should be set to ADC_DEF_CHANNEL_RESOLUTION */
            .convMode = ADC_CONV_MODE_ONESHOT,
            .triggSrc = ADC_TRIGG_SRC_SW,
            .accessMode = ADC_ACCESS_MODE_SINGLE,
            .streamBufMode = ADC_STREAM_BUFFER_LINEAR,
            .hwTrigSignal =ADC_HW_TRIG_BOTH_EDGES,
            .hwTrigTimer =ADC_TRIGGER_SW_ONLY,            
            .groupReplacement = (Adc_GroupReplacementType)ADC_GROUP_REPL_SUSPEND_RESUME,
            .groupChannelMask = 0x3f,
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
            .grouplimitcheck = FALSE,
#endif
            .groupDataAccessMode = ADC_GROUP_DMA_ACCESS,
            .numChannels = 6U,
            .channelConfig =
            {
                [0] =
                {
                    .hwChannelId = 0U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 6,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =2482,
                    .lowRange =1241,
#endif
                },
                [1] =
                {
                    .hwChannelId = 1U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 7,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [2] =
                {
                    .hwChannelId = 2U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 8,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [3] =
                {
                    .hwChannelId = 3U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 9,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [4] =
                {
                    .hwChannelId = 4U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 10,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
                [5] =
                {
                    .hwChannelId = 5U,
                    .samplewindow = 16U,
#if (STD_ON == ADC_DMA_MODE)
                    .adcDMAChannel = 11,
#endif
#if (STD_ON == ADC_ENABLE_LIMIT_CHECK)
                    .channelEnableLimitCheck =(FALSE),
                    .highRange =4095,
                    .lowRange =0,
#endif
                },
            },
        },
    },
    .hwUnitCfg =
    {
        [0] =
        {
            .hwUnitId = (Adc_HWUnitType)ADC_HWUNIT_0,
            .baseAddr =0x502c0000UL,
            .prescale = (Adc_mcalClkPrescale_t)ADC_CLK_DIV_1_0,
            .resolution = (Adc_mcalResolution_t)ADC_RESOLUTION_12BIT,
        },
        [1] =
        {
            .hwUnitId = (Adc_HWUnitType)ADC_HWUNIT_3,
            .baseAddr =0x502c3000UL,
            .prescale = (Adc_mcalClkPrescale_t)ADC_CLK_DIV_1_0,
            .resolution = (Adc_mcalResolution_t)ADC_RESOLUTION_12BIT,
        },
    },
};


#ifdef __cplusplus
}
#endif

#define ADC_STOP_SEC_CONFIG_DATA
#include "Adc_MemMap.h"

/*******************************************************************************
 *  END OF FILE: Adc_PBcfg.c
 ******************************************************************************/
