/* ======================================================================
*   Copyright (C) 2022-2023 Texas Instruments Incorporated
*
*   All rights reserved. Property of Texas Instruments Incorporated.
*   Restricted rights to use, duplicate or disclose this code are
*   granted through contract.
*
*   The program may not be used without the written permission
*   of Texas Instruments Incorporated or against the terms and conditions
*   stipulated in the agreement under which this program has been
*   supplied.
* ==================================================================== */
 /***************************************************************************
  Project: CAN
  Date   : 2023-05-11 16:50:45
  This file is generated by EB Tresos
  Do not modify this file, otherwise the software may behave in unexpected way.

 *****************************************************************************/

/**
 *  \file     Can_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file for
 *            CAN MCAL driver
 *
 */

/**
 *
 ******************************************************************************
 * \defgroup MCAL_CAN_CFG Can Configuration
 *
 * This files defines CAN MCAL configuration structures
 *  @{
 ******************************************************************************/

#ifndef CAN_CFG_H_
#define CAN_CFG_H_

#include "Dem.h"
#include "Os.h"
#ifdef __cplusplus
extern "C" {
#endif

/** \brief CAN Config ID */
#define CAN_CFG_ID          (CAN_CFG_ID_0)

/**
*  \brief CAN Build Variant.
*   Build variants.(i.e Pre Compile,Post Build)
*/

#define CAN_VARIANT_POST_BUILD	(STD_ON)

/**
 *  \name Can Driver Configuration SW Version Info
 *
 *  Defines for CAN Driver configuration version
 *  @{
 */
/** \brief Can configuration Major Version */
#define CAN_CFG_MAJOR_VERSION           (8U)
/** \brief Can configuration Minor Version */
#define CAN_CFG_MINOR_VERSION           (6U)
/** \brief Can configuration Patch Version */
#define CAN_CFG_PATCH_VERSION           (2U)
/* @} */

/**
 *  \name Can Driver Configuration SW Version Info
 *
 *  Pre-compile switches for enabling/disabling CAN MCAL APIs
 *  @{
 */
#define CAN_VERSION_INFO_API   (STD_ON)
/*!< Enable/Disable Can_GetVersionInfo() */

#define CAN_DEV_ERROR_DETECT  (STD_ON)
/*!< Enable/Disable DEV error detection */
#define CAN_DEINIT_API  (STD_ON)
/*!< Enable/Disable Can_DeInit() API */
#define CAN_SET_BAUDRATE_API  (STD_ON)
/*!< Enable/Disable Can_SetBaudrate() API */
#define CAN_LOOPBACK_ENABLE   (STD_ON)
/*!< Enable/Disable Can_TestLoopBackModeEnable() */
#define CAN_WAKEUP_FUNCTIONALITY_API        (STD_ON)
/*!< Enable/Disable Can_CheckWakeup() */
#define CAN_MULTIPLEXED_TRANSMISSION_ENABLE (STD_OFF)
/*!< Enable/Disable Multiplexed Transmission */

/**
*  \brief CAN Build Variant.
*   Build Variants.(i.e Pre-compile,Post-Build or Link time)
*/

 /*mixed mode is allowed */

#define CAN_TX_POLLING      (STD_ON)
/*!< Enable/Disable Can_MainFunction_Write */
#define CAN_RX_POLLING      (STD_ON)
/*!< Enable/Disable Can_MainFunction_Read */
#define CAN_BUSOFF_POLLING  (STD_ON)
/*!< Enable/Disable Can_MainFunction_BusOff */
#define CAN_WAKEUP_POLLING  (STD_ON)
/*!< Enable/Disable Can_MainFunction_Wakeup */
#define CAN_ECC_ENABLE      STD_OFF
/*!< Enable/Disable single bit ECC logic */
/* @} */

/*!< Maximum number of Config sets */
/*!< Max Baud rate config structs */
#define CAN_NUM_CONTROLLER          (4U)
/*!< Max number of controllers defined*/

#define CAN_NUM_MAILBOXES           (16U)
/*!< Max number of mailboxes defined*/
#define CAN_MAX_CONTROLLER          (4U)
/*!< Max number of mailboxes per controller */

#define CAN_NUM_TX_MAILBOXES 		(8U)
/*!< Total Number of TX mailboxes */

#define CAN_ISR_TYPE                (CAN_ISR_CAT1)
/*!< Enable/Disable OSEK Category 1 ISR */

/**
 *  \name Can Controller Id names
 *
 *  Defines for symbolic names for the CanControllerIds
 *  @{
 */
#define CanConf_CanController_CanController_0   (0U)
#define CanConf_CanController_CanController_1   (1U)
#define CanConf_CanController_CanController_2   (2U)
#define CanConf_CanController_CanController_3   (3U)
/* @} */

/* @} */

#define CAN_CONTROLLER_MCAN0
#define CAN_CONTROLLER_MCAN1
#define CAN_CONTROLLER_MCAN2
#define CAN_CONTROLLER_MCAN3

/**
 *  \name Can HW Object names
 *
 *  Defines for symbolic names for the CanHardwareObjectIds
 *  @{
 */

#define CanConf_CanHardwareObject_CanHardwareObject_0   (0U)
#define CAN_HTRH_0         (CanConf_CanHardwareObject_CanHardwareObject_0)

#define CanConf_CanHardwareObject_CanHardwareObject_1   (1U)
#define CAN_HTRH_1         (CanConf_CanHardwareObject_CanHardwareObject_1)

#define CanConf_CanHardwareObject_CanHardwareObject_2   (2U)
#define CAN_HTRH_2         (CanConf_CanHardwareObject_CanHardwareObject_2)

#define CanConf_CanHardwareObject_CanHardwareObject_3   (3U)
#define CAN_HTRH_3         (CanConf_CanHardwareObject_CanHardwareObject_3)

#define CanConf_CanHardwareObject_CanHardwareObject_4   (4U)
#define CAN_HTRH_4         (CanConf_CanHardwareObject_CanHardwareObject_4)

#define CanConf_CanHardwareObject_CanHardwareObject_5   (5U)
#define CAN_HTRH_5         (CanConf_CanHardwareObject_CanHardwareObject_5)

#define CanConf_CanHardwareObject_CanHardwareObject_6   (6U)
#define CAN_HTRH_6         (CanConf_CanHardwareObject_CanHardwareObject_6)

#define CanConf_CanHardwareObject_CanHardwareObject_7   (7U)
#define CAN_HTRH_7         (CanConf_CanHardwareObject_CanHardwareObject_7)

#define CanConf_CanHardwareObject_CanHardwareObject_8   (8U)
#define CAN_HTRH_8         (CanConf_CanHardwareObject_CanHardwareObject_8)

#define CanConf_CanHardwareObject_CanHardwareObject_9   (9U)
#define CAN_HTRH_9         (CanConf_CanHardwareObject_CanHardwareObject_9)

#define CanConf_CanHardwareObject_CanHardwareObject_10   (10U)
#define CAN_HTRH_10         (CanConf_CanHardwareObject_CanHardwareObject_10)

#define CanConf_CanHardwareObject_CanHardwareObject_11   (11U)
#define CAN_HTRH_11         (CanConf_CanHardwareObject_CanHardwareObject_11)

#define CanConf_CanHardwareObject_CanHardwareObject_12   (12U)
#define CAN_HTRH_12         (CanConf_CanHardwareObject_CanHardwareObject_12)

#define CanConf_CanHardwareObject_CanHardwareObject_13   (13U)
#define CAN_HTRH_13         (CanConf_CanHardwareObject_CanHardwareObject_13)

#define CanConf_CanHardwareObject_CanHardwareObject_14   (14U)
#define CAN_HTRH_14         (CanConf_CanHardwareObject_CanHardwareObject_14)

#define CanConf_CanHardwareObject_CanHardwareObject_15   (15U)
#define CAN_HTRH_15         (CanConf_CanHardwareObject_CanHardwareObject_15)

/* @} */

/* @} */

/** \brief Counter ID for counter used to count wait ticks */
#define CAN_OS_COUNTER_ID               ((CounterType)OsCounter_0)

/**
*  \brief CAN timeout - used in CAN IFCMD busy wait and Start/Stop busy wait.
*   Specifies the maximum time for blocking function until a timeout is detected.
*   Unit is milli seconds.
*/
#define CAN_TIMEOUT_DURATION            (10000U)



/* DEM Error Definitions */
/* DEM Error Codes */
/** \brief No event error code */
#define DemConf_DemEventParameter_CAN_DEM_NO_EVENT (0xFFFFU)
#define CAN_DEM_NO_EVENT DemConf_DemEventParameter_CAN_DEM_NO_EVENT

#ifndef CAN_E_HARDWARE_ERROR
/** \brief Hardware failed */
#define CAN_E_HARDWARE_ERROR          (DemConf_DemEventParameter_CAN_E_HARDWARE_ERROR)
#endif

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/** \brief CAN Configuration struct declaration */
extern const struct Can_ConfigType_s CanConfigSet;

extern const struct Can_ControllerStruct_PC CanConfigSet_PC_CanController_0;

extern const struct Can_ControllerStruct_PC CanConfigSet_PC_CanController_1;

extern const struct Can_ControllerStruct_PC CanConfigSet_PC_CanController_2;

extern const struct Can_ControllerStruct_PC CanConfigSet_PC_CanController_3;


/** \brief CAN Controller Pre Compile Configuration List */
extern const struct Can_ControllerStruct_PC
    *CanConfigSet_CanController_List_PC[CAN_NUM_CONTROLLER];

/** \brief CAN Mailbox Pre Compile Configuration List */
extern const struct Can_MailboxStruct_PC
    *CanConfigSet_CanHardwareObject_List_PC[CAN_NUM_MAILBOXES];


#ifdef __cplusplus
}
#endif

#endif /*CAN_CFG_H__*/

/* @} */
/**********************************************************************************************************************
 *  END OF FILE: Can_Cfg.h
 *********************************************************************************************************************/
