
/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */
/***********************************************************************
    Project: AM263x
	Date   : 2023-05-05 22:44:32

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in
	unexpected way.

 ***********************************************************************/
/**
 *  \file     Dio_Lcfg.c
 *
 *  \brief    This file contains generated link time configuration file
 *            for DIO MCAL driver
 *
 */

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
#include "Std_Types.h"
#include "Dio.h"


/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/
#if ((DIO_CFG_MAJOR_VERSION != (8U))||(DIO_CFG_MINOR_VERSION != (6U)))
  #error "Version numbers of Dio_Lcfg.c and Dio_Cfg.h are inconsistent!"
#endif

/**********************************************************************************************************************
 *  GLOBAL DATA
 **********************************************************************************************************************/
#define DIO_START_SEC_CONFIG_DATA
/* MISRAC_19.1 "Reason - This is the format for specifying memory sections" */
#include "Dio_MemMap.h"

/*<DIO_CFG_GROUP_LIST>*/
CONST(Dio_ChannelGroupType, DIO_CONST) DioConfig_GPIOAB_ChannelGroup[] =
{
    [0] =
	{
		.port =   0U,
		.mask =   0x000000ffU,
		.offset = 0U,
	},
    [1] =
	{
		.port =   0U,
		.mask =   0x000000ffU,
		.offset = 2U,
	},
};

CONST(Dio_ChannelGroupType, DIO_CONST) DioConfig_GPIOCD_ChannelGroup[] =
{
    [0] =
	{
		.port =   1U,
		.mask =   0x000000ffU,
		.offset = 6U,
	},
};


P2CONST(void,AUTOMATIC,  DIO_CONST) DioConfig_GPIOAB_ChannelGroupRef[2] =
{
    [0] = &DioConfig_GPIOAB_ChannelGroup[0],
    [1] = &DioConfig_GPIOAB_ChannelGroup[1],
};

P2CONST(void,AUTOMATIC,  DIO_CONST) DioConfig_GPIOCD_ChannelGroupRef[1] =
{
    [0] = &DioConfig_GPIOCD_ChannelGroup[0],
};


CONST(uint32,DIO_CONST) DioConfig_ValidChannelMask[DIO_MAX_NO_OF_PORTS] =
{
    [0] = (0
        | (1U << 0U)
        | (1U << 1U)
        | (1U << 2U)
        | (1U << 3U)
        | (1U << 4U)
        | (1U << 5U)
        | (1U << 6U)
        | (1U << 7U)
        | (1U << 8U)
        | (1U << 9U)
        | (1U << 10U)
        | (1U << 11U)
        | (1U << 12U)
        | (1U << 13U)
        | (1U << 14U)
        | (1U << 15U)
        | (1U << 16U)
        | (1U << 17U)
        | (1U << 18U)
        | (1U << 19U)
        | (1U << 20U)
        | (1U << 21U)
        | (1U << 22U)
        | (1U << 23U)
        | (1U << 24U)
        | (1U << 25U)
        | (1U << 26U)
        | (1U << 27U)
        | (1U << 28U)
        | (1U << 29U)
        | (1U << 30U)
        | (1U << 31U)
    ),
    [1] = (0
        | (1U << 0U)
        | (1U << 1U)
        | (1U << 2U)
        | (1U << 3U)
        | (1U << 4U)
        | (1U << 5U)
        | (1U << 6U)
        | (1U << 7U)
        | (1U << 8U)
        | (1U << 9U)
        | (1U << 10U)
        | (1U << 11U)
        | (1U << 12U)
        | (1U << 13U)
        | (1U << 14U)
        | (1U << 15U)
        | (1U << 16U)
        | (1U << 17U)
        | (1U << 18U)
        | (1U << 19U)
        | (1U << 20U)
        | (1U << 21U)
        | (1U << 22U)
        | (1U << 23U)
        | (1U << 24U)
        | (1U << 25U)
        | (1U << 26U)
        | (1U << 27U)
        | (1U << 28U)
        | (1U << 29U)
        | (1U << 30U)
        | (1U << 31U)
    ),
    [2] = (0
        | (1U << 0U)
        | (1U << 1U)
        | (1U << 2U)
        | (1U << 3U)
        | (1U << 4U)
        | (1U << 5U)
        | (1U << 6U)
        | (1U << 7U)
        | (1U << 8U)
        | (1U << 9U)
        | (1U << 10U)
        | (1U << 11U)
        | (1U << 12U)
        | (1U << 13U)
        | (1U << 14U)
        | (1U << 15U)
        | (1U << 16U)
        | (1U << 17U)
        | (1U << 18U)
        | (1U << 19U)
        | (1U << 20U)
        | (1U << 21U)
        | (1U << 22U)
        | (1U << 23U)
        | (1U << 24U)
        | (1U << 25U)
        | (1U << 26U)
        | (1U << 27U)
        | (1U << 28U)
        | (1U << 29U)
        | (1U << 30U)
        | (1U << 31U)
    ),
    [3] = (0
        | (1U << 0U)
        | (1U << 1U)
        | (1U << 2U)
        | (1U << 3U)
        | (1U << 4U)
        | (1U << 5U)
        | (1U << 6U)
        | (1U << 7U)
        | (1U << 8U)
        | (1U << 9U)
        | (1U << 10U)
        | (1U << 11U)
        | (1U << 12U)
        | (1U << 13U)
        | (1U << 14U)
        | (1U << 15U)
        | (1U << 16U)
        | (1U << 17U)
        | (1U << 18U)
        | (1U << 19U)
        | (1U << 20U)
        | (1U << 21U)
        | (1U << 22U)
        | (1U << 23U)
        | (1U << 24U)
        | (1U << 25U)
        | (1U << 26U)
        | (1U << 27U)
        | (1U << 28U)
        | (1U << 29U)
        | (1U << 30U)
        | (1U << 31U)
    ),
    [4] = (0
        | (1U << 0U)
        | (1U << 1U)
        | (1U << 2U)
        | (1U << 3U)
        | (1U << 4U)
        | (1U << 5U)
        | (1U << 6U)
        | (1U << 7U)
        | (1U << 8U)
        | (1U << 9U)
        | (1U << 10U)
    ),
};

/*</DIO_CFG_GROUP_LIST>*/

#define DIO_STOP_SEC_CONFIG_DATA
#include "Dio_MemMap.h"

/**********************************************************************************************************************
 *  END OF FILE: DIO_LCFG.C
 *********************************************************************************************************************/

