/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated

 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Cdd_Dma_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for Complex device driver
 */

  /*********************************************************************************************************************
    Project: AM263x
    Date   : 2023-05-05 22:44:33

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/

/**
 *  \defgroup CDD_DMA_CFG  Configuration
 *
 *  This files defines CDD DMA configuration structures
 *  @{
 */

#ifndef CDD_DMA_CFG_H_
#define CDD_DMA_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "Std_Types.h"
#include "Os.h"
#include "Dem.h"
#include "Cdd_Dma.h"

#include "Det.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 *  \name CDD DMA Driver Configuration SW Version Info
 *
 *  Defines for CDD DMA Driver configuration version
 *  @{
 */
/** \brief CDD DMA configuration Major Version */
#define CDD_DMA_MAJOR_VERSION                 (8U)
/** \brief CDD DMA configuration Minor Version */
#define CDD_DMA_MINOR_VERSION                 (6U)
/** \brief CDD DMA configuration Patch Version */
#define CDD_DMA_PATCH_VERSION                 (2U)
/* @} */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/** \brief CDD DMA Config ID */
#define CDD_DMA_ID                                                        (0x1U)

/** \brief Enable/Disable CDD DMA dev detect error */
/* Requirements: ___ */
#define CDD_DMA_DEV_ERROR_DETECT                                          (STD_ON)

/**
 *  \name Pre-Compile Switches for API Services
 */
/** \brief Enable/Disable CDD DMA get version info API */
#define CDD_DMA_VERSION_INFO_API                                          (STD_ON)
#define CDD_DMA_DEINIT_API                                                (STD_ON)

/** \brief Count CDD DMA resources */
#define CDD_DMA_OWN_CHANNEL_RESOURCES                                     1
#define CDD_DMA_OWN_QDMA_CHANNEL_RESOURCES                                1
#define CDD_DMA_OWN_TCC_RESOURCES                                         1
#define CDD_DMA_OWN_PARAM_RESOURCES                                       1
#define CDD_DMA_RESERVED_RESOURCES                                        1

/** \brief CDD DMA resources amount */
#define CDD_DMA_NUM_DMACH_SOC                                             64
#define CDD_DMA_NUM_PARAMSETS_SOC                                         256

/** \brief CDD DMA Instances */
#define CDD_DMA_RCSS_A                                                    0U
#define CDD_DMA_MSS_A                                                     1U
#define CDD_DMA_MSS_B                                                     2U
#define CDD_DMA_DSS_A                                                     3U
#define CDD_DMA_DSS_B                                                     4U
#define CDD_DMA_DSS_C                                                     5U

/** \brief CSL Base Addresses for Sitara MCAL2X */
#define MCAL_MSS_CTRL_U_BASE                                              (0x50D00000ul)
#define MCAL_MSS_TPCC_A_U_BASE                                            (0x52A00000ul)
#define MCAL_MSS_TPCC_B_U_BASE                                            (0x3120000U)
#define MCAL_DSS_TPCC_A_U_BASE                                            (0x6100000U)
#define MCAL_DSS_TPCC_B_U_BASE                                            (0x6120000U)
#define MCAL_DSS_TPCC_C_U_BASE                                            (0x6140000U)
#define MCAL_CSL_MSS_CTRL_U_BASE                                          (0x50D00000ul)
#define MCAL_CSL_EDMA_TRIG_XBAR_U_BASE                                    (0x52E01000ul)
#define MCAL_CSL_CONTROLSS_DMAXBAR_U_BASE                                 (0x502D6000ul)

/** \brief CDD DMA Completion Interrupt Number */
#define MCAL_MSS_INTR_MSS_TPCC_A_INTAGG                                   72
#define MCAL_MSS_INTR_MSS_TPCC_B_INTAGG                                   68
#define MCAL_MSS_INTR_DSS_TPCC_A_INTAGG                                   120
#define MCAL_MSS_INTR_DSS_TPCC_B_INTAGG                                   122
#define MCAL_MSS_INTR_DSS_TPCC_C_INTAGG                                   124

/** \brief CDD DMA field MSS and DSS TPCC Adresseses for Interrupt Aggregate */
#define MCAL_MSS_CTRL_MSS_TPCC_A_INTAGG_MASK                              (0x00000830U)
#define MCAL_MSS_CTRL_MSS_TPCC_A_INTAGG_STATUS                            (0x00000834U)
#define MCAL_MSS_CTRL_MSS_TPCC_B_INTAGG_MASK                              (0x00000194U)
#define MCAL_MSS_CTRL_MSS_TPCC_B_INTAGG_STATUS                            (0x00000198U)
#define MCAL_DSS_CTRL_DSS_TPCC_A_INTAGG_MASK                              (0x00000024U)
#define MCAL_DSS_CTRL_DSS_TPCC_A_INTAGG_STATUS                            (0x00000028U)
#define MCAL_DSS_CTRL_DSS_TPCC_B_INTAGG_MASK                              (0x0000003CU)
#define MCAL_DSS_CTRL_DSS_TPCC_B_INTAGG_STATUS                            (0x00000040U)
#define MCAL_DSS_CTRL_DSS_TPCC_C_INTAGG_MASK                              (0x00000054U)
#define MCAL_DSS_CTRL_DSS_TPCC_C_INTAGG_STATUS                            (0x00000058U)

/* PRE-COMPLIE variant related macro(s) */
#define CDD_DMA_PRE_COMPILE_VARIANT                                       STD_ON
#define CDD_DMA_INIT_CONFIG_PC                                            CddDmaDriver_0

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/**
 *  \brief This type defines a range of specific status for Complex driver
 */
/** Requirements :  SitaraMCU_MCAL-__ */
/** Design: SitaraMCU_MCAL-__ */
typedef enum
{
    /**< The Complex Driver is not initialized or not usable */
    CDD_DMA_UNINIT =       0U,
    /**< The Complex Driver is not currently transferring */
    CDD_DMA_IDLE =         1U,
    /**< The Complex Driver is currently open */
    CDD_DMA_ALLOW_ACCESS = 2U,
    /**< The Complex Driver is performing a write operation */
    CDD_DMA_BUSY =         3U,
    /**< The Complex Driver is currently closed */
    CDD_DMA_CLOSE =        4U,
} CddDma_StatusType;

#define CDD_DMA_TRIG_XBAR_EDMA_MODULE_0_INPUT   CDD_DMA_TRIG_XBAR_USART0_DMA_1
#define CDD_DMA_TRIG_XBAR_EDMA_MODULE_1_INPUT   CDD_DMA_TRIG_XBAR_USART0_DMA_0
#define CDD_DMA_TRIG_XBAR_EDMA_MODULE_6_INPUT   CDD_DMA_TRIG_XBAR_DMA_XBAR_OUT_6
#define CDD_DMA_TRIG_XBAR_EDMA_MODULE_7_INPUT   CDD_DMA_TRIG_XBAR_DMA_XBAR_OUT_7
#define CDD_DMA_TRIG_XBAR_EDMA_MODULE_8_INPUT   CDD_DMA_TRIG_XBAR_DMA_XBAR_OUT_8
#define CDD_DMA_TRIG_XBAR_EDMA_MODULE_9_INPUT   CDD_DMA_TRIG_XBAR_DMA_XBAR_OUT_9
#define CDD_DMA_TRIG_XBAR_EDMA_MODULE_10_INPUT   CDD_DMA_TRIG_XBAR_DMA_XBAR_OUT_10
#define CDD_DMA_TRIG_XBAR_EDMA_MODULE_11_INPUT   CDD_DMA_TRIG_XBAR_DMA_XBAR_OUT_11

/** \brief Cdd Configuration struct declaration */
extern CONST(Cdd_Dma_ConfigType, CDD_DMA_CFG) CddDmaDriver_0;

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
extern void Cdd_Dma_TrigXbar(void);
extern void Cdd_Dma_Xbar(void);

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef CDD_DMA_CFG_H_ */

/* @} */
