/* ======================================================================
 *   Copyright (C) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Cdd_Dma_Cfg.c
 *
 *  \brief    This file contains generated pre-compile configuration file
 *            for DMA Complex Device Driver
 */

  /********************************************************************************************************************
  Project: AM263x
	Date   : 2023-05-05 22:44:32

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/
/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
#include "Cdd_Dma_Cfg.h"
#include "soc.h"
#include "Cdd_edma_xbar.h"

/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/
#if ( (CDD_DMA_MAJOR_VERSION != (8U)) \
    ||(CDD_DMA_MINOR_VERSION != (6U)))
  #error "Version numbers of Cdd_Dma_Cfg.c and Cdd_Dma_Cfg.h are inconsistent!"
#endif

/**********************************************************************************************************************
 *  LOCAL CONSTANT MACROS
 **********************************************************************************************************************/

#define CDD_DMA_SOURCE 1U

/**********************************************************************************************************************
 *  LOCAL FUNCTION MACROS
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  LOCAL DATA TYPES AND STRUCTURES
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  LOCAL DATA PROTOTYPES
 **********************************************************************************************************************/

/**********************************************************************************************************************
 *  GLOBAL DATA
 **********************************************************************************************************************/

#define  CDD_DMA_START_SEC_CONFIG_DATA
#include "Cdd_Dma_MemMap.h"

/* Runtime Configuration Generation */

/* Requirements : SitaraMCU_MCAL-__, SitaraMCU_MCAL-__ */
CONST(Cdd_Dma_ConfigType, CDD_DMA_CFG) CddDmaDriver_0 =
{
    .baseAddr = MCAL_MSS_TPCC_A_U_BASE,
    .edmaConfig = 
    {
        .compIntrNumber = MCAL_MSS_INTR_MSS_TPCC_A_INTAGG,
        .compIntrPriority = 4,
        .intrAggEnableAddr = MCAL_MSS_CTRL_U_BASE + MCAL_MSS_CTRL_MSS_TPCC_A_INTAGG_MASK,
        .intrAggEnableMask = 0x1FF & (~(2U << 0)),
        .intrAggStatusAddr = MCAL_MSS_CTRL_U_BASE + MCAL_MSS_CTRL_MSS_TPCC_A_INTAGG_STATUS,
        .intrAggClearMask = (2U << 0),
        .intrEnable = TRUE,
        .regionId = 0,
        .queNum = 0,
        .initParamSet = TRUE,
        .reservedDmaCh[0]   = 0x0U,
        .reservedDmaCh[1]   = 0x40000000U,
        .ownResource = 
        {
            .qdmaCh   = 0xFFU,
            .dmaCh[0] = 0xFFFFFFFFU,
            .dmaCh[1] = 0xFFFFFFFFU,
            .tcc[0]        = 0xFFFFFFFFU,
            .tcc[1]        = 0xFFFFFFFFU,
            .paramSet[0]   = 0xFFFFFFFFU,
            .paramSet[1]   = 0xFFFFFFFFU,
            .paramSet[2]   = 0xFFFFFFFFU,
            .paramSet[3]   = 0xFFFFFFFFU,
            .paramSet[4]   = 0x0U,
            .paramSet[5]   = 0x0U,
            .paramSet[6]   = 0x0U,
            .paramSet[7]   = 0x0U,
        },
    }
};

#define  CDD_DMA_STOP_SEC_CONFIG_DATA
#include "Cdd_Dma_MemMap.h"

#define CDD_DMA_START_SEC_CODE
#include "Cdd_Dma_MemMap.h"

void Cdd_Dma_TrigXbar(void)
{
   /*
    * DMA TRIGGER XBAR 1
    */

    CDD_DMA_SOC_xbarSelectEdmaTrigXbarInputSource(MCAL_CSL_EDMA_TRIG_XBAR_U_BASE, CDD_DMA_TRIG_XBAR_EDMA_MODULE_0, CDD_DMA_TRIG_XBAR_EDMA_MODULE_0_INPUT);
    CDD_DMA_SOC_xbarSelectEdmaTrigXbarInputSource(MCAL_CSL_EDMA_TRIG_XBAR_U_BASE, CDD_DMA_TRIG_XBAR_EDMA_MODULE_1, CDD_DMA_TRIG_XBAR_EDMA_MODULE_1_INPUT);
    CDD_DMA_SOC_xbarSelectEdmaTrigXbarInputSource(MCAL_CSL_EDMA_TRIG_XBAR_U_BASE, CDD_DMA_TRIG_XBAR_EDMA_MODULE_6, CDD_DMA_TRIG_XBAR_EDMA_MODULE_6_INPUT);
    CDD_DMA_SOC_xbarSelectEdmaTrigXbarInputSource(MCAL_CSL_EDMA_TRIG_XBAR_U_BASE, CDD_DMA_TRIG_XBAR_EDMA_MODULE_7, CDD_DMA_TRIG_XBAR_EDMA_MODULE_7_INPUT);
    CDD_DMA_SOC_xbarSelectEdmaTrigXbarInputSource(MCAL_CSL_EDMA_TRIG_XBAR_U_BASE, CDD_DMA_TRIG_XBAR_EDMA_MODULE_8, CDD_DMA_TRIG_XBAR_EDMA_MODULE_8_INPUT);
    CDD_DMA_SOC_xbarSelectEdmaTrigXbarInputSource(MCAL_CSL_EDMA_TRIG_XBAR_U_BASE, CDD_DMA_TRIG_XBAR_EDMA_MODULE_9, CDD_DMA_TRIG_XBAR_EDMA_MODULE_9_INPUT);
    CDD_DMA_SOC_xbarSelectEdmaTrigXbarInputSource(MCAL_CSL_EDMA_TRIG_XBAR_U_BASE, CDD_DMA_TRIG_XBAR_EDMA_MODULE_10, CDD_DMA_TRIG_XBAR_EDMA_MODULE_10_INPUT);
    CDD_DMA_SOC_xbarSelectEdmaTrigXbarInputSource(MCAL_CSL_EDMA_TRIG_XBAR_U_BASE, CDD_DMA_TRIG_XBAR_EDMA_MODULE_11, CDD_DMA_TRIG_XBAR_EDMA_MODULE_11_INPUT);
}

void Cdd_Dma_Xbar(void)
{
    /* DMA XBAR */

    CDD_DMA_SOC_xbarSelectDMAXBarInputSource(MCAL_CSL_CONTROLSS_DMAXBAR_U_BASE, CDD_DMA_XBAR_DMA_TRIG_XBAR_6, 2, 0, 0, CDD_DMA_XBAR_ADC3_INT1, 0, 0, 0);
    CDD_DMA_SOC_xbarSelectDMAXBarInputSource(MCAL_CSL_CONTROLSS_DMAXBAR_U_BASE, CDD_DMA_XBAR_DMA_TRIG_XBAR_7, 2, 0, 0, CDD_DMA_XBAR_ADC3_INT1, 0, 0, 0);
    CDD_DMA_SOC_xbarSelectDMAXBarInputSource(MCAL_CSL_CONTROLSS_DMAXBAR_U_BASE, CDD_DMA_XBAR_DMA_TRIG_XBAR_8, 2, 0, 0, CDD_DMA_XBAR_ADC3_INT1, 0, 0, 0);
    CDD_DMA_SOC_xbarSelectDMAXBarInputSource(MCAL_CSL_CONTROLSS_DMAXBAR_U_BASE, CDD_DMA_XBAR_DMA_TRIG_XBAR_9, 2, 0, 0, CDD_DMA_XBAR_ADC3_INT1, 0, 0, 0);
    CDD_DMA_SOC_xbarSelectDMAXBarInputSource(MCAL_CSL_CONTROLSS_DMAXBAR_U_BASE, CDD_DMA_XBAR_DMA_TRIG_XBAR_10, 2, 0, 0, CDD_DMA_XBAR_ADC3_INT1, 0, 0, 0);
    CDD_DMA_SOC_xbarSelectDMAXBarInputSource(MCAL_CSL_CONTROLSS_DMAXBAR_U_BASE, CDD_DMA_XBAR_DMA_TRIG_XBAR_11, 2, 0, 0, CDD_DMA_XBAR_ADC3_INT1, 0, 0, 0);
}
#define CDD_DMA_STOP_SEC_CODE
#include "Cdd_Dma_MemMap.h"

/**********************************************************************************************************************
 *  END OF FILE: Cdd_Dma_Cfg.c
 **********************************************************************************************************************/
