/* ======================================================================
 *   Copyright (C) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     EthTrcv_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file for
 *            Ethernet Transceiver MCAL driver
 *
 */

/*******************************************************************************
    Project: AM263x
    Date   : 2023-05-05 22:44:32
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

*******************************************************************************/
 
/**
 *  \defgroup MCAL_ETHTRCV_CFG EthTrcv Configuration
 *
 *  This files defines EthTrcv MCAL configuration structures
 *  @{
 */

#ifndef ETHTRCV_CFG_H_
#define ETHTRCV_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "Dem.h"


#ifdef __cplusplus
extern "C" {
#endif


/**
*  \brief ETHTRCV Build Variant.
*   Build variants.(i.e Pre-compile,Post-build or Link time)
*/
#define ETHTRCV_PRE_COMPILE_VARIANT       (STD_OFF)

#define ETHTRCV_POST_BUILD_VARIANT        (STD_ON)

#define ETHTRCV_LINK_TIME_VARIANT         (STD_OFF)

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/** \brief ETHTRCV Config ID */
#define ETHTRCV_CFG_ID          (0x1U)

/**
 *  \name EthTrcv Driver Configuration SW Version Info
 *
 *  Defines for EthTrcv Driver configuration version
 *  @{
 */
#define ETHTRCV_CFG_MAJOR_VERSION           (8U)
#define ETHTRCV_CFG_MINOR_VERSION           (6U)
#define ETHTRCV_CFG_PATCH_VERSION           (2U)
/* @} */







/**
 *  \name EthTrcv Driver Configuration SW Version Info
 *
 *  Pre-compile switches for enabling/disabling ETHTRCV MCAL APIs
 *  @{
 */
/** \brief Enable/Disable EthTrcv_GetVersionInfo()*/
#define ETHTRCV_VERSION_INFO_API        	        (STD_ON)

/** \brief Enable/Disable DEV error detection */
#define ETHTRCV_DEV_ERROR_DETECT        	        (STD_ON)
/* @} */

/** \brief EthTrcv max number of controllers. */
#define ETHTRCV_MAX_CONTROLLER          	(2U)

/** \brief EthTrcv max number of configurations. */
#define ETHTRCV_MAX_CONTROLLER_CFGS     	(2U)

/**
 *  \name EthTrcv Controller names
 *
 *  Symbolic names for the EthTrcvControllerId.
 *  @{
 */
/* Requirements : SWS_EthTrcv_00003 */
#define ETHTRCV_CONTROLLER_ID_0         	(0U)
/* @} */

/**
 *  \name EthTrcv Transceiver names
 *
 *  Symbolic names for the EthTrcv.
 *  @{
 */

#define EthTrcvConf_EthTrcvConfig_EthTrcvIdx_0    (0U)

#define EthTrcvConf_EthTrcvConfig_EthTrcvIdx_1    (1U)


/** \brief EthTrcv auto negotiation wait count
 *       Transceiver delay after auto negotiation started to auto negotiation
 *       completed. Transceiver (PHY) sets auto-negotiation status bit in
 *       status register once it is complete. Depending on Transceiver type,
 *       MDIO frequency it will take different time. Change count value if
 *       transceiver detection fails in auto-negotiation.
 */
/* For auto-negotiation configuring wait count to 100ms
 * (32K/10 X 31.25ms each tick = ~1s)
 */
#define ETHTRCV_AUTONEG_STATUS_WAITCOUNT_TICKS            (0x13880U)

/** \brief  Wait for link status to become up after configuration */
#define ETHTRCV_LINKSTATUS_WAITCOUNT_TICKS                 (0x13880U)

/* Requirements : SWS_EthTrcv_00046 */
/**
 *  \brief Enable/disable Ethernet transceiver set transceiver mode API
 */
#define ETHTRCV_SETTRANSCEIVERMODE_API       	        (STD_ON)

/* Requirements : SWS_EthTrcv_00053 */
/**
 *  \brief Enable/disable Ethernet transceiver get transceiver mode API
 */
#define ETHTRCV_GETTRANSCEIVERMODE_API       	        (STD_ON)

/* Requirements : SWS_EthTrcv_00059 */
/**
 *  \brief Enable/disable Ethernet transceiver start autonegotiation API
 */
#define ETHTRCV_STARTAUTONEGOTIATION_API     	        (STD_ON)

/* Requirements : SWS_EthTrcv_00066 */
/**
 *  \brief Enable/disable Ethernet transceiver get link state API
 */
#define ETHTRCV_GETLINKSTATE_API             	        (STD_ON)

/* Requirements : SWS_EthTrcv_00073 */
/**
 *  \brief Enable/disable Ethernet transceiver get baudrate API
 */
#define ETHTRCV_GETBAUDRATE_API              	        (STD_ON)

/* Requirements : SWS_EthTrcv_00080 */
/**
 *  \brief Enable/disable Ethernet transceiver get duplex mode API
 */
#define ETHTRCV_GETDUPLEXMODE_API            	        (STD_ON)

 /** \brief Counter ID for counter used to count wait ticks */
 #define ETHTRCV_OS_COUNTER_ID               	((CounterType)0U)

 /**
  *  \brief ETH timeout.
  *   Each tick is 31.25us (for 32K Counter). Wait for 5s which comes to
  *   below value
  */
 #define ETHTRCV_TIMEOUT_DURATION            	(160000U)

/**
 *  \name ETHTRCV DEM Error codes to report
 *
 *  Pre-compile switches for enabling/disabling DEM events
 *  @{
 */
#define DemConf_DemEventParameter_ETHTRCV_DEM_NO_EVENT (0xFFFFU)
#define ETHTRCV_DEM_NO_EVENT DemConf_DemEventParameter_ETHTRCV_DEM_NO_EVENT

#ifndef ETHTRCV_E_HARDWARE_ERROR
/** \brief Hardware failed */
#define ETHTRCV_E_HARDWARE_ERROR             	(ETHTRCV_DEM_NO_EVENT)
#endif

#ifndef ETHTRCV_E_ACCESS
/** \brief Hardware failed */
#define ETHTRCV_E_ACCESS                     	(ETHTRCV_DEM_NO_EVENT)
#endif

/* @} */
 /* \brief Enables / Disables EthTrcv_GetCableDiagnosticsResult API.*/
#define ETHTRCV_GETCABLEDIAGNOSTICSRESULT_API            (STD_ON)

/**
 *  \brief Enables / Disables EthTrcv_GetPhyIdentifier API
 */
#define ETHTRCV_GETPHYIDENTIFIER_API                     (STD_ON)

/**
 *  \brief Specifies the InstanceId of this module instance. If only one instance is present it shall have the Id 0
 */
#define ETHTRCV_INDEX             				0U

/**
 *  \brief Specifies the period of main function EthTrcv_MainFunction in seconds.
 */
#define ETHTRCV_MAINFUNCTION_PERIOD          	10.0U

/**
 *  \brief EthTrcvMaxTrcvsSupported.
 */
#define ETHTRCV_MAXTRCVSUPPORTED             	(2U)

/**
 *  \brief Enables / Disables EthTrcv_SetPhyTxMode API.
 */
#define ETHTRCV_SETPHYTXMODE_API             	        (STD_ON)

/**
 *   \brief Enables / Disables version info API macro implementation.
 */
#define ETHTRCV_VERSIONINFO_API_MACRO        	        (STD_ON)

/**
 *  \brief Enables / Disables EthTrcv_SetPhyTxMode API.
 */
#define ETHTRCV_SETPHYTESTMODE_API             	        (STD_ON)

/* Requirements : SWS_EthTrcv_00110 */
/**
 *  \brief Enable/disable Ethernet transceiver EthTrcvWakeUpSupport APIs.
 */
#define ETHTRCV_WAKEUPSUPPORT_API               (ETHTRCV_WAKEUP_NOT_SUPPORTED)

/**
*	\brief Change of PHY Loop Back MOdes
*/
#define ETHTRCV_PHYLOOPBACK_INTERNAL_TYPE 			ETHTRCV_PHYLOOPBACK_INTERNAL_ANALOG



/* ========================================================================== */
/* 							Structures and Enums */
/* ========================================================================== */

/** \brief EthTrcv Configuration struct declaration */
extern struct EthTrcv_ConfigType_s EthTrcvConfigSet_EthTrcvConfig_0;

/** \brief EthTrcv Configuration struct declaration */
extern struct EthTrcv_ConfigType_s EthTrcvConfigSet_EthTrcvConfig_1;


/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

#endif  /* ETHTRCV_CFG_H_ */

/* @} */

