/* ======================================================================
 *   Copyright (C) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */
/**
 *  \file     EthTrcv_PBcfg.c
 *
 *  \brief    This file contains generated post build configuration file for
 *            Ethernet Transceiver MCAL driver
 *
 */
 
 /*******************************************************************************
    Project: AM263x
    Date   : 2023-05-05 22:44:33
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

*******************************************************************************/

/* Module switch */
#define ETHTRCV_PBCFG_SOURCE
/*******************************************************************************
 * Standard Header Files
 ******************************************************************************/
/*******************************************************************************
 * Other Header Files
 ******************************************************************************/
#include "EthTrcv.h"

/*******************************************************************************
 *  Version Check
 ******************************************************************************/
/*  Version checking  */
 #if ((ETHTRCV_SW_MAJOR_VERSION != (8U))||(ETHTRCV_SW_MINOR_VERSION != (6U)))
  #error "Version numbers of EthTrcv_PBcfg.c and EthTrcv.h are inconsistent!"
#endif
#if ((ETHTRCV_CFG_MAJOR_VERSION != (8U)) || (ETHTRCV_CFG_MINOR_VERSION != (6U)))
  #error "Version numbers of EthTrcv_PBcfg.c and EthTrcv_Cfg.h are inconsistent!"
#endif
/*******************************************************************************
 * Local Preprocessor #define Constants
 ******************************************************************************/
/*******************************************************************************
 * Local Preprocessor #define Macros
 ******************************************************************************/
/*******************************************************************************
 * Local Data Types and Structures
 ******************************************************************************/
/*******************************************************************************
 * Constants for Post-Build Configuration
 ******************************************************************************/
#define ETHTRCV_START_SEC_CONFIG_DATA
#include "EthTrcv_MemMap.h"

/*<ETHTRCV_CONFIG>*/
VAR(struct EthTrcv_ConfigType_s, ETHTRCV_PBCFG)
    EthTrcvConfigSet_EthTrcvConfig_0 =
{
    .ctrlIdx = 0U,
    .trcvIdx = 0U,
    .phyAddr = 0U,
    .MiiSel = RGMII,
    .enableAutoNeg = (uint32 ) TRUE,
    .connNeg = TRCV_CONN_NEG_AUTO,
    .advertiseCapab =
        (0U
        |ETHERNET_ADV_CAPAB_10_HALF
        |ETHERNET_ADV_CAPAB_10_FULL
        |ETHERNET_ADV_CAPAB_100_HALF
        |ETHERNET_ADV_CAPAB_100_FULL
        |ETHERNET_ADV_CAPAB_1000_FULL
        ),
    .linkPartCapab =
        (0U
        ),
    .isGigCapab =  (uint32 )TRUE,
    .baudRate = (ETHTRCV_BAUD_RATE_100MBIT),
    .duplexMode = ETHTRCV_DUPLEX_MODE_FULL,
    .loopbackEnable = (boolean)FALSE,
    .PortMacLaySpeed = ETH_MAC_LAYER_SPEED_100M,
    .PortMacLaySubType = REDUCED,
    .PortMacLayType = TRCV_MAC_LAYER_TYPE_XMII,
    .PhysLayerType = TRCV_PHYS_LAYER_TYPE_100BASE_T1
};

VAR(struct EthTrcv_ConfigType_s, ETHTRCV_PBCFG)
    EthTrcvConfigSet_EthTrcvConfig_1 =
{
    .ctrlIdx = 0U,
    .trcvIdx = 1U,
    .phyAddr = 3U,
    .MiiSel = RGMII,
    .enableAutoNeg = (uint32 ) TRUE,
    .connNeg = TRCV_CONN_NEG_AUTO,
    .advertiseCapab =
        (0U
        |ETHERNET_ADV_CAPAB_10_HALF
        |ETHERNET_ADV_CAPAB_10_FULL
        |ETHERNET_ADV_CAPAB_100_HALF
        |ETHERNET_ADV_CAPAB_100_FULL
        |ETHERNET_ADV_CAPAB_1000_FULL
        ),
    .linkPartCapab =
        (0U
        ),
    .isGigCapab =  (uint32 )TRUE,
    .baudRate = (ETHTRCV_BAUD_RATE_100MBIT),
    .duplexMode = ETHTRCV_DUPLEX_MODE_FULL,
    .loopbackEnable = (boolean)FALSE,
    .PortMacLaySpeed = ETH_MAC_LAYER_SPEED_100M,
    .PortMacLaySubType = REDUCED,
    .PortMacLayType = TRCV_MAC_LAYER_TYPE_XMII,
    .PhysLayerType = TRCV_PHYS_LAYER_TYPE_100BASE_T1
};


/*</ETHTRCV_CONFIG>*/
#define ETHTRCV_STOP_SEC_CONFIG_DATA
#include "EthTrcv_MemMap.h"
/*******************************************************************************
 *  End of File: EthTrcv_PBcfg.c
 ******************************************************************************/
