/* ======================================================================
 *   Copyright (c) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Eth_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for ETH MCAL driver
 *
 */

  /*****************************************************************************
    Project: Am263x
    Date   : 2023-05-12 16:38:12
    8.6.2
    4.6.0
    AUTOSAR 4.3.1 0
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 ******************************************************************************/

/**
 *  \defgroup MCAL_ETH_CFG Eth Configuration
 *
 *  This files defines ETH MCAL configuration structures
 *  @{
 */

#ifndef ETH_CFG_H_
#define ETH_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "Dem.h"




#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/**
*  \brief ETH Build Variant.
*   Build variants.(i.e Pre-compile,Post-build or Link time)
*/
#define ETH_VARIANT_PRE_COMPILE     (STD_OFF)
#define ETH_VARIANT_POST_BUILD      (STD_ON)
#define ETH_VARIANT_LINK_TIME       (STD_OFF)
/** \brief ETH Config ID */
#define ETH_CFG_ID          (0U)

/**
 *  \name Eth Driver Configuration SW Version Info
 *
 *  Defines for Eth Driver configuration version
 *  @{
 */
/** \brief Eth configuration Major Version */
#define ETH_CFG_MAJOR_VERSION           (8U)
/** \brief Eth configuration Minor Version */
#define ETH_CFG_MINOR_VERSION           (6U)
/** \brief Eth configuration Patch Version */
#define ETH_CFG_PATCH_VERSION           (2U)
/* @} */

/**
 *  \name Eth service enable/diable defines
 *
 *  Pre-compile switches for enabling/disabling Eth MCAL APIs
 *  @{
 */
/** \brief Enable/disable SPI get version info API */
#define ETH_VERSION_INFO_API            (STD_ON)
/** \brief Enable/disable Eth get drop count API  */
#define ETH_GET_DROPCOUNT_API           (STD_ON)
/** \brief Enable/disable Eth MII(MDIO) related API  */
#define ETH_ENABLE_MII_API              (STD_ON)
/** \brief Enable/disable Eth statistics gathering API  */
#define ETH_GETETHERSTATS_API           (STD_ON)
/** \brief Enable/disable Eth time sync related API  */
#define ETH_GLOBALTIMESUPPORT_API       (STD_ON)
/** \brief Enable/disable Eth update physical address related API  */
#define ETH_UPDATE_PHYS_ADDR_FILTER_API       (STD_ON)
/** \brief Enable/Disable Development Error Detection */
#define ETH_DEV_ERROR_DETECT        (STD_ON)
/** \brief Enable/Disable Transmission Error Counters API */
#define ETH_GETTXERROR_COUNTERVALUES_API        (STD_ON)
/** \brief Enable/Disable Transmission Statistics API */
#define ETH_GETTX_STATS_API        (STD_ON)
/* @} */

/** \brief Enable/disable Eth traffic shaping  */
#define ETH_TX_TRAFFIC_SHAPING_ENABLE   (STD_OFF)

/**
 *  \name Eth Buffer defines
 *
 *  Defines for Buffer configurations
 *  @{
 */
/**
 *  \brief Eth buffer rotation enable
 *  This will enable driver to recycle buffers without driver intervention.
 */
#define ETH_AUTO_BUFF_ROTATION      (STD_ON)

/** \brief Number of TX buffers */
#define ETH_NUM_TX_BUFFERS          (24U)
/** \brief Number of RX buffers */
#define ETH_NUM_RX_BUFFERS          (48U)


/** \brief Limits the maximum rx/tx buffer length (frame length) in bytes.*/
#define ETH_BUF_LEN_BYTE          (1518U)
/* @} */

#define ETH_PORT1 				(1U)
#define ETH_PORT2 				(2U)

/**
 *  \name Eth Config Id names
 *
 *  Defines for symbolic names for the EthCtrlConfigIdxs
 *  @{
 */
#define EthConf_EthCtrlConfig_EthCtrlConfig_0   (0U)
/* @} */


/**
 *  \name Eth Control Config Ingress FIFO names
 *
 *  Defines for symbolic names for the EthCtrlConfigIngressFifoIdx
 *  @{
 */
#define EthConf_EthCtrlConfigIngressFifo_EthCtrlConfigIngressFifo_0   (0U)
/* @} */

/**
 *  \name Eth interrupt configuration- misc interrupts flags
 *
 *  Pre-compile switches interrupt configuration.
 *  @{
 */
 /** \brief Enables / Disables Statistics interrupt */ 
#define ETH_STATS_INTERRUPT         (STD_ON)
 /** \brief Enables / Disables MDIO interrupt */
#define ETH_USR_MDIO_INTERRUPT      (STD_ON)
 /** \brief Enables / Disables HOST interrupt */
#define ETH_HOST_ERROR_INTERRUPT    (STD_ON)
/** \brief Enables / Disables Receive interrupt */
#define ETH_ENABLE_RX_INTERRUPT     (STD_ON)
 /** \brief Enables / Disables Transmit interrupt */
#define ETH_ENABLE_TX_INTERRUPT     (STD_ON)

/* @} */

/**
 *  \name Eth misc configurations
 *
 *  Pre-compile switches for MAC addr configuration, ISR Type etc.
 *  @{
 */
#define ETH_USE_DEFAULT_MAC_ADDR    (STD_ON)

/** \brief ISR type */
#define ETH_ISR_TYPE                (ETH_ISR_CAT1)


/** \brief Counter ID for counter used to count wait ticks */
#define ETH_OS_COUNTER_ID               ((CounterType)0U)

/**
 *  \brief ETH timeout.
 *   Each tick is 31.25us (for 32K Counter). Wait for 5s which comes to
 *   below value
 */
#define ETH_TIMEOUT_DURATION            (3200U)
/* @} */

/**
 *  \name ETH DEM Error codes to report
 *
 *  Pre-compile switches for enabling/disabling DEM events
 *  @{
 */
#define DemConf_DemEventParameter_ETH_DEM_NO_EVENT (0xFFFFU)
#define ETH_DEM_NO_EVENT DemConf_DemEventParameter_ETH_DEM_NO_EVENT

#ifndef ETH_E_HARDWARE_ERROR
/** \brief Hardware failed */
#define ETH_E_HARDWARE_ERROR          (DemConf_DemEventParameter_ETH_E_HARDWARE_ERROR)
#endif

#ifndef ETH_E_LATECOLLISION
/* 
*Design: SITARA_MCU_MCAL-2231 
*/
/** \brief Hardware failed */
#define ETH_E_LATECOLLISION          (DemConf_DemEventParameter_ETH_E_LATECOLLISION)
#endif

#ifndef ETH_E_MULTIPLECOLLISION
/* 
*Design: SITARA_MCU_MCAL-2233 
*/
/** \brief Hardware failed */
#define ETH_E_MULTIPLECOLLISION          (DemConf_DemEventParameter_ETH_E_MULTIPLECOLLISION)
#endif

#ifndef ETH_E_SINGLECOLLISION
/* 
*Design: SITARA_MCU_MCAL-2234 
*/
/** \brief Hardware failed */
#define ETH_E_SINGLECOLLISION          (DemConf_DemEventParameter_ETH_E_SINGLECOLLISION)
#endif

#ifndef ETH_E_ALIGNMENT
/* 
*Design: SITARA_MCU_MCAL-2235 
*/
/** \brief Hardware failed */
#define ETH_E_ALIGNMENT          (DemConf_DemEventParameter_ETH_E_ALIGNMENT)
#endif

#ifndef ETH_E_OVERSIZEFRAME
/* 
*Design: SITARA_MCU_MCAL-2236 
*/
/** \brief Hardware failed */
#define ETH_E_OVERSIZEFRAME          (DemConf_DemEventParameter_ETH_E_OVERSIZEFRAME)
#endif

#ifndef ETH_E_UNDERSIZEFRAME
/* 
*Design: SITARA_MCU_MCAL-2237 
*/
/** \brief Hardware failed */
#define ETH_E_UNDERSIZEFRAME          (DemConf_DemEventParameter_ETH_E_UNDERSIZEFRAME)
#endif

#ifndef ETH_E_CRC
/*
*Design: SITARA_MCU_MCAL-2238 
*/
/** \brief Hardware failed */
#define ETH_E_CRC          (DemConf_DemEventParameter_ETH_E_CRC)
#endif

#ifndef ETH_E_RX_FRAMES_LOST
/* 
*Design: SITARA_MCU_MCAL-2285 
*/
/** \brief Hardware failed */
#define ETH_E_RX_FRAMES_LOST          (DemConf_DemEventParameter_ETH_E_RX_FRAMES_LOST)
#endif

#ifndef ETH_E_ACCESS
/* 
*Design: SITARA_MCU_MCAL-2286 
*/
/** \brief Hardware failed */
#define ETH_E_ACCESS          (DemConf_DemEventParameter_ETH_E_ACCESS)
#endif


/* @} */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/**
 *  \name Eth Configuration Structure
 *
 *  @{
 */
/** \brief ETH Configuration struct declaration */
extern struct Eth_ConfigType_s EthConfigSet_EthCtrlConfig_0;


/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef ETH_CFG_H_ */

/* @} */
