/* ======================================================================
 *   Copyright (c) 2023 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

 /**
 *  \file     Eth_PBCfg.c
 *
 *  \brief    This file contains generated post build configuration file
 *            for ETH MCAL driver
 */

/*******************************************************************************
    Project: Am263x
    Date   : 2023-05-12 16:38:11
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way
*******************************************************************************/

/*******************************************************************************
 * Standard Header Files
 ******************************************************************************/

/*******************************************************************************
 * Other Header Files
 ******************************************************************************/
#include "Eth.h"

/*******************************************************************************
 *  Version Check
 ******************************************************************************/

/*  Version checking  */
 #if ((ETH_SW_MAJOR_VERSION != (8U))||(ETH_SW_MINOR_VERSION != (6U)))
  #error "Version numbers of Eth_PBcfg.c and Eth.h are inconsistent!"
#endif

#if ((ETH_CFG_MAJOR_VERSION != (8U)) || (ETH_CFG_MINOR_VERSION != (6U)))
  #error "Version numbers of Eth_PBcfg.c and Eth_Cfg.h are inconsistent!"
#endif

/*******************************************************************************
 * Constants for Post-Build Configuration
 ******************************************************************************/
#define  ETH_START_SEC_CONFIG_DATA
#include "Eth_MemMap.h"

#ifdef __cplusplus
extern "C" {
#endif


extern void EcuM_cacheWbInv(uint8 *BufPtr, uint32 LenByte);
extern void EcuM_cacheInvalidate(uint8 *BufPtr, uint32 LenByte);

#ifdef __cplusplus
}
#endif

/* generation of runtime configuration       */
/*<ETH_CONFIG>*/
VAR(struct Eth_ConfigType_s, ETH_PBCFG)
    EthConfigSet_EthCtrlConfig_0 =
{
       .ctrlIdx = 0U,
	   .portIdx = ETH_PORT1,
       .portCfg =
       {
            .macCfg =
            {
                .macModeFlags = (0U  ),
                .macConnectionType = (Eth_MacConnectionType)ETH_MAC_CONN_TYPE_RGMII_DETECT_INBAND,
                .macAddr =
                {
                    0x11U,
                    0x22U,
                    0x33U,
                    0x44U,
                    0x55U,
                    0x66U,
                },
            },
       },

#if (ETH_ENABLE_MII_API != STD_ON)
    #error "Mistmatch between Precompile header and Post Build configuration"
#endif
       .mdioCfg =
       {
           .mdioBusFreq = (uint32)2200000U,
           .mdioClockFreq = (uint32) 200000000U
       },

       .cpdmaCfg =
       {
            .pacingClkFreq = (uint32)125000000U,
            .rxInterruptPacingEnabled = (uint32) TRUE,
            .rxInterruptsPerMsec = 2U,
            .txInterruptPacingEnabled = (uint32) TRUE,
            .txInterruptsPerMsec = 2U,
            .dmaModeFlags = 0U,
            .rxThreshCount = 15U,
       },
#if (ETH_GLOBALTIMESUPPORT_API == STD_ON)
       .cptsCfg =
       {
           .cptsInputFreq = 100U,
           .vlanType      = ETH_CPTS_VLAN_TYPE_NONE,
           .msgTypeCfg    = (0U
                            )
       },
#endif

       .enableCacheOps = (uint32)TRUE,
	   
       .cacheFlushOps = (Eth_CacheFlushType)EcuM_cacheWbInv,

       .cacheInvalidateOps = (Eth_CacheInvalidateType)EcuM_cacheInvalidate,
       /* Fifo configuration not used, added for QoS implementation in Future */ 
        .egressFifo =
        {
        [0] =
            {
            .egressBufLenByte = 1522U,
            .egressBufTotal = 2U,
            .egressFifoIdx = 0U,
            .egressFifoPriority = 0U
            },
        },

       .ingressFifo =
        {
        [0] =
            {
            .ingressBufLenByte = 1522U,
            .ingressBufTotal = 2U,
            .ingressFifoIdx = 0U,
            .ingressFifoPriority = 0U
            },
        }
};
/*</ETH_CONFIG>*/
#define  ETH_STOP_SEC_CONFIG_DATA
#include "Eth_MemMap.h"

/*******************************************************************************
 *  End of File: Eth_PBcfg.c
 ******************************************************************************/
