/*
*
* Copyright (c) 2022 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* any redistribution and use are licensed by TI for use only with TI Devices.
*
* Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/
/**
 *  \file     Fls_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for FLS MCAL driver
 */

  /*****************************************************************************
    Project: AM263x
    Date   : 2023-05-05 22:44:33
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.
 ******************************************************************************/

/**
 *  \defgroup MCAL_FLS_CFG FLS Configuration
 *
 *  This files defines FLS MCAL configuration structures
 *  @{
 */

 

#ifndef FLS_CFG_H_
#define FLS_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "Det.h"
#ifdef __cplusplus
extern "C" {
#endif


/**
*  \brief FLS Build Variant.
*   Build variants.(i.e Pre Compile,Post Build or Link time)
*/

#define FLS_PRE_COMPILE_VARIANT    (STD_ON)

#define FLS_POST_BUILD_VARIANT     (STD_OFF)

/**  \brief Pre Compile config macro name. */
#define FLS_INIT_CONFIG_PC       FlsConfigSet


/** \brief Enable/disable FLS Blank Check API */
#define FLS_BLANK_CHECK_API          (STD_ON)

/** \brief Enable/disable FLS compare API */
#define FLS_COMPARE_API              (STD_ON)

/** \brief Enable/disable FLS cancel API */
#define FLS_CANCEL_API              (STD_ON)

/** \brief Enable/disable FlsTimeoutSupervisionEnabled */
#define FLS_TIMEOUT_SUPERVISION_ENABLED             (STD_ON)

/** \brief Enable/disable FLS dev detect error */
#define FLS_DEV_ERROR_DETECT         (STD_ON)

/** \brief Index of driver, used by FEE */
#define FLS_DRIVER_INDEX             (0U)

/** \brief Enable/disable FLS  Fls_GetJobResult function API */
#define FLS_GET_JOB_RESULT_API        (STD_ON)

/** \brief Enable/disable FLS  Fls_GetStatus function API */
#define FLS_GET_STATUS_API            (STD_ON)

/** \brief Total amount of flash memory in bytes */
#define FLS_TOTAL_SIZE                (16777215U)


/** \brief Enable/disable FLS get version info API */
#define FLS_VERSION_INFO_API           (STD_ON)

/** \brief Counter ID for counter used to count wait ticks */
#define FLS_OS_COUNTER_ID              ((CounterType)OsCounter_0)

/** \brief Base Address of QSPI */
#define FLS_QSPI_CTRL_BASE_ADDR        (1210056704UL)


/** \brief External Flash device selected */
#define FLS_EXTERNAL_FLASH_SELECT       (S25FL128S)

/** \brief Flash Base Address */
#define FLS_BASE_ADDRESS                (1610612736UL)

/** \brief Enable/disable memory mapped FLS read*/
#define FLS_MEM_MAP_MODE                (STD_ON)

/** \brief Max Erase time in millisec*/
#define FLS_MAX_ERASE_TIME                (1000.0)

/** \brief Max Write time in millisec*/
#define FLS_MAX_WRITE_TIME                (1000.0)

/* @} */

/**
 * \name FLS interrupt configuration
 * @{
 */
 /**  \brief Job processing triggered by hardware interrupt.*/
#define FLS_USE_INTERRUPTS             (STD_OFF)

/** \brief ISR type */
#define FLS_ISR_TYPE                (FLS_ISR_CAT1)


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
/** \brief FLS Configuration struct declaration */
extern const struct Fls_ConfigType_s FlsConfigSet;


/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef FLS_CFG_H_ */

/* @} */
