/* ======================================================================
 *   Copyright (c) 2022 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission
 *   of Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been
 *   supplied.
 * ==================================================================== */

/**
 *  \file     Gpt_Cfg.h
 *
 *  \brief    This file contains generated pre compile configuration file
 *            for GPT MCAL driver
 *
 */

 /*********************************************************************************************************************
    Project: AM263x
	Date   : 2023-05-05 22:44:32
	8.6.2
	4.6.0
	AUTOSAR 4.3.1 0
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/

/**
 *  \defgroup MCAL_GPT_CFG GPT Configuration
 *
 *  This files defines GPT MCAL configuration structures
 *  @{
 */

#ifndef GPT_CFG_H_
#define GPT_CFG_H_

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "Dem.h"
#include "Os.h"


#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/**
 *  \name Gpt Driver Configuration SW Version Info
 *
 *  Defines for Gpt Driver configuration version
 *  @{
 */
/** \brief Gpt configuration Major Version */
#define GPT_CFG_MAJOR_VERSION           (8U)
/** \brief Gpt configuration Minor Version */
#define GPT_CFG_MINOR_VERSION           (6U)
/** \brief Gpt configuration Patch Version */
#define GPT_CFG_PATCH_VERSION           (2U)
/* @} */

/** \brief GPT Config ID */
#define GPT_CFG_ID                      (0x1U)



/**
*  \brief GPT Build Variant.
*   Build variants.(i.e Pre Compile,Post Build or Link time)
*/
#define GPT_PRE_COMPILE_VARIANT       (STD_OFF)

#define GPT_POST_BUILD_VARIANT        (STD_ON)




/** \brief Enable/disable GPT dev detect error */
/* Requirements: ECUC_Gpt_00321 */
#define GPT_DEV_ERROR_DETECT                (STD_ON)

/** \brief ISR type */
#define GPT_ISR_TYPE                (GPT_ISR_CAT1)

/** \brief Enable/disable wakeup source in wakeup related APIs */
/* Requirements: ECUC_Gpt_00322 */
#define GPT_REPORT_WAKEUP_SOURCE            (STD_OFF)

/**
 *  \name Pre-Compile Switches for API Services
 *  @{
 */
/** \brief Enable/disable GPT get version info API */
#define GPT_VERSION_INFO_API                           (STD_ON)
/** \brief Enable/disable GPT deinit API */
#define GPT_DEINIT_API                                 (STD_ON)
/** \brief Enable/disable GPT get time elapsed API */
#define GPT_TIME_ELAPSED_API                           (STD_ON)
/** \brief Enable/disable GPT time remaining API */
#define GPT_TIME_REMAINING_API                         (STD_ON)
/** \brief Enable/disable GPT enable/disable GPT API */
#define GPT_ENABLE_DISABLE_NOTIFICATION_API            (STD_ON)
/** \brief Enable/disable GPT wakeup functionality API */
#define GPT_WAKEUP_FUNCTIONALITY_API                   (STD_OFF)
/* @} */

/** \brief No. of channels configured for GPT driver */
#define GPT_MAX_CHANNELS                                    (12U)

/** \brief Macro for enabling predefined timers
 *        This is in case to disable GPT Predef Timers if timers can not be
 *        supported by hardware reasons.
 */
/* Requirements: SWS_Gpt_00385 */
/* Requirements: ECUC_Gpt_00335 */
#define GPT_PREDEF_TIMER_TYPE   (GPT_PREDEF_TIMER_DISABLED)

/** \brief: Specifies the grade of enabling the GPT Predef Timers with 1s
 *         tick duration */
#define GPT_PREDEF_TIMER_1US_ENABLING_GRADE   (GPT_PREDEF_UNDEFINED)


 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_5 (4U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_6 (5U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_7 (6U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_8 (7U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_9 (8U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_10 (9U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_11 (10U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_12 (11U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_13 (12U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_14 (13U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_15 (14U)
 #define GptConf_GptChannelConfiguration_GptChannelConfiguration_0 (15U)


/** \brief Counter ID for counter used to count wait ticks */
#define GPT_OS_COUNTER_ID               ((CounterType)OsCounter_0)

/**
 *  \brief GPT timeout.
 *   Each tick is 31.25us (for 32K Counter). Wait for 5s which comes to
 *   below value
 */
#define GPT_TIMEOUT_DURATION            (32000U)

/* DEM Error Definitions */
/* DEM Error Codes */
/** \brief No event error code */
#define GPT_DEM_NO_EVENT                (0xFFFFFFFFU)


#ifndef GPT_E_HARDWARE_ERROR
/** \brief Hardware failed */
#define GPT_E_HARDWARE_ERROR          (GPT_DEM_NO_EVENT)
#endif

/** \brief Enable/disable GPT register read back API */
#define GPT_REGISTER_READBACK_API               (STD_OFF)


/*********************************************************************************************************************
 *  Exported Object Declarations
 *********************************************************************************************************************/
 
extern const struct Gpt_ConfigType_s Gpt_ChannelConfigSet_0;


/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

#endif  /* #ifndef GPT_CFG_H_ */

/* @} */

